/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class AAS
extends TriggerHappy {
    IO io;
    public int maxscore = 100;
    public int score = 0;
    public String title = "AAS Game";
    public String author;
    public String instructions = "\n";
    public String winmessage = "You won! Congratulations!\n";
    public String losemessage = "You lost! Better luck next time!\n";
    Map newverbs = new HashMap();
    Map changeverbs = new HashMap();
    Random random = new Random(Math.round(Math.random() * 1000.0));
    Map connections = new HashMap();
    Map objects = new HashMap();
    Map vocabLists = new HashMap();
    Map countdowns = new HashMap();
    Map commands = new HashMap();
    Map verbs = new HashMap();
    boolean saveLastCommand;
    String lastCommand = "";
    boolean quitting = false;
    boolean won = false;
    Monster booby;
    static /* synthetic */ Class class$java$util$List;

    public AAS(IO iO) {
        this.io = iO;
        this.initTags();
    }

    public AAS(PrintStream printStream, InputStream inputStream) {
        this.io = new BasicIO(printStream, inputStream);
        this.initTags();
    }

    public void load_room(Element element) {
        this.io.print(".");
        new Room().load(element);
    }

    public void load_connection(Element element) {
        this.io.print(".");
        new Connection().load(element);
    }

    public void load_monster(Element element) {
        this.io.print(".");
        new Monster().load(element);
    }

    public void load_thing(Element element) {
        this.io.print(".");
        new Thing().load(element);
    }

    public void load_countdown(Element element) {
        this.io.print(".");
        new Countdown().load(element);
    }

    public void load_newverb(Element element) {
        this.newverbs.put(element.getAttributeValue("newverb"), element.getAttributeValue("oldverb"));
    }

    public void load_changeverb(Element element) {
        this.changeverbs.put(element.getAttributeValue("oldverb"), element.getAttributeValue("newverb"));
    }

    void initTags() {
        this.io.print("Welcome to AAS!\n\n");
        this.addStringAttr("title");
        this.addStringAttr("author");
        this.addIntTag("maxscore");
        this.addSubLoaderTag("room");
        this.addSubLoaderTag("connection");
        this.addSubLoaderTag("monster");
        this.addSubLoaderTag("thing");
        this.addSubLoaderTag("countdown");
        this.addSubLoaderTag("changeverb");
        this.addSubLoaderTag("newverb");
        this.addStringTag("instructions");
        this.addStringTag("winmessage");
        this.addStringTag("losemessage");
    }

    boolean chance(int n) {
        return this.random.nextInt(100) < n;
    }

    int randomInRange(int n, int n2) {
        return this.random.nextInt(n2 - n + 1) + n;
    }

    public void loadURL(URL uRL) throws JDOMException {
        this.io.print("Loading, please wait");
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(uRL);
        Element element = document.getRootElement();
        this.load(element);
        this.io.print("\n");
    }

    public void loadFile(String string) throws JDOMException {
        this.io.print("Loading, please wait");
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(string);
        Element element = document.getRootElement();
        this.load(element);
        this.io.print("\n");
    }

    private boolean isNameOfAnEncryptedThing(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1 || n >= string.length()) {
            return false;
        }
        return "aie".equals(string.substring(n + 1).toLowerCase());
    }

    void addCommand(String string, Countdown countdown) {
        this.commands.put(string, countdown);
    }

    Countdown getCommand(String string) {
        return (Countdown)this.commands.get(string);
    }

    void addCountdown(Countdown countdown) {
        this.countdowns.put(countdown.number, countdown);
    }

    Countdown getCountdown(String string) {
        return (Countdown)this.countdowns.get(string);
    }

    void addObject(Container container) {
        this.objects.put(container.number, container);
    }

    Container getObject(String string) {
        return (Container)this.objects.get(string);
    }

    void addConnection(Connection connection) {
        this.connections.put(connection.number, connection);
    }

    Connection getConnection(String string) {
        return (Connection)this.connections.get(string);
    }

    void addVocab(Located located, String string) {
        LinkedList<Located> linkedList = (LinkedList<Located>)this.vocabLists.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList<Located>();
        }
        linkedList.add(located);
        this.vocabLists.put(string, linkedList);
    }

    void addVocab(Located located) {
        this.addVocab(located, located.name);
        if (located.noun != null) {
            this.addVocab(located, located.noun);
        }
        if (located.adj != null) {
            this.addVocab(located, located.adj);
        }
        if (located.noun != null && located.adj != null) {
            this.addVocab(located, located.adj + " " + located.noun);
        }
    }

    Located getVocab(String string) {
        List list = (List)this.vocabLists.get(string);
        if (list == null) {
            this.io.print("I don't know what that is!\n");
            return null;
        }
        HashSet<Located> hashSet = new HashSet<Located>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Located located = (Located)iterator.next();
            if (located.getOuterContainer() != this.booby.getOuterContainer()) continue;
            hashSet.add(located);
        }
        if (hashSet.size() == 0) {
            this.io.print("You can't see that here!\n");
            return null;
        }
        if (hashSet.size() > 1) {
            this.io.print("You'll have to be more specific!\n");
            return null;
        }
        return (Located)hashSet.toArray()[0];
    }

    static Object head(List list) {
        return list.get(0);
    }

    static List tail(List list) {
        return list.subList(1, list.size());
    }

    Verb addVerb(String string) {
        try {
            if (this.changeverbs.containsKey(string)) {
                string = (String)this.changeverbs.get(string);
            }
            Class[] classArray = new Class[]{class$java$util$List == null ? (class$java$util$List = AAS.class$("java.util.List")) : class$java$util$List};
            Method method = this.getClass().getMethod("do_" + string, classArray);
            Verb verb = new Verb(method, this);
            this.verbs.put(string, verb);
            return verb;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    Verb addSynonym(String string, String string2) {
        if (this.changeverbs.containsKey(string)) {
            string = (String)this.changeverbs.get(string);
        }
        Verb verb = (Verb)this.verbs.get(string);
        this.verbs.put(string2, verb);
        return verb;
    }

    static List splitString(String string, int n, boolean bl) {
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = 0;
        int n3 = string.indexOf(n);
        while (n3 >= 0) {
            if (n3 > n2) {
                linkedList.add(string.substring(n2, n3));
            }
            n2 = n3 + 1;
            n3 = string.indexOf(n, n2);
            if (!bl) break;
        }
        if (string.length() > n2) {
            linkedList.add(string.substring(n2, string.length()));
        }
        return linkedList;
    }

    void runOneCommand(String string) {
        try {
            Countdown countdown = this.getCommand(string);
            if (countdown != null) {
                countdown.trig();
            } else {
                List list = AAS.splitString(string, 32, false);
                String string2 = (String)AAS.head(list);
                Verb verb = (Verb)this.verbs.get(string2);
                this.saveLastCommand = true;
                verb.run(AAS.tail(list));
                if (this.saveLastCommand) {
                    this.lastCommand = string;
                }
            }
        }
        catch (Exception exception) {
            this.io.print("That makes no sense!\n");
        }
    }

    void runCommands(String string) {
        List list = AAS.splitString(string, 46, true);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.runOneCommand((String)iterator.next());
        }
    }

    public void addPoints(int n) {
        this.score += n;
        this.io.print("You scored " + n + " points! Your score is now " + this.score + "/" + this.maxscore + "!\n");
    }

    public void do_again(List list) throws AbortCommand {
        this.runOneCommand(this.lastCommand);
        this.saveLastCommand = false;
    }

    public void do_score(List list) {
        this.io.print("Your score is " + this.score + " out of " + this.maxscore + ". ");
        if (this.score < this.maxscore) {
            this.io.print("Keep going!\n");
        } else if (this.score == this.maxscore) {
            this.io.print("Well done!\n");
        } else {
            this.io.print("Wow! That's amazing!\n");
        }
    }

    public void do_quit(List list) {
        this.quitting = true;
    }

    public void do_wait(List list) {
        this.io.print("You stand around for a bit.\n");
    }

    public void do_jump(List list) {
        this.io.print("Boing!\n");
        this.pullTriggers("jump");
    }

    Room getCurrentRoom() {
        return (Room)this.booby.getOuterContainer();
    }

    void doExit(String string) {
        Connection connection = this.getCurrentRoom().getExit(string);
        if (connection == null) {
            this.io.print("You can't go that way!\n");
        } else {
            connection.goThrough();
        }
    }

    public void do_up(List list) {
        this.doExit("u");
    }

    public void do_down(List list) {
        this.doExit("d");
    }

    public void do_north(List list) {
        this.doExit("n");
    }

    public void do_south(List list) {
        this.doExit("s");
    }

    public void do_east(List list) {
        this.doExit("e");
    }

    public void do_west(List list) {
        this.doExit("w");
    }

    public void do_pickup(List list) {
        String string = (String)AAS.head(list);
        Located located = this.getVocab(string);
        if (located != null) {
            located.do_pickup();
        }
    }

    public void do_putdown(List list) {
        String string = (String)AAS.head(list);
        Located located = this.getVocab(string);
        if (located != null) {
            located.do_putdown();
        }
    }

    public void do_eat(List list) {
        String string = (String)AAS.head(list);
        Located located = this.getVocab(string);
        if (located != null) {
            located.do_eat();
        }
    }

    public void do_drink(List list) {
        String string = (String)AAS.head(list);
        Located located = this.getVocab(string);
        if (located != null) {
            located.do_drink();
        }
    }

    public void do_wear(List list) {
        String string = (String)AAS.head(list);
        Located located = this.getVocab(string);
        if (located != null) {
            located.do_wear();
        }
    }

    public void do_unwear(List list) {
        String string = (String)AAS.head(list);
        Located located = this.getVocab(string);
        if (located != null) {
            located.do_unwear();
        }
    }

    public void do_fight(List list) {
        String string = (String)AAS.head(list);
        Located located = this.getVocab(string);
        if (located != null) {
            this.booby.fight(located);
        }
    }

    public void do_wield(List list) {
        String string = (String)AAS.head(list);
        Located located = this.getVocab(string);
        if (located != null) {
            located.do_wield();
        }
    }

    public void do_unwield(List list) {
        String string = (String)AAS.head(list);
        Located located = this.getVocab(string);
        if (located != null) {
            located.do_unwield();
        }
    }

    public void do_turnon(List list) {
        String string = (String)AAS.head(list);
        Located located = this.getVocab(string);
        if (located != null) {
            located.do_turnon();
        }
    }

    public void do_turnoff(List list) {
        String string = (String)AAS.head(list);
        Located located = this.getVocab(string);
        if (located != null) {
            located.do_turnoff();
        }
    }

    public void do_open(List list) {
        String string = (String)AAS.head(list);
        Located located = this.getVocab(string);
        if (located != null) {
            located.do_open();
        }
    }

    public void do_close(List list) {
        String string = (String)AAS.head(list);
        Located located = this.getVocab(string);
        if (located != null) {
            located.do_close();
        }
    }

    public void do_inv(List list) {
        this.io.print("You don't need a special command to see what you're holding. Just type \"examine me\"!\n");
    }

    public void do_smell(List list) {
        Room room = this.getCurrentRoom();
        this.io.print(room.smelldesc);
        room.pullTriggers("smell");
    }

    public void do_listen(List list) {
        Room room = this.getCurrentRoom();
        this.io.print(room.sounddesc);
        room.pullTriggers("listen");
    }

    public void do_look(List list) {
        if (list.isEmpty()) {
            this.getCurrentRoom().describeSelfAndContents();
        } else {
            String string = (String)AAS.head(list);
            Located located = this.getVocab(string);
            if (located != null) {
                located.describeSelfAndContents();
                located.pullTriggers("examine");
            }
        }
    }

    protected void postload(Element element) {
        super.postload(element);
        this.addVocab(this.booby, "me");
        this.addVocab(this.booby, "self");
        this.addVocab(this.booby, "myself");
        Iterator iterator = this.objects.values().iterator();
        while (iterator.hasNext()) {
            ((Container)iterator.next()).preinit();
        }
    }

    public void run() throws IOException {
        this.runInit();
        do {
            this.io.print("\nWhat now?\n");
        } while (!this.runNext(this.io.input()));
    }

    public void runInit() throws IOException {
        this.addVerb("north");
        this.addVerb("south");
        this.addVerb("east");
        this.addVerb("west");
        this.addVerb("up");
        this.addVerb("down");
        this.addVerb("look");
        this.addVerb("smell");
        this.addVerb("listen");
        this.addVerb("quit");
        this.addVerb("jump");
        this.addVerb("wait");
        this.addVerb("open");
        this.addVerb("close");
        this.addVerb("pickup");
        this.addVerb("putdown");
        this.addVerb("eat");
        this.addVerb("drink");
        this.addVerb("wear");
        this.addVerb("unwear");
        this.addVerb("fight");
        this.addVerb("wield");
        this.addVerb("unwield");
        this.addVerb("turnon");
        this.addVerb("turnoff");
        this.addVerb("again");
        this.addVerb("score");
        this.addVerb("inv");
        this.addSynonym("score", "status");
        this.addSynonym("score", "points");
        this.addSynonym("inv", "i");
        this.addSynonym("inv", "inventory");
        this.addSynonym("wait", "z");
        this.addSynonym("again", "g");
        this.addSynonym("smell", "sniff");
        this.addSynonym("listen", "hear");
        this.addSynonym("turnon", "on");
        this.addSynonym("turnoff", "off");
        this.addSynonym("wield", "aim");
        this.addSynonym("wield", "cock");
        this.addSynonym("wield", "raise");
        this.addSynonym("wield", "heft");
        this.addSynonym("wield", "grasp");
        this.addSynonym("wield", "use");
        this.addSynonym("unwield", "uncock");
        this.addSynonym("unwield", "lower");
        this.addSynonym("unwield", "stow");
        this.addSynonym("fight", "f");
        this.addSynonym("fight", "kill");
        this.addSynonym("fight", "attack");
        this.addSynonym("fight", "hit");
        this.addSynonym("fight", "destroy");
        this.addSynonym("fight", "murder");
        this.addSynonym("fight", "maim");
        this.addSynonym("fight", "mutilate");
        this.addSynonym("fight", "pulverise");
        this.addSynonym("fight", "ruin");
        this.addSynonym("fight", "break");
        this.addSynonym("fight", "smash");
        this.addSynonym("fight", "destroy");
        this.addSynonym("fight", "vanquish");
        this.addSynonym("fight", "defeat");
        this.addSynonym("fight", "punish");
        this.addSynonym("fight", "beat");
        this.addSynonym("fight", "kick");
        this.addSynonym("fight", "punch");
        this.addSynonym("fight", "rip");
        this.addSynonym("fight", "tear");
        this.addSynonym("fight", "hack");
        this.addSynonym("fight", "slash");
        this.addSynonym("fight", "chop");
        this.addSynonym("fight", "slice");
        this.addSynonym("fight", "cut");
        this.addSynonym("wear", "don");
        this.addSynonym("wear", "puton");
        this.addSynonym("unwear", "doff");
        this.addSynonym("unwear", "takeoff");
        this.addSynonym("unwear", "remove");
        this.addSynonym("unwear", "strip");
        this.addSynonym("unwear", "disrobe");
        this.addSynonym("north", "n");
        this.addSynonym("south", "s");
        this.addSynonym("east", "e");
        this.addSynonym("west", "w");
        this.addSynonym("up", "u");
        this.addSynonym("down", "d");
        this.addSynonym("look", "l");
        this.addSynonym("look", "x");
        this.addSynonym("quit", "q");
        this.addSynonym("jump", "j");
        this.addSynonym("pickup", "take");
        this.addSynonym("pickup", "get");
        this.addSynonym("pickup", "pu");
        this.addSynonym("putdown", "pd");
        this.addSynonym("putdown", "drop");
        Iterator iterator = this.newverbs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            this.addSynonym(string2, string);
        }
        this.io.print(this.title + "\n\n");
        this.io.print(this.instructions + "\n");
        this.getCurrentRoom().describeSelfAndContents();
        iterator = this.objects.values().iterator();
        while (iterator.hasNext()) {
            ((Container)((Object)iterator.next())).eachTurn();
        }
        this.pullTriggers("everyturn");
        iterator = this.objects.values().iterator();
        while (iterator.hasNext()) {
            ((Container)((Object)iterator.next())).checkForWin();
        }
    }

    public boolean runNext(String string) {
        if (!this.quitting) {
            this.runCommands(string);
            Iterator iterator = this.objects.values().iterator();
            while (iterator.hasNext()) {
                ((Container)iterator.next()).eachTurn();
            }
            this.pullTriggers("everyturn");
            this.won = true;
            iterator = this.objects.values().iterator();
            while (iterator.hasNext()) {
                ((Container)iterator.next()).checkForWin();
            }
            if (this.booby.isDead()) {
                this.io.print(this.losemessage);
                this.quitting = true;
            } else if (this.won) {
                this.io.print(this.winmessage);
                this.quitting = true;
            }
            if (this.quitting) {
                this.io.print("\nPlay again soon!\n\n");
            }
        } else {
            this.io.print("The game's over! Go and read a book or something!\n");
        }
        return this.quitting;
    }

    public static void main(String[] stringArray) {
        try {
            AAS aAS = new AAS(System.out, System.in);
            aAS.loadFile(stringArray[0]);
            aAS.run();
        }
        catch (JDOMException jDOMException) {
            jDOMException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class BasicIO
    implements IO {
        PrintStream out;
        BufferedReader in;

        public BasicIO(PrintStream printStream, InputStream inputStream) {
            this.out = printStream;
            this.in = new BufferedReader(new InputStreamReader(inputStream));
        }

        public void print(String string) {
            this.randomSleep(0, 150);
            this.out.print(string);
        }

        public void alert(String string) {
            this.print(string);
        }

        void randomSleep(int n, int n2) {
        }

        public String input() throws IOException {
            this.print(">");
            return this.in.readLine();
        }

        public void clear() {
            this.print("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
        }

        public void setColour(int n, int n2, int n3) {
        }

        public void enterNewRoom() {
            this.randomSleep(1, 500);
        }
    }

    static class AbortCommand
    extends Exception {
        AbortCommand() {
        }
    }

    static class Verb {
        Method method;
        Object owner;

        public Verb(Method method, Object object) {
            this.method = method;
            this.owner = object;
        }

        public final void run(List list) throws Exception {
            Object[] objectArray = new Object[]{list};
            this.method.invoke(this.owner, objectArray);
        }
    }

    class Countdown
    extends AASLoader
    implements Trigger {
        public String number;
        public int count = 1;
        public int currentCount;
        public int delay = 0;
        public int loops = 1;
        boolean useAndLogic = true;
        List conditions = new LinkedList();
        List events = new LinkedList();

        Countdown() {
            this.addSubLoaderTag("triggers");
            this.addSubLoaderTag("conditions");
            this.addSubLoaderTag("event");
            this.addStringAttr("number");
            this.addIntTag("count");
            this.addIntTag("loops");
            this.addIntTag("delay");
        }

        public void postload(Element element) {
            super.postload(element);
            this.currentCount = this.count;
            AAS.this.addCountdown(this);
        }

        public void load_triggers(Element element) {
            new Triggers().load(element);
        }

        public void load_conditions(Element element) {
            new Conditions().load(element);
        }

        public void load_event(Element element) {
            this.events.add(new Event(element));
        }

        public boolean trig() {
            int n;
            Object object;
            boolean bl;
            Iterator iterator = this.conditions.iterator();
            if (iterator.hasNext()) {
                bl = this.useAndLogic;
                while (iterator.hasNext()) {
                    boolean bl2;
                    object = (Condition)iterator.next();
                    n = object.isTrue();
                    if (this.useAndLogic) {
                        if (bl && n != 0) {
                            bl2 = true;
                            continue;
                        }
                        bl2 = false;
                        continue;
                    }
                    bl2 = bl = bl || n != 0;
                }
            } else {
                bl = true;
            }
            if (bl && --this.currentCount == 0) {
                this.currentCount = this.count;
                iterator = this.events.iterator();
                while (iterator.hasNext()) {
                    object = (Event)iterator.next();
                    n = this.delay;
                    int n2 = this.loops;
                    if (n == 0) {
                        ((Event)object).run();
                        n = 1;
                        --n2;
                    }
                    if (n2 <= 0) continue;
                    class DelayAndLoopEvent
                    implements Trigger {
                        int delay;
                        int loops;
                        Event event;
                        private final /* synthetic */ Countdown this$1;

                        DelayAndLoopEvent(Countdown countdown, int n, int n2, Event event) {
                            this.this$1 = countdown;
                            this.delay = n;
                            this.loops = n2;
                            this.event = event;
                        }

                        public boolean trig() {
                            if (--this.delay > 0) {
                                return false;
                            }
                            this.event.run();
                            return --this.loops > 0;
                        }
                    }
                    AAS.this.addTrigger("everyturn", new DelayAndLoopEvent(this, n, n2, (Event)object));
                }
            }
            return true;
        }

        class Event
        extends AASLoader {
            Element element;

            Event(Element element) {
                this.element = element;
                this.addSubLoaderTag("deadly");
                this.addSubLoaderTag("desc");
                this.addSubLoaderTag("descnear");
                this.addSubLoaderTag("alert");
                this.addSubLoaderTag("move");
                this.addSubLoaderTag("movetosameroomas");
                this.addSubLoaderTag("remove");
                this.addSubLoaderTag("destroy");
                this.addSubLoaderTag("ignite");
                this.addSubLoaderTag("douse");
                this.addSubLoaderTag("conjure");
                this.addSubLoaderTag("vanish");
                this.addSubLoaderTag("poison");
                this.addSubLoaderTag("esuna");
                this.addSubLoaderTag("wear");
                this.addSubLoaderTag("hurt");
                this.addSubLoaderTag("heal");
                this.addSubLoaderTag("changehitchance");
                this.addSubLoaderTag("changedodgechance");
                this.addSubLoaderTag("enrage");
                this.addSubLoaderTag("placate");
                this.addSubLoaderTag("changedesc");
                this.addSubLoaderTag("changesmell");
                this.addSubLoaderTag("changesound");
                this.addSubLoaderTag("triggercountdown");
                this.addSubLoaderTag("changeconnection");
                this.addSubLoaderTag("lock");
                this.addSubLoaderTag("unlock");
            }

            void run() {
                this.load(this.element);
            }

            public void load_deadly(Element element) {
                ((Countdown)Countdown.this).AAS.this.booby.hp = 0;
            }

            public void load_desc(Element element) {
                ((Countdown)Countdown.this).AAS.this.io.print(element.getText());
            }

            public void load_descnear(Element element) {
                Container container = AAS.this.getObject(element.getAttributeValue("target"));
                if (container.getOuterContainer() == ((Countdown)Countdown.this).AAS.this.booby.getOuterContainer()) {
                    ((Countdown)Countdown.this).AAS.this.io.print(element.getText());
                }
            }

            public void load_alert(Element element) {
                ((Countdown)Countdown.this).AAS.this.io.alert(element.getText());
            }

            public void load_move(Element element) {
                Located located = (Located)AAS.this.getObject(element.getAttributeValue("thing"));
                if (located == null) {
                    located = (Located)AAS.this.getObject(element.getAttributeValue("target"));
                }
                Container container = AAS.this.getObject(element.getAttributeValue("loc"));
                located.moveInto(container);
            }

            public void load_movetosameroomas(Element element) {
                Located located = (Located)AAS.this.getObject(element.getAttributeValue("target"));
                Container container = AAS.this.getObject(element.getAttributeValue("loc"));
                located.moveInto(container.getOuterContainer());
            }

            public void load_changehitchance(Element element) {
                boolean bl = "true".equals(element.getAttributeValue("minus"));
                bl = bl || "true".equals(element.getAttributeValue("subtract"));
                Monster monster = (Monster)AAS.this.getObject(element.getAttributeValue("target"));
                int n = Integer.parseInt(element.getAttributeValue("amount"));
                monster.hitchance = monster.hitchance + (bl ? -n : n);
            }

            public void load_changedodgechance(Element element) {
                boolean bl = "true".equals(element.getAttributeValue("minus"));
                bl = bl || "true".equals(element.getAttributeValue("subtract"));
                Monster monster = (Monster)AAS.this.getObject(element.getAttributeValue("target"));
                int n = Integer.parseInt(element.getAttributeValue("amount"));
                monster.dodgechance = monster.dodgechance + (bl ? -n : n);
            }

            public void load_enrage(Element element) {
                Monster monster = (Monster)AAS.this.getObject(element.getAttributeValue("target"));
                int n = Integer.parseInt(element.getAttributeValue("amount"));
                monster.turnstofight -= n;
            }

            public void load_placate(Element element) {
                Monster monster = (Monster)AAS.this.getObject(element.getAttributeValue("target"));
                int n = Integer.parseInt(element.getAttributeValue("amount"));
                monster.turnstofight += n;
            }

            public void load_changedesc(Element element) {
                Container container = AAS.this.getObject(element.getAttributeValue("target"));
                container.desc = element.getText();
            }

            public void load_changesmell(Element element) {
                Room room = (Room)AAS.this.getObject(element.getAttributeValue("target"));
                room.smelldesc = element.getText();
            }

            public void load_changesound(Element element) {
                Room room = (Room)AAS.this.getObject(element.getAttributeValue("target"));
                room.sounddesc = element.getText();
            }

            public void load_wear(Element element) {
                Located located;
                Thing thing = (Thing)AAS.this.getObject(element.getAttributeValue("clothing"));
                if (thing == null) {
                    thing = (Thing)AAS.this.getObject(element.getAttributeValue("target"));
                }
                if ((located = (Located)AAS.this.getObject(element.getAttributeValue("wearer"))) == null) {
                    located = (Located)AAS.this.getObject(element.getAttributeValue("target"));
                }
                if (!(located == thing || located.contains(thing) && thing.isWorn())) {
                    thing.moveInto(located);
                    thing.worn = true;
                }
            }

            public void load_heal(Element element) {
                Located located = (Located)AAS.this.getObject(element.getAttributeValue("target"));
                int n = Integer.parseInt(element.getAttributeValue("amount"));
                located.heal(n);
            }

            public void load_hurt(Element element) {
                Located located = (Located)AAS.this.getObject(element.getAttributeValue("target"));
                int n = Integer.parseInt(element.getAttributeValue("amount"));
                located.hurt(n);
            }

            public void load_remove(Element element) {
                Located located = (Located)AAS.this.getObject(element.getAttributeValue("target"));
                located.moveInto(null);
            }

            public void load_destroy(Element element) {
                Located located = (Located)AAS.this.getObject(element.getAttributeValue("target"));
                located.moveInto(null);
            }

            public void load_ignite(Element element) {
                Located located = (Located)AAS.this.getObject(element.getAttributeValue("target"));
                located.ignite();
            }

            public void load_douse(Element element) {
                Located located = (Located)AAS.this.getObject(element.getAttributeValue("target"));
                located.douse();
            }

            public void load_poison(Element element) {
                Located located = (Located)AAS.this.getObject(element.getAttributeValue("target"));
                located.poison();
            }

            public void load_esuna(Element element) {
                Located located = (Located)AAS.this.getObject(element.getAttributeValue("target"));
                located.esuna();
            }

            public void load_conjure(Element element) {
                Located located = (Located)AAS.this.getObject(element.getAttributeValue("target"));
                located.isvisible = true;
            }

            public void load_vanish(Element element) {
                Located located = (Located)AAS.this.getObject(element.getAttributeValue("target"));
                located.isvisible = false;
            }

            public void load_changeconnection(Element element) {
                Connection connection = AAS.this.getConnection(element.getAttributeValue("connection"));
                connection.to = element.getAttributeValue("to");
            }

            public void load_triggercountdown(Element element) {
                Countdown countdown = AAS.this.getCountdown(element.getText());
                countdown.trig();
            }

            public void load_lock(Element element) {
                Connection connection = AAS.this.getConnection(element.getAttributeValue("connection"));
                connection.locked = true;
            }

            public void load_unlock(Element element) {
                Connection connection = AAS.this.getConnection(element.getAttributeValue("connection"));
                connection.locked = false;
            }
        }

        class Conditions
        extends AASLoader {
            public String logic;

            public Conditions() {
                this.addStringAttr("logic");
                this.addSubLoaderTag("isvisible");
                this.addSubLoaderTag("isin");
                this.addSubLoaderTag("isopen");
                this.addSubLoaderTag("ison");
                this.addSubLoaderTag("iseaten");
                this.addSubLoaderTag("isworn");
                this.addSubLoaderTag("isdead");
                this.addSubLoaderTag("isonfire");
                this.addSubLoaderTag("ispoisoned");
                this.addSubLoaderTag("isprob");
            }

            public void load_isvisible(Element element) {
                Container container = AAS.this.getObject(element.getAttributeValue("target"));
                Container container2 = AAS.this.getObject(element.getAttributeValue("from"));
                this.finishLoadingCondition(element, new IsVisibleCond(container, container2));
            }

            public void load_isprob(Element element) {
                int n = Integer.parseInt(element.getAttributeValue("chance"));
                this.finishLoadingCondition(element, new ProbCond(n));
            }

            public void load_isin(Element element) {
                Container container = AAS.this.getObject(element.getAttributeValue("containee"));
                Container container2 = AAS.this.getObject(element.getAttributeValue("container"));
                this.finishLoadingCondition(element, new XinY(container, container2));
            }

            public void load_isopen(Element element) {
                this.load_iscond(element, "isOpen");
            }

            public void load_ison(Element element) {
                this.load_iscond(element, "isOn");
            }

            public void load_iseaten(Element element) {
                this.load_iscond(element, "isEaten");
            }

            public void load_isworn(Element element) {
                this.load_iscond(element, "isWorn");
            }

            public void load_isdead(Element element) {
                this.load_iscond(element, "isDead");
            }

            public void load_isonfire(Element element) {
                this.load_iscond(element, "isOnFire");
            }

            public void load_ispoisoned(Element element) {
                this.load_iscond(element, "isPoisoned");
            }

            void load_iscond(Element element, String string) {
                try {
                    Container container = AAS.this.getObject(element.getAttributeValue("target"));
                    Method method = container.getClass().getMethod(string, new Class[0]);
                    this.finishLoadingCondition(element, new MethodCond(container, method));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            void finishLoadingCondition(Element element, Condition condition) {
                if ("true".equals(element.getAttributeValue("not"))) {
                    condition = new Inverter(condition);
                }
                Countdown.this.conditions.add(condition);
            }

            public void postload(Element element) {
                super.postload(element);
                if ("or".equals(this.logic)) {
                    Countdown.this.useAndLogic = false;
                } else if ("and".equals(this.logic)) {
                    Countdown.this.useAndLogic = true;
                }
            }

            class Inverter
            implements Condition {
                Condition c;

                Inverter(Condition condition) {
                    this.c = condition;
                }

                public boolean isTrue() {
                    return !this.c.isTrue();
                }
            }

            class MethodCond
            implements Condition {
                Object obj;
                Method method;

                MethodCond(Object object, Method method) {
                    this.obj = object;
                    this.method = method;
                }

                public boolean isTrue() {
                    try {
                        Boolean bl = (Boolean)this.method.invoke(this.obj, new Object[0]);
                        return bl;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return false;
                    }
                }
            }

            class XinY
            implements Condition {
                Container x;
                Container y;

                XinY(Container container, Container container2) {
                    this.x = container;
                    this.y = container2;
                }

                public boolean isTrue() {
                    return this.y.contains(this.x);
                }
            }

            class ProbCond
            implements Condition {
                int percent;

                ProbCond(int n) {
                    this.percent = n;
                }

                public boolean isTrue() {
                    return AAS.this.chance(this.percent);
                }
            }

            class IsVisibleCond
            implements Condition {
                Container x;
                Container y;

                IsVisibleCond(Container container, Container container2) {
                    this.x = container;
                    this.y = container2;
                }

                public boolean isTrue() {
                    return this.x.getOuterContainer() == this.y.getOuterContainer();
                }
            }
        }

        class Triggers
        extends AASLoader {
            void addTriggerTag(String string) {
                this.addTag("on" + string, new TriggerTag(string));
            }

            public void load_oncommand(Element element) {
                AAS.this.addCommand(element.getText(), Countdown.this);
            }

            public void load_oneveryturn(Element element) {
                boolean bl = "true".equals(element.getAttributeValue("firstonly"));
                AAS.this.addTrigger("everyturn", Countdown.this, bl);
            }

            public void load_onjump(Element element) {
                boolean bl = "true".equals(element.getAttributeValue("firstonly"));
                AAS.this.addTrigger("jump", Countdown.this, bl);
            }

            public void load_onhpbelow(Element element) {
                HPBelowTrigger hPBelowTrigger = new HPBelowTrigger();
                hPBelowTrigger.firstOnly = "true".equals(element.getAttributeValue("firstonly"));
                hPBelowTrigger.obj = (Located)AAS.this.getObject(element.getAttributeValue("target"));
                hPBelowTrigger.hp = Integer.parseInt(element.getAttributeValue("hp"));
                hPBelowTrigger.subTrigger = Countdown.this;
                hPBelowTrigger.obj.addTrigger("hp", hPBelowTrigger);
            }

            public Triggers() {
                this.addSubLoaderTag("oncommand");
                this.addSubLoaderTag("oneveryturn");
                this.addSubLoaderTag("onhpbelow");
                this.addSubLoaderTag("onjump");
                this.addTriggerTag("examine");
                this.addTriggerTag("smell");
                this.addTriggerTag("listen");
                this.addTriggerTag("enter");
                this.addTriggerTag("exit");
                this.addTriggerTag("pickup");
                this.addTriggerTag("putdown");
                this.addTriggerTag("open");
                this.addTriggerTag("close");
                this.addTriggerTag("turnon");
                this.addTriggerTag("turnoff");
                this.addTriggerTag("wear");
                this.addTriggerTag("unwear");
                this.addTriggerTag("ignite");
                this.addTriggerTag("douse");
                this.addTriggerTag("eat");
                this.addTriggerTag("drink");
                this.addTriggerTag("kill");
                this.addTriggerTag("turn");
                this.addTriggerTag("attack");
                this.addTriggerTag("hit");
                this.addTriggerTag("poison");
                this.addTriggerTag("wield");
                this.addTriggerTag("unwield");
                this.addTriggerTag("lock");
                this.addTriggerTag("unlock");
            }

            class HPBelowTrigger
            implements Trigger {
                boolean firstOnly;
                Located obj;
                int hp;
                Trigger subTrigger;

                HPBelowTrigger() {
                }

                public boolean trig() {
                    if (this.obj.hp >= this.hp) {
                        return false;
                    }
                    this.subTrigger.trig();
                    return this.firstOnly;
                }
            }

            class TriggerTag
            implements AASLoader.Tag {
                String trigger;

                TriggerTag(String string) {
                    this.trigger = string;
                }

                public void load(Element element) {
                    boolean bl = "true".equals(element.getAttributeValue("firstonly"));
                    Container container = AAS.this.getObject(element.getAttributeValue("target"));
                    if (container == null) {
                        container = AAS.this.getObject(element.getAttributeValue("thing"));
                    }
                    if (container == null) {
                        container = AAS.this.getObject(element.getAttributeValue("monster"));
                    }
                    if (container == null) {
                        container = AAS.this.getObject(element.getAttributeValue("room"));
                    }
                    if (container != null) {
                        container.addTrigger(this.trigger, Countdown.this, bl);
                    }
                }
            }
        }
    }

    static interface Condition {
        public boolean isTrue();
    }

    class Thing
    extends Located {
        public int value;
        public int ammo;
        public int size;
        public int weight;
        public int carryease;
        public boolean treasure = false;
        public boolean weapon = false;
        public boolean food = false;
        public boolean drink = false;
        public boolean clothing = false;
        public boolean table = false;
        public boolean box = false;
        public boolean open = false;
        public boolean turnonable = false;
        public boolean on = false;
        public boolean worn = false;

        public Thing() {
            this.name = "thingy";
            this.addIntTag("value");
            this.addIntTag("ammo");
            this.addIntTag("size");
            this.addIntTag("weight");
            this.addIntTag("carryease");
            this.addFlagTag("treasure");
            this.addFlagTag("weapon");
            this.addFlagTag("food");
            this.addFlagTag("drink");
            this.addFlagTag("clothing");
            this.addFlagTag("table");
            this.addFlagTag("box");
            this.addFlagTag("open");
            this.addFlagTag("turnonable");
            this.addFlagTag("on");
            this.addFlagTag("worn");
        }

        public void postload(Element element) {
            super.postload(element);
            this.addTrigger("pickup", new AddScoreTrigger(this.value), true);
        }

        public void defend(Monster monster) {
            AAS.this.io.print("The " + this.name + " offers no resistance!\n");
            super.defend(monster);
        }

        public boolean isOn() {
            return this.on;
        }

        public boolean isWorn() {
            return this.worn;
        }

        public void moveInto(Container container) {
            this.worn = false;
            super.moveInto(container);
        }

        public void zeroHitPoints() {
            AAS.this.io.print("The " + this.name + " explodes into tiny fragments!\n");
            this.emptyInto(this.location);
            this.moveInto(null);
            this.pullTriggers("kill");
        }

        public void describeSelfAndContents() {
            super.describeSelfAndContents();
            if (this.box) {
                if (this.open) {
                    AAS.this.io.print("\nThe " + this.name + " is open, and contains:");
                    boolean bl = false;
                    Iterator iterator = this.contents.iterator();
                    while (iterator.hasNext()) {
                        Located located = (Located)iterator.next();
                        if (located == AAS.this.booby || !located.isVisible()) continue;
                        AAS.this.io.print("  " + located.name);
                        bl = true;
                    }
                    if (!bl) {
                        AAS.this.io.print(" nothing!");
                    }
                } else {
                    AAS.this.io.print("\nThe " + this.name + " is closed.\n");
                }
            }
        }

        public boolean do_turnon() {
            if (!this.turnonable) {
                super.do_turnon();
            } else if (this.isOn()) {
                AAS.this.io.print("The " + this.name + " is already on!\n");
            } else {
                AAS.this.io.print("You turn on the " + this.name + ".\n");
                this.on = true;
                this.pullTriggers("turnon");
            }
            return false;
        }

        public boolean do_turnoff() {
            if (!this.turnonable) {
                super.do_turnoff();
            } else if (!this.isOn()) {
                AAS.this.io.print("The " + this.name + " is already off!\n");
            } else {
                AAS.this.io.print("You turn off the " + this.name + ".\n");
                this.on = false;
                this.pullTriggers("turnoff");
            }
            return false;
        }

        public boolean do_wield() {
            if (AAS.this.booby.wieldedItem == this) {
                AAS.this.io.print("You're already wielding that!\n");
            } else if (!this.weapon) {
                AAS.this.io.print("That's not a weapon!\n");
            } else if (AAS.this.booby.contains(this) || this.do_pickup()) {
                AAS.this.io.print("You draw your " + this.name + " and wield it warily.\n");
                AAS.this.booby.wieldedItem = this;
                this.pullTriggers("wield");
                return true;
            }
            return false;
        }

        public boolean do_unwield() {
            if (AAS.this.booby.wieldedItem == this) {
                AAS.this.io.print("You sheath the " + this.name + ".\n");
                AAS.this.booby.wieldedItem = null;
                this.pullTriggers("unwield");
                return true;
            }
            AAS.this.io.print("You're not wielding that!\n");
            return false;
        }

        public boolean do_pickup() {
            if (AAS.this.booby.contains(this)) {
                AAS.this.io.print("You've already got that!\n");
            } else if (!this.pickupable) {
                AAS.this.io.print("You can't pick that up!\n");
            } else {
                this.moveInto(AAS.this.booby);
                AAS.this.io.print("You picked up the " + this.name + ".\n");
                this.pullTriggers("pickup");
                return true;
            }
            return false;
        }

        public boolean do_putdown() {
            if (!AAS.this.booby.contains(this)) {
                AAS.this.io.print("You don't have that!\n");
            } else if (!this.pickupable) {
                AAS.this.io.print("You can't put that down!\n");
            } else if (!this.worn || this.do_unwear()) {
                this.moveInto(AAS.this.booby.location);
                AAS.this.io.print("You put down the " + this.name + ".\n");
                this.pullTriggers("putdown");
                return true;
            }
            return false;
        }

        public boolean do_open() {
            if (!this.box) {
                return super.do_close();
            }
            if (!this.open) {
                AAS.this.io.print("You open the " + this.name + ".\n");
                this.open = true;
                this.pullTriggers("open");
                return true;
            }
            AAS.this.io.print("The " + this.name + " is already open!\n");
            return false;
        }

        public boolean do_close() {
            if (!this.box) {
                return super.do_close();
            }
            if (this.open) {
                AAS.this.io.print("You close the " + this.name + ".\n");
                this.open = false;
                this.pullTriggers("close");
                return true;
            }
            AAS.this.io.print("The " + this.name + " is already closed!\n");
            return false;
        }

        public boolean do_eat() {
            if (!this.food) {
                AAS.this.io.print("You can't eat that!\n");
            } else if (AAS.this.booby.contains(this) || this.do_pickup()) {
                AAS.this.io.print("Chomp, chomp! You guzzle down the " + this.name);
                if (this.poisonous || this.poisoned) {
                    AAS.this.io.print(". It tastes bad! It's poisoned!\n");
                    AAS.this.booby.poison();
                } else {
                    AAS.this.io.print(". It tastes good!\n");
                    AAS.this.booby.heal(this.hp);
                }
                this.moveInto(null);
                this.pullTriggers("eat");
                return true;
            }
            return false;
        }

        public boolean do_drink() {
            if (!this.drink) {
                AAS.this.io.print("You can't drink that!\n");
            } else if (AAS.this.booby.contains(this) || this.do_pickup()) {
                AAS.this.io.print("Glug, glug! You slurp down the " + this.name);
                if (this.poisonous || this.poisoned) {
                    AAS.this.io.print(". It tastes bad! It's poisoned!\n");
                    AAS.this.booby.poison();
                } else {
                    AAS.this.io.print(". It tastes good!\n");
                    AAS.this.booby.heal(this.hp);
                }
                this.moveInto(null);
                this.pullTriggers("drink");
                return true;
            }
            return false;
        }

        public boolean do_wear() {
            if (!this.clothing) {
                AAS.this.io.print("You can't wear that!\n");
            } else if (this.worn) {
                if (AAS.this.booby.contains(this)) {
                    AAS.this.io.print("You're already wearing that!\n");
                } else {
                    AAS.this.io.print(this.location.name + " is wearing that!\n");
                }
            } else if (AAS.this.booby.contains(this) || this.do_pickup()) {
                this.worn = true;
                AAS.this.io.print("You're now wearing the " + this.name + ".\n");
                this.pullTriggers("wear");
                return true;
            }
            return false;
        }

        public boolean do_unwear() {
            if (!this.clothing) {
                AAS.this.io.print("You can't wear that!\n");
            } else if (!AAS.this.booby.contains(this) || !this.worn) {
                AAS.this.io.print("You're not wearing that!\n");
            } else if (this.location != AAS.this.booby) {
                Located located = (Located)this.location;
                while (located.location != AAS.this.booby) {
                    located = (Located)located.location;
                }
                AAS.this.io.print("You'll have to take the " + located.name + " off first.\n");
            } else {
                this.worn = false;
                AAS.this.io.print("You take off the " + this.name + ".\n");
                this.emptyInto(this.location);
                this.pullTriggers("unwear");
                return true;
            }
            return false;
        }

        public void checkForWin() {
            super.checkForWin();
            if (this.treasure && this.location != AAS.this.getObject("9999")) {
                AAS.this.won = false;
            }
        }
    }

    class AddScoreTrigger
    implements Trigger {
        int value;

        AddScoreTrigger(int n) {
            this.value = n;
        }

        public boolean trig() {
            AAS.this.addPoints(this.value);
            return true;
        }
    }

    class Monster
    extends Located {
        public int turnstofight = 5;
        public int hitchance = 66;
        public int dodgechance = 33;
        public int ldamage = 1;
        public int hdamage = 20;
        public int value = 1;
        public String challenge;
        public String attack;
        public String death;
        public String missmsg;
        public String dodgemsg;
        public String hitmsg;
        public String painmsg;
        public String corpse;
        Thing wieldedItem;

        public Monster() {
            this.name = "booby";
            this.hp = 0;
            this.addIntTag("value");
            this.addIntTag("turnstofight");
            this.addIntTag("hitchance");
            this.addIntTag("dodgechance");
            this.addIntTag("ldamage");
            this.addIntTag("hdamage");
            this.addStringTag("challenge");
            this.addStringTag("attack");
            this.addStringTag("death");
            this.addStringTag("missmsg");
            this.addStringTag("dodgemsg");
            this.addStringTag("hitmsg");
            this.addStringTag("painmsg");
            this.addStringTag("corpse");
        }

        protected void postload(Element element) {
            super.postload(element);
            this.addTrigger("kill", new AddScoreTrigger(this.value), true);
            if (this.number.equals("0")) {
                AAS.this.booby = this;
            }
            if (this.challenge == null) {
                this.challenge = "RAR! The " + this.name + " roars in challenge!\n";
            }
            if (this.attack == null) {
                this.attack = "The " + this.name + " lunges viciously!\n";
            }
            if (this.death == null) {
                this.death = "ARRRGH! The " + this.name + " screams horribly and dies, vanishing in a puff of smoke!\n";
            }
            if (this.missmsg == null) {
                this.missmsg = "WHOOSH! The " + this.name + " hits thin air!\n";
            }
            if (this.dodgemsg == null) {
                this.dodgemsg = "SWISH! The " + this.name + " dodges aside!\n";
            }
            if (this.hitmsg == null) {
                this.hitmsg = "CRUNCH! The " + this.name + " connects with a powerful blow!\n";
            }
            if (this.painmsg == null) {
                this.painmsg = "OUCH! The " + this.name + " cries out in pain!\n";
            }
        }

        public void moveInto(Container container) {
            if (this == AAS.this.booby && this.location != null) {
                this.location.pullTriggers("exit");
            }
            super.moveInto(container);
            if (this == AAS.this.booby && this.location != null) {
                this.location.describeSelfAndContents();
                this.location.pullTriggers("enter");
                if (this.location instanceof Room && ((Room)this.location).deadly != null) {
                    AAS.this.io.print(((Room)this.location).deadly);
                    AAS.this.booby.hp = 0;
                }
            }
        }

        public void remove(Object object) {
            super.remove(object);
            if (object == this.wieldedItem) {
                this.wieldedItem = null;
                ((Located)object).pullTriggers("unwield");
            }
        }

        public void eachTurn() {
            if (this != AAS.this.booby && this.isHere()) {
                if (this.turnstofight == 1) {
                    AAS.this.io.print(this.challenge);
                }
                if (this.turnstofight > 0) {
                    --this.turnstofight;
                }
                if (this.turnstofight <= 0) {
                    this.fight(AAS.this.booby);
                }
            }
            super.eachTurn();
        }

        public void fight(Located located) {
            AAS.this.io.print(this.attack);
            located.pullTriggers("attack");
            if (AAS.this.chance(this.hitchance)) {
                located.defend(this);
            } else {
                AAS.this.io.print(this.missmsg);
            }
        }

        public void defend(Monster monster) {
            if (AAS.this.chance(this.dodgechance)) {
                AAS.this.io.print(this.dodgemsg);
            } else {
                monster.hit(this);
            }
        }

        public void hit(Located located) {
            AAS.this.io.print(this.hitmsg);
            int n = AAS.this.randomInRange(this.ldamage, this.hdamage);
            if (this.wieldedItem != null) {
                n += this.wieldedItem.weight;
                if (this.wieldedItem.isOnFire() && !located.isOnFire() && located.flammable) {
                    AAS.this.io.print("The searing heat of the burning " + this.wieldedItem.name + " sets the " + located.name + " alight!\n");
                    located.ignite();
                } else {
                    AAS.this.io.print("The " + this.wieldedItem.name + " bites deep!\n");
                }
                if (this.wieldedItem.poisonous && !located.isPoisoned()) {
                    located.poison();
                }
            } else {
                if (this.isOnFire() && !located.isOnFire() && located.flammable) {
                    this.printIfHere("A shower of sparks erupts as the burning " + this.name + " strikes home!\n", "Flames leap from your body and lick the " + located.name + "!\n");
                    located.ignite();
                }
                if (this.poisonous && !located.isPoisoned()) {
                    this.printIfHere("The " + this.name + " injects its cruel poison!\n", "You inject the " + located.name + " with cruel poison!");
                    located.poison();
                }
            }
            located.hurt(n);
            located.pullTriggers("hit");
        }

        public void heal(int n) {
            super.heal(n);
            this.printIfHere("The " + this.name + " looks stronger!\n", "You feel stronger!\n");
        }

        public void hurt(int n) {
            if (this.isHere()) {
                AAS.this.io.print(this.painmsg);
            }
            super.hurt(n);
        }

        public void zeroHitPoints() {
            if (this.isHere()) {
                AAS.this.io.print(this.death);
            }
            if (this.corpse != null) {
                Located located = (Located)AAS.this.getObject(this.corpse);
                located.moveInto(this.location);
                this.emptyInto(located);
            } else {
                this.emptyInto(this.location);
            }
            if (this != AAS.this.booby) {
                this.moveInto(null);
            }
            this.pullTriggers("kill");
        }

        public void describeSelfAndContents() {
            Located located;
            AAS.this.io.print(this.desc + "\n\n");
            if (this == AAS.this.booby) {
                AAS.this.io.print("You are carrying: ");
            } else {
                AAS.this.io.print(this.name + " is carrying: ");
            }
            LinkedList<Located> linkedList = new LinkedList<Located>();
            boolean bl = false;
            Iterator iterator = this.contents.iterator();
            while (iterator.hasNext()) {
                located = (Located)iterator.next();
                if (located.isWorn()) {
                    linkedList.add(located);
                    continue;
                }
                if (!located.isVisible()) continue;
                located.listSelfAndContents();
                bl = true;
            }
            if (!bl) {
                AAS.this.io.print("nothing! ");
            }
            if (this == AAS.this.booby) {
                AAS.this.io.print("\n\nYou are wearing: ");
            } else {
                AAS.this.io.print("\n\n" + this.name + " is wearing: ");
            }
            bl = false;
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                located = (Located)iterator.next();
                located.listSelfAndContents();
                bl = true;
            }
            if (!bl) {
                AAS.this.io.print("nothing! ");
            }
            AAS.this.io.print("\n");
        }
    }

    class Connection
    extends AASLoader {
        public String number;
        public String from;
        public String to;
        public String key;
        public String dir;
        public String deadly;
        public boolean locked;

        public Connection() {
            this.addStringAttr("number");
            this.addStringTag("from");
            this.addStringTag("to");
            this.addStringTag("dir");
            this.addStringTag("key");
            this.addStringTag("deadly");
            this.addFlagTag("locked");
        }

        protected void postload(Element element) {
            super.postload(element);
            AAS.this.addConnection(this);
            Room room = (Room)AAS.this.getObject(this.from);
            room.addExit(this.dir, this);
        }

        boolean goThrough() {
            Container container;
            if (this.locked && this.key != null && AAS.this.booby.contains(container = AAS.this.getObject(this.key))) {
                AAS.this.io.print("You use the " + container.name + " to unlock the door.\n\n");
                this.locked = false;
            }
            AAS.this.io.enterNewRoom();
            if (this.locked) {
                AAS.this.io.print("You can't go that way -- yet! It's locked!\n");
            } else if (this.deadly != null) {
                AAS.this.io.print(this.deadly);
                AAS.this.booby.hp = 0;
            } else {
                AAS.this.booby.moveInto(AAS.this.getObject(this.to));
                return true;
            }
            return false;
        }
    }

    class Room
    extends Container {
        public String bgcolor = "#EEFFEE";
        public String mdesc = "Nothing here!";
        public String smelldesc = "There is a faint smell of cheese here.";
        public String sounddesc = "Deafening silence!";
        public String deadly;
        public boolean lighted = false;
        public int score = 1;
        Map exits = new HashMap();

        public Room() {
            this.addStringTag("bgcolor");
            this.addStringTag("mdesc");
            this.addStringTag("smelldesc");
            this.addStringTag("sounddesc");
            this.addStringTag("deadly");
            this.addFlagTag("lighted");
            this.addIntTag("score");
        }

        void addExit(String string, Connection connection) {
            this.exits.put(string, connection);
        }

        public void postload(Element element) {
            super.postload(element);
            this.addTrigger("enter", new AddScoreTrigger(this.score), true);
            if (this.bgcolor.startsWith("#")) {
                this.bgcolor = this.bgcolor.substring(1);
            }
        }

        public void parseColour() {
            try {
                int n = Integer.parseInt(this.bgcolor, 16);
                int n2 = (n & 0xFF0000) >> 16;
                int n3 = (n & 0xFF00) >> 8;
                int n4 = n & 0xFF;
                AAS.this.io.setColour(n2, n3, n4);
            }
            catch (Exception exception) {
                AAS.this.io.setColour(255, 255, 255);
            }
        }

        public void describeSelfAndContents() {
            this.parseColour();
            AAS.this.io.print("\n" + this.name + "\n");
            if (!this.lighted) {
                AAS.this.io.setColour(0, 0, 0);
                AAS.this.io.print("All you can see is inky blackness!\n");
            } else {
                AAS.this.io.print(this.desc);
                AAS.this.io.print("\n\nYou can see:");
                boolean bl = false;
                Iterator<Object> iterator = this.contents.iterator();
                while (iterator.hasNext()) {
                    Located located = (Located)iterator.next();
                    if (located == AAS.this.booby || !located.isVisible()) continue;
                    AAS.this.io.print("  " + located.name);
                    bl = true;
                }
                if (!bl) {
                    AAS.this.io.print(" nothing!");
                }
                AAS.this.io.print("\n\nExits:");
                iterator = this.exits.keySet().iterator();
                if (!iterator.hasNext()) {
                    AAS.this.io.print(" none!");
                }
                while (iterator.hasNext()) {
                    AAS.this.io.print("  " + iterator.next());
                }
                AAS.this.io.print("\n");
            }
        }

        Connection getExit(String string) {
            return (Connection)this.exits.get(string);
        }
    }

    abstract class Located
    extends Container {
        public boolean flammable = false;
        public boolean inflammable = false;
        public boolean onfire = false;
        public boolean poisonous = false;
        public boolean pickupable = false;
        public boolean isvisible = false;
        public int hp = 100;
        public String loc;
        public String noun;
        public String adj;
        boolean poisoned = false;
        Container location;

        public Located() {
            this.addStringTag("loc");
            this.addStringTag("noun");
            this.addStringTag("adj");
            this.addIntTag("hp");
            this.addFlagTag("flammable");
            this.addFlagTag("inflammable");
            this.addFlagTag("onfire");
            this.addFlagTag("poisonous");
            this.addFlagTag("pickupable");
            this.addFlagTag("isvisible");
            this.addSubLoaderTag("visible");
        }

        public void load_visible(Element element) {
            this.isvisible = true;
        }

        protected void postload(Element element) {
            super.postload(element);
            AAS.this.addVocab(this);
        }

        public void preinit() {
            this.location = AAS.this.getObject(this.loc);
            if (this.location == null) {
                System.err.println(this.name + " is in a non-existent location!");
            } else {
                this.location.add(this);
            }
        }

        protected boolean isContainedBy(Container container) {
            if (this.location == container) {
                return true;
            }
            if (this.location == null) {
                return false;
            }
            if (container == null) {
                return false;
            }
            return container.contains(this.location);
        }

        public void printIfHere(String string, String string2) {
            if (this == AAS.this.booby) {
                AAS.this.io.print(string2);
            } else if (this.isHere()) {
                AAS.this.io.print(string);
            }
        }

        public boolean isHere() {
            return this.getOuterContainer() == AAS.this.booby.getOuterContainer();
        }

        public boolean isVisible() {
            return this.isHere() && this.isvisible;
        }

        public boolean isOpen() {
            return false;
        }

        public boolean isOn() {
            return false;
        }

        public boolean isEaten() {
            return false;
        }

        public boolean isDrunk() {
            return false;
        }

        public boolean isWorn() {
            return false;
        }

        public boolean isOnFire() {
            return this.onfire;
        }

        public boolean isPoisoned() {
            return this.poisoned;
        }

        public boolean isAlive() {
            return this.hp > 0;
        }

        public boolean isDead() {
            return this.hp <= 0;
        }

        public void defend(Monster monster) {
            monster.hit(this);
        }

        public boolean do_open() {
            AAS.this.io.print("You can't open that!\n");
            return false;
        }

        public boolean do_close() {
            AAS.this.io.print("You can't close that!\n");
            return false;
        }

        public void heal(int n) {
            this.hp += n;
        }

        public void hurt(int n) {
            this.hp -= n;
            this.pullTriggers("hp");
        }

        public void ignite() {
            if (!this.onfire) {
                this.printIfHere("The " + this.name + " catches fire!\n", "You catch fire!\n");
                this.onfire = true;
                this.pullTriggers("ignite");
            }
        }

        public void douse() {
            if (this.onfire) {
                this.printIfHere("The burning " + this.name + " sputters out.\n", "You stop burning. Phew!\n");
                this.onfire = false;
                this.pullTriggers("douse");
            }
        }

        public void poison() {
            if (!this.poisoned) {
                this.printIfHere("Virulent poison seeps into the " + this.name + ".\n", "You gasp as virulent poison spreads through your system!\n");
                this.poisoned = true;
                this.pullTriggers("poison");
            }
        }

        public void esuna() {
            if (this.poisoned) {
                this.printIfHere("The " + this.name + " recovers from the poison.\n", "You sigh in relief as your body recovers from the effects of the poison.\n");
                this.poisoned = false;
                this.pullTriggers("esuna");
            }
        }

        public abstract void zeroHitPoints();

        public void eachTurn() {
            super.eachTurn();
            if (this.isAlive() && this.isOnFire()) {
                this.printIfHere("The " + this.name + " is burning!\n", "You're on fire! Ouch!\n");
                this.hurt(this.inflammable ? 100 : 10);
            }
            if (this.isAlive() && this.isPoisoned()) {
                this.printIfHere("The poison takes its toll on the " + this.name + ".\n", "You gasp as the poison takes its toll.\n");
                this.hurt(3);
            }
            if (this.location != null && this.hp <= 0) {
                this.hp = 0;
                this.zeroHitPoints();
            }
        }

        public Container getOuterContainer() {
            if (this.location == null) {
                return null;
            }
            return this.location.getOuterContainer();
        }

        public void moveInto(Container container) {
            if (this.location != null) {
                this.location.remove(this);
            }
            this.location = container;
            if (this.location != null) {
                this.location.add(this);
            }
        }

        public boolean do_wield() {
            AAS.this.io.print("What a strange idea!\n");
            return false;
        }

        public boolean do_unwield() {
            AAS.this.io.print("What a bizarre notion!\n");
            return false;
        }

        public boolean do_pickup() {
            AAS.this.io.print("Don't be silly!\n");
            return false;
        }

        public boolean do_putdown() {
            AAS.this.io.print("Don't be ridiculous!\n");
            return false;
        }

        public boolean do_wear() {
            AAS.this.io.print("Don't be stupid!\n");
            return false;
        }

        public boolean do_unwear() {
            AAS.this.io.print("You are insane!\n");
            return false;
        }

        public boolean do_eat() {
            AAS.this.io.print("Very funny!\n");
            return false;
        }

        public boolean do_drink() {
            AAS.this.io.print("What nonsense!\n");
            return false;
        }

        public boolean do_turnon() {
            AAS.this.io.print("You can't turn that on!\n");
            return false;
        }

        public boolean do_turnoff() {
            AAS.this.io.print("You can't turn that off!\n");
            return false;
        }

        public void listSelfAndContents() {
            AAS.this.io.print(this.name + "  ");
        }
    }

    abstract class Container
    extends TriggerHappy {
        public Set contents = new HashSet();
        public String number = "0";
        public String name = "untitled";
        public String desc = "Nothing to see here!";

        public void add(Object object) {
            this.contents.add(object);
        }

        public void remove(Object object) {
            this.contents.remove(object);
        }

        public void emptyInto(Container container) {
            Iterator iterator = this.contents.iterator();
            while (iterator.hasNext()) {
                Located located = (Located)iterator.next();
                located.location = container;
                container.add(located);
            }
            this.contents.clear();
        }

        public Container getOuterContainer() {
            return this;
        }

        public boolean contains(Container container) {
            return container == null ? false : container.isContainedBy(this);
        }

        protected boolean isContainedBy(Container container) {
            return false;
        }

        public Container() {
            this.addStringAttr("number");
            this.addStringTag("name");
            this.addStringTag("desc");
        }

        public void preinit() {
        }

        public void eachTurn() {
        }

        public void checkForWin() {
        }

        protected void postload(Element element) {
            super.postload(element);
            AAS.this.addObject(this);
        }

        public void describeSelfAndContents() {
            AAS.this.io.print(this.desc + "\n");
        }
    }

    public static interface IO {
        public void print(String var1);

        public void alert(String var1);

        public String input() throws IOException;

        public void clear();

        public void setColour(int var1, int var2, int var3);

        public void enterNewRoom();
    }
}

