#include "stdafx.h"
#include "resource.h"

#include <SIPAPI.H>
#include <aygshell.h>
#include <Commdlg.h>


#include "MagneticWinCEUtility.h"
#include "MagneticWinCEInterface.h"
#include "Graphics.h"

extern "C"
{
#include "defs.h"
}

#define ID_EDITBOX1     1

struct VerbLookup {
	unsigned short ID;
	wchar_t* Verb;
};


VerbLookup verblookuptable[]={ 
	{ID_LOOKAT,L"look at %s"},
	{ID_GET,L"get %s"},
	{ID_OPEN,L"open %s"},
	{ID_CLOSE,L"close %s"}, 
	{ID_INVENTORY,L"inventory"}
};
 
LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK WndProcEdit1Subclass(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
void OpenGame(HWND);
void DoVerb(unsigned short);

WNDPROC WndProcEdit1Original;

unsigned int iGraphicsOn = MF_CHECKED;
SHACTIVATEINFO g_sai;
HFONT hFontEdit = NULL;
HINSTANCE thisInstance;
HWND hwndEdit;
HWND hwndMain;
HMENU hMenuMain;


extern bool bRequestInput;
extern bool bResponseReturned;
extern bool bResponseUndo;
extern int iLastOutputPosition;
extern wchar_t statusoutput[100];

int iFontCount = 0;


int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,PWSTR szCmdLine, int iCmdShow)
{
	static wchar_t szAppName[] = TEXT("MagneticWinCE") ;
	HWND         hwnd ;
	MSG          msg ;
	WNDCLASS     wndclass ;

	thisInstance = hInstance;

	wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
	wndclass.lpfnWndProc   = WndProc ;
	wndclass.cbClsExtra    = 0 ;
	wndclass.cbWndExtra    = 0 ;
	wndclass.hInstance     = hInstance ;
	wndclass.hIcon         = LoadIcon (NULL, MAKEINTRESOURCE(IDI_MS)) ;
	wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
	wndclass.hbrBackground = (HBRUSH) GetStockObject (WHITE_BRUSH) ;
	wndclass.lpszMenuName  = NULL ;
	wndclass.lpszClassName = szAppName ;

     if (!RegisterClass (&wndclass))  
     {
          MessageBox (NULL, TEXT ("Unable to register main window"), szAppName, MB_ICONERROR) ;
          return 0 ;
     }

     hwndMain = hwnd = CreateWindow (szAppName, TEXT ("Magnetic for WinCE"),
                          WS_VISIBLE ,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL);
	
     ShowWindow (hwnd, iCmdShow);
     UpdateWindow (hwnd);

	 PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE);
	// run till completed
	while (msg.message!=WM_QUIT) {
		// is there a message to process?
		if (PeekMessage( &msg, NULL, 0, 0, PM_REMOVE)) {
			// dispatch the message
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		} else {
			if(ms_is_running()) ms_rungame(); // execute game instruction if no pending messages
		}
	}

	return msg.wParam;
}

int CALLBACK EnumFontFamProc(ENUMLOGFONT FAR *lpelf, TEXTMETRIC FAR *lpntm, int FontType, LPARAM lParam)
{
	AppendMenu((HMENU)lParam,MF_STRING | MF_ENABLED ,ID_FONT_PLACEHOLDER + iFontCount++,lpelf->elfFullName);
	return 1;
}

HMENU GetFontMenu() {
	HMENU hDisplay;
	hDisplay = GetSubMenu(hMenuMain,2);
	return GetSubMenu(hDisplay,6);
}


void SetScalerMenu(HMENU theMenu) {

	CheckMenuRadioItem(theMenu,ID_GRAPHICS_50,ID_GRAPHICS_200,ID_GRAPHICS_PLACEHOLDER + GetScale(),MF_BYCOMMAND);			

}

void SetFont(int iFontIndex) {

	DWORD dwRequired;
	LONG  dwFontSize;
	dwFontSize = 12;
	SHGetUIMetrics(SHUIM_FONTSIZE_PIXEL, &dwFontSize, sizeof(dwFontSize), &dwRequired);

	HMENU hFontMenu = GetFontMenu();
	CheckMenuRadioItem(hFontMenu,ID_FONT_PLACEHOLDER,ID_FONT_PLACEHOLDER + iFontCount,ID_FONT_PLACEHOLDER + iFontIndex,MF_BYCOMMAND);
	
	wchar_t selectedfont[LF_FULLFACESIZE];
	MENUITEMINFO lpmii;
	lpmii.cbSize = sizeof(LPMENUITEMINFO);
	lpmii.fMask = MIIM_TYPE;
	lpmii.fType = MFT_STRING;
	lpmii.fState = NULL;
	lpmii.wID = ID_FONT_PLACEHOLDER + iFontIndex;
	lpmii.hSubMenu = NULL;
	lpmii.hbmpChecked = NULL;
	lpmii.hbmpUnchecked = NULL;
	lpmii.dwItemData = NULL;
	lpmii.dwTypeData = selectedfont;
	lpmii.cch = LF_FULLFACESIZE;

	GetMenuItemInfo(
		hFontMenu, 
		iFontIndex, 
		true,		//menu item position
		&lpmii 
	);

//	MessageBoxPrintf(L"FONT",L"%s",selectedfont);
	LOGFONT lf;
	memset(&lf, 0, sizeof(lf));
//		GetMenuString(hFont,ID_FONT_PLACEHOLDER,lf.lfFaceName,LF_FACESIZE,MF_BYCOMMAND);
	lstrcpy(lf.lfFaceName, selectedfont);
	lf.lfHeight = -dwFontSize;
	lf.lfWeight = FW_NORMAL;
	if(hFontEdit) DeleteObject((HGDIOBJ)hFontEdit);
	hFontEdit = CreateFontIndirect(&lf);
	
	SendMessage(hwndEdit,WM_SETFONT,(WPARAM)hFontEdit,TRUE);
	SendMessage(hwndEdit,EM_SCROLLCARET,0,0);
}


LRESULT CALLBACK WndProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{

	static HWND hwndMenuBar;

	switch (message) {
	case WM_CREATE:
//------Setup menu bar
		SHMENUBARINFO mbi;

		memset(&mbi, 0, sizeof(SHMENUBARINFO));
		mbi.cbSize     = sizeof(SHMENUBARINFO);
		mbi.hwndParent = hwnd;
		mbi.nToolBarId = IDR_MENUMAIN;
		mbi.hInstRes   = thisInstance;
		mbi.nBmpId     = 0;
		mbi.cBmpImages = 0;

        memset (&g_sai, 0, sizeof (g_sai));
        g_sai.cbSize = sizeof (g_sai);

		if(SHCreateMenuBar(&mbi)) {
			hwndMenuBar = mbi.hwndMB;
		}
		else {
			MessageBox(hwnd,L"ERROR",L"Unable to create menubar",MB_OK);
		}

		hMenuMain = (HMENU) SendMessage(hwndMenuBar,SHCMBM_GETMENU,(WPARAM)0,(LPARAM)IDR_MENUMAIN); 
//		CheckMenuRadioItem(hMenuMain,ID_GRAPHICS_200,ID_GRAPHICS_50,ID_GRAPHICS_100,MF_BYCOMMAND);
		SetScalerMenu(hMenuMain);
//------Setup edit box
		hwndEdit = CreateWindow (TEXT ("edit"), NULL,
			WS_CHILD | WS_VISIBLE | WS_VSCROLL |
			WS_BORDER | ES_MULTILINE | ES_AUTOVSCROLL,
			0, 0, 0, 0, 
			hwnd, 
			0,
			thisInstance,
			NULL);

		WndProcEdit1Original = (WNDPROC)GetWindowLong(hwndEdit, GWL_WNDPROC);
		SetWindowLong(hwndEdit, GWL_WNDPROC, (long)WndProcEdit1Subclass);

		SendMessage(
			hwndEdit,
			(UINT) EM_SETLIMITTEXT,
			10000000,
			0
		);

//------Setup font menu		
		HMENU hMenuFont;
		hMenuFont = GetFontMenu();
		DeleteMenu(hMenuFont,0,MF_BYPOSITION);

		HDC hdc;
		hdc = GetDC(hwnd);
		EnumFontFamilies(
			hdc, 
			NULL, 
			(FONTENUMPROC)EnumFontFamProc, 
			(LPARAM)hMenuFont
		);
		ReleaseDC(hwnd,hdc);

		SetFont(0);

		return 0;
		break;
	case WM_SIZE : 
		int	 cyClient, cxClient;
		cxClient = LOWORD(lParam);
		cyClient = HIWORD(lParam);

		SIPINFO si;
		// Query the SIP state and size our window appropriately.
		memset (&si, 0, sizeof (si));
		si.cbSize = sizeof (si);
		SHSipInfo(SPI_GETSIPINFO, 0, (PVOID)&si, FALSE); 

		cxClient = si.rcVisibleDesktop.right - si.rcVisibleDesktop.left;
		cyClient = si.rcVisibleDesktop.bottom - si.rcVisibleDesktop.top;

		// If the SIP is not shown, or is showing but not docked, the
		// desktop rect doesn't include the height of the menu bar.
		if (!(si.fdwFlags & SIPF_ON) || ((si.fdwFlags & SIPF_ON) && !(si.fdwFlags & SIPF_DOCKED))) { 
			RECT rectMB;
			GetWindowRect(hwndMenuBar, &rectMB);
			cyClient -= (rectMB.bottom - rectMB.top);  
		}

		MoveWindow (hwndEdit, 0, 0, cxClient , cyClient, TRUE) ;
		SendMessage(hwndEdit,EM_SCROLLCARET,0,0);
		return 0;
		break;
	case WM_DESTROY:
		CommandBar_Destroy(hwndMenuBar);
		DeleteObject((HGDIOBJ)hFontEdit);
		PostQuitMessage(0) ;
		return 0;
		break;
	case WM_COMMAND:
		if(LOWORD(wParam) >= ID_FONT_PLACEHOLDER && LOWORD(wParam) < ID_FONT_PLACEHOLDER + iFontCount) {
			SetFont(LOWORD(wParam)-ID_FONT_PLACEHOLDER);
			//MessageBoxPrintf(L"Selected Font",L"%i",LOWORD(wParam)-ID_FONT_PLACEHOLDER);
			break;
			return 0;
		}

		if(LOWORD(wParam)>=ID_LOOKAT && LOWORD(wParam)<=ID_INVENTORY) {
			DoVerb(LOWORD(wParam));
			break;
			return 0;
		}

		switch(LOWORD(wParam)) {
			case ID_FILE_EXIT:
				SendMessage (hwnd, WM_CLOSE, 0, 0);
				break;
			case ID_FILE_OPEN:
				OpenGame(hwnd);
				SetFocus(hwndEdit);
				break;
			case ID_GRAPHICS_TOGGLE:
				if(iGraphicsOn == MF_CHECKED) {
					iGraphicsOn = MF_UNCHECKED;
					GraphicsOff();
				}
				else {
					iGraphicsOn = MF_CHECKED;
					GraphicsOn();
				}
				CheckMenuItem(hMenuMain,ID_GRAPHICS_TOGGLE,iGraphicsOn);
				SetFocus(hwndEdit);
				break;
			case ID_GRAPHICS_200: 
			case ID_GRAPHICS_100: 
			case ID_GRAPHICS_50: 
				SetScale(LOWORD(wParam)-ID_GRAPHICS_PLACEHOLDER);
				SetScalerMenu(hMenuMain);
				break;
			case ID_UNDO: 
				bResponseUndo = true;
				break;
			case IDM_HELP_ABOUT:
				DialogBox(thisInstance,(LPCTSTR)IDD_ABOUTBOX,hwnd,(DLGPROC)About);
				break;
			case ID_EDIT_CUT:
				SendMessage(hwndEdit,WM_CUT,0,0);
				break;
			case ID_EDIT_COPY:
				SendMessage(hwndEdit,WM_COPY,0,0);
				break;
			case ID_EDIT_PASTE:
				SendMessage(hwndEdit,WM_PASTE,0,0);
				break;	
	}
		return 0;
		break;
    case WM_ACTIVATE:
        SHHandleWMActivate(hwnd, wParam, lParam, &g_sai, FALSE);
		return 0;
        break;
    case WM_SETTINGCHANGE:
        SHHandleWMSettingChange(hwnd, wParam, lParam, &g_sai);
		return 0;
        break;


	}	// switch

	return DefWindowProc (hwnd, message, wParam, lParam) ;
}








void OpenGame(HWND hwnd) {

	LRESULT   lResult = TRUE;
	wchar_t   szFile[MAX_PATH] = TEXT("\0");

	OPENFILENAME   ofn;

	memset( &(ofn), 0, sizeof(ofn));
	ofn.lStructSize   = sizeof(ofn);
	ofn.hwndOwner = hwnd;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = MAX_PATH;
	ofn.lpstrFilter = TEXT("MAG (*.MAG)\0*.MAG\0");   
	ofn.lpstrTitle = TEXT("Open File");
	ofn.Flags = OFN_EXPLORER;
	ofn.lpstrInitialDir = TEXT("\\");
	if (GetOpenFileName(&ofn))  {
		//MessageBox(NULL, ofn.lpstrFile, TEXT("Info"), MB_OK);

		char gamename[MAX_PATH];
		char gfxname[MAX_PATH];

		WideCharToMultiByte(
		  CP_ACP,            // code page
		  0,            // performance and mapping flags
		  ofn.lpstrFile,    // wide-character string
		  lstrlen(ofn.lpstrFile),          // number of chars in string.
		  gamename,     // buffer for new string
		  MAX_PATH,          // size of buffer
		  NULL,     // default for unmappable chars
		  NULL  // set when default char used
		);

		gamename[lstrlen(ofn.lpstrFile)]=0;

		strcpy(gfxname,gamename);
		strcpy(gfxname + lstrlen(ofn.lpstrFile) - 3,"GFX");

		if(ms_is_running()) {
			ms_stop();
			ms_freemem();
		}

		bRequestInput = false;
		SetWindowText(hwndEdit,TEXT(""));
		statusoutput[0]=0;
		TerminateGraphics();

		if(!ms_init((signed char *)gamename,(signed char *)gfxname,NULL)) {
			MessageBox(hwnd,TEXT("FAILURE"),TEXT("FAILURE"),MB_OK);
		}
	}
}



LRESULT WndProcEdit1Subclass(HWND hWnd, UINT message,WPARAM wParam, LPARAM lParam) {
	int startsel,endsel;
	switch (message) {
	case WM_CUT:
	case WM_PASTE:
		startsel = endsel = 0;
		SendMessage(
		   hWnd,
		   EM_GETSEL,
		   (WPARAM)&startsel,
		   (LPARAM)&endsel
		);
		if(startsel<iLastOutputPosition) return 0;
		return CallWindowProc(WndProcEdit1Original, hWnd, message,wParam, lParam);
		break;
	case WM_LBUTTONDOWN:
		
		RECT r;
		GetWindowRect(hWnd,&r);
		SHRGINFO rg;
		rg.cbSize = sizeof(rg);
		rg.hwndClient = hWnd;
		rg.dwFlags = SHRG_RETURNCMD;
		rg.ptDown.x = LOWORD(lParam);
		rg.ptDown.y = HIWORD(lParam);
		if(SHRecognizeGesture(&rg) == GN_CONTEXTMENU) {

			HMENU hPopup = LoadMenu(thisInstance,MAKEINTRESOURCE(IDR_MENUMAIN));
			
			TrackPopupMenu(
				GetSubMenu(hPopup,1), 
				TPM_LEFTALIGN | TPM_TOPALIGN, 
				LOWORD(lParam) + r.left, 
				HIWORD(lParam) + r.top, 
				0, 
				hwndMain, 
				NULL 
			);

			DestroyMenu(hPopup);
			return 0;
		}
		return CallWindowProc(WndProcEdit1Original, hWnd, message,wParam, lParam);
		break;
    case WM_CHAR:
		startsel = endsel = 0;
		SendMessage(
		   hWnd,
		   EM_GETSEL,
		   (WPARAM)&startsel,
		   (LPARAM)&endsel
		);
		
		if(startsel<iLastOutputPosition) {
			return 0;
		}
		else if(startsel==iLastOutputPosition&&endsel==iLastOutputPosition&&wParam==VK_BACK) {
			return 0;
		}
		else {
			if(wParam==10||wParam==13) {
				int iNumberOfCharacters = SendMessage(hWnd,WM_GETTEXTLENGTH,0,0);
				SendMessage(hWnd,EM_SETSEL,iNumberOfCharacters,iNumberOfCharacters);
				bResponseReturned = true;
			}
		}
		return CallWindowProc(WndProcEdit1Original, hWnd, message,wParam, lParam);
		break;
	case WM_KEYDOWN:
		if(wParam==VK_UP||wParam==VK_DOWN) {
			wchar_t* history = GetHistory(wParam==VK_UP);
			if(history) {
				int iTotalLength = GetWindowTextLength(hwndEdit);
				SendMessage(hwndEdit,EM_SETSEL,(WPARAM)iLastOutputPosition,(LPARAM)iTotalLength);
				SendMessage(hwndEdit,EM_REPLACESEL,false,(LPARAM)history);
			}
			return 0;
		}
	default:
		return CallWindowProc(WndProcEdit1Original, hWnd, message,wParam, lParam);
	}
}


// Mesage handler for the About box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	SHINITDLGINFO shidi;

	switch (message)
	{
		case WM_INITDIALOG:
			// Create a Done button and size it.  
			shidi.dwMask = SHIDIM_FLAGS;
			shidi.dwFlags = SHIDIF_DONEBUTTON | SHIDIF_SIPDOWN | SHIDIF_SIZEDLGFULLSCREEN;
			shidi.hDlg = hDlg;
			SHInitDialog(&shidi);
			return TRUE; 
		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK)
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}

void DoVerb(unsigned short MenuID) {

	wchar_t* outputbuffer=NULL;

	for(int i=0;i<sizeof(verblookuptable);i++) {
		if(verblookuptable[i].ID==MenuID) {
			outputbuffer=verblookuptable[i].Verb;
			break;
		}
	}
	if(!outputbuffer) return;

	int startsel,endsel,selsize;
	SendMessage(
	   hwndEdit,
	   EM_GETSEL,
	   (WPARAM)&startsel,
	   (LPARAM)&endsel
	);

	selsize = endsel-startsel;
	if(selsize==0 && wcschr(outputbuffer,'%')) return;
	
	int iTotalLength = GetWindowTextLength(hwndEdit);
	wchar_t* fullbuffer = new wchar_t[iTotalLength];
	wchar_t *selected = new wchar_t[1+selsize];
	GetWindowText(hwndEdit,fullbuffer,iTotalLength);
	memcpy(selected,fullbuffer+startsel,selsize*2);
	selected[selsize]=0;
	delete[] fullbuffer;
	
	wchar_t* results = new wchar_t[lstrlen(outputbuffer) + lstrlen(selected) + 1];
	wsprintf(results,outputbuffer,selected);

	SendMessage(hwndEdit,EM_SETSEL,(WPARAM)iLastOutputPosition,(LPARAM)iTotalLength);
	SendMessage(hwndEdit,EM_REPLACESEL,false,(LPARAM)results);
	SendMessage(hwndEdit,WM_CHAR,10,0);

	delete[] results;

}