#include "stdafx.h"
#include "resource.h"

#include <SIPAPI.H>
#include <aygshell.h>
#include <Commdlg.h>
#include "MagneticWinCEUtility.h"

extern "C"
{
#include "defs.h"
}

#define OUTPUT_BUFFER 50
#define VISIBLE_LINES 100

bool bRequestInput = false;
bool bResponseReturned = false;
bool bResponseUndo = false;
int iLastOutputPosition;

extern HWND hwndMain;
extern HWND hwndEdit;

wchar_t output[OUTPUT_BUFFER];
int iOutputPointer=0;

wchar_t statusoutput[100];
int iStatusPointer=0;

struct historyInput {
	wchar_t* input;
	historyInput* previoushistory;
	historyInput* nexthistory;
};

historyInput* historyEnd = NULL;
historyInput* historyIndex = NULL;

void AddHistory(wchar_t* toadd) {
	historyInput* i = new historyInput;
	i->input = new wchar_t[wcslen(toadd)+1];
	wcscpy(i->input,toadd);
	i->input[wcslen(toadd)-1]=0;	// trim off the trailing line feed
	i->previoushistory = historyEnd;
	i->nexthistory = NULL;
	if(historyEnd) historyEnd->nexthistory=i;
	historyEnd = i;
	historyIndex = NULL;
}

//	Gets the current history
//	boolean argument	true - backwards in history
//						false - forwards in history
wchar_t* GetHistory(bool direction) {
	
	wchar_t* retval = NULL;

	if(direction) {
		if(historyIndex==NULL) {
			historyIndex = historyEnd;
		}
		else if(historyIndex->previoushistory) {
			historyIndex = historyIndex->previoushistory;
		}
		else return NULL;
	}
	else {
		if(historyIndex==NULL) return NULL;
		if(historyIndex->nexthistory) {
			historyIndex = historyIndex->nexthistory;
		}
		else return NULL;
	}
	return historyIndex->input;
}

void ClearHistory() {
	
	
}

type8 ms_load_file(type8s * name, type8 * ptr, type16 size) {
	HANDLE file_load;
	wchar_t filename[MAX_PATH];

	if(name==NULL) {
		OPENFILENAME   ofn;
		
		filename[0]=0;
		memset( &(ofn), 0, sizeof(ofn));
		ofn.lStructSize   = sizeof(ofn);
		ofn.hwndOwner = hwndMain;
		ofn.lpstrFile = filename;
		ofn.nMaxFile = MAX_PATH;
		ofn.lpstrFilter = TEXT("SAV (*.SAV)\0*.SAV\0");   
		ofn.lpstrTitle = TEXT("Load Game");
		ofn.Flags = OFN_EXPLORER;
		ofn.lpstrInitialDir = TEXT("\\");
		if (GetOpenFileName(&ofn))  {
			lstrcpy(filename,ofn.lpstrFile);
		}
		else {
			return 1;
		}
	}
	else {
		MultiByteToWideChar(
		  CP_ACP,         // code page
		  0,         // character-type options
		  (char*)name, // string to map
		  strlen((char*)name),       // number of bytes in string
		  filename,  // wide-character buffer
		  MAX_PATH        // size of buffer
		);	
		filename[strlen((char*)name)]=0;
	}

	file_load = CreateFile(
		filename, 
		GENERIC_READ, 
		0, //DWORD dwShareMode, 
		NULL, //LPSECURITY_ATTRIBUTES lpSecurityAttributes, 
		OPEN_EXISTING, //DWORD dwCreationDispostion , 
		FILE_ATTRIBUTE_NORMAL, //DWORD dwFlagsAndAttributes, 
		NULL //HANDLE hTemplateFile
	);
	if(!file_load) return 1;	

	unsigned long iBytesRead;
	ReadFile( 
		file_load, //HANDLE hFile, 
		ptr, //LPVOID lpBuffer, 
		size, //DWORD nNumberOfBytesToRead, 
		&iBytesRead, 
		NULL //LPOVERLAPPED lpOverlapped
	); 
	
	CloseHandle(file_load);
//	SetFocus(hwndEdit);
	return 0;

}

type8 ms_save_file(type8s * name, type8 * ptr, type16 size) {

	HANDLE file_save;
	wchar_t filename[MAX_PATH];

	if(name==NULL) {

		OPENFILENAME   ofn;
		
		filename[0]=0;
		memset( &(ofn), 0, sizeof(ofn));
		ofn.lStructSize   = sizeof(ofn);
		ofn.hwndOwner = hwndMain;
		ofn.lpstrFile = filename;
		ofn.nMaxFile = MAX_PATH;
		ofn.lpstrFilter = TEXT("SAV (*.SAV)\0*.SAV\0");   
		ofn.lpstrTitle = TEXT("Save Game");
		ofn.Flags = OFN_EXPLORER;
		ofn.lpstrInitialDir = TEXT("\\");
		if (GetSaveFileName(&ofn))  {
			lstrcpy(filename,ofn.lpstrFile);
		}
		else {
			return 1;
		}
	}
	else {
		MultiByteToWideChar(
		  CP_ACP,         // code page
		  0,         // character-type options
		  (char*)name, // string to map
		  strlen((char*)name),       // number of bytes in string
		  filename,  // wide-character buffer
		  MAX_PATH        // size of buffer
		);	
		filename[strlen((char*)name)]=0;
	}


	file_save = CreateFile(
		filename, 
		GENERIC_WRITE, 
		0, //DWORD dwShareMode, 
		NULL, //LPSECURITY_ATTRIBUTES lpSecurityAttributes, 
		CREATE_ALWAYS, //DWORD dwCreationDispostion , 
		FILE_ATTRIBUTE_NORMAL, //DWORD dwFlagsAndAttributes, 
		NULL //HANDLE hTemplateFile
	);
	if(!file_save) return 1;

	unsigned long iBytesWritten;
	WriteFile( 
		file_save, // HANDLE hFile, 
		ptr, //LPCVOID lpBuffer, 
		size, //DWORD nNumberOfBytesToWrite, 
		&iBytesWritten, //LPDWORD lpNumberOfBytesWritten, 
		NULL //LPOVERLAPPED lpOverlapped
	);
	
	CloseHandle(file_save);
//	SetFocus(hwndEdit);
	return 0;

}

void ms_fatal(type8s * txt) {

	wchar_t* out;
	int numberofbytes = strlen((char*)txt);

	out = new wchar_t[numberofbytes+1];
	MultiByteToWideChar(
	  CP_ACP,         // code page
	  0,         // character-type options
	  (char*)txt, // string to map
	  numberofbytes,       // number of bytes in string
	  out,  // wide-character buffer
	  numberofbytes        // size of buffer
	);
	
	out[numberofbytes]='\0';
	MessageBox (NULL, out, TEXT("Fatal Error"), MB_ICONERROR);
	delete[] out;
}

type8 ms_showhints(struct ms_hint * hints) {
	return 0;
}

type8 ms_getchar(type8 trans) {

	static int inputpointer = 0;
	static wchar_t* input = NULL;
	bResponseUndo = false;
	bRequestInput = true;

	type8 retval;

	if(inputpointer==0) {	//if nothing currently buffered in output queue

		// Truncate the edit box to a specified number of lines.
		int numberoflines = SendMessage(hwndEdit,EM_GETLINECOUNT,0,0);
		SendMessage(hwndEdit,WM_SETREDRAW,false,0);	
		if(numberoflines>VISIBLE_LINES) {
			int startindex= SendMessage(hwndEdit,EM_LINEINDEX,numberoflines-VISIBLE_LINES,0);
			SendMessage(hwndEdit,EM_SETSEL,0,startindex);
			SendMessage(hwndEdit,EM_REPLACESEL,false,(LPARAM)L"");
		}

		iLastOutputPosition = GetWindowTextLength(hwndEdit);
		SendMessage(hwndEdit,EM_SETSEL,iLastOutputPosition,iLastOutputPosition);
		SendMessage(hwndEdit,EM_SCROLLCARET,0,0);
		SendMessage(hwndEdit,WM_SETREDRAW,true,0);	

		// Second message loop to run during input requests.
		MSG msg;
		while(GetMessage(&msg, NULL, 0, 0)) {

			TranslateMessage (&msg) ;
			DispatchMessage (&msg) ;
	
			if(!bRequestInput) return 1;	//Input request cancelled - ie, new game started
			if(bResponseUndo) return 0;
			if(bResponseReturned) break;	//	ie if user has typed CR/LF
		}	// while

		if(msg.message==WM_QUIT) {
			ms_stop(); 
			PostQuitMessage(0);
			return 1;
		}

		if(input) delete[] input;
		int iTotalLength = GetWindowTextLength(hwndEdit);
		wchar_t* fullbuffer = new wchar_t[iTotalLength+1];
		input = new wchar_t[iTotalLength+1-iLastOutputPosition];
		GetWindowText(hwndEdit,fullbuffer,iTotalLength);
		fullbuffer[iTotalLength]=0;
		lstrcpy(input,fullbuffer+iLastOutputPosition);
		AddHistory(input); 
		delete[] fullbuffer;
	}

	retval = (type8)input[inputpointer++];
	if(retval==13) retval=10;	// only 10 accepted for MW games

	if(input[inputpointer]==0) inputpointer = 0;  //Handle the case of no char input
	if(retval==10) inputpointer=0;	// detect EOL and reset pointer
	bRequestInput = false;
	bResponseReturned = false;
	return retval;	
}


void AppendToOutputBuffer(type8 c) {
	if(c==8) {
		iOutputPointer--;
		return;
	}
	if(c==10) {
		output[iOutputPointer++]=13;
	}
	output[iOutputPointer++]=c;
	if(iOutputPointer>=OUTPUT_BUFFER-1) ms_flush();
}


void ms_statuschar(type8 c) {
	AppendToOutputBuffer(c);

	if(/*c==13||*/c==10) {
		statusoutput[iStatusPointer++]=0;		
		iStatusPointer=0;
	}
	else if (c==9) {
		statusoutput[iStatusPointer++]=0;		
	}
	else statusoutput[iStatusPointer++]=c;
}

void ms_putchar(type8 c) {
	AppendToOutputBuffer(c);
}

void ms_flush(void) {
	if(iOutputPointer>0) {
		output[iOutputPointer]=0;
		SendMessage(
		   hwndEdit,
			EM_REPLACESEL,
			false,
			(LPARAM)output
		);
		iOutputPointer = 0;
	}
}
