#include <windows.h>
#include <aygshell.h>
#include "resource.h"
#include "Graphics.h"

#include "MagneticWinCEMain.h"
#include "MagneticWinCEUtility.h"
extern "C"
{
#include "defs.h"
}

int iScale = 100;

type16 pic_width;
type16 pic_height;
type8* pic_ptr_aligned = NULL; 

ms_position *framepositions = NULL;
type16 framecount;

HWND hwndGraphics = NULL;
type32 lastpic;
type8 lastmode;
extern HINSTANCE thisInstance;
extern HWND hwndMain;
extern unsigned int iGraphicsOn;
extern wchar_t statusoutput[];

HPALETTE hPalette;
LRESULT CALLBACK PictureWndProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);

void SetScale(int iNewScale) {
	if(iNewScale!=iScale) {
		iScale=iNewScale;
		ResizeWindowToImage();
		RepaintWindow();
	}
}

int GetScale() {
	return iScale;
}

void GraphicsOn() {
	if(hwndGraphics) { 
		SetForegroundWindow(hwndGraphics);
	}
	else {
		ms_showpic(lastpic,lastmode);
	}
}

void GraphicsOff() {
	framecount = 0;
	if(framepositions) delete[] framepositions;
	if(hwndGraphics) {
		SendMessage(hwndGraphics,WM_CLOSE,0,0);
		hwndGraphics = NULL;
	}
}

void TerminateGraphics() {
	lastpic = 0xFFFFFFFF;
	GraphicsOff();
}

void ms_showpic(type32 c, type8 mode) {

	static ATOM r =0;
	static wchar_t szAppName[] = TEXT ("MagneticWinCEPic");
	static wchar_t windowcaption[100];
	
	type8 pic_isanim;	

	if(c!=lastpic) {
		lstrcpy(windowcaption,statusoutput);
	}

	lastpic = c;
	lastmode = mode;

	if(mode==0||iGraphicsOn==MF_UNCHECKED) {
		GraphicsOff();
		return;
	}

	framecount = 0;
	if(framepositions) delete[] framepositions;


	if (!r) {
		 WNDCLASS     wndclass ;

		 wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
		 wndclass.lpfnWndProc   = PictureWndProc ;
		 wndclass.cbClsExtra    = 0 ;
		 wndclass.cbWndExtra    = 0 ;
		 wndclass.hInstance     = thisInstance;
		 wndclass.hIcon         = LoadIcon (NULL, MAKEINTRESOURCE(IDI_MS)) ;
		 wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
		 wndclass.hbrBackground = (HBRUSH) GetStockObject (WHITE_BRUSH) ;
		 wndclass.lpszMenuName  = NULL ;
		 wndclass.lpszClassName = szAppName ;

		 r = RegisterClass (&wndclass);
		 if (!r)  
		 {
			  MessageBox (NULL, TEXT ("Failed to register window!"), szAppName, MB_ICONERROR) ;
		 }

	}


	unsigned short pic_palette[16];
	type8* pic_ptr = ms_extract(c, &pic_width, &pic_height, pic_palette, &pic_isanim);
	if(!pic_ptr) {
	  MessageBox (NULL, TEXT ("No picture!"), szAppName, MB_ICONERROR);
	}
	else
	{
		if(hwndGraphics==NULL) {
			RECT rectMain;
			GetWindowRect(hwndMain,&rectMain);

			hwndGraphics = CreateWindow (szAppName, 
				TEXT ("Pic"),
				WS_CAPTION, 
				  rectMain.right - rectMain.left - pic_width - GetSystemMetrics(SM_CXVSCROLL) - GetSystemMetrics(SM_CXFIXEDFRAME),
				  0,
				  20,
				  20,
				hwndMain,
				NULL,
				thisInstance,
				NULL);
			SHDoneButton (
				hwndGraphics,
				SHDB_SHOW
			);
		}
		
		SetWindowText(hwndGraphics,windowcaption);

		LPLOGPALETTE lpLogPal = (LPLOGPALETTE)new BYTE[sizeof(LOGPALETTE) + 16*sizeof(PALETTEENTRY)];
		for(int i=0;i<16;i++) {
			lpLogPal->palPalEntry[i].peRed   = (pic_palette[i]&0x0F00)>>3;
			lpLogPal->palPalEntry[i].peGreen = (pic_palette[i]&0x00F0)<<1;
			lpLogPal->palPalEntry[i].peBlue  = (pic_palette[i]&0x000F)<<5;
			lpLogPal->palPalEntry[i].peFlags = 0;
		}
		lpLogPal->palVersion = 0x0300;
		lpLogPal->palNumEntries = 16;
		hPalette = CreatePalette(lpLogPal);
		delete [](byte *)lpLogPal;


		int iAlignment;
		iAlignment = pic_width % 2;

		if(pic_ptr_aligned) delete[] pic_ptr_aligned;
		pic_ptr_aligned = NULL;

		pic_ptr_aligned = new type8[(pic_width + iAlignment) * pic_height];

		if(iAlignment) {
			for(i = 0; i < pic_height; i++)
			{
				memcpy(pic_ptr_aligned+i*(pic_width + iAlignment),
						pic_ptr+i*pic_width,
						pic_width
						);
			}
		}
		else {
			memcpy(pic_ptr_aligned,pic_ptr,pic_width*pic_height);
		}

		ResizeWindowToImage();
		RepaintWindow();

		if(pic_isanim) {
			SetTimer(hwndGraphics, 1, 100, NULL);
		}
		
	} // if any pic_ptr

}

void ResizeWindowToImage() {
		RECT rect;
		SetRect(&rect, 0, 0, iScale * pic_width/100, iScale * pic_height/100);

/*		HDC hdc = GetDC(hwndGraphics);
		HBRUSH br = CreateSolidBrush(RGB(0,0,0));
		HGDIOBJ oldBrush = SelectObject(hdc,br);
		FillRect(hdc,&rect,br);
		SelectObject(hdc,oldBrush);
		DeleteObject(br);
		ReleaseDC(hwndGraphics,hdc);
*/
		AdjustWindowRectEx( 
			&rect, 
			WS_VISIBLE | WS_CAPTION, 
			false, 
			0  //DWORD dwExStyle 
		); 

		RECT rectMain;
		GetWindowRect(hwndMain,&rectMain);

		RECT rectGraphics;
		GetWindowRect(hwndGraphics,&rectGraphics);
//		GetClientRect(hwndGraphics,&rectGraphics);

		SetWindowPos(hwndGraphics,
				HWND_TOP,
				rectGraphics.left - rectMain.left,
				rectGraphics.top - rectMain.top,
				rect.right - rect.left,
				rect.bottom - rect.top,
				SWP_SHOWWINDOW);


}

void RepaintWindow() {
	RECT r2;
	SetRect(&r2, 0, 0, iScale * pic_width/100, iScale * pic_height/100);
	InvalidateRect(hwndGraphics,&r2,false);
	UpdateWindow(hwndGraphics);
}

void PaintGraphics(HDC hdc) {

	
	HBITMAP hBitmap = CreateBitmap (pic_width, pic_height, 1, 8, /*pic_ptr*/ pic_ptr_aligned) ;

	HDC hdcMem = CreateCompatibleDC(hdc);
	HGDIOBJ hMemBitmapOld = SelectObject(hdcMem, hBitmap);
	HPALETTE hOldPalette = SelectPalette(hdcMem, hPalette, FALSE);

	for(int frameindex=0;frameindex<framecount;frameindex++) {
		ms_position pos = framepositions[frameindex];
		type16 frame_width,frame_height;
		type8* frame_mask;
		type8* frame_data = ms_get_anim_frame(pos.number, &frame_width, &frame_height, &frame_mask);

		if(frame_data) {
			HBITMAP hframeBitmap;
			unsigned char* frame_data_aligned;
			int iAlignment = frame_width % 2;

			if(!iAlignment) {
				frame_data_aligned = frame_data;
				hframeBitmap = CreateBitmap(frame_width, frame_height, 1, 8, /*pic_ptr*/ frame_data_aligned) ;					
			}
			else {			
				frame_data_aligned = new unsigned char[(frame_width + iAlignment) * frame_height];
				for(int y = 0; y < frame_height; y++)
				{
					memcpy(frame_data_aligned+y*(frame_width+iAlignment),
						frame_data+y*frame_width,
						frame_width);
//					for(int x = 0; x < frame_width; x++)
//						frame_data_aligned[(y*(frame_width + iAlignment))+x] = frame_data[(y*frame_width)+x];
				}
				hframeBitmap = CreateBitmap(frame_width, frame_height, 1, 8, /*pic_ptr*/ frame_data_aligned) ;
				delete[] frame_data_aligned;
			}
			

			HDC hdcFrame = CreateCompatibleDC(hdcMem);	
			HGDIOBJ hFrameBitmapOld = SelectObject(hdcFrame, hframeBitmap);
			HPALETTE hFramePaletteOld = SelectPalette(hdcFrame, hPalette, FALSE);

			if(frame_mask) {

				HBITMAP hmaskBitmap;
				hmaskBitmap = CreateBitmap(frame_width, frame_height,1,1,frame_mask);

				MaskBlt(
					hdcMem, 
					pos.x, 
					pos.y, 
					frame_width, 
					frame_height, 
					hdcFrame, 
					0, 
					0, 
					hmaskBitmap, 
					0, 
					0, 
					MAKEROP4(0x00AA0000,SRCCOPY)
				); 
				DeleteObject(hmaskBitmap);
			}
			else {
				BitBlt(hdcMem, pos.x, pos.y, frame_width, frame_height, hdcFrame, 0,  0, SRCCOPY);
			}



			SelectPalette(hdcFrame,hFramePaletteOld,FALSE);
			SelectObject(hdcFrame,hFrameBitmapOld);
			DeleteObject(hframeBitmap);
			DeleteDC(hdcFrame);
		}	// If frame data present
	}	//Main for loop for frames



//	BitBlt(hdc, 0, 0, pic_width, pic_height, hdcMem, 0,  0, SRCCOPY);

	RECT rectGraphics;
	GetWindowRect(hwndGraphics,&rectGraphics);

	StretchBlt(
		hdc,		//HDC hdcDest, 
		0,			//int nXOriginDest, 
		0,			//int nYOriginDest, 
		rectGraphics.right - rectGraphics.left,	//	int nWidthDest, 
		rectGraphics.bottom - rectGraphics.top - GetSystemMetrics(SM_CYCAPTION),	//   int nHeightDest, 
		hdcMem,
		0,			//int nXOriginSrc, 
		0,			//int nYOriginSrc, 
		pic_width,	//int nWidthSrc, 
		pic_height,	//int nHeightSrc, 
		SRCCOPY
	); 

	SelectPalette(hdcMem, hOldPalette, FALSE);
	SelectObject (hdcMem, hMemBitmapOld);

	DeleteObject(hBitmap);
	DeleteDC(hdcMem);

}

LRESULT CALLBACK PictureWndProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{

     switch (message)
     {
	 case WM_PAINT:
		HDC hdc;
		PAINTSTRUCT ps;
		hdc = BeginPaint (hwnd, &ps) ;
		PaintGraphics(hdc);
		EndPaint(hwnd, &ps);
		return 0;	
		break;
	case WM_COMMAND:
		//IDOK
		SendMessage(hwnd,WM_CLOSE,0,0);
		hwndGraphics = NULL;
		return 0;
		break;
	case WM_TIMER:
		ms_position *tempframepositions;
		type16 tempframecount;
		type8 animationcontinues;
		animationcontinues = ms_animate(&tempframepositions,&tempframecount);
		if(!animationcontinues) {
			KillTimer(hwnd,1);
		}
		else {
			framecount = tempframecount;
			if(framepositions) delete[] framepositions;

			framepositions = new ms_position[framecount];

			memcpy(framepositions,tempframepositions,framecount*sizeof(ms_position));
		}
		RepaintWindow();
		return 0;
		break;

	case WM_LBUTTONDOWN:

		RECT r;
		GetWindowRect(hwnd,&r);
		SHRGINFO rg;
		rg.cbSize = sizeof(rg);
		rg.hwndClient = hwnd;
		rg.dwFlags = SHRG_RETURNCMD;
		rg.ptDown.x = LOWORD(lParam);
		rg.ptDown.y = HIWORD(lParam);
		if(SHRecognizeGesture(&rg) == GN_CONTEXTMENU) {

			HMENU hPopup = LoadMenu(thisInstance,MAKEINTRESOURCE(IDR_MENUMAIN));
			SetScalerMenu(hPopup);
			HMENU hDisplayMenu = GetSubMenu(hPopup,2);
			RemoveMenu(hDisplayMenu,6,MF_BYPOSITION);
			RemoveMenu(hDisplayMenu,5,MF_BYPOSITION);
			TrackPopupMenu(
				hDisplayMenu, 
				TPM_LEFTALIGN | TPM_TOPALIGN, 
				LOWORD(lParam) + r.left, 
				HIWORD(lParam) + r.top, 
				0, 
				hwndMain, 
				NULL 
			);

			DestroyMenu(hPopup);
			return 0;
		}


		return 0;
		break;

     }	// switch

     return DefWindowProc (hwnd, message, wParam, lParam) ;
}
