/*
	-------------------------------------------
	Magnetic 2.2 Front End for the Sega Dreamcast
	Copyright (c) 2004
        Eyatn Kaziberdov
	-------------------------------------------

        Requires KOS V1.2.0 by Dan Potter to compile.
        If you use this just give me credit
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <kos.h>
#include "defs.h"
#include <dc/maple.h>
#include <dc/video.h>
#include <dc/maple/keyboard.h>

#define width   39


extern uint8 romdisk[];
extern type32 i_count;
KOS_INIT_ROMDISK(romdisk);


type8		buffer[80],xpos=0,bufpos=0,log_on=0,ms_gfx_enabled,filename[128];
type8           textbuffer[255],textindex=0,charrom[2048],more=3,release=0;
type8           menubuffer[320*200+12],mousebuffer[16*16+2];
FILE		*log=0,*log2=0;
uint32          pos_x=2,pos_y=12;
type8            corrupt=1,fish=1,guild=1,jinxter=1,myth=1,pawn=1,wonder=1;
type8            ccorrupt=1,cfish=1,cguild=1;
type8            keyboard=0,controller=0,frame_count=0,current_frame=0,anims=0;
type8            *gamename=0, *gfxname=0, *sndname=0;
type16           menupalette[258],mousepalette[258],mouseunder[16*16+2],mouse_y=25,mouse_x=425;
type16           pal[16],textcolor=0xffff;
type8            scrncol=79,charwidth=8,scrnrow=27,mousespeed=1;; //defaults 39 16 23
cont_cond_t cond;

//animation
struct bmap
{
  int w, h;
  int bitmap[320*240];
};
struct bmap obitmap[4];

struct frame
{
  int x, y;
  int bitmap[320*240];
};
struct frame frames[20];


///////////////////////////////////////////////////////////////////////////
inline void plot_pixel16( unsigned int x, unsigned int y, unsigned short color )
{

	uint16 *pixel;


	pixel = (uint16*)(vram_s)+((y<<9)+(y<<7));
	pixel[x] = color;

}
///////////////////////////////////////////////////////////////////////////
unsigned short  get_pixel16( unsigned int x, unsigned int y)
{

	uint16 *pixel;


	pixel = (uint16*)(vram_s)+((y<<9)+(y<<7));
	return pixel[x];

}
///////////////////////////////////////////////////////////////////////////
void wipescrn32(void){
	uint32 *dblpixel=vram_l;
	uint32 i;

for(i=0; i<=153600; i++){
    *dblpixel=0x00000000;
    *dblpixel++;
}
}


///////////////////////////////////////////////////////////////////////////
type8 load_font(void){
        FILE *fh;


	if (!(fh=fopen("/rd/font.bin","rb")))return(1);
	fread(charrom,1,1400,fh);
	fclose(fh);

	return 0;

}

///////////////////////////////////////////////////////////////////////////

void dcprintf(uint16 *address,int scrnwidth,int reverse, char character){
     uint8 i,j,k=0;
     uint16 *screenptr;
     uint8 bitmask;
     int c;

  if(scrncol<40){
     for(i=0;i<16;i+=2){
        bitmask=0x80;

        for(j=0;j<16;j+=2){
           //if((charrom[j+(character*8)]&(bitmask>>i))!=0){
            c=charrom[k+((character)*8)]&(bitmask);
            if(reverse!=0)c=!c;
            bitmask = bitmask >>1;
            if(c!=0){
            screenptr=address+((i<<9)+(i<<7));
            screenptr[j]= textcolor;
            screenptr[j+1]= textcolor;

            screenptr=address+((i<<9)+(i<<7))+640;
            screenptr[j]= textcolor;
            screenptr[j+1]= textcolor;

           }
            else{
            screenptr=address+((i<<9)+(i<<7));
            screenptr[j]= 0x0000;
            screenptr[j+1]= 0x0000;

            screenptr=address+((i<<9)+(i<<7))+640;
            screenptr[j]= 0x0000;
            screenptr[j+1]= 0x0000;
            }
            }//end for J
            k++;
            }//end for I
           }//end if
           else{
          for(i=0;i<16;i+=2){
        bitmask=0x80;

        for(j=0;j<8;j++){
           //if((charrom[j+(character*8)]&(bitmask>>i))!=0){
            c=charrom[k+((character)*8)]&(bitmask);
            if(reverse!=0)c=!c;
            bitmask = bitmask >>1;
            if(c!=0){
            screenptr=address+((i<<9)+(i<<7));
            screenptr[j]= textcolor;
            //screenptr[j+1]= 0xffff;

            screenptr=address+((i<<9)+(i<<7))+640;
            screenptr[j]= textcolor;
            //screenptr[j+1]= 0xffff;

           }
            else{
            screenptr=address+((i<<9)+(i<<7));
            screenptr[j]= 0x0000;
            //screenptr[j+1]= 0x0000;

            screenptr=address+((i<<9)+(i<<7))+640;
            screenptr[j]= 0x0000;
            //screenptr[j+1]= 0x0000;
            }
            }//end for J
            k++;
            }//end for I

            }//end else
        
        
        }//end dcprintf
///////////////////////////////////////////////////////////////////////////
void sdcprintf(uint16 *address,int scrnwidth,int reverse, char * character){

     while(*character){
          dcprintf(address,scrnwidth,reverse, *character);
          character++;
          address+=charwidth;
     }
}


//////////////////////////////////////////////////////////////////////////////
void pcxload(int x,int y, char *pbuffer,type16 *ppalette, char *filename)
{
//FILE *fp, *fopen();
FILE *fp;
int num_bytes,index;
long count;
unsigned char data;
char header[130],red[258],green[258],blue[258];
fp = fopen(filename,"rb");

for (index=0; index<128; index++)
    {
    header[index] = fgetc(fp);
    } // end for index

count=0;
while(count<=(x * y))
     {
      data = fgetc(fp);

     if (data>=192 && data<=255)
        {
        num_bytes = data-192;
        data = fgetc(fp);
        while(num_bytes-->0)
             {
             pbuffer[count++] = data;
             } // end while
      } // end if rle
     else
        {
        pbuffer[count++] = data;
        } // end else not rle
} // end while
fseek(fp,-768L,SEEK_END);

for (index=0; index<256; index++)
    {
    red[index]   = (fgetc(fp) >> 3);
    green[index] = (fgetc(fp) >> 3);
    blue[index]  = (fgetc(fp) >> 3);
    ppalette[index]=(unsigned int *) ((blue[index])+ (green[index]<<5)+(red[index]<<10));
    } // end for index

fclose(fp);
//free(image->buffer);

} // end bkload

///////////////////////////////////////////////////////////////////////////
void dispkb(int x, int y){
        type16 ypict,xpict;
        type16 *pic=vram_s,index;
        index=0;

         for(ypict=y;ypict<y+184;ypict++){
           for(xpict=x;xpict<x+320;xpict++){

          plot_pixel16(xpict,ypict,menupalette[menubuffer[index]]);

          index++;
            }
           }
}
///////////////////////////////////////////////////////////////////////////
void ms_fatal(type8s *txt)
{
	fputs("\nFatal error: ",stderr);
	fputs(txt,stderr);
	fputs("\n",stderr);
	ms_status();
	exit(1);
}
///////////////////////////////////////////////////////////////////////////
type8 ms_showhints(struct ms_hint * hints)
{
	return 0;
}
///////////////////////////////////////////////////////////////////////////
void showdir(void){
dirent_t *de;
file_t d;
int y = 3;
uint32 i;
uint32 *dblpixel=0xa5100000;
char name[30];

for(i=0; i<=153600; i++){
*dblpixel=0x00000000;
*dblpixel++;
}




        vid_set_start(0x100000);

	d = fs_open("/vmu/a1", O_RDONLY | O_DIR);
        de = fs_readdir(d);
        if (!d) {
		//printf("Can't read VMU\n");
	} else {

        while ( (de = fs_readdir(d)) ) {
			strcpy(name,de->name);
                        //printf("%s",name);
                        sdcprintf(0xa5100000+(y*32*640)+(5*charwidth), 640,1,de->name);
                        //bfont_draw_str(vram_s + y*640+10, 640, 0, de->name);
			y +=1;
			if (y >= 48)
				break;
		}
 }
      fs_close(d);

                         while(kbd_get_key()!=-1); //empty the kb buffer
                         while(kbd_get_key()==-1);

 vid_set_start(0x000000);
}//end showdir
///////////////////////////////////////////////////////////////////////////
type8 ms_load_file(type8s *name, type8 *ptr, type16 size) {
	uint8 crap[200],i;
	char fail[15]="Load FAILED!";
       type8s filename[30]="/vmu/a1/";
       char good[15]="Load Complete!";
        file_t *fd;
       strcat(filename,name);


        fd=fs_open(filename,O_RDONLY);
        if (!fd) {
		for(i=0;i<14;i++){
                ms_statuschar(fail[i]);
                }
                ms_statuschar(0x0a);
		fs_close(fd);
                return(1);
	}
        fs_read(fd,crap,128); //read and ignore the header :)
        fs_read(fd,ptr,size);
        fs_close(fd);
         for(i=0;i<14;i++){
                ms_statuschar(good[i]);
                }
                ms_statuschar(0x09);

                ms_statuschar(0x0a);
		return(0);


}
///////////////////////////////////////////////////////////////////////////
type8 ms_save_file(type8s *name, type8 *ptr, type16 size) {
        vmu_pkg_t	pkg;
	uint8		*pkg_out;
	int		pkg_size,free,i;
	file_t		f;
	maple_device_t * dev;
	char fail[15]="SAVE FAILED!";
	char full[25]="VMU FULL CAN'T SAVE!";
	char good[15]="Save Complete!";
        type8s filename[30]="/vmu/a1/";
        ssize_t written;
        strcat(filename,name);

        dev = maple_enum_dev(0, 1);
        free =  vmufs_free_blocks(dev);

        if(free<((size+23040)/512)){
               for(i=0;i<20;i++){
                ms_statuschar(full[i]);
                }
                ms_statuschar(0x0a);

                return(1);
        }


        strcpy(pkg.desc_short, "Magnetic DC");
	strcpy(pkg.desc_long, "Magnetic Scrolls 2.2");
	strcpy(pkg.app_id, "MSDC");
	pkg.icon_cnt = 0;
	pkg.icon_anim_speed = 0;
	pkg.eyecatch_type = VMUPKG_EC_NONE;
	pkg.data_len = size;
	pkg.data = ptr;

        vmu_pkg_build(&pkg, &pkg_out, &pkg_size);


	fs_unlink(filename);
	f = fs_open(filename, O_WRONLY);
	if (!f) {
		for(i=0;i<14;i++){
                ms_statuschar(fail[i]);
                }
                ms_statuschar(0x0a);
		fs_close(f);
                return(1);
	}
	written = fs_write(f, pkg_out, pkg_size);
	fs_close(f);
                for(i=0;i<14;i++){
                ms_statuschar(good[i]);
                }
                ms_statuschar(0x09);

                ms_statuschar(0x0a);
		return(0);

}
///////////////////////////////////////////////////////////////////////////
void scroll(void){
        //end at line 448
        //move data to line 13 = 208

	uint32 *src,*dst;
	uint32 i;
        src=vram_s+(640*208);
        dst=vram_s+(640*192);

if(scrnrow<25){
               for(i=0; i<=640*132; i++){   //copy up data 132 640*132
                        *dst=*src;
                        src++;
                        dst++;
                        }
for(i=0; i<=640*80; i++){  //blank out the bottom line 640*40
         *src=0x00000000;
         src++;
         }
}//endif
else{
for(i=0; i<=640*154; i++){   //copy up data 132 640*132
         *dst=*src;
         src++;
         dst++;
}
for(i=0; i<=640*80; i++){  //blank out the bottom line 640*40
         *src=0x00000000;
         src++;
}
}//endelse

}
///////////////////////////////////////////////////////////////////////////
void wipescrn(void){
	uint32 *dblpixel=vram_s;
	uint32 i;
        dblpixel=vram_l+(128000);
for(i=0; i<=89600; i++){
         *dblpixel=0x00000000;
         *dblpixel++;
}
}
///////////////////////////////////////////////////////////////////////////
void wipepic(void){
	uint32 *dblpixel=vram_s;
	uint32 i;
        dblpixel=vram_l+5120;
for(i=0; i<=58240-1920; i++){
         *dblpixel=0x00000000;
         *dblpixel++;
}
}
///////////////////////////////////////////////////////////////////////////
void cleartop(void){
	uint32 *dblpixel=vram_s;
	uint32 i;

for(i=0; i<=5120; i++){
         *dblpixel=0x00000000;
         *dblpixel++;
}
}

///////////////////////////////////////////////////////////////////////////
void ms_statuschar(type8 c) {
	static type8 x=1;
	type16 oldtext;
        oldtext=textcolor;

        if(x==1)cleartop();
	textcolor=0x7fff;
        if (c==0x09) {
		//while (x+10<width) {
	          while (x+10<scrncol) {
			//printf(" ");
	               dcprintf(vram_s+(x*charwidth),640,1,c);
                	x++;

                }
                 textcolor=oldtext;
                return;
	}
	if (c==0x0a) {
		x=1;
                textcolor=oldtext;
		return;
	}
	dcprintf(vram_s+(x*charwidth),640,1,c);
        textcolor=oldtext;
	x++;
}
///////////////////////////////////////////////////////////////////////////
void ms_flush(void) {
	type8 j,done;

	if (!bufpos) return;
	//if (pos_x+bufpos > 39) {
	if (pos_x+bufpos > scrncol) {
        	//printf("\n");

		xpos=0;
		pos_y++;
                pos_x=1;
                more++;
                //if(pos_y>=23){
                if(pos_y>=scrnrow){

                    if(more>=9){
                         sdcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,1,"<MORE>");

                         done=0;
                         while(kbd_get_key()!=-1);
                         while(!done){
                         if(controller!=0)cont_get_cond(maple_first_controller(), &cond);
                         if(kbd_get_key()!=-1)done=1; //empty the kb buffer
                          if(controller!=0){if((!(cond.buttons & CONT_A)))done=1;}
                         }
                    more=0;
                    }
                         scroll();
                         pos_y=scrnrow;
                         pos_x=1;
                }

	}
	for (j=0;j<bufpos;j++) {
		if (buffer[j]==0x0a){
		                    xpos=1;
		                    pos_y++;
                pos_x=1;
                //if(pos_y>=23){
                if(pos_y>=scrnrow){
                          if(more>=9){
                         sdcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,1,"<MORE>");

                         done=0;

                         while(kbd_get_key()!=-1);
                         while(!done){
                         if(controller!=0)cont_get_cond(maple_first_controller(), &cond);
                         if(kbd_get_key()!=-1)done=1; //empty the kb buffer
                          if(controller!=0){if((!(cond.buttons & CONT_A)))done=1;}
                         }
                    more=0;
                    }
                         scroll();
                         pos_y=scrnrow;
                         pos_x=1;
                }
		}
		if (buffer[j]==0x08){
		                    xpos-=2;
		                    pos_x-=1;
		}
                //printf("%c",buffer[j]);

		dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth),640,0,buffer[j]);
                pos_x++;
                xpos++;
	}
	bufpos=0;
}
///////////////////////////////////////////////////////////////////////////
void ms_putchar(type8 c) {
	buffer[bufpos++]=c;

	//if ((c==0x20) || (c==0x0a) || (bufpos>=39)) ms_flush();
	if ((c==0x20) || (c==0x0a) || (bufpos>=scrncol)) ms_flush();
}
///////////////////////////////////////////////////////////////////////////
int getjoy(void){
 static char firsttime=1,moved=1;
     type16 mousex,mousey;
     int x,y,index;
     char c=-1;

     cont_get_cond(maple_first_controller(), &cond);


     if(release==1 && ((cond.buttons & CONT_A)&&(cond.buttons & CONT_X)&&(cond.buttons & CONT_B)&&(cond.buttons & CONT_Y)&&(cond.buttons & CONT_START)))
		{
		release=0;
		}

     if((!(cond.buttons & CONT_X)) && release==0){
                c=0x08; //delete on X
                release=1;
     }
     if((!(cond.buttons & CONT_B)) && release==0){
                c=' ';//space on B
                release=1;
     }
     if((!(cond.buttons & CONT_Y)) && release==0){
                c=13;//return on Y
                release=1;
     }
     if((!(cond.buttons & CONT_START)) && release==0){
                c=0x00000007e;//return on Y
                release=1;
     }

     if((!(cond.buttons & CONT_A)) && release==0){

           release=1;
            mousex=mouse_x-320;
            mousey=mouse_y-16;
            if(mousex>20 &&mousey<100){ //keyboard
                if(mousey>0 &&mousey<20){//digits
                    if(mousex>100 &&mousex<=120)c=0x30;
                    if(mousex>120 &&mousex<=140)c=0x31;
                    if(mousex>140 &&mousex<=160)c=0x32;
                    if(mousex>160 &&mousex<=180)c=0x33;
                    if(mousex>180 &&mousex<=200)c=0x34;
                    if(mousex>200 &&mousex<=220)c=0x35;
                    if(mousex>220 &&mousex<=240)c=0x36;
                    if(mousex>240 &&mousex<=260)c=0x37;
                    if(mousex>260 &&mousex<=280)c=0x38;
                    if(mousex>280 &&mousex<=300)c=0x39;
                    if(mousex>300 &&mousex<=320)c=0x08;
                }//end digits
                if(mousey>20 &&mousey<40){//q-p
                    if(mousex>20 &&mousex<=40){
                       textbuffer[0]='U';
                       textbuffer[1]='P';
                       dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,'U');
                            pos_x++;
                       dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,'P');
                            pos_x++;
                            c=13;
                    }

                    if(mousex>40 &&mousex<=60){
                       textbuffer[0]='N';
                       textbuffer[1]='W';
                       textindex+=2;
                       dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,'N');
                            pos_x++;
                       dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,'W');
                            pos_x++;
                            c=13;
                    }
                    if(mousex>60 &&mousex<=80){
                       textbuffer[0]='N';
                       textindex++;
                       dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,'N');
                            pos_x++;
                            c=13;
                    }
                    if(mousex>80 &&mousex<=100){
                       textbuffer[0]='N';
                       textbuffer[1]='E';
                       textindex+=2;
                       dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,'N');
                            pos_x++;
                       dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,'E');
                            pos_x++;
                            c=13;
                    }
                    if(mousex>120 &&mousex<=140)c='w';
                    if(mousex>140 &&mousex<=160)c='e';
                    if(mousex>160 &&mousex<=180)c='r';

                    if(mousex>100 &&mousex<=120)c='q';
                    if(mousex>120 &&mousex<=140)c='w';
                    if(mousex>140 &&mousex<=160)c='e';
                    if(mousex>160 &&mousex<=180)c='r';
                    if(mousex>180 &&mousex<=200)c='t';
                    if(mousex>200 &&mousex<=220)c='y';
                    if(mousex>220 &&mousex<=240)c='u';
                    if(mousex>240 &&mousex<=260)c='i';
                    if(mousex>260 &&mousex<=280)c='o';
                    if(mousex>280 &&mousex<=300)c='p';
                }//end q-p
                 if(mousey>40 &&mousey<60){//a-l
                    if(mousex>40 &&mousex<=60){
                       textbuffer[0]='W';
                       textindex++;
                       dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,'W');
                            pos_x++;
                            c=13;
                    }
                     if(mousex>80 &&mousex<=100){
                       textbuffer[0]='E';
                       textindex++;
                       dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,'E');
                            pos_x++;
                            c=13;
                    }
                    //if(mousex>100 &&mousex<120)c='q';
                    if(mousex>120 &&mousex<140)c='a';
                    if(mousex>140 &&mousex<160)c='s';
                    if(mousex>160 &&mousex<180)c='d';
                    if(mousex>180 &&mousex<200)c='f';
                    if(mousex>200 &&mousex<220)c='g';
                    if(mousex>220 &&mousex<240)c='h';
                    if(mousex>240 &&mousex<260)c='j';
                    if(mousex>260 &&mousex<280)c='k';
                    if(mousex>280 &&mousex<300)c='l';
                }//end a-l
                if(mousey>60 &&mousey<80){//z-m

                    if(mousex>20 &&mousex<=40){
                       textbuffer[0]='D';

                       dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,'D');
                            pos_x++;
                            c=13;
                    }

                    if(mousex>40 &&mousex<=60){
                       textbuffer[0]='S';
                       textbuffer[1]='W';
                       textindex+=2;
                       dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,'S');
                            pos_x++;
                       dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,'W');
                            pos_x++;
                            c=13;
                    }
                    if(mousex>60 &&mousex<=80){
                       textbuffer[0]='S';
                       textindex++;
                       dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,'S');
                            pos_x++;
                            c=13;
                    }
                    if(mousex>80 &&mousex<=100){
                       textbuffer[0]='S';
                       textbuffer[1]='E';
                       textindex+=2;
                       dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,'S');
                            pos_x++;
                       dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,'E');
                            pos_x++;
                            c=13;
                    }

                    //if(mousex>100 &&mousex<120)c='q';
                    //if(mousex>120 &&mousex<140)c='a';
                    if(mousex>140 &&mousex<160)c='z';
                    if(mousex>160 &&mousex<180)c='x';
                    if(mousex>180 &&mousex<200)c='c';
                    if(mousex>200 &&mousex<220)c='v';
                    if(mousex>220 &&mousex<240)c='b';
                    if(mousex>240 &&mousex<260)c='n';
                    if(mousex>260 &&mousex<280)c='m';
                    if(mousex>280 &&mousex<300)c=',';
                }//end z-m
                if(mousey>80 &&mousey<100){
                    if(mousex>160 &&mousex<240)c=' ';
                    if(mousex>240 &&mousex<300)c=13;
                }//end space and rtn

        }//end keyboard

           if(mousey>100 &&mousey<120){//words1
              if(mousex>20 &&mousex<=80){
                       strcat(textbuffer,"take ");
                       sdcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,"take ");
                            pos_x+=5;
                            textindex+=5;
                    }
              if(mousex>120 &&mousex<=180){
                       strcat(textbuffer,"open ");
                       sdcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,"open ");
                            pos_x+=5;
                            textindex+=5;
                    }
              if(mousex>200 &&mousex<=300){
                       strcat(textbuffer,"examine ");
                       sdcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,"examine ");
                            pos_x+=8;
                            textindex+=8;
                    }
                 }//end word1

          if(mousey>120 &&mousey<140){//words2
              if(mousex>20 &&mousex<=80){
                       strcat(textbuffer,"drop ");
                       sdcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,"drop ");
                            pos_x+=5;
                            textindex+=5;
                    }
              if(mousex>120 &&mousex<=190){
                       strcat(textbuffer,"unlock ");
                       sdcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,"unlock ");
                            pos_x+=7;
                            textindex+=7;
                    }
              if(mousex>200 &&mousex<=240){
                       strcat(textbuffer,"lift ");
                       sdcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,"lift ");
                            pos_x+=5;
                            textindex+=5;
                    }
                 }//end words2

           if(mousey>140 &&mousey<160){//words2
              if(mousex>20 &&mousex<=80){
                       strcat(textbuffer,"look ");
                       sdcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,"look ");
                            pos_x+=5;
                            textindex+=5;
                    }
              if(mousex>120 &&mousex<=180){
                       strcat(textbuffer,"read ");
                       sdcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,"read ");
                            pos_x+=5;
                            textindex+=5;
                    }
              if(mousex>200 &&mousex<=260){
                       strcat(textbuffer,"wait ");
                       sdcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,"wait ");
                            pos_x+=5;
                            textindex+=5;
                    }
                 }//end words2
    
     //printf("%d,%d, %c  ",mousex,mousey,c);
     }//end button A


    if(firsttime==0){
        index=0;
      for(y=mouse_y;y<mouse_y+16;y++){
         for(x=mouse_x;x<mouse_x+16;x++){
        plot_pixel16(x,y,mouseunder[index]);
         index++;
         }
      }

    }



     if(!(cond.buttons & CONT_DPAD_RIGHT)||(cond.joyx >=0xa0))
                       {
                       mouse_x+=mousespeed;
                       moved=1;
                       }
    if(!(cond.buttons & CONT_DPAD_LEFT)||(cond.joyx <=0x50))
                       {
                       moved=1;
                       mouse_x-=mousespeed;
                       }
      if(!(cond.buttons & CONT_DPAD_UP)||(cond.joyy <=0x50))
                       {
                       mouse_y-=mousespeed;
                       moved=1;
                       }
    if(!(cond.buttons & CONT_DPAD_DOWN)||(cond.joyy >=0xa0))
                       {
                       moved=1;
                       mouse_y+=mousespeed;
                       }

       
       if(mouse_x>=620)mouse_x=620;
       if(mouse_x<=320)mouse_x=320;
       if(mouse_y>=184)mouse_y=184;
       if(mouse_y<=15)mouse_y=16;

       if(moved=1){
       index=0;
       for(y=mouse_y;y<mouse_y+16;y++){
         for(x=mouse_x;x<mouse_x+16;x++){
        mouseunder[index]=get_pixel16(x,y);
        if(mousepalette[mousebuffer[index]]!=0)plot_pixel16(x,y,mousepalette[mousebuffer[index]]);
        index++;
         }
      }
       moved=0;
       }//end moved

firsttime=0;
//printf("%d,%x\n",c,c);
return c;
}//end getjoy
///////////////////////////////////////////////////////////////////////////
type8 ms_getchar(void) {
       static char history[80];
       int c=0,done=0,loops=0;
       pos_x--;

   if(textbuffer[0]==0){ //command buffer empty
       more=0;
       textindex=0;
       while(done==0){ //get user input
             vid_waitvbl();
             //printf("anims:%d loops%d\n");
             loops++;
             if(anims!=0 && loops>6){
             animate();
             loops=0;
             }
             c=-1;
             if(keyboard!=0){c=kbd_get_key();}
             if(controller!=0){if(c==-1)c=getjoy();}
             dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,1,32);//cursor
             if(c!=-1){
                   //valid ascii and space
                   if((c>=32 && c<=122 )){
                   dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,32);
                   dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,c);
                   pos_x++;
                   textbuffer[textindex]=(char)c;
                   history[textindex]=(char)c;
                   textindex++;
                   } //end ascii

              //delete
              if(c==0x08 && textindex!=0){
                   dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,32);
                   textbuffer[textindex]=0;
                   history[textindex]=0;
                   textindex--;
                   pos_x--;
                   dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,32);
              }  //end delete

              //music
              if((c==0x3a00) && (*sndname!=0)){
                              sndoggvorbis_stop();
                              sndoggvorbis_start(sndname,1);

              }
              if((c==0x3b00) && (*sndname!=0))sndoggvorbis_stop();
         
              if((c==0x3c00))showdir();
              if((c==0x3d00)||(c==0x7e)){
                            selectcolor();
                            c=13;
              }

              if(c==0x3e00)return(0);  //undo

              if(c==0x5200 && history[0]!=0){
                        pos_x=3;
                        textindex=0;
                        sdcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,"                     ");
                        while(c!=0){
                            textbuffer[textindex]=history[textindex];
                            c=history[textindex];
                            dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,c);
                            pos_x++;
                            textindex++;
                        }
                         pos_x--;
                         dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,1,32);//cursor
                        }
             //return
             if(c==13){
                    dcprintf(vram_s+(pos_y*16*640)+(pos_x*charwidth), 640,0,32);
                   if(textindex!=0){
                       //strcpy(history,textbuffer);
                       }

                   done=1;
                   //pos_y++;
                   textbuffer[textindex]=0;
                   history[textindex]=0;
                   textindex=0;
             }

             
             
             } //end c!=-1

        }//end while done

      }//end if textbuffer



      	 c = textbuffer[textindex];
      	 textindex++;
         if(c==0){
                 c=0x0a;
                 textbuffer[0]=0;
                 textindex=0;
         }//end c==0

     return c;

} //end getchar
///////////////////////////////////////////////////////////////////////////

void playanim(void){

type16 i,j,w,h,temp, *vidbuffer,u,v,x,y;
//printf("enter playanim\n");

h=obitmap[1].h;
w=obitmap[1].w;

                for(x=16;x<320;x++){
                      for(y=16;y<(200);y++){
                        //u=w*(x-(320-(nw/2)))/((320+(nw/2))-(320-(nw/2)));
                        u=w*(x-16)/(320-16);
                        v=h*(y-16)/((200)-16);
                        vidbuffer=vram_s+x-8+(y*640);
                        *vidbuffer=pal[obitmap[1].bitmap[u+v*w]];
                      }
                      }

        /*     k=0;
             for(i=0;i<obitmap[1].h;i++){
             for(j=0;j<obitmap[1].w;j++){
             plot_pixel16(j,i,pal[obitmap[1].bitmap[k]]);
             k++;
             }
             }

          */

current_frame++;

}//end play anime
///////////////////////////////////////////////////////////////////////////
void animate (void){
//printf("enter anim\n");

    struct ms_position* positions;
    type16 count,*vidbuffer;
    int i,j,index;
    type8 *anim_data;
    type8 *mask_data;
    type16 w,ow=obitmap[1].w;
    type16 h,oh=obitmap[1].h;
    unsigned int x,y,u,v;
    type8 bitmask,b;
    type8 *animbk;
    /* Get the new animation frames. */
    if (ms_animate(&positions,&count) == 0)
    {
      anims = 0;
      return;
    }
    //printf("count %d\n",count);
    if (count > 19)return;
    //clear_animation();

    /* Decode each frame. */
   current_frame=0;
    for (i = 0; i < count; i++)
    {
      anim_data = ms_get_anim_frame(positions[i].number,&w,&h,&mask_data);
      animbk=anim_data;




     if (anim_data != 0){
        for(j=0;j<ow*oh;j++){
        frames[i].bitmap[j]=obitmap[0].bitmap[j];//copy template into next frame
        }                                        //orig is in 0-zero

        bitmask=0x80;
       if(mask_data!=0){
        for(y=positions[i].y;y<positions[i].y+h;y++){
           for(x=positions[i].x;x<positions[i].x+w;x++){
            bitmask=0x80;
            b=*mask_data&bitmask;

            if((b)!=0){

                obitmap[1].bitmap[x+(y*ow)]=*animbk; //o-zero ready
               // frames[i].bitmap[x+(y*ow)]=*animbk;
                //frames[i].bitmap[x+(y*ow)]=*anim_data;


                }else{



                 obitmap[1].bitmap[x+(y*ow)]=*animbk; //ozero ready
              //   frames[i].bitmap[x+(y*ow)]=*animbk;


                }
                *animbk++;
                 bitmask=bitmask>>1;
                 if(bitmask==0){
                 bitmask=0x80;
                 *mask_data++;
                 }
                }//endx
           }//endy




          }//end type 1
          else{

         for(y=positions[i].y;y<positions[i].y+h;y++){
           for(x=positions[i].x;x<positions[i].x+w;x++){
        obitmap[1].bitmap[x+(y*ow)]=*anim_data;  //0 one to dump
        anim_data++;
        }
         }
          //obitmap[1].h=h;
          //obitmap[1].w=w;
          }//end type 2


      }//end animdata

    playanim();
    current_frame++;
      }//end count


}//end animate
///////////////////////////////////////////////////////////////////////////
void ms_showpic(type32 c,type8 mode) {

        struct ms_position* positions;
        unsigned short count;
        type8 is_anim = 0;
	type16 i,j,w,h,temp, *vidbuffer,u,v,x,y;
	float aspect,nw;
	type8 *raw;

        wipepic();
	dispkb(320,16);
        raw=ms_extract(c,&w,&h,pal,&is_anim);

        if(is_anim!=0){
        obitmap[0].h=h;
        obitmap[0].w=w;
        obitmap[1].h=h;
        obitmap[1].w=w;
        for(i=0;i<w*h;i++){
        obitmap[0].bitmap[i]=*raw;//copy to restore
        obitmap[1].bitmap[i]=*raw;//copy to mask
        *raw++;
        }
        }


        //printf("Bitmap at: %x\n",raw);
       // printf("Mode 0=off 1=thumb 2=norm:%x anime%x\n",mode,is_anim);

        //convert the pallete 0RGB 0:4:4:4
        for(i=0;i<16;i++){
                temp=(pal[i]<<2);//blue
                temp=temp&0x001F;
                temp=temp | ((pal[i]<<3)&0xffe0);//green
                temp=temp&0x03ff;
                temp=temp | ((pal[i]<<4)&0x7c00);//red
                pal[i]=temp;
        }
        //if the image is small scale it
        if(is_anim!=0){
        anims=1;
        animate();
        }
        if(anims==0){

       if(h<180){

                 aspect=(float)w/h;
                 nw=aspect*200; //center=320-nw/2

                //if (nw>320)nw=320;
                 //printf("h:%d,w:%d .. h:200,w:%f",h,w,nw);
                 //for(x=(320-(nw/2));x<(320+(nw/2));x++){
                  for(x=16;x<320;x++){
                      for(y=16;y<(200);y++){
                        //u=w*(x-(320-(nw/2)))/((320+(nw/2))-(320-(nw/2)));
                        u=w*(x-16)/(320-16);
                        v=h*(y-16)/((200)-16);
                        vidbuffer=vram_s+x-8+(y*640);
                        *vidbuffer=pal[raw[u+v*w]];
                      }
                      }
                      }
                      else{
        //draw image on the screen
        vidbuffer=vram_s;
        for(i=0;i<h;i++){
            // for(j=(320-(w/2));j<(320+(w/2));j++){
               for(j=16;j<w+16;j++){
               vidbuffer=vram_s+j+((640*i)+(640*32));
              *vidbuffer=pal[*raw];
                *raw++;
           }
             }
                     }
        }//end for not an amimation..






}
///////////////////////////////////////////////////////////////////////////
type8 dispbitmap(type8s *name){
         type8 *buffer;
         type32 data,j,*vidmem;
         FILE *fh;

        buffer = (char *) malloc(1024000);
        if (buffer==0){
                    
                     	return(0);
         }

         if (!(fh=fopen(name,"rb"))) printf("menu load faild!\n");


        fread(buffer,1,640*480*3,fh);
        fclose(fh);
        vidmem=vram_s;

        for(j=0;j<640*480;j++){

        data=0x00000;
        data=(*buffer)*0x10000;
        *buffer++;
        data=data+(*buffer*0x100);
        *buffer++;
        data+=*buffer;
        buffer++;
        *vidmem=data;
         vidmem++;


        }

        free(buffer);
        return(1);
}
///////////////////////////////////////////////////////////////////////////

void dim_missing(int x, int y){
    type32 data,*vidmem;
     int32 i,j;
     type8 red,green,blue;
      vidmem=vram_l+x+(y*640);
       for(j=0;j<=140;j++){      //vert count
       for(i=0;i<=100;i++){     //hcount
      data=*vidmem;
      red=(data & 0x000000FF);
      data=data>>8;
      green=(data & 0x000000FF);
      data=data>>8;
      blue=(data & 0x000000FF);
       red=red>>3;
      green=green>>3;
      blue=blue>>3;
      data=0x00000000;
      data=(blue*0x10000)+(green*0x100)+(red);
      *vidmem=data;
      vidmem++;
}    // end i
y++;
vidmem=vram_l+x+(y*640);

}     //end J
}    //end dim
///////////////////////////////////////////////////////////////////////////
void plot_pixel32(int x, int y,int32 color){
     type32 *vidmem;
     vidmem=vram_l+(y*640);
     vidmem[x]=color;
}
///////////////////////////////////////////////////////////////////////////
int32 get_pixel32(int x, int y){
     type32 *vidmem;
     vidmem=vram_l+(y*640);
     return(vidmem[x]);
 }
///////////////////////////////////////////////////////////////////////////
void get_game_list(void){
        FILE *fh;
	if (!(fh=fopen("/cd/corrupt.mag","rb"))){
	        corrupt=0;
	        dim_missing(400,40);

	}
        fclose(fh);
        if (!(fh=fopen("/cd/fish.mag","rb"))){
                fish=0;
                dim_missing(520,40);
                
        }
        fclose(fh);
        if (!(fh=fopen("/cd/guild.mag","rb"))){
                guild=0;
               dim_missing(160,40);
        }
        fclose(fh);
        if (!(fh=fopen("/cd/jinxter.mag","rb"))){
                jinxter=0;
                dim_missing(280,40);
        }
        fclose(fh);
        if (!(fh=fopen("/cd/myth.mag","rb"))){
                myth=0;
                dim_missing(40,220);
        }
        fclose(fh);
        if (!(fh=fopen("/cd/pawn.mag","rb"))){
                pawn=0;
                dim_missing(40,40);
        }
        fclose(fh);
        if (!(fh=fopen("/cd/wonder.mag","rb"))){
                wonder=0;
                dim_missing(160,220);
        }
        fclose(fh);
        if (!(fh=fopen("/cd/ccorrupt.mag","rb"))){
                ccorrupt=0;
                dim_missing(520,220);
        }
        fclose(fh);
        if (!(fh=fopen("/cd/cfish.mag","rb"))){
                cfish=0;
                dim_missing(400,220);
        }
        fclose(fh);
        if (!(fh=fopen("/cd/cguild.mag","rb"))){
                cguild=0;
                dim_missing(280,220);
        }
        fclose(fh);
}
///////////////////////////////////////////////////////////////////////////

void select_game(void){
       int choice=1;
       int done=0,i,x,y,xo;
       char release=0;
       x=80;
       y=180;
       gamename="/cd/pawn.mag";
       gfxname="/cd/pawn.gfx";
       sndname="/cd/pawn.ogg";

     while(!done){

       if(choice==1){
           x=80;
           y=180;
        gamename="/cd/pawn.mag";
        gfxname="/cd/pawn.gfx";
        sndname="/cd/pawn.ogg";
       }
       if(choice==2){
           x=200;
           y=180;
        gamename="/cd/guild.mag";
        gfxname="/cd/guild.gfx";
        sndname="/cd/guild.ogg";

       }
       if(choice==3){
           x=320;
           y=180;
        gamename="/cd/jinxter.mag";
        gfxname="/cd/jinxter.gfx";
        sndname="/cd/jinxter.ogg";
       }
       if(choice==4){
           x=440;
           y=180;
        gamename="/cd/corrupt.mag";
        gfxname="/cd/corrupt.gfx";
        sndname="/cd/corrupt.ogg";
       }
       if(choice==5){
           x=560;
           y=180;
        gamename="/cd/fish.mag";
        gfxname="/cd/fish.gfx";
        sndname="/cd/fish.ogg";
       }
       if(choice==6){
           x=80;
           y=360;
        gamename="/cd/myth.mag";
        gfxname="/cd/myth.gfx";
        sndname="/cd/myth.ogg";

       }
       if(choice==7){
           x=200;
           y=360;
        gamename="/cd/wonder.mag";
        gfxname="/cd/wonder.gfx";
        sndname="/cd/wonder.ogg";

       }
       if(choice==8){
           x=320;
           y=360;
        gamename="/cd/cguild.mag";
        gfxname="/cd/cguild.gfx";
        sndname="/cd/guild.ogg";

       }
       if(choice==9){
           x=440;
           y=360;
        gamename="/cd/cfish.mag";
        gfxname="/cd/cfish.gfx";
        sndname="/cd/fish.ogg";
       }
       if(choice==10){
           x=560;
           y=360;
        gamename="/cd/ccorrupt.mag";
        gfxname="/cd/ccorrupt.gfx";
        sndname="/cd/corrupt.ogg";
       }
       light_dot(x, y, 1);
       xo=0;
       while(xo==0 && done==0){
                i=-1;
                if(keyboard!=0){i=kbd_get_key();}
                //i=kbd_get_key();
                if(controller!=0){
                   cont_get_cond(maple_first_controller(), &cond);

                  if((!(cond.buttons & CONT_DPAD_RIGHT))&&release==0)
                       {
                       i=0x4f00;
                       release=1;
                       }
                       if((!(cond.buttons & CONT_DPAD_LEFT))&&release==0)
                       {
                       i=0x5000;
                       release=1;
                       }
                       if((!(cond.buttons & CONT_A))&&release==0)
                       {
                       i=13;
                       release=1;
                       }
                  
                  if(release==1 && ((cond.buttons & CONT_DPAD_RIGHT)&&(cond.buttons & CONT_DPAD_LEFT)
                  &&(cond.buttons & CONT_A)))
		  {
		  release=0;
		  }

                   }//end controller

                if(i==0x5000){

                choice-=1;
                if(choice==0)choice=10;
                xo=1;

                }
                if(i==0x4f00){

                choice+=1;
                if(choice==11)choice=1;
                xo=1;
                }


                if(i==13){
                done=1;
                xo=1;
                }
                }//end while
    light_dot(x, y, 0);
    }//end !done
}//end select game
///////////////////////////////////////////////////////////////////////////
void light_dot(int x, int y, int light){
type32 data,*vidmem;
     int32 i,j;
     type8 red,green,blue;
      vidmem=vram_l+x+(y*640);
       for(j=0;j<=20;j++){      //vert count
       for(i=0;i<=20;i++){     //hcount
      data=*vidmem;
      
      if(light==0){
      red=(data & 0x000000FF);
      data=data>>8;
      green=(data & 0x000000FF);
      data=data>>8;
      blue=(data & 0x000000FF);
       red=red>>1;
      green=green>>1;
      blue=blue>>1;
      data=0x00000000;
      }else{
      red=(data & 0x000000FF);
      data=data>>8;
      green=(data & 0x000000FF);
      data=data>>8;
      blue=(data & 0x000000FF);
      red=red<<1;
      green=green<<1;
      blue=blue<<1;
      data=0x00000000;
      }
      data=(blue*0x10000)+(green*0x100)+(red);
      *vidmem=data;
      vidmem++;
}    // end i
y++;
vidmem=vram_l+x+(y*640);

}     //end J
}    //end dim
///////////////////////////////////////////////////////////////////////////
void intro(void){
typedef struct star_typ
        {
        int x,y;
        int vel;
        uint16 color;

        } star, *star_ptr;

int star_first=1;  // flags first time into star field
int NUM_STARS = 120;
star stars[NUM_STARS]; // the star field
int index,c=-1,done=0;
int32 event=0;

while (!done){

if (star_first)
   {
   // reset first time
   star_first=0;
   // initialize all the stars


for (index=0; index<NUM_STARS; index++)
       {
       // initialize each star to a velocity, position and color
       stars[index].x     = rand()%640;
       stars[index].y     = rand()%480;
       // decide what star plane the star is in
       switch(rand()%5)
             {

             case 0: // plane 1- the farthest star plane
                  {
                  // set velocity and color
                  stars[index].vel = 2;
                  stars[index].color =0x1ce7;
                  } break;
             case 1: // plane 2-The medium distance star plane
                  {
                  stars[index].vel = 4;
                  stars[index].color = 0x4210;
                  } break;

             case 2: // plane 1- the farthest star plane
                  {
                  // set velocity and color
                  stars[index].vel = 7;
                  stars[index].color =0xFFFF;


                  } break;
             case 3: // plane 1- the farthest star plane
                  {
                  // set velocity and color
                  stars[index].vel = 1;
                  stars[index].color =0x1ce7;


                  } break;
              case 4: // plane 1- the farthest star plane
                  {
                  // set velocity and color
                  stars[index].vel = 5;
                  stars[index].color =0x6318;


                  } break;

             } // end switch

       } // end for index

   } // end if first time
else
   { // draw stars

   // erase, move, draw



   for (index=0; index<NUM_STARS; index++)
       {
       
       
        plot_pixel16(stars[index].x,stars[index].y,0);

       if(event<100)stars[index].x+=stars[index].vel/3;
       if(event>100 && event<200)stars[index].x+=stars[index].vel/2;
       if(event>200&&event<400)stars[index].x+=stars[index].vel;
       if(event>400&&event<800)stars[index].x-=stars[index].vel;
       if(event>801)stars[index].x+=stars[index].vel;

       if ( stars[index].x>=640 )stars[index].x = 10;
       if ( stars[index].x<=9 )stars[index].x = 630;

       plot_pixel16(stars[index].x,stars[index].y,stars[index].color);

       } // end for index

   } // end else

   if(event>1&&event<200)sdcprintf(vram_s+(13*16*640)+(9*16), 640,0,"In a time, long ago..");
   if(event==201)wipescrn32();
   if(event>200&&event<400)sdcprintf(vram_s+(13*16*640)+(9*16), 640,0,"When Text was the Master..");
   if(event==401)wipescrn32();
   if(event>401&&event<600)sdcprintf(vram_s+(13*16*640)+(13*16), 640,0,"Then there was");
   if(event>401&&event<600)sdcprintf(vram_s+(14*16*640)+(13*16), 640,0,"   Graphics");
   if(event==601)wipescrn32();
   if(event>601&&event<800)sdcprintf(vram_s+(13*16*640)+(10*16), 640,0,"Magnetic  DC V1.2");

   if(event==801)wipescrn32();
   if(event>801&&event<1100)sdcprintf(vram_s+(13*16*640)+(7*16), 640,0,"Front end & Dreamcast Port");
   if(event>801&&event<1100)sdcprintf(vram_s+(14*16*640)+(11*16), 640,0,"Eytan Kaziberdov");
   if(event==1101)wipescrn32();
   if(event>1101&&event<1300)sdcprintf(vram_s+(13*16*640)+(13*16), 640,0,"Interpreter By");
   if(event>1101&&event<1300)sdcprintf(vram_s+(14*16*640)+(13*16), 640,0,"Niclas Karlsson");
   if(event==1301)wipescrn32();
   if(event>1301&&event<1500)sdcprintf(vram_s+(13*16*640)+(9*16), 640,0,"Some Art and Music (C) by");
   if(event>1301&&event<1500)sdcprintf(vram_s+(14*16*640)+(11*16), 640,0,"  Magnetic Scrolls");
   if(event==1501)wipescrn32();

   if(event>1501&&event<1800)sdcprintf(vram_s+(13*16*640)+(10*16), 640,0,"Press Space or A");
   if(event==1801)wipescrn32();
   
   
   if(event>1801)event=401;


     if(controller!=0)cont_get_cond(maple_first_controller(), &cond);
     if(keyboard!=0){if(kbd_get_key()==' ')done=1; }
     if(controller!=0){if((!(cond.buttons & CONT_A)))done=1;}

    event++;
    timer_spin_sleep(20);
       }//end while

}//end intro

///////////////////////////////////////////////////////////////////////////
//select text color

void selectcolor(){
            int stx=10,sty=8,done=0,colover=0,selection=0,selectedcolor;
            int i=-1,release=1;
            uint32 *dblpixel=0xa5100000;
            type8 sdata[32];
            type16 *sdata_w;

 selectedcolor=textcolor;
 for(i=0; i<=153600; i++){
*dblpixel=0x00000000;
*dblpixel++;
 }


 vid_set_start(0x100000);

 if(charwidth<10){colover=0;}else{colover=1;}

 while(!done){
 if(colover==1){stx=10;}else{stx=28;}
 sty=2;
 textcolor=0x7fff;//br_white
 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"Configuration Screen");
 sty++ ;
 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"Up/Down A/RTN to Select");
 sty+=3;
 textcolor=0x7fff;//br_white

 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"Text Color Options:");
sty++;
 if(selection==0){sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"-->");}else{
                  sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"   ");}

 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"This is an example!");
 sty++;

  textcolor=0x7398;//white
 if(selection==1){sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"-->");}else{
                  sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"   ");}
 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"This is an example!");
 sty++;

  textcolor=0x4210;//gray
 if(selection==2){sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"-->");}else{
                  sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"   ");}
 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"This is an example!");
 sty++;

  textcolor=0x4000;//Red
 if(selection==3){sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"-->");}else{
                  sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"   ");}
 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"This is an example!");
 sty++;

  textcolor=0x4200;//yellow
 if(selection==4){sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"-->");}else{
                  sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"   ");}
 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"This is an example!");
 sty++;

  textcolor=0x0200;//green
 if(selection==5){sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"-->");}else{
                  sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"   ");}
 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"This is an example!");
 sty++;

 textcolor=0x421f;//Br_blue
 if(selection==6){sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"-->");}else{
                  sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"   ");}
 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"This is an example!");
 sty++;

 textcolor=0x03e0;//BR_green
  if(selection==7){sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"-->");}else{
                  sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"   ");}
 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"This is an example!");
 sty++;

 textcolor=0x03ff;//br_cyan
 if(selection==8){sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"-->");}else{
                  sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"   ");}
 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"This is an example!");
 sty++;

 textcolor=0x7c00;//br_red
 if(selection==9){sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"-->");}else{
                  sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"   ");}
 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"This is an example!");
 sty++;

 textcolor=0x7c1f;//br_mag
 if(selection==10){sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"-->");}else{
                  sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"   ");}
 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"This is an example!");
 sty++;

  textcolor=0x7fe0;//br_yellow
 if(selection==11){sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"-->");}else{
                  sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"   ");}
 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"This is an example!");
 sty+=2;

 textcolor=0xffff;
 if(selection==12){sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"-->");}else{
                  sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"   ");}
 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"Force 40/80 Column:");
 if(colover==1)sdcprintf(vram_s+(sty*16*640)+((stx+23)*charwidth),640,0,"40");
 if(colover==0){ textcolor=0x7c00;//br_red
              	sdcprintf(vram_s+(sty*16*640)+((stx+23)*charwidth),640,0,"80");}
 sty++;
 textcolor=0xffff;
 if(selection==13){sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"-->");}else{
                  sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"   ");}
 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"Mouse Speed:");
 dcprintf(vram_s+(sty*16*640)+((stx+13)*charwidth), 640,0,mousespeed+0x30);
  sty++;


 if(selection==14){sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"-->");}else{
                  sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"   ");}
 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"Return to Game");
  sty++;

 if(selection==15){sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"-->");}else{
                  sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"   ");}
 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"Save setting as default");
  sty++;
 textcolor=0x7c00;
 if(selection==16){sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"-->");}else{
                  sdcprintf(vram_s+(sty*16*640)+((stx-3)*charwidth), 640,0,"   ");}
 sdcprintf(vram_s+(sty*16*640)+(stx*charwidth), 640,0,"Exit Magnetic!");

 sty++;

   i=-1;
                if(keyboard!=0){i=kbd_get_key();}
                //if(i!=-1)printf("%x\n",i);
                if(controller!=0){
                   cont_get_cond(maple_first_controller(), &cond);

                  if((!(cond.buttons & CONT_DPAD_UP))&&release==0)
                       {
                       i=0x5200;
                       release=1;
                       }
                       if((!(cond.buttons & CONT_DPAD_DOWN))&&release==0)
                       {
                       i=0x5100;
                       release=1;
                       }
                       if((!(cond.buttons & CONT_A))&&release==0)
                       {
                       i=13;
                       release=1;
                       }

                  if(release==1 && ((cond.buttons & CONT_DPAD_UP)&&(cond.buttons & CONT_DPAD_DOWN)
                  &&(cond.buttons & CONT_A)))
		  {
		  release=0;
		  }

                   }//end controller

                if(i==0x5200){

                selection-=1;
                if(selection==-1)selection=0;


                }
                if(i==0x5100){

                selection+=1;
                if(selection==17)selection=16;

                }

                if(i==13){
                        switch(selection){
                                         case 0:
                                         {
                                         selectedcolor=0x7fff;
                                         } break;
                                         case 1:
                                         {
                                         selectedcolor=0x7398;//white
                                         } break;
                                         case 2:
                                         {
                                         selectedcolor=0x4210;//gray
                                         } break;
                                         case 3:
                                         {
                                         selectedcolor=0x4000;//Red
                                         } break;
                                         case 4:
                                         {
                                         selectedcolor=0x4200;//yellow
                                         } break;
                                         case 5:
                                         {
                                         selectedcolor=0x0200;//green
                                         } break;
                                         case 6:
                                         {
                                         selectedcolor=0x421f;//Br_blue
                                         } break;
                                         case 7:
                                         {
                                         selectedcolor=0x03e0;//BR_green
                                         } break;
                                         case 8:
                                         {
                                         selectedcolor=0x03ff;//br_cyan
                                         } break;
                                         case 9:
                                         {
                                         selectedcolor=0x7c00;//br_red
                                         } break;
                                         case 10:
                                         {
                                         selectedcolor=0x7c1f;//br_mag
                                         } break;
                                         case 11:
                                         {
                                         selectedcolor=0x7fe0;//br_yellow
                                         } break;
                                         case 12:
                                         {
                                         colover++;
                                         colover&=1;
                                         dblpixel=0xa5100000;
                                         for(i=0; i<=153600; i++){
                                         *dblpixel=0x00000000;
                                         *dblpixel++;
                                         }

                                         if(colover==0){
                                         scrncol=79;
                                         charwidth=8;
                                         }else{
                                         scrncol=39;
                                         charwidth=16;
                                         }
                                         } break;

                                         case 13:
                                         {
                                         mousespeed++;
                                         mousespeed&=3;
                                         if(mousespeed==0)mousespeed=1;
                                         } break;
                                          case 14:
                                         {
                                         textcolor=selectedcolor;
                                         done=1;
                                         } break;
                                         case 15:
                                         {
                                         sdata_w=sdata;
                                         *sdata_w=selectedcolor;
                                         sdata[2]=scrncol;
                                         sdata[3]=charwidth;
                                         sdata[4]=mousespeed;
                                         ms_save_file("MAGDEFS", sdata, 8);
                                         } break;
                                         case 16:
                                         {
                                         textcolor=selectedcolor;
                                         (*(void(**)())0x8c0000e0)(1);
                                         } break;
                                         }
                                         }//end i=13

 }//end done
  vid_set_start(0x000000);
 }

///////////////////////////////////////////////////////////////////////////
//main(int argc, char **argv) {
main(void) {
	type8  running,done,tv=1;
	type32 dlimit, slimit;
	type8 *buffer,sdata[32];
        type16 *sdata_w;
        FILE *fh;
        
        sdata_w=sdata;


        scrncol=39,charwidth=16,scrnrow=23; //defaults 39 16 23
        keyboard = maple_first_kb();
        controller = maple_first_controller();

        //printf("keyboard:%x\nController:%x\n",keyboard,controller);


        if(keyboard!=0)kbd_set_queue(1);
        load_font();
        pcxload(320,200,menubuffer,menupalette,"/rd/kb.pcx");
        pcxload(16,16,mousebuffer,mousepalette,"/rd/mouse.pcx");


        if (sizeof(type8)!=1 || sizeof(type16)!=2 || sizeof(type32)!=4) {
	//printf("You have incorrect typesizes, please edit \n");
		exit(1);
	}
	dlimit=slimit=0xffffffff;



        vid_set_mode(3, 0);
        vid_empty();

      /*   sdcprintf(vram_s+(13*16*640)+(2*16), 640,0,"Insert Game CD & Press a Key or A");
                         done=0;
                         if(keyboard!=0){while(kbd_get_key()!=-1);}
                         while(!done){
                         if(controller!=0)cont_get_cond(maple_first_controller(), &cond);
                         if(keyboard!=0){if(kbd_get_key()!=-1)done=1;}
                          if(controller!=0){if((!(cond.buttons & CONT_A)))done=1;}
                         }
         */
        vid_empty();
  //intro goes here
        sndoggvorbis_init();
        sndoggvorbis_start("/rd/intro.ogg",1);
        intro();
        vid_empty();
        sndoggvorbis_stop();


  //game selection menu
restart:
         vid_set_mode(3, 3);
         dispbitmap("/rd/menu.raw"); //show the selection menu
         get_game_list(); //dim out unselectable games
         select_game();
         vid_empty();


         
          //if(*sndname==0)sndoggvorbis_shutdown(); //no sound kill the thread
          
          if(*sndname!=0){
                    if (!(fh=fopen(sndname,"rb"))){
	            *sndname=0;
	            fclose(fh);
                    //sndoggvorbis_shutdown();

          }
          else{
            fclose(fh);
            sndoggvorbis_start(sndname,1);
           }
          }

         vid_set_mode(3, 0);
         vid_empty();
         tv = vid_check_cable();

         if(tv==0){ //not a VGA
         scrncol=79,charwidth=8,scrnrow=27;
         }

         if(ms_load_file("MAGDEFS", sdata, 8)==0){
                  textcolor=*sdata_w;
                  scrncol=sdata[2];
                  charwidth=sdata[3];
                  mousespeed=sdata[4];
         }


         vid_empty();
         dispkb(320,16);




        if (!(ms_gfx_enabled=ms_init(gamename,gfxname))) {
		//sdcprintf("Couldn't start up game");
		//exit(1);
	        goto restart;
        }
	ms_gfx_enabled--;
	running=1;
	

        while ((i_count<slimit) && running) {
		if (i_count>=dlimit) ms_status();

                running=ms_rungame();
	}
	if (i_count==slimit) {
		//printf("\n\nSafety limit (%d) reached.\n",slimit);
		ms_status();
	}
	ms_freemem();
	sndoggvorbis_stop();

        dlimit=slimit=0xffffffff;
        goto restart;
        sndoggvorbis_shutdown();
	//printf("\nExiting.\n");
	//exit(0);
}
