/*
 * @(#)ScrollBarTest.java  1.0  18 settembre 2005
 *
 * Copyright (c) 2005 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * The copyright of this software is owned by Werner Randelshofer. 
 * You may not use, copy or modify this software, except in  
 * accordance with the license agreement you entered into with  
 * Werner Randelshofer. For details see accompanying license terms. 
 */

package test;

import java.awt.*;
import java.util.*;
import javax.swing.*;
/**
 * ScrollBarTest.
 *
 * @author  Werner Randelshofer
 * @version 1.0 18 settembre 2005 Created.
 */
public class ScrollBarTest extends javax.swing.JPanel {
    
    /**
     * Creates a new instance.
     */
    public ScrollBarTest() {
        initComponents();
        
        JScrollBar[] bars = {
            scrollBar1, scrollBar2, scrollBar3, scrollBar4, scrollBar5,
            scrollBar6, scrollBar7, scrollBar8,
            scrollBar9, scrollBar10, scrollBar11, scrollBar12, scrollBar13,
            scrollBar14, scrollBar15,
            scrollBar16
        };
        Font smallFont = new Font("Lucida Grande", Font.PLAIN, 11);
        for (int i=0; i < 16; i++) {
            if (i % 8 > 3) {
                bars[i].setFont(smallFont);
            }
            if (i % 2 == 0) {
                bars[i].putClientProperty("Quaqua.ScrollBar.placeButtonsTogether", Boolean.TRUE);
            } else {
                bars[i].putClientProperty("Quaqua.ScrollBar.placeButtonsTogether", Boolean.FALSE);
            }
        }
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        final long start = System.currentTimeMillis();
        final java.util.List argList = Arrays.asList(args);
        // Explicitly turn on font antialiasing.
        System.setProperty("swing.aatext", "true");
        
        // Launch the test program
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                long edtEnd = System.currentTimeMillis();
                int index = argList.indexOf("-laf");
                if (index != -1 && index < argList.size() - 1) {
                    try {
                        UIManager.setLookAndFeel((String) argList.get(index + 1));
                    } catch (Exception e) {
                        // can't do anything about this
                    }
                } else {
                    try {
                        UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
                    } catch (Exception e) {
                        // can't do anything about this
                    }
                }
                
                JComponent c = new ScrollBarTest();
                JFrame f = new JFrame("ScrollBarTest");
                f.getContentPane().add(c);
                f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                f.pack();
                f.setVisible(true);
                long end = System.currentTimeMillis();
                System.out.println("total startup latency="+(end - start));
            }
        });
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        scrollBar1 = new javax.swing.JScrollBar();
        scrollBar2 = new javax.swing.JScrollBar();
        scrollBar3 = new javax.swing.JScrollBar();
        scrollBar4 = new javax.swing.JScrollBar();
        scrollBar5 = new javax.swing.JScrollBar();
        scrollBar6 = new javax.swing.JScrollBar();
        scrollBar7 = new javax.swing.JScrollBar();
        scrollBar8 = new javax.swing.JScrollBar();
        scrollBar16 = new javax.swing.JScrollBar();
        scrollBar15 = new javax.swing.JScrollBar();
        scrollBar14 = new javax.swing.JScrollBar();
        scrollBar13 = new javax.swing.JScrollBar();
        scrollBar12 = new javax.swing.JScrollBar();
        scrollBar11 = new javax.swing.JScrollBar();
        scrollBar10 = new javax.swing.JScrollBar();
        scrollBar9 = new javax.swing.JScrollBar();

        setLayout(new java.awt.GridBagLayout());

        scrollBar1.setPreferredSize(new java.awt.Dimension(25, 48));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        add(scrollBar1, gridBagConstraints);

        scrollBar2.setVisibleAmount(100);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        add(scrollBar2, gridBagConstraints);

        scrollBar3.setValue(24);
        scrollBar3.setVisibleAmount(50);
        scrollBar3.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        add(scrollBar3, gridBagConstraints);

        scrollBar4.setValue(90);
        scrollBar4.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        add(scrollBar4, gridBagConstraints);

        scrollBar5.setValue(25);
        scrollBar5.setVisibleAmount(25);
        scrollBar5.setPreferredSize(new java.awt.Dimension(25, 48));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        add(scrollBar5, gridBagConstraints);

        scrollBar6.setVisibleAmount(100);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        add(scrollBar6, gridBagConstraints);

        scrollBar7.setVisibleAmount(75);
        scrollBar7.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        add(scrollBar7, gridBagConstraints);

        scrollBar8.setValue(90);
        scrollBar8.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        add(scrollBar8, gridBagConstraints);

        scrollBar16.setOrientation(javax.swing.JScrollBar.HORIZONTAL);
        scrollBar16.setValue(90);
        scrollBar16.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        add(scrollBar16, gridBagConstraints);

        scrollBar15.setOrientation(javax.swing.JScrollBar.HORIZONTAL);
        scrollBar15.setValue(24);
        scrollBar15.setVisibleAmount(50);
        scrollBar15.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        add(scrollBar15, gridBagConstraints);

        scrollBar14.setOrientation(javax.swing.JScrollBar.HORIZONTAL);
        scrollBar14.setVisibleAmount(100);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        add(scrollBar14, gridBagConstraints);

        scrollBar13.setOrientation(javax.swing.JScrollBar.HORIZONTAL);
        scrollBar13.setPreferredSize(new java.awt.Dimension(48, 25));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        add(scrollBar13, gridBagConstraints);

        scrollBar12.setOrientation(javax.swing.JScrollBar.HORIZONTAL);
        scrollBar12.setValue(90);
        scrollBar12.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        add(scrollBar12, gridBagConstraints);

        scrollBar11.setOrientation(javax.swing.JScrollBar.HORIZONTAL);
        scrollBar11.setVisibleAmount(75);
        scrollBar11.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        add(scrollBar11, gridBagConstraints);

        scrollBar10.setOrientation(javax.swing.JScrollBar.HORIZONTAL);
        scrollBar10.setVisibleAmount(100);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        add(scrollBar10, gridBagConstraints);

        scrollBar9.setOrientation(javax.swing.JScrollBar.HORIZONTAL);
        scrollBar9.setValue(25);
        scrollBar9.setVisibleAmount(25);
        scrollBar9.setPreferredSize(new java.awt.Dimension(48, 25));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        add(scrollBar9, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollBar scrollBar1;
    private javax.swing.JScrollBar scrollBar10;
    private javax.swing.JScrollBar scrollBar11;
    private javax.swing.JScrollBar scrollBar12;
    private javax.swing.JScrollBar scrollBar13;
    private javax.swing.JScrollBar scrollBar14;
    private javax.swing.JScrollBar scrollBar15;
    private javax.swing.JScrollBar scrollBar16;
    private javax.swing.JScrollBar scrollBar2;
    private javax.swing.JScrollBar scrollBar3;
    private javax.swing.JScrollBar scrollBar4;
    private javax.swing.JScrollBar scrollBar5;
    private javax.swing.JScrollBar scrollBar6;
    private javax.swing.JScrollBar scrollBar7;
    private javax.swing.JScrollBar scrollBar8;
    private javax.swing.JScrollBar scrollBar9;
    // End of variables declaration//GEN-END:variables
    
}
