/*
 * @(#)RolloverIconTest14.java  1.1  2005-09-10
 *
 * Copyright (c) 2004 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * The copyright of this software is owned by Werner Randelshofer. 
 * You may not use, copy or modify this software, except in  
 * accordance with the license agreement you entered into with  
 * Werner Randelshofer. For details see accompanying license terms. 
 */

package test;

import ch.randelshofer.quaqua.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;
/**
 * RolloverIconTest14.
 * 
 * @author Werner Randelshofer
 * @version 1.1 2005-09-10 Harmonized lengths of texts.
 * <br>1.0  13 February 2005  Created.
 */
public class RolloverIconTest14 extends javax.swing.JPanel {
    
    /** Creates new form. */
    public RolloverIconTest14() {
        initComponents();
        AbstractButton[] buttons = { button1, button2, toggle1, toggle2 };
        Icon icon = new TextIcon("Default       ");
        for (int i=0; i < buttons.length; i++) {
            buttons[i].setIcon(icon);
        }
        icon = new TextIcon("Pressed");
        for (int i=0; i < buttons.length; i++) {
            buttons[i].setPressedIcon(icon);
        }
        icon = new TextIcon("Selected");
        for (int i=0; i < buttons.length; i++) {
            buttons[i].setSelectedIcon(icon);
        }
        icon = new TextIcon("Rollover");
        for (int i=0; i < buttons.length; i++) {
            buttons[i].setRolloverIcon(icon);
        }
        icon = new TextIcon("Roll.+Sel.");
        for (int i=0; i < buttons.length; i++) {
            buttons[i].setRolloverSelectedIcon(icon);
        }
        icon = new TextIcon("Disabled");
        for (int i=0; i < buttons.length; i++) {
            buttons[i].setDisabledIcon(icon);
        }
        icon = new TextIcon("Dis.+Sel.");
        for (int i=0; i < buttons.length; i++) {
            buttons[i].setDisabledSelectedIcon(icon);
        }
    }
    
    public static void main(String args[]) {
        
        try {
            UIManager.setLookAndFeel(QuaquaManager.getLookAndFeelClassName());
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        } catch (Exception e) {
            e.printStackTrace();
        }
        JFrame f = new JFrame("Quaqua Rollover Icon Test");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.getContentPane().add(new RolloverIconTest14());
        ((JComponent) f.getContentPane()).setBorder(new EmptyBorder(9,17,17,17));
        f.pack();
        f.setVisible(true);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        button1 = new javax.swing.JButton();
        toggle1 = new javax.swing.JToggleButton();
        jPanel1 = new javax.swing.JPanel();
        jToolBar1 = new javax.swing.JToolBar();
        button2 = new javax.swing.JButton();
        toggle2 = new javax.swing.JToggleButton();

        setLayout(new java.awt.GridBagLayout());

        button1.setText("\u00c5ngstr\u00f6m H");
        button1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                button1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        add(button1, gridBagConstraints);

        toggle1.setText("\u00c5ngstr\u00f6m H");
        add(toggle1, new java.awt.GridBagConstraints());

        jPanel1.setLayout(new java.awt.BorderLayout());

        jToolBar1.setRollover(true);
        button2.setText("\u00c5ngstr\u00f6m H");
        jToolBar1.add(button2);

        toggle2.setText("\u00c5ngstr\u00f6m H");
        jToolBar1.add(toggle2);

        jPanel1.add(jToolBar1, java.awt.BorderLayout.NORTH);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        add(jPanel1, gridBagConstraints);

    }//GEN-END:initComponents
    
    private void button1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_button1ActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_button1ActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton button1;
    private javax.swing.JButton button2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JToolBar jToolBar1;
    private javax.swing.JToggleButton toggle1;
    private javax.swing.JToggleButton toggle2;
    // End of variables declaration//GEN-END:variables
    
}
