/**
 * @(#)ResolutionIndependenceTest.java  1.0  December 21, 2007
 *
 * Copyright (c) 1996-2007 by the original authors of JHotDraw
 * and all its contributors ("JHotDraw.org")
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * JHotDraw.org ("Confidential Information"). You shall not disclose
 * such Confidential Information and shall use it only in accordance
 * with the terms of the license agreement you entered into with
 * JHotDraw.org.
 */

package test;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * ResolutionIndependenceTest.
 *
 * @author Werner Randelshofer
 * @version 1.0 ResolutionIndependenceTest Created.
 */
public class ResolutionIndependenceTest extends javax.swing.JPanel {
    private Point mouseLocation;
    
    /** Creates new form. */
    public ResolutionIndependenceTest() {
        initComponents();
        addMouseMotionListener(new MouseMotionListener() {

            public void mouseDragged(MouseEvent e) {
                mouseLocation = e.getPoint();
                repaint();
            }

            public void mouseMoved(MouseEvent e) {
                mouseLocation = e.getPoint();
                System.out.println(e);
                repaint();
            }
            
        });
        
        
       setPreferredSize(new Dimension(240,240));
       setOpaque(true);
    }
    
    public void paintComponent(Graphics gr) {
        Graphics2D g = (Graphics2D) gr;
        
        g.clearRect(0, 0, getWidth(), getHeight());
        
        g.setFont(new Font("Dialog",Font.PLAIN,12));
        g.drawString("This square is 200 pixels long",20,15);
        
        Rectangle r = new Rectangle(20,20,200,200);
        
        g.draw(r);
        
        if (mouseLocation != null && r.contains(mouseLocation)) {
            g.drawLine(mouseLocation.x - 5, mouseLocation.y, mouseLocation.x + 5, mouseLocation.y);
            g.drawLine(mouseLocation.x, mouseLocation.y - 5, mouseLocation.x, mouseLocation.y + 5);
            g.drawOval(mouseLocation.x - 7, mouseLocation.y - 7, 14, 14);
        }
        
        g.drawString(g.getDeviceConfiguration().getDefaultTransform().toString(),20,235);
        System.out.println(g.getDeviceConfiguration().getNormalizingTransform());
    }
    
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
           JFrame f = new JFrame("ResolutionIndependenceTest");
           f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
           f.add(new ResolutionIndependenceTest());
           f.pack();
           f.show();
            }
        });
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setLayout(new java.awt.BorderLayout());
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    
}
