/*
 * @(#)ColorChooserTest.java  1.0  13 February 2005
 *
 * Copyright (c) 2004 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * The copyright of this software is owned by Werner Randelshofer. 
 * You may not use, copy or modify this software, except in  
 * accordance with the license agreement you entered into with  
 * Werner Randelshofer. For details see accompanying license terms. 
 */

package test;

import ch.randelshofer.quaqua.*;
import java.awt.*;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.colorchooser.DefaultColorSelectionModel;
/**
 * ColorChooserTest.
 *
 * @author  Werner Randelshofer
 * @version 1.0  13 February 2005  Created.
 */
public class ColorChooserTest extends javax.swing.JPanel {
    private JColorChooser chooser;
    private Color color = Color.white;
    /** Creates new form. */
    public ColorChooserTest() {
        initComponents();
        chooserButton.putClientProperty("Quaqua.Button.style","colorWell");
        chooserButton.setBackground(color);
    }
    
    public static void main(String args[]) {
        try {
            UIManager.setLookAndFeel(QuaquaManager.getLookAndFeelClassName());
        } catch (Exception e) {
            e.printStackTrace();
        }
        JFrame f = new JFrame("Quaqua ColorChooser Test");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.getContentPane().add(new ColorChooserTest());
        ((JComponent) f.getContentPane()).setBorder(new EmptyBorder(9,17,17,17));
        f.pack();
        f.setVisible(true);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        chooserButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        chooserButton.setText("Open Color Chooser");
        chooserButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chooserButtonActionPerformed(evt);
            }
        });

        add(chooserButton, new java.awt.GridBagConstraints());

    }//GEN-END:initComponents
    
    private void chooserButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chooserButtonActionPerformed
        // TODO add your handling code here:
        try {
            //      System.out.println("chooserButtonActionPerformed "+evt);
            if (chooser == null) {
                chooser = new JColorChooser();
                /*
                chooser.setSelectionModel(new DefaultColorSelectionModel() {
                    public void setSelectedColor(Color c) {
                        new Throwable().printStackTrace();
                        super.setSelectedColor(c);
                    }
                }
                );*/
                //JOptionPane.showMessageDialog(this, "Made a new chooser");
            }
            color = chooser.showDialog(this, "Color Chooser", color);
            chooserButton.setBackground(color);
        } catch (Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            JOptionPane.showMessageDialog(this, "JColorChooser Failed "+sw.toString());
            t.printStackTrace();
        }
    }//GEN-LAST:event_chooserButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton chooserButton;
    // End of variables declaration//GEN-END:variables
    
}
