/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.Map;
import javax.help.Popup;
import javax.help.Presentation;
import javax.help.SwingHelpUtilities;
import javax.help.WindowPresentation;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;

public class CSH {
    private static Map comps;
    private static Map parents;
    private static Vector managers;
    private static final boolean debug = false;
    static /* synthetic */ Class class$javax$help$HelpSet;
    static /* synthetic */ Class class$java$lang$String;

    public static void addManager(Manager manager) {
        managers.add(manager);
    }

    public static void addManager(int n, Manager manager) {
        managers.add(n, manager);
    }

    public static boolean removeManager(Manager manager) {
        return managers.remove(manager);
    }

    public static void removeManager(int n) {
        managers.remove(n);
    }

    public static void removeAllManagers() {
        managers.clear();
    }

    public static Manager getManager(int n) {
        return (Manager)managers.get(n);
    }

    public static Manager[] getManagers() {
        return managers.toArray(new Manager[0]);
    }

    public static int getManagerCount() {
        return managers.size();
    }

    private static void _setHelpIDString(Object object, String string) {
        if (object instanceof JComponent) {
            ((JComponent)object).putClientProperty("HelpID", string);
        } else if (object instanceof Component || object instanceof MenuItem) {
            Hashtable<String, String> hashtable;
            if (comps == null) {
                comps = new WeakHashMap(5);
            }
            if ((hashtable = (Hashtable<String, String>)comps.get(object)) != null) {
                if (string != null) {
                    hashtable.put("HelpID", string);
                } else {
                    hashtable.remove("HelpID");
                    if (hashtable.isEmpty()) {
                        comps.remove(object);
                    }
                }
            } else if (string != null) {
                hashtable = new Hashtable<String, String>(2);
                hashtable.put("HelpID", string);
                comps.put(object, hashtable);
            }
        } else {
            throw new IllegalArgumentException("Invalid Component");
        }
    }

    private static String _getHelpIDString(Object object) {
        String string = null;
        if (object != null) {
            if (object instanceof JComponent) {
                string = (String)((JComponent)object).getClientProperty("HelpID");
            } else if (object instanceof Component || object instanceof MenuItem) {
                Hashtable hashtable;
                if (comps != null && (hashtable = (Hashtable)comps.get(object)) != null) {
                    string = (String)hashtable.get("HelpID");
                }
            } else {
                throw new IllegalArgumentException("Invalid Component");
            }
        }
        return string;
    }

    private static String _getHelpIDString(Object object, AWTEvent aWTEvent) {
        String string = null;
        if (object != null) {
            Manager[] managerArray = CSH.getManagers();
            int n = 0;
            while (n < managerArray.length) {
                string = managerArray[n].getHelpIDString(object, aWTEvent);
                if (string != null) {
                    return string;
                }
                ++n;
            }
        }
        return null;
    }

    private static Object getParent(Object object) {
        if (object == null) {
            return null;
        }
        MenuContainer menuContainer = null;
        if (object instanceof MenuComponent) {
            menuContainer = ((MenuComponent)object).getParent();
        } else if (object instanceof JPopupMenu) {
            menuContainer = ((JPopupMenu)object).getInvoker();
        } else if (object instanceof Component) {
            menuContainer = ((Component)object).getParent();
        } else {
            throw new IllegalArgumentException("Invalid Component");
        }
        if (menuContainer == null && parents != null) {
            menuContainer = parents.get(object);
        }
        return menuContainer;
    }

    public static void setHelpIDString(Component component, String string) {
        CSH._setHelpIDString(component, string);
    }

    public static void setHelpIDString(MenuItem menuItem, String string) {
        CSH._setHelpIDString(menuItem, string);
    }

    public static String getHelpIDString(Object object, AWTEvent aWTEvent) {
        if (object == null) {
            return null;
        }
        String string = CSH._getHelpIDString(object, aWTEvent);
        if (string == null) {
            string = CSH._getHelpIDString(object);
        }
        if (string == null) {
            string = CSH.getHelpIDString(CSH.getParent(object), aWTEvent);
        }
        return string;
    }

    public static String getHelpIDString(Component component) {
        return CSH.getHelpIDString(component, null);
    }

    public static String getHelpIDString(MenuItem menuItem) {
        return CSH.getHelpIDString(menuItem, null);
    }

    private static void _setHelpSet(Object object, HelpSet helpSet) {
        if (object instanceof JComponent) {
            ((JComponent)object).putClientProperty("HelpSet", helpSet);
        } else if (object instanceof Component || object instanceof MenuItem) {
            Hashtable<String, HelpSet> hashtable;
            if (comps == null) {
                comps = new WeakHashMap(5);
            }
            if ((hashtable = (Hashtable<String, HelpSet>)comps.get(object)) != null) {
                if (helpSet != null) {
                    hashtable.put("HelpSet", helpSet);
                } else {
                    hashtable.remove("HelpSet");
                    if (hashtable.isEmpty()) {
                        comps.remove(object);
                    }
                }
            } else if (helpSet != null) {
                hashtable = new Hashtable<String, HelpSet>(2);
                hashtable.put("HelpSet", helpSet);
                comps.put(object, hashtable);
            }
        } else {
            throw new IllegalArgumentException("Invalid Component");
        }
    }

    private static HelpSet _getHelpSet(Object object) {
        HelpSet helpSet = null;
        if (object != null) {
            if (object instanceof JComponent) {
                helpSet = (HelpSet)((JComponent)object).getClientProperty("HelpSet");
            } else if (object instanceof Component || object instanceof MenuItem) {
                Hashtable hashtable;
                if (comps != null && (hashtable = (Hashtable)comps.get(object)) != null) {
                    helpSet = (HelpSet)hashtable.get("HelpSet");
                }
            } else {
                throw new IllegalArgumentException("Invalid Component");
            }
        }
        return helpSet;
    }

    private static HelpSet _getHelpSet(Object object, AWTEvent aWTEvent) {
        HelpSet helpSet = null;
        if (object != null) {
            Manager[] managerArray = CSH.getManagers();
            int n = 0;
            while (n < managerArray.length) {
                helpSet = managerArray[n].getHelpSet(object, aWTEvent);
                if (helpSet != null) {
                    return helpSet;
                }
                ++n;
            }
        }
        return helpSet;
    }

    public static void setHelpSet(Component component, HelpSet helpSet) {
        CSH._setHelpSet(component, helpSet);
    }

    public static void setHelpSet(MenuItem menuItem, HelpSet helpSet) {
        CSH._setHelpSet(menuItem, helpSet);
    }

    public static HelpSet getHelpSet(Object object, AWTEvent aWTEvent) {
        if (object == null) {
            return null;
        }
        String string = CSH._getHelpIDString(object, aWTEvent);
        if (string == null) {
            string = CSH._getHelpIDString(object);
        }
        if (string != null) {
            HelpSet helpSet = CSH._getHelpSet(object, aWTEvent);
            if (helpSet == null) {
                helpSet = CSH._getHelpSet(object);
            }
            return helpSet;
        }
        return CSH.getHelpSet(CSH.getParent(object), aWTEvent);
    }

    public static HelpSet getHelpSet(Component component) {
        return CSH.getHelpSet(component, null);
    }

    public static HelpSet getHelpSet(MenuItem menuItem) {
        return CSH.getHelpSet(menuItem, null);
    }

    public static Object trackCSEvents() {
        MouseEvent mouseEvent = CSH.getMouseEvent();
        if (mouseEvent != null) {
            return CSH.getDeepestObjectAt(mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
        return null;
    }

    private static void displayHelp(HelpBroker helpBroker, HelpSet helpSet, String string, String string2, Object object, Object object2, AWTEvent aWTEvent) {
        Serializable serializable;
        Object object3;
        Object object4;
        Presentation presentation = null;
        if (helpBroker != null) {
            if (helpBroker instanceof DefaultHelpBroker) {
                ((DefaultHelpBroker)helpBroker).setActivationObject(object2);
            }
        } else {
            object4 = new Class[]{class$javax$help$HelpSet == null ? (class$javax$help$HelpSet = CSH.class$("javax.help.HelpSet")) : class$javax$help$HelpSet, class$java$lang$String == null ? (class$java$lang$String = CSH.class$("java.lang.String")) : class$java$lang$String};
            Object[] objectArray = new Object[]{helpSet, string2};
            try {
                object3 = helpSet.getLoader();
                serializable = object3 == null ? Class.forName(string) : ((ClassLoader)object3).loadClass(string);
                Method method = ((Class)serializable).getMethod("getPresentation", (Class<?>)object4);
                presentation = (Presentation)method.invoke(null, objectArray);
            }
            catch (Exception exception) {
                throw new RuntimeException("error invoking presentation");
            }
            if (presentation == null) {
                return;
            }
            if (presentation instanceof WindowPresentation) {
                ((WindowPresentation)presentation).setActivationObject(object2);
            }
            if (presentation instanceof Popup && object instanceof Component) {
                ((Popup)presentation).setInvoker((Component)object);
            }
        }
        object3 = null;
        serializable = null;
        object3 = CSH.getHelpIDString(object, aWTEvent);
        serializable = CSH.getHelpSet(object, aWTEvent);
        if (serializable == null) {
            serializable = helpBroker != null ? helpBroker.getHelpSet() : helpSet;
        }
        try {
            object4 = Map.ID.create((String)object3, (HelpSet)serializable);
            if (object4 == null) {
                object4 = ((HelpSet)serializable).getHomeID();
            }
            if (helpBroker != null) {
                helpBroker.setCurrentID((Map.ID)object4);
                helpBroker.setDisplayed(true);
            } else {
                presentation.setCurrentID((Map.ID)object4);
                presentation.setDisplayed(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static MouseEvent getMouseEvent() {
        block14: {
            try {
                if (!EventQueue.isDispatchThread()) break block14;
                EventQueue eventQueue = null;
                try {
                    eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                }
                catch (Exception exception) {
                    CSH.debug(exception);
                }
                if (eventQueue == null) {
                    return null;
                }
                int n = -1;
                while (true) {
                    ++n;
                    AWTEvent aWTEvent = eventQueue.getNextEvent();
                    Object object = aWTEvent.getSource();
                    if (aWTEvent instanceof ActiveEvent) {
                        ((ActiveEvent)((Object)aWTEvent)).dispatch();
                        continue;
                    }
                    if (object instanceof Component) {
                        InputEvent inputEvent;
                        if (aWTEvent instanceof KeyEvent) {
                            inputEvent = (KeyEvent)aWTEvent;
                            if (((KeyEvent)inputEvent).getKeyCode() == 3 || ((KeyEvent)inputEvent).getKeyCode() == 27) {
                                inputEvent.consume();
                                return null;
                            }
                            inputEvent.consume();
                            continue;
                        }
                        if (aWTEvent instanceof MouseEvent) {
                            inputEvent = (MouseEvent)aWTEvent;
                            int n2 = inputEvent.getID();
                            if ((n2 == 500 || n2 == 501 || n2 == 502) && SwingUtilities.isLeftMouseButton((MouseEvent)inputEvent)) {
                                if (n2 == 500 && n == 0) {
                                    CSH.dispatchEvent(aWTEvent);
                                    continue;
                                }
                                inputEvent.consume();
                                return inputEvent;
                            }
                            inputEvent.consume();
                            continue;
                        }
                        CSH.dispatchEvent(aWTEvent);
                        continue;
                    }
                    if (object instanceof MenuComponent) {
                        if (!(aWTEvent instanceof InputEvent)) continue;
                        ((InputEvent)aWTEvent).consume();
                        continue;
                    }
                    System.err.println("unable to dispatch event: " + aWTEvent);
                }
            }
            catch (InterruptedException interruptedException) {
                CSH.debug(interruptedException);
            }
        }
        CSH.debug("Fall Through code");
        return null;
    }

    private static void dispatchEvent(AWTEvent aWTEvent) {
        Object object = aWTEvent.getSource();
        if (aWTEvent instanceof ActiveEvent) {
            ((ActiveEvent)((Object)aWTEvent)).dispatch();
        } else if (object instanceof Component) {
            ((Component)object).dispatchEvent(aWTEvent);
        } else if (object instanceof MenuComponent) {
            ((MenuComponent)object).dispatchEvent(aWTEvent);
        } else {
            System.err.println("unable to dispatch event: " + aWTEvent);
        }
    }

    private static Object getDeepestObjectAt(Object object, int n, int n2) {
        Container container;
        Component component;
        if (object instanceof Container && (component = CSH.findComponentAt(container = (Container)object, container.getWidth(), container.getHeight(), n, n2)) != null && component != container) {
            if (component instanceof JRootPane) {
                JLayeredPane jLayeredPane = ((JRootPane)component).getLayeredPane();
                Rectangle rectangle = jLayeredPane.getBounds();
                component = (Component)CSH.getDeepestObjectAt(jLayeredPane, n - rectangle.x, n2 - rectangle.y);
            }
            if (component != null) {
                return component;
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Component findComponentAt(Container container, int n, int n2, int n3, int n4) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Serializable serializable;
            Serializable serializable2;
            if (n3 < 0) return null;
            if (n3 >= n) return null;
            if (n4 < 0) return null;
            if (n4 >= n2) return null;
            if (!container.isVisible()) return null;
            if (!container.isEnabled()) {
                return null;
            }
            Component[] componentArray = container.getComponents();
            int n5 = container.getComponentCount();
            int n6 = 0;
            while (n6 < n5) {
                Component component = componentArray[n6];
                serializable2 = null;
                if (component instanceof CellRendererPane && (serializable = CSH.getComponentAt((CellRendererPane)component, n3, n4)) != null) {
                    serializable2 = CSH.getRectangleAt((CellRendererPane)component, n3, n4);
                    component = serializable;
                }
                if (component != null && !component.isLightweight()) {
                    if (serializable2 == null || ((Rectangle)serializable2).width == 0 || ((Rectangle)serializable2).height == 0) {
                        serializable2 = component.getBounds();
                    }
                    if ((component = component instanceof Container ? CSH.findComponentAt((Container)component, ((Rectangle)serializable2).width, ((Rectangle)serializable2).height, n3 - ((Rectangle)serializable2).x, n4 - ((Rectangle)serializable2).y) : component.getComponentAt(n3 - ((Rectangle)serializable2).x, n4 - ((Rectangle)serializable2).y)) != null && component.isVisible() && component.isEnabled()) {
                        return component;
                    }
                }
                ++n6;
            }
            int n7 = 0;
            while (n7 < n5) {
                Serializable serializable3;
                serializable2 = componentArray[n7];
                serializable = null;
                if (serializable2 instanceof CellRendererPane && (serializable3 = CSH.getComponentAt((CellRendererPane)serializable2, n3, n4)) != null) {
                    serializable = CSH.getRectangleAt((CellRendererPane)serializable2, n3, n4);
                    serializable2 = serializable3;
                }
                if (serializable2 != null && ((Component)serializable2).isLightweight()) {
                    if (serializable == null || ((Rectangle)serializable).width == 0 || ((Rectangle)serializable).height == 0) {
                        serializable = ((Component)serializable2).getBounds();
                    }
                    if ((serializable2 = serializable2 instanceof Container ? CSH.findComponentAt((Container)serializable2, ((Rectangle)serializable).width, ((Rectangle)serializable).height, n3 - ((Rectangle)serializable).x, n4 - ((Rectangle)serializable).y) : ((Component)serializable2).getComponentAt(n3 - ((Rectangle)serializable).x, n4 - ((Rectangle)serializable).y)) != null && ((Component)serializable2).isVisible() && ((Component)serializable2).isEnabled()) {
                        return serializable2;
                    }
                }
                ++n7;
            }
            return container;
        }
    }

    private static Rectangle getRectangleAt(CellRendererPane cellRendererPane, int n, int n2) {
        Rectangle rectangle = null;
        Container container = cellRendererPane.getParent();
        if (container instanceof JTable) {
            rectangle = CSH.getRectangleAt((JTable)container, n, n2);
        } else if (container instanceof JTableHeader) {
            rectangle = CSH.getRectangleAt((JTableHeader)container, n, n2);
        } else if (container instanceof JTree) {
            rectangle = CSH.getRectangleAt((JTree)container, n, n2);
        } else if (container instanceof JList) {
            rectangle = CSH.getRectangleAt((JList)container, n, n2);
        }
        return rectangle;
    }

    private static Component getComponentAt(CellRendererPane cellRendererPane, int n, int n2) {
        Component component = null;
        Container container = cellRendererPane.getParent();
        if (container instanceof JTable) {
            component = CSH.getComponentAt((JTable)container, n, n2);
        } else if (container instanceof JTableHeader) {
            component = CSH.getComponentAt((JTableHeader)container, n, n2);
        } else if (container instanceof JTree) {
            component = CSH.getComponentAt((JTree)container, n, n2);
        } else if (container instanceof JList) {
            component = CSH.getComponentAt((JList)container, n, n2);
        }
        if (component != null) {
            if (parents == null) {
                parents = new WeakHashMap(4){

                    public Object put(Object object, Object object2) {
                        return super.put(object, new WeakReference<Object>(object2));
                    }

                    public Object get(Object object) {
                        WeakReference weakReference = (WeakReference)super.get(object);
                        if (weakReference != null) {
                            return weakReference.get();
                        }
                        return null;
                    }
                };
            }
            parents.put(component, cellRendererPane);
        }
        return component;
    }

    private static Rectangle getRectangleAt(JTableHeader jTableHeader, int n, int n2) {
        Rectangle rectangle = null;
        try {
            int n3 = jTableHeader.columnAtPoint(new Point(n, n2));
            rectangle = jTableHeader.getHeaderRect(n3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rectangle;
    }

    private static Component getComponentAt(JTableHeader jTableHeader, int n, int n2) {
        try {
            int n3;
            if (!(jTableHeader.contains(n, n2) && jTableHeader.isVisible() && jTableHeader.isEnabled())) {
                return null;
            }
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(n3 = tableColumnModel.getColumnIndexAtX(n));
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = jTableHeader.getDefaultRenderer();
            }
            return tableCellRenderer.getTableCellRendererComponent(jTableHeader.getTable(), tableColumn.getHeaderValue(), false, false, -1, n3);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Rectangle getRectangleAt(JTable jTable, int n, int n2) {
        Rectangle rectangle = null;
        try {
            Point point = new Point(n, n2);
            int n3 = jTable.rowAtPoint(point);
            int n4 = jTable.columnAtPoint(point);
            rectangle = jTable.getCellRect(n3, n4, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rectangle;
    }

    private static Component getComponentAt(JTable jTable, int n, int n2) {
        try {
            if (!(jTable.contains(n, n2) && jTable.isVisible() && jTable.isEnabled())) {
                return null;
            }
            Point point = new Point(n, n2);
            int n3 = jTable.rowAtPoint(point);
            int n4 = jTable.columnAtPoint(point);
            if (jTable.isEditing() && jTable.getEditingRow() == n3 && jTable.getEditingColumn() == n4) {
                return null;
            }
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n3, n4);
            return jTable.prepareRenderer(tableCellRenderer, n3, n4);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Rectangle getRectangleAt(JTree jTree, int n, int n2) {
        Rectangle rectangle = null;
        try {
            TreePath treePath = jTree.getPathForLocation(n, n2);
            rectangle = jTree.getPathBounds(treePath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rectangle;
    }

    private static Component getComponentAt(JTree jTree, int n, int n2) {
        try {
            TreePath treePath = jTree.getPathForLocation(n, n2);
            if (jTree.isEditing() && jTree.getSelectionPath() == treePath) {
                return null;
            }
            int n3 = jTree.getRowForPath(treePath);
            Object object = treePath.getLastPathComponent();
            boolean bl = jTree.isRowSelected(n3);
            boolean bl2 = jTree.isExpanded(treePath);
            boolean bl3 = jTree.getModel().isLeaf(object);
            boolean bl4 = jTree.hasFocus() && jTree.getLeadSelectionRow() == n3;
            return jTree.getCellRenderer().getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n3, bl4);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Rectangle getRectangleAt(JList jList, int n, int n2) {
        Rectangle rectangle = null;
        try {
            int n3 = jList.locationToIndex(new Point(n, n2));
            rectangle = jList.getCellBounds(n3, n3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rectangle;
    }

    private static Component getComponentAt(JList jList, int n, int n2) {
        try {
            int n3 = jList.locationToIndex(new Point(n, n2));
            Object e = jList.getModel().getElementAt(n3);
            boolean bl = jList.isSelectedIndex(n3);
            boolean bl2 = jList.hasFocus() && jList.getLeadSelectionIndex() == n3;
            return jList.getCellRenderer().getListCellRendererComponent(jList, e, n3, bl, bl2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static JPopupMenu getRootPopupMenu(JPopupMenu jPopupMenu) {
        while (jPopupMenu != null && jPopupMenu.getInvoker() instanceof JMenu && jPopupMenu.getInvoker().getParent() instanceof JPopupMenu) {
            jPopupMenu = (JPopupMenu)jPopupMenu.getInvoker().getParent();
        }
        return jPopupMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Component findFocusOwner(JPopupMenu jPopupMenu) {
        if (jPopupMenu == null) {
            return null;
        }
        Object object = jPopupMenu.getTreeLock();
        synchronized (object) {
            block12: {
                Component component;
                block11: {
                    if (jPopupMenu.isVisible()) break block11;
                    Component component2 = null;
                    return component2;
                }
                Component component3 = null;
                int n = 0;
                int n2 = jPopupMenu.getComponentCount();
                while (n < n2) {
                    component = jPopupMenu.getComponent(n);
                    if (component.hasFocus()) {
                        component3 = component;
                        break;
                    }
                    if (component instanceof JMenu && ((JMenu)component).isPopupMenuVisible()) {
                        component3 = component;
                    }
                    if (component instanceof JMenuItem && ((JMenuItem)component).isArmed()) {
                        component3 = component;
                    }
                    ++n;
                }
                if (component3 instanceof JMenu) {
                    component3 = CSH.findFocusOwner(((JMenu)component3).getPopupMenu());
                }
                if (component3 == null) break block12;
                component = component3;
                return component;
            }
        }
        return jPopupMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Component findFocusOwner(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (component instanceof JPopupMenu) {
                return CSH.findFocusOwner(CSH.getRootPopupMenu((JPopupMenu)component));
            }
            if (component.hasFocus()) {
                return component;
            }
            if (!(component instanceof Container)) return null;
            int n = 0;
            int n2 = ((Container)component).getComponentCount();
            while (n < n2) {
                Component component2 = CSH.findFocusOwner(((Container)component).getComponent(n));
                if (component2 != null) {
                    return component2;
                }
                ++n;
            }
            return null;
        }
    }

    private static void debug(Object object) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        managers = new Vector();
    }

    public static class DisplayHelpAfterTracking
    implements ActionListener {
        private HelpBroker hb = null;
        private HelpSet hs = null;
        private String presentation = null;
        private String presentationName = null;
        private Hashtable cursors;

        public DisplayHelpAfterTracking(HelpBroker helpBroker) {
            if (helpBroker == null) {
                throw new NullPointerException("hb");
            }
            this.hb = helpBroker;
        }

        public DisplayHelpAfterTracking(HelpSet helpSet, String string, String string2) {
            if (helpSet == null) {
                throw new NullPointerException("hs");
            }
            try {
                ClassLoader classLoader = helpSet.getLoader();
                if (classLoader == null) {
                    Class<?> clazz = Class.forName(string);
                } else {
                    Class<?> clazz = classLoader.loadClass(string);
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(string + "presentation  invalid");
            }
            this.presentation = string;
            this.presentationName = string2;
            this.hs = helpSet;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2;
            SwingHelpUtilities.installUIDefaults();
            Cursor cursor = (Cursor)UIManager.get("HelpOnItemCursor");
            if (cursor == null) {
                return;
            }
            Vector vector = null;
            this.cursors = null;
            if (cursor != null) {
                this.cursors = new Hashtable();
                vector = DisplayHelpAfterTracking.getTopContainers(actionEvent.getSource());
                object2 = vector.elements();
                while (object2.hasMoreElements()) {
                    this.setAndStoreCursors((Container)object2.nextElement(), cursor);
                }
            }
            object2 = CSH.getMouseEvent();
            CSH.debug("CSH.getMouseEvent() >>> " + object2);
            if (object2 != null) {
                object = CSH.getDeepestObjectAt(((EventObject)object2).getSource(), ((MouseEvent)object2).getX(), ((MouseEvent)object2).getY());
                CSH.debug("CSH.getDeepestObjectAt() >>> " + object);
                if (object != null) {
                    CSH.displayHelp(this.hb, this.hs, this.presentation, this.presentationName, object, actionEvent.getSource(), (AWTEvent)object2);
                }
            }
            if (vector != null) {
                object = vector.elements();
                while (object.hasMoreElements()) {
                    this.resetAndRestoreCursors((Container)object.nextElement());
                }
            }
            this.cursors = null;
        }

        private static Vector getTopContainers(Object object) {
            Object object2;
            Vector<Object> vector = new Vector<Object>();
            Component component = null;
            component = DisplayHelpAfterTracking.getRoot(object);
            if (component instanceof Applet) {
                try {
                    object2 = ((Applet)component).getAppletContext().getApplets();
                    while (object2.hasMoreElements()) {
                        vector.add(object2.nextElement());
                    }
                }
                catch (NullPointerException nullPointerException) {
                    vector.add(component);
                }
            }
            object2 = Frame.getFrames();
            int n = 0;
            while (n < ((Frame[])object2).length) {
                Window[] windowArray = ((Window)object2[n]).getOwnedWindows();
                int n2 = 0;
                while (n2 < windowArray.length) {
                    vector.add(windowArray[n2]);
                    ++n2;
                }
                if (!vector.contains(object2[n])) {
                    vector.add(object2[n]);
                }
                ++n;
            }
            return vector;
        }

        private static Component getRoot(Object object) {
            Object object2 = object;
            while (object2 != null) {
                object = object2;
                if (object instanceof MenuComponent) {
                    object2 = ((MenuComponent)object).getParent();
                    continue;
                }
                if (!(object instanceof Component) || object instanceof Window || object instanceof Applet) break;
                object2 = ((Component)object).getParent();
            }
            if (object instanceof Component) {
                return (Component)object;
            }
            return null;
        }

        private void setAndStoreCursors(Component component, Cursor cursor) {
            if (component == null) {
                return;
            }
            Cursor cursor2 = component.getCursor();
            if (cursor2 != cursor) {
                this.cursors.put(component, cursor2);
                CSH.debug("set cursor on " + component);
                component.setCursor(cursor);
            }
            if (component instanceof Container) {
                Component[] componentArray = ((Container)component).getComponents();
                int n = 0;
                while (n < componentArray.length) {
                    this.setAndStoreCursors(componentArray[n], cursor);
                    ++n;
                }
            }
        }

        private void resetAndRestoreCursors(Component component) {
            if (component == null) {
                return;
            }
            Cursor cursor = (Cursor)this.cursors.get(component);
            if (cursor != null) {
                CSH.debug("restored cursor " + cursor + " on " + component);
                component.setCursor(cursor);
            }
            if (component instanceof Container) {
                Component[] componentArray = ((Container)component).getComponents();
                int n = 0;
                while (n < componentArray.length) {
                    this.resetAndRestoreCursors(componentArray[n]);
                    ++n;
                }
            }
        }
    }

    public static class DisplayHelpFromFocus
    implements ActionListener {
        private HelpBroker hb = null;
        private HelpSet hs = null;
        private String presentation = null;
        private String presentationName = null;

        public DisplayHelpFromFocus(HelpBroker helpBroker) {
            if (helpBroker == null) {
                throw new NullPointerException("hb");
            }
            this.hb = helpBroker;
        }

        public DisplayHelpFromFocus(HelpSet helpSet, String string, String string2) {
            if (helpSet == null) {
                throw new NullPointerException("hs");
            }
            try {
                ClassLoader classLoader = helpSet.getLoader();
                if (classLoader == null) {
                    Class<?> clazz = Class.forName(string);
                } else {
                    Class<?> clazz = classLoader.loadClass(string);
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(string + "presentation  invalid");
            }
            this.presentation = string;
            this.presentationName = string2;
            this.hs = helpSet;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = (Component)actionEvent.getSource();
            if (this.hb instanceof DefaultHelpBroker) {
                ((DefaultHelpBroker)this.hb).setActivationObject(component);
            }
            Component component2 = CSH.findFocusOwner(component);
            CSH.debug("focusOwner:" + component2);
            if (component2 == null) {
                component2 = component;
            }
            CSH.displayHelp(this.hb, this.hs, this.presentation, this.presentationName, component2, component2, actionEvent);
        }
    }

    public static class DisplayHelpFromSource
    implements ActionListener {
        private HelpBroker hb;
        private HelpSet hs = null;
        private String presentation = null;
        private String presentationName = null;

        public DisplayHelpFromSource(HelpBroker helpBroker) {
            if (helpBroker == null) {
                throw new NullPointerException("hb");
            }
            this.hb = helpBroker;
        }

        public DisplayHelpFromSource(HelpSet helpSet, String string, String string2) {
            if (helpSet == null) {
                throw new NullPointerException("hs");
            }
            try {
                ClassLoader classLoader = helpSet.getLoader();
                if (classLoader == null) {
                    Class<?> clazz = Class.forName(string);
                } else {
                    Class<?> clazz = classLoader.loadClass(string);
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(string + "presentation  invalid");
            }
            this.presentation = string;
            this.presentationName = string2;
            this.hs = helpSet;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            CSH.displayHelp(this.hb, this.hs, this.presentation, this.presentationName, object, object, actionEvent);
        }
    }

    public static interface Manager {
        public HelpSet getHelpSet(Object var1, AWTEvent var2);

        public String getHelpIDString(Object var1, AWTEvent var2);
    }
}

