/*
 * Decompiled with CFR 0.152.
 */
package HalogenWare.Custom;

import com.apple.eio.FileManager;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.prefs.Preferences;
import java.util.zip.ZipFile;
import javax.help.CSH;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelp;
import javax.help.JHelpContentViewer;
import javax.help.SwingHelpUtilities;
import javax.help.WindowPresentation;
import javax.help.plaf.basic.BasicContentViewerUI;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.plaf.ComponentUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickHelp {
    private static final String helpx = "x";
    private static final String helpy = "y";
    private static final String helpw = "w";
    private static final String helph = "h";
    private static final String helpstate = "helpstate";
    private static final String helpfont = "helpfont";
    private static final String helpfontsize = "helpfontsize";
    private static final int defaultx = 0;
    private static final int defaulty = 0;
    private static final int defaultw = 0;
    private static final int defaulth = 0;
    private static final int defaultwindowstate = 0;
    private JFrame helpwindow;
    private HelpBroker hb;
    private Preferences helpprefs;
    private JLabel status;

    public QuickHelp(File file, boolean bl, String string, Locale locale, boolean bl2) throws MalformedURLException, HelpSetException {
        URL[] uRLArray;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        arrayList.add(file.toURI().toURL());
        if (bl && file.isDirectory()) {
            uRLArray = new FileFilter(){

                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    try {
                        new ZipFile(file);
                        return true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
            };
            this.recurse(file, (FileFilter)uRLArray, arrayList);
        }
        uRLArray = new URL[arrayList.size()];
        uRLArray = arrayList.toArray(uRLArray);
        URLClassLoader uRLClassLoader = URLClassLoader.newInstance(uRLArray);
        this.finishInit(uRLClassLoader, string, locale, bl2);
    }

    public QuickHelp(ClassLoader classLoader, String string, Locale locale, boolean bl) throws MalformedURLException, HelpSetException {
        this.finishInit(classLoader, string, locale, bl);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    URL uRL;
                    Manifest manifest;
                    Attributes attributes;
                    ClassLoader classLoader = QuickHelp.class.getClassLoader();
                    String string = null;
                    Object object = classLoader.getResources("META-INF/MANIFEST.MF");
                    while (object.hasMoreElements() && (string = (attributes = (manifest = new Manifest((uRL = object.nextElement()).openStream())).getMainAttributes()).getValue("Helpset")) == null) {
                    }
                    object = new QuickHelp(classLoader, string, null, true);
                    ((QuickHelp)object).show();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    private void finishInit(ClassLoader classLoader, String string, Locale locale, boolean bl) throws MalformedURLException, HelpSetException {
        URL uRL = locale != null ? HelpSet.findHelpSet((ClassLoader)classLoader, (String)string, (Locale)locale) : HelpSet.findHelpSet((ClassLoader)classLoader, (String)string);
        SwingHelpUtilities.setContentViewerUI((String)"HalogenWare.Custom.QuickHelp$ExternalLinkContentViewerUI");
        HelpSet helpSet = new HelpSet(classLoader, uRL);
        this.hb = helpSet.createHelpBroker();
        this.hb.initPresentation();
        WindowPresentation windowPresentation = ((DefaultHelpBroker)this.hb).getWindowPresentation();
        this.helpwindow = (JFrame)windowPresentation.getHelpWindow();
        this.helpprefs = Preferences.userNodeForPackage(this.getClass());
        this.customize(bl);
    }

    private void recurse(File file, FileFilter fileFilter, ArrayList<URL> arrayList) throws MalformedURLException {
        File[] fileArray = file.listFiles(fileFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            arrayList.add(fileArray[i].toURI().toURL());
            if (!fileArray[i].isDirectory()) continue;
            this.recurse(fileArray[i], fileFilter, arrayList);
        }
    }

    public HelpBroker getHelpBroker() {
        return this.hb;
    }

    public ActionListener getHelpAction() {
        return new CSH.DisplayHelpFromSource(this.hb);
    }

    public void show() {
        this.hb.setDisplayed(true);
    }

    private void customize(boolean bl) {
        this.helpwindow.setDefaultCloseOperation(2);
        this.helpwindow.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (QuickHelp.this.helpwindow.getExtendedState() != 6) {
                    QuickHelp.this.helpprefs.putInt(QuickHelp.helpx, QuickHelp.this.helpwindow.getX());
                    QuickHelp.this.helpprefs.putInt(QuickHelp.helpy, QuickHelp.this.helpwindow.getY());
                    QuickHelp.this.helpprefs.putInt(QuickHelp.helpw, QuickHelp.this.helpwindow.getWidth());
                    QuickHelp.this.helpprefs.putInt(QuickHelp.helph, QuickHelp.this.helpwindow.getHeight());
                }
                QuickHelp.this.helpprefs.putInt(QuickHelp.helpstate, QuickHelp.this.helpwindow.getExtendedState());
            }

            public void windowStateChanged(WindowEvent windowEvent) {
                if (windowEvent.getNewState() == 6) {
                    QuickHelp.this.helpprefs.putInt(QuickHelp.helpx, QuickHelp.this.helpwindow.getX());
                    QuickHelp.this.helpprefs.putInt(QuickHelp.helpy, QuickHelp.this.helpwindow.getY());
                    QuickHelp.this.helpprefs.putInt(QuickHelp.helpw, QuickHelp.this.helpwindow.getWidth());
                    QuickHelp.this.helpprefs.putInt(QuickHelp.helph, QuickHelp.this.helpwindow.getHeight());
                }
            }
        });
        int n = this.helpprefs.getInt(helpx, 0);
        int n2 = this.helpprefs.getInt(helpy, 0);
        int n3 = this.helpprefs.getInt(helpw, 0);
        int n4 = this.helpprefs.getInt(helph, 0);
        if (n != 0 || n2 != 0 || n3 != 0 || n4 != 0) {
            this.helpwindow.setBounds(n, n2, n3, n4);
            this.helpwindow.validate();
        }
        this.helpwindow.setExtendedState(this.helpprefs.getInt(helpstate, 0));
        if (bl) {
            Font font = this.hb.getFont();
            Font font2 = new Font(this.helpprefs.get(helpfont, font.getFamily()), font.getStyle(), this.helpprefs.getInt(helpfontsize, font.getSize()));
            this.hb.setFont(font2);
            JComboBox<String> jComboBox = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
            jComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    String string = (String)itemEvent.getItem();
                    if (itemEvent.getStateChange() == 1) {
                        Font font = QuickHelp.this.hb.getFont();
                        QuickHelp.this.hb.setFont(new Font(string, font.getStyle(), font.getSize()));
                        QuickHelp.this.helpprefs.put(QuickHelp.helpfont, string);
                    }
                }
            });
            jComboBox.setSelectedItem(this.hb.getFont().getFamily());
            final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(this.hb.getFont().getSize(), 0, 128, 1));
            jSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    Integer n = (Integer)jSpinner.getValue();
                    QuickHelp.this.hb.setFont(QuickHelp.this.hb.getFont().deriveFont((float)n.intValue()));
                    QuickHelp.this.helpprefs.putInt(QuickHelp.helpfontsize, n);
                }
            });
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.anchor = 23;
            gridBagConstraints.gridwidth = -1;
            gridBagLayout.setConstraints(jComboBox, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(jSpinner, gridBagConstraints);
            JPanel jPanel = new JPanel(gridBagLayout);
            jPanel.add(jComboBox);
            jPanel.add(jSpinner);
            this.helpwindow.getContentPane().add((Component)jPanel, "First");
            this.status = new JLabel(" ");
            this.status.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            this.helpwindow.getContentPane().add((Component)this.status, "Last");
            Component[] componentArray = this.helpwindow.getContentPane().getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof JHelp)) continue;
                ((JHelp)componentArray[i]).getContentViewer().putClientProperty((Object)"statusbar", (Object)this.status);
                break;
            }
        }
    }

    public static class ExternalLinkContentViewerUI
    extends BasicContentViewerUI {
        private JLabel status;

        public static ComponentUI createUI(JComponent jComponent) {
            return new ExternalLinkContentViewerUI((JHelpContentViewer)jComponent);
        }

        public ExternalLinkContentViewerUI(JHelpContentViewer jHelpContentViewer) {
            super(jHelpContentViewer);
            if (jHelpContentViewer.getClientProperty((Object)"statusbar") != null) {
                this.status = (JLabel)jHelpContentViewer.getClientProperty((Object)"statusbar");
            } else {
                jHelpContentViewer.addPropertyChangeListener("statusbar", new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        ExternalLinkContentViewerUI.this.status = (JLabel)propertyChangeEvent.getNewValue();
                    }
                });
            }
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (this.status != null && hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                this.status.setText(hyperlinkEvent.getURL().toString());
            }
            if (this.status != null && hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                this.status.setText(" ");
            }
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                URL uRL;
                if (this.status != null) {
                    this.status.setText(" ");
                }
                if (!((uRL = hyperlinkEvent.getURL()) == null || uRL.getProtocol().equalsIgnoreCase("file") || uRL.getProtocol().equalsIgnoreCase("jar") || uRL.getProtocol().equalsIgnoreCase("ejar"))) {
                    if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
                        try {
                            FileManager.openURL((String)uRL.toString());
                            return;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    try {
                        Thread thread = new Thread(){
                            BrowserLauncher bl = new BrowserLauncher(null);

                            public void run() {
                                try {
                                    this.bl.openURLinBrowser(uRL.toString());
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        };
                        thread.setDaemon(true);
                        thread.start();
                        return;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            super.hyperlinkUpdate(hyperlinkEvent);
        }
    }
}

