/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.windows;

import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.IBrowserLaunching;
import edu.stanford.ejalbert.launching.windows.WindowsBrowser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import net.sf.wraplog.AbstractLogger;

public class WindowsBrowserLaunching
implements IBrowserLaunching {
    private static final String CONFIGFILE_WINDOWS = "/edu/stanford/ejalbert/launching/windows/windowsConfig.properties";
    public static final String WINKEY_WINVISTA = "windows.winVista";
    public static final String WINKEY_WIN2000 = "windows.win2000";
    public static final String WINKEY_WIN9X = "windows.win9x";
    public static final String WINKEY_WINNT = "windows.winNT";
    private static final String[] WIN_KEYS = new String[]{"windows.win2000", "windows.win9x", "windows.winNT", "windows.winVista"};
    protected final AbstractLogger logger;
    private Map browserNameAndExeMap = null;
    private List browsersToCheck = new ArrayList();
    private String commandsDefaultBrowser;
    private String commandsTargettedBrowser;
    private final String windowsKey;
    private boolean forceNewWindow = false;
    private boolean useRegistry = false;
    private String programFilesFolderTemplate;
    private String driveLetters;
    private static final int REGEDIT_TYPE_APPPATHS = 0;
    private static String[] regeditQueries;

    public WindowsBrowserLaunching(AbstractLogger abstractLogger, String string) {
        if (string == null) {
            throw new IllegalArgumentException("windowsKey cannot be null");
        }
        if (Arrays.binarySearch(WIN_KEYS, string) < 0) {
            throw new IllegalArgumentException(string + " is invalid");
        }
        this.logger = abstractLogger;
        this.windowsKey = string;
        abstractLogger.info(string);
    }

    private String getArrayAsString(String[] stringArray) {
        return Arrays.asList(stringArray).toString();
    }

    private String getProtocol(String string) throws MalformedURLException {
        URL uRL = new URL(string);
        return uRL.getProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getBrowserMap() {
        Class<WindowsBrowserLaunching> clazz = WindowsBrowserLaunching.class;
        synchronized (WindowsBrowserLaunching.class) {
            if (this.browserNameAndExeMap == null) {
                this.browserNameAndExeMap = new HashMap();
                ArrayList arrayList = new ArrayList(this.browsersToCheck);
                if (this.useRegistry) {
                    this.browserNameAndExeMap.putAll(this.getAvailableBrowsers(arrayList));
                }
                if (!arrayList.isEmpty()) {
                    this.browserNameAndExeMap.putAll(this.processFilePathsForBrowsers(arrayList));
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.browserNameAndExeMap;
        }
    }

    private File getProgramFilesPath() {
        File file = null;
        if (this.driveLetters != null && this.programFilesFolderTemplate != null) {
            String[] stringArray = this.driveLetters.split(";");
            for (int i = 0; i < stringArray.length && file == null; ++i) {
                String string = MessageFormat.format(this.programFilesFolderTemplate, stringArray[i]);
                File file2 = new File(string);
                this.logger.debug(string);
                this.logger.debug(file2.getPath());
                if (!file2.exists()) continue;
                file = file2;
            }
        }
        return file;
    }

    private Map processFilePathsForBrowsers(List list) {
        this.logger.debug("finding available browsers in program files path");
        this.logger.debug("browsers to check: " + list);
        HashMap<String, WindowsBrowser> hashMap = new HashMap<String, WindowsBrowser>();
        File file = this.getProgramFilesPath();
        if (file != null) {
            this.logger.debug("program files path: " + file.getPath());
            File[] fileArray = file.listFiles(new DirFileFilter());
            int n = fileArray != null ? fileArray.length : 0;
            Iterator iterator = list.iterator();
            HashMap<String, WindowsBrowser> hashMap2 = new HashMap<String, WindowsBrowser>();
            while (iterator.hasNext()) {
                WindowsBrowser windowsBrowser = (WindowsBrowser)iterator.next();
                hashMap2.put(windowsBrowser.getSubDirName(), windowsBrowser);
            }
            for (int i = 0; i < n && !list.isEmpty(); ++i) {
                WindowsBrowser windowsBrowser;
                String string;
                File file2;
                if (!hashMap2.containsKey(fileArray[i].getName()) || (file2 = this.findExeFilePath(fileArray[i], string = (windowsBrowser = (WindowsBrowser)hashMap2.get(fileArray[i].getName())).getBrowserApplicationName() + ".exe")) == null) continue;
                this.logger.debug("Adding browser " + windowsBrowser.getBrowserDisplayName() + " to available list.");
                windowsBrowser.setPathToExe(file2.getPath());
                this.logger.debug(windowsBrowser.getPathToExe());
                hashMap.put(windowsBrowser.getBrowserDisplayName(), windowsBrowser);
                hashMap.put(windowsBrowser.getBrowserApplicationName(), windowsBrowser);
                list.remove(windowsBrowser);
            }
        }
        return hashMap;
    }

    private File findExeFilePath(File file, String string) {
        File[] fileArray;
        File file2 = null;
        File[] fileArray2 = file.listFiles(new ExeFileNameFilter());
        if (fileArray2 != null && fileArray2.length > 0) {
            for (int i = 0; i < fileArray2.length && file2 == null; ++i) {
                if (!fileArray2[i].getName().equalsIgnoreCase(string)) continue;
                file2 = fileArray2[i].getParentFile();
            }
        }
        if (file2 == null && (fileArray = file.listFiles(new DirFileFilter())) != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length && file2 == null; ++i) {
                file2 = this.findExeFilePath(fileArray[i], string);
            }
        }
        return file2;
    }

    private void processFileForBrowsers(File file, Map map, List list, int n) throws FileNotFoundException, IOException {
        String string;
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[2];
        fileInputStream.read(byArray);
        fileInputStream.close();
        InputStreamReader inputStreamReader = null;
        inputStreamReader = byArray[0] == -1 && byArray[1] == -2 ? new InputStreamReader((InputStream)new FileInputStream(file), "UTF-16") : new InputStreamReader(new FileInputStream(file));
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        HashMap<String, WindowsBrowser> hashMap = new HashMap<String, WindowsBrowser>();
        for (Object object : list) {
            String string2 = ((WindowsBrowser)object).getBrowserApplicationName().toLowerCase() + ".exe";
            hashMap.put(string2, (WindowsBrowser)object);
        }
        while ((string = bufferedReader.readLine()) != null) {
            String string3;
            int n2;
            Object object;
            if (0 != n || !string.startsWith("@=") || (n2 = ((String)(object = string.substring(3, string.length() - 1))).lastIndexOf(92) + 1) <= 1 || n2 >= ((String)object).length() || !hashMap.containsKey(string3 = ((String)object).toLowerCase().substring(n2))) continue;
            WindowsBrowser windowsBrowser = (WindowsBrowser)hashMap.get(string3);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(string);
                this.logger.debug((String)object);
                this.logger.debug("Adding browser " + windowsBrowser.getBrowserDisplayName() + " to available list.");
            }
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, "\\", false);
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = stringTokenizer.countTokens();
            for (int i = 1; i < n3; ++i) {
                stringBuffer.append(stringTokenizer.nextToken());
                stringBuffer.append('\\');
            }
            windowsBrowser.setPathToExe(stringBuffer.toString());
            this.logger.debug(windowsBrowser.getPathToExe());
            map.put(windowsBrowser.getBrowserDisplayName(), windowsBrowser);
            map.put(windowsBrowser.getBrowserApplicationName(), windowsBrowser);
            list.remove(windowsBrowser);
        }
        inputStreamReader.close();
    }

    private Map getAvailableBrowsers(List list) {
        this.logger.debug("finding available browsers using registry");
        this.logger.debug("browsers to check: " + list);
        TreeMap treeMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        try {
            for (int i = 0; i < regeditQueries.length && !list.isEmpty(); ++i) {
                File file = File.createTempFile("bl2-app-paths", ".reg");
                String[] stringArray = new String[]{"regedit.exe", "/E", "\"" + file.getAbsolutePath() + "\"", regeditQueries[i]};
                Process process = Runtime.getRuntime().exec(stringArray);
                int n = -1;
                try {
                    n = process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    this.logger.error("InterruptedException exec'ing regedit.exe: " + interruptedException.getMessage());
                }
                if (n != 0) {
                    this.logger.error("Unable to exec regedit.exe to extract available browsers.");
                    file.delete();
                    return treeMap;
                }
                this.processFileForBrowsers(file, treeMap, list, i);
                file.delete();
            }
        }
        catch (IOException iOException) {
            this.logger.error("Error listing available browsers: " + iOException.getMessage());
        }
        return treeMap;
    }

    private String[] getCommandArgs(String string, String string2) {
        String string3 = this.commandsDefaultBrowser.replaceAll("<url>", string2);
        return string3.split("[ ]");
    }

    private String getCommandArgs(String string, WindowsBrowser windowsBrowser, String string2, boolean bl) {
        int n;
        String string3 = this.commandsTargettedBrowser.replaceAll("<url>", string2);
        string3 = string3.replaceAll("<browser>", windowsBrowser.getBrowserApplicationName());
        String string4 = "";
        if (bl) {
            string4 = windowsBrowser.getForceNewWindowArgs();
        }
        if ((n = (string3 = string3.replaceAll("<args>", string4)).indexOf("<path>")) > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string3.substring(0, n));
            stringBuffer.append(windowsBrowser.getPathToExe());
            stringBuffer.append(string3.substring(n + 6));
            string3 = stringBuffer.toString();
        }
        return string3;
    }

    private boolean openUrlWithBrowser(WindowsBrowser windowsBrowser, String string, String string2) throws BrowserLaunchingExecutionException {
        boolean bl = false;
        try {
            this.logger.info(windowsBrowser.getBrowserDisplayName());
            this.logger.info(string2);
            this.logger.info(string);
            String string3 = this.getCommandArgs(string, windowsBrowser, string2, this.forceNewWindow);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(string3);
            }
            Process process = Runtime.getRuntime().exec(string3);
            process.waitFor();
            int n = process.exitValue();
            bl = n == 0 || n == 1;
        }
        catch (Exception exception) {
            throw new BrowserLaunchingExecutionException(exception);
        }
        return bl;
    }

    public void initialize() throws BrowserLaunchingInitializingException {
        try {
            Object object;
            URL uRL = this.getClass().getResource(CONFIGFILE_WINDOWS);
            if (uRL == null) {
                throw new BrowserLaunchingInitializingException("unable to find config file: /edu/stanford/ejalbert/launching/windows/windowsConfig.properties");
            }
            Properties properties = new Properties();
            properties.load(uRL.openStream());
            String string2 = properties.getProperty("delimchar");
            for (String string3 : properties.keySet()) {
                if (!string3.startsWith("browser.")) continue;
                object = new WindowsBrowser(string2, properties.getProperty(string3));
                this.browsersToCheck.add(object);
            }
            String string = properties.getProperty(this.windowsKey, null);
            if (string == null) {
                throw new BrowserLaunchingInitializingException(this.windowsKey + " is not a valid property");
            }
            object = string.split(string2);
            this.commandsDefaultBrowser = object[0];
            this.commandsTargettedBrowser = object[1];
            Boolean bl = new Boolean(object[2]);
            this.useRegistry = bl;
            this.programFilesFolderTemplate = properties.getProperty("program.files.template", null);
            this.driveLetters = properties.getProperty("drive.letters", null);
            this.browsersToCheck = Collections.unmodifiableList(this.browsersToCheck);
        }
        catch (IOException iOException) {
            throw new BrowserLaunchingInitializingException(iOException);
        }
    }

    public void openUrl(String string) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        try {
            String[] stringArray;
            Object object;
            this.logger.info(string);
            String string2 = this.getProtocol(string);
            this.logger.info(string2);
            boolean bl = false;
            String string3 = System.getProperty("edu.stanford.ejalbert.preferred.browser", null);
            if (string3 != null && (object = (WindowsBrowser)(stringArray = this.getBrowserMap()).get(string3)) != null) {
                this.logger.debug("using browser from system property");
                bl = this.openUrlWithBrowser((WindowsBrowser)object, string2, string);
            }
            if (!bl) {
                stringArray = this.getCommandArgs(string2, string);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.getArrayAsString(stringArray));
                }
                object = Runtime.getRuntime().exec(stringArray);
                ((Process)object).waitFor();
                ((Process)object).exitValue();
            }
        }
        catch (Exception exception) {
            this.logger.error("fatal exception", exception);
            throw new BrowserLaunchingExecutionException(exception);
        }
    }

    public void openUrl(String string, String string2) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        if ("Default".equals(string) || string == null) {
            this.logger.info("default or null browser target; falling through to non-targetted openUrl");
            this.openUrl(string2);
        } else {
            Map map = this.getBrowserMap();
            WindowsBrowser windowsBrowser = (WindowsBrowser)map.get(string);
            if (windowsBrowser == null) {
                this.logger.info("the available browsers list does not contain: " + string);
                this.logger.info("falling through to non-targetted openUrl");
                this.openUrl(string2);
            } else {
                String string3 = null;
                try {
                    string3 = this.getProtocol(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new BrowserLaunchingExecutionException(malformedURLException);
                }
                boolean bl = this.openUrlWithBrowser(windowsBrowser, string3, string2);
                if (!bl) {
                    this.logger.debug("falling through to non-targetted openUrl");
                    this.openUrl(string2);
                }
            }
        }
    }

    public void openUrl(List list, String string) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        if (list == null || list.isEmpty()) {
            this.logger.debug("falling through to non-targetted openUrl");
            this.openUrl(string);
        } else {
            String string2 = null;
            try {
                string2 = this.getProtocol(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new BrowserLaunchingExecutionException(malformedURLException);
            }
            Map map = this.getBrowserMap();
            boolean bl = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && !bl) {
                WindowsBrowser windowsBrowser = (WindowsBrowser)map.get(iterator.next());
                if (windowsBrowser == null) continue;
                bl = this.openUrlWithBrowser(windowsBrowser, string2, string);
            }
            if (!bl) {
                this.logger.debug("none of listed browsers succeeded; falling through to non-targetted openUrl");
                this.openUrl(string);
            }
        }
    }

    public List getBrowserList() {
        Map map = this.getBrowserMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Default");
        for (String string : map.keySet()) {
            WindowsBrowser windowsBrowser;
            if (!string.equals((windowsBrowser = (WindowsBrowser)map.get(string)).getBrowserDisplayName())) continue;
            arrayList.add(windowsBrowser.getBrowserDisplayName());
        }
        return arrayList;
    }

    public boolean getNewWindowPolicy() {
        return this.forceNewWindow;
    }

    public void setNewWindowPolicy(boolean bl) {
        this.forceNewWindow = bl;
    }

    static {
        Arrays.sort(WIN_KEYS);
        regeditQueries = new String[]{"\"HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows\\CurrentVersion\\App Paths\""};
    }

    private static final class DirFileFilter
    implements FileFilter {
        private DirFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }
    }

    private static final class ExeFileNameFilter
    implements FilenameFilter {
        private ExeFileNameFilter() {
        }

        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(".exe");
        }
    }
}

