/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.misc;

import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.IBrowserLaunching;
import edu.stanford.ejalbert.launching.misc.StandardUnixBrowser;
import edu.stanford.ejalbert.launching.misc.UnixBrowser;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import net.sf.wraplog.AbstractLogger;

public class UnixNetscapeBrowserLaunching
implements IBrowserLaunching {
    public static final String CONFIGFILE_LINUX_UNIX = "/edu/stanford/ejalbert/launching/misc/linuxUnixConfig.properties";
    private Map unixBrowsers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    protected final AbstractLogger logger;
    private final String configFileName;
    private boolean forceNewWindow = false;

    public UnixNetscapeBrowserLaunching(AbstractLogger abstractLogger, String string) {
        if (string == null) {
            throw new IllegalArgumentException("config file cannot be null");
        }
        this.logger = abstractLogger;
        this.configFileName = string;
    }

    protected StandardUnixBrowser getBrowser(String string) {
        return (StandardUnixBrowser)this.unixBrowsers.get(string);
    }

    protected boolean openUrlWithBrowser(UnixBrowser unixBrowser, String string) throws BrowserLaunchingExecutionException {
        boolean bl = false;
        this.logger.info(unixBrowser.getBrowserDisplayName());
        this.logger.info(string);
        try {
            String[] stringArray;
            int n = -1;
            Process process = null;
            if (!this.forceNewWindow) {
                stringArray = unixBrowser.getArgsForOpenBrowser(string);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(Arrays.asList(stringArray).toString());
                }
                process = Runtime.getRuntime().exec(stringArray);
                n = process.waitFor();
            }
            if (this.forceNewWindow && n != 0) {
                stringArray = unixBrowser.getArgsForForcingNewBrowserWindow(string);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(Arrays.asList(stringArray).toString());
                }
                process = Runtime.getRuntime().exec(stringArray);
                n = process.waitFor();
            }
            if (n != 0) {
                stringArray = unixBrowser.getArgsForStartingBrowser(string);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(Arrays.asList(stringArray).toString());
                }
                process = Runtime.getRuntime().exec(stringArray);
                n = process.waitFor();
            }
            if (n == 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            throw new BrowserLaunchingExecutionException(exception);
        }
        return bl;
    }

    public void initialize() throws BrowserLaunchingInitializingException {
        try {
            URL uRL = this.getClass().getResource(this.configFileName);
            if (uRL == null) {
                throw new BrowserLaunchingInitializingException("unable to find config file: " + this.configFileName);
            }
            StringBuffer stringBuffer = new StringBuffer();
            Properties properties = new Properties();
            properties.load(uRL.openStream());
            String string = properties.getProperty("delimchar");
            for (String string2 : properties.keySet()) {
                if (!string2.startsWith("browser.")) continue;
                StandardUnixBrowser standardUnixBrowser = new StandardUnixBrowser(string, properties.getProperty(string2));
                if (standardUnixBrowser.isBrowserAvailable(this.logger)) {
                    this.unixBrowsers.put(standardUnixBrowser.getBrowserDisplayName(), standardUnixBrowser);
                    continue;
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("; ");
                }
                stringBuffer.append(standardUnixBrowser.getBrowserDisplayName());
            }
            if (this.unixBrowsers.size() == 0) {
                throw new BrowserLaunchingInitializingException("one of the supported browsers must be installed: " + stringBuffer);
            }
            this.logger.info(this.unixBrowsers.keySet().toString());
            this.unixBrowsers = Collections.unmodifiableMap(this.unixBrowsers);
        }
        catch (IOException iOException) {
            throw new BrowserLaunchingInitializingException(iOException);
        }
    }

    public void openUrl(String string) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        try {
            Object object;
            this.logger.info(string);
            boolean bl = false;
            ArrayList arrayList = new ArrayList(this.unixBrowsers.values());
            String string2 = System.getProperty("edu.stanford.ejalbert.preferred.browser", null);
            if (string2 != null && (object = (UnixBrowser)this.unixBrowsers.get(string2)) != null) {
                arrayList.add(0, object);
            }
            object = arrayList.iterator();
            while (object.hasNext() && !bl) {
                UnixBrowser unixBrowser = (UnixBrowser)object.next();
                bl = this.openUrlWithBrowser(unixBrowser, string);
            }
        }
        catch (Exception exception) {
            throw new BrowserLaunchingExecutionException(exception);
        }
    }

    public void openUrl(String string, String string2) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        UnixBrowser unixBrowser = (UnixBrowser)this.unixBrowsers.get(string);
        if (unixBrowser == null || "Default".equals(string)) {
            this.logger.debug("falling through to non-targetted openUrl");
            this.openUrl(string2);
        } else {
            boolean bl = this.openUrlWithBrowser(unixBrowser, string2);
            if (!bl) {
                this.logger.debug("open browser failure, trying non-targetted openUrl");
                this.openUrl(string2);
            }
        }
    }

    public void openUrl(List list, String string) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        if (list == null || list.isEmpty()) {
            this.logger.debug("falling through to non-targetted openUrl");
            this.openUrl(string);
        } else {
            boolean bl = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && !bl) {
                UnixBrowser unixBrowser = (UnixBrowser)this.unixBrowsers.get(iterator.next());
                if (unixBrowser == null) continue;
                bl = this.openUrlWithBrowser(unixBrowser, string);
            }
            if (!bl) {
                this.logger.debug("none of listed browsers succeeded; falling through to non-targetted openUrl");
                this.openUrl(string);
            }
        }
    }

    public List getBrowserList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.unixBrowsers.containsKey("Default")) {
            arrayList.add("Default");
        }
        arrayList.addAll(this.unixBrowsers.keySet());
        return arrayList;
    }

    public boolean getNewWindowPolicy() {
        return this.forceNewWindow;
    }

    public void setNewWindowPolicy(boolean bl) {
        this.forceNewWindow = bl;
    }
}

