/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.misc;

import edu.stanford.ejalbert.launching.misc.UnixBrowser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.sf.wraplog.AbstractLogger;

class StandardUnixBrowser
implements UnixBrowser {
    private final String browserName;
    private final String browserArgName;
    private final String argsForOpenBrowser;
    private final String argsForStartBrowser;
    private final String argsForForcedBrowserWindow;

    StandardUnixBrowser(String string, String string2) {
        String[] stringArray = string2.split(string, -2);
        this.browserName = stringArray[0];
        this.browserArgName = stringArray[1];
        this.argsForStartBrowser = stringArray[2];
        this.argsForOpenBrowser = stringArray[3];
        this.argsForForcedBrowserWindow = stringArray.length == 5 ? stringArray[4] : stringArray[2];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("display name=");
        stringBuffer.append(this.browserName);
        stringBuffer.append(" executable name=");
        stringBuffer.append(this.browserArgName);
        stringBuffer.append(" argsForStartBrowser=");
        stringBuffer.append(this.argsForStartBrowser);
        stringBuffer.append(" argsForOpenBrowser=");
        stringBuffer.append(this.argsForOpenBrowser);
        return stringBuffer.toString();
    }

    private String[] getCommandLineArgs(String string, String string2) {
        string = string.replaceAll("<browser>", this.browserArgName);
        string = string.replaceAll("<url>", string2);
        return string.split("[ ]");
    }

    public String getBrowserDisplayName() {
        return this.browserName;
    }

    public String getBrowserApplicationName() {
        return this.browserArgName;
    }

    public String[] getArgsForOpenBrowser(String string) {
        String string2 = this.argsForOpenBrowser != null && this.argsForOpenBrowser.length() > 0 ? this.argsForOpenBrowser : this.argsForStartBrowser;
        return this.getCommandLineArgs(string2, string);
    }

    public String[] getArgsForStartingBrowser(String string) {
        return this.getCommandLineArgs(this.argsForStartBrowser, string);
    }

    public String[] getArgsForForcingNewBrowserWindow(String string) {
        return this.getCommandLineArgs(this.argsForForcedBrowserWindow, string);
    }

    public boolean isBrowserAvailable(AbstractLogger abstractLogger) {
        boolean bl = false;
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"which", this.browserArgName});
            InputStream inputStream = process.getErrorStream();
            InputStream inputStream2 = process.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream2));
            String string = bufferedReader2.readLine();
            String string2 = bufferedReader.readLine();
            bufferedReader2.close();
            bufferedReader.close();
            if (string != null) {
                abstractLogger.debug(string);
            }
            if (string2 != null) {
                abstractLogger.debug(string2);
            }
            bl = string != null && string.startsWith("/");
        }
        catch (IOException iOException) {
            abstractLogger.error("io error executing which command", iOException);
        }
        return bl;
    }
}

