/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.macos;

import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.IBrowserLaunching;
import edu.stanford.ejalbert.launching.macos.MacOsBrowserLaunching;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MacOs2_1BrowserLaunching
extends MacOsBrowserLaunching
implements IBrowserLaunching {
    private static final String FINDER_TYPE = "FNDR";
    private Object kSystemFolderType;
    private Method findFolder;
    private Method getFileCreator;
    private Method getFileType;
    private String browser;

    public void initialize() throws BrowserLaunchingInitializingException {
        try {
            Class<?> clazz = Class.forName("com.apple.mrj.MRJFileUtils");
            Class<?> clazz2 = Class.forName("com.apple.mrj.MRJOSType");
            Field field = clazz.getDeclaredField("kSystemFolderType");
            this.kSystemFolderType = field.get(null);
            this.findFolder = clazz.getDeclaredMethod("findFolder", clazz2);
            this.getFileCreator = clazz.getDeclaredMethod("getFileCreator", File.class);
            this.getFileType = clazz.getDeclaredMethod("getFileType", File.class);
        }
        catch (Exception exception) {
            throw new BrowserLaunchingInitializingException(exception);
        }
    }

    private String getBrowser() throws BrowserLaunchingInitializingException {
        File file;
        if (this.browser != null) {
            return this.browser;
        }
        try {
            file = (File)this.findFolder.invoke(null, this.kSystemFolderType);
        }
        catch (Exception exception) {
            throw new BrowserLaunchingInitializingException(exception);
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object object;
                Object object2;
                File file2 = new File(file, stringArray[i]);
                if (!file2.isFile() || !FINDER_TYPE.equals((object2 = this.getFileType.invoke(null, file2)).toString()) || !"MACS".equals((object = this.getFileCreator.invoke(null, file2)).toString())) continue;
                this.browser = file2.toString();
                return this.browser;
            }
            catch (Exception exception) {
                throw new BrowserLaunchingInitializingException(exception);
            }
        }
        throw new BrowserLaunchingInitializingException("Unable to find finder");
    }

    public void openUrl(String string) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        String string2 = this.getBrowser();
        try {
            Runtime.getRuntime().exec(new String[]{string2, string});
        }
        catch (IOException iOException) {
            throw new BrowserLaunchingExecutionException(iOException);
        }
    }

    public List getBrowserList() {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("Default");
        return arrayList;
    }
}

