/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching;

import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.IBrowserLaunching;
import edu.stanford.ejalbert.launching.macos.MacOs2_0BrowserLaunching;
import edu.stanford.ejalbert.launching.macos.MacOs2_1BrowserLaunching;
import edu.stanford.ejalbert.launching.macos.MacOs3_0BrowserLaunching;
import edu.stanford.ejalbert.launching.macos.MacOs3_1BrowserLaunching;
import edu.stanford.ejalbert.launching.misc.SunOSBrowserLaunching;
import edu.stanford.ejalbert.launching.misc.UnixNetscapeBrowserLaunching;
import edu.stanford.ejalbert.launching.windows.WindowsBrowserLaunching;
import net.sf.wraplog.AbstractLogger;

public class BrowserLaunchingFactory {
    public static IBrowserLaunching createSystemBrowserLaunching(AbstractLogger abstractLogger) throws UnsupportedOperatingSystemException {
        String string = System.getProperty("os.name");
        if (string.startsWith("Mac OS")) {
            abstractLogger.info("Mac OS");
            String string2 = System.getProperty("mrj.version");
            String string3 = string2.substring(0, 3);
            try {
                double d = Double.valueOf(string3);
                abstractLogger.info("version=" + Double.toString(d));
                if (d == 2.0) {
                    return new MacOs2_0BrowserLaunching();
                }
                if (d >= 2.1 && d < 3.0) {
                    return new MacOs2_1BrowserLaunching();
                }
                if (d == 3.0) {
                    return new MacOs3_0BrowserLaunching();
                }
                if (d >= 3.1) {
                    return new MacOs3_1BrowserLaunching();
                }
                throw new UnsupportedOperatingSystemException("Unsupported MRJ version: " + d);
            }
            catch (NumberFormatException numberFormatException) {
                throw new UnsupportedOperatingSystemException("Invalid MRJ version: " + string2);
            }
        }
        if (string.startsWith("Windows")) {
            abstractLogger.info("Windows OS");
            if (string.indexOf("9") != -1) {
                return new WindowsBrowserLaunching(abstractLogger, "windows.win9x");
            }
            if (string.indexOf("Vista") != -1) {
                return new WindowsBrowserLaunching(abstractLogger, "windows.winVista");
            }
            if (string.indexOf("2000") != -1 || string.indexOf("XP") != -1) {
                return new WindowsBrowserLaunching(abstractLogger, "windows.win2000");
            }
            return new WindowsBrowserLaunching(abstractLogger, "windows.winNT");
        }
        if (string.startsWith("SunOS")) {
            abstractLogger.info("SunOS");
            return new SunOSBrowserLaunching(abstractLogger);
        }
        abstractLogger.info("Unix-type OS");
        return new UnixNetscapeBrowserLaunching(abstractLogger, "/edu/stanford/ejalbert/launching/misc/linuxUnixConfig.properties");
    }
}

