/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.jconfig.server.ProtocolHandler;
import org.jconfig.server.ServerContext;
import org.jconfig.server.ThreadPool;
import org.jconfig.server.WorkerThread;

public class BaseServer
extends Thread {
    private boolean active = false;
    private ServerSocket socket;
    private ThreadPool pool;
    private Class clazz;
    private ServerContext serverContext;

    public BaseServer(int port, Class handler, ServerContext serverContext) {
        this.serverContext = serverContext;
        try {
            this.socket = new ServerSocket(port);
            this.pool = new ThreadPool();
            this.active = true;
            this.clazz = handler;
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    public void run() {
        while (this.active) {
            try {
                Socket clientSocket = this.socket.accept();
                clientSocket.setTcpNoDelay(true);
                this.handleConnection(clientSocket);
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
        }
    }

    private void handleConnection(Socket clientSocket) throws IOException {
        WorkerThread wt = this.pool.getWorker();
        try {
            ProtocolHandler handler = (ProtocolHandler)this.clazz.newInstance();
            wt.execute(clientSocket, handler, this.serverContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pool.releaseWorkerThread(wt);
    }

    public void shutdown() {
        this.active = false;
    }

    public void setAsDaemon(boolean isDaemon) {
        super.setDaemon(isDaemon);
    }
}

