/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.parser;

import org.jconfig.Configuration;
import org.jconfig.NestedCategory;
import org.jconfig.NestedConfiguration;
import org.jconfig.parser.AbstractConfigParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NestedConfigParser
extends AbstractConfigParser {
    private boolean doTrimValue = false;

    public NestedConfigParser() {
        String trimStr = System.getProperty("jconfig.trimValue");
        if (trimStr != null && trimStr.length() > 0 && (trimStr.equalsIgnoreCase("yes") || trimStr.equalsIgnoreCase("true"))) {
            this.doTrimValue = true;
        }
    }

    public Configuration parse(Document doc, String configName) {
        NestedConfiguration configuration = new NestedConfiguration(configName);
        this.getBaseConfigName(doc, configuration);
        this.getVariables(doc, configuration);
        this.getIncludeProperties(doc, configuration);
        Element root = doc.getDocumentElement();
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals("category")) continue;
            NamedNodeMap curAtt = child.getAttributes();
            Node curNode = curAtt.getNamedItem("name");
            String currentCategory = curNode.getNodeValue();
            NestedCategory category = new NestedCategory(currentCategory);
            this.getCategory(child, category, configName);
            configuration.setCategory(category);
        }
        return configuration;
    }

    private void getCategory(Node n, NestedCategory cat, String configName) {
        for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            String name = child.getNodeName();
            if (name.equals("category")) {
                NamedNodeMap curAtt = child.getAttributes();
                Node nNode = curAtt.getNamedItem("name");
                String categoryName = nNode.getNodeValue();
                NestedCategory category = new NestedCategory(categoryName);
                category.setConfigurationName(configName);
                cat.addCategory(category);
                this.getCategory(child, category, configName);
                continue;
            }
            if (child.getFirstChild() == null) continue;
            String value = child.getFirstChild().getNodeValue();
            if (name == null || value == null) continue;
            cat.setProperty(name, this.doTrimValue ? value.trim() : value);
        }
    }
}

