/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.parser;

import org.jconfig.Configuration;
import org.jconfig.DefaultConfiguration;
import org.jconfig.error.ErrorReporter;
import org.jconfig.parser.AbstractConfigParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultConfigParser
extends AbstractConfigParser {
    public Configuration parse(Document doc, String configName) {
        DefaultConfiguration configuration = new DefaultConfiguration(configName);
        this.getBaseConfigName(doc, configuration);
        this.getVariables(doc, configuration);
        this.getIncludeProperties(doc, configuration);
        NodeList nl = doc.getElementsByTagName("category");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            NamedNodeMap curAtt = n.getAttributes();
            Node curNode = curAtt.getNamedItem("name");
            String currentCategory = curNode.getNodeValue();
            configuration.setCategory(currentCategory);
            for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!child.getNodeName().equals("property")) continue;
                NamedNodeMap myAtt = child.getAttributes();
                Node myNode = myAtt.getNamedItem("name");
                if (myNode != null) {
                    String name = myNode.getNodeValue();
                    myNode = myAtt.getNamedItem("value");
                    if (myNode != null) {
                        String value = myNode.getNodeValue();
                        if (name == null || value == null) continue;
                        configuration.setProperty(name, value, currentCategory);
                        continue;
                    }
                    ErrorReporter.getErrorHandler().reportError("No attribute 'value' found for property - ignoring entry");
                    continue;
                }
                ErrorReporter.getErrorHandler().reportError("No attribute 'name' found for property - ignoring entry");
            }
        }
        return configuration;
    }
}

