/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.parser;

import org.jconfig.Configuration;
import org.jconfig.DefaultConfiguration;
import org.jconfig.parser.ConfigurationParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdvancedConfigParser
implements ConfigurationParser {
    private static void getVariables(Document doc, Configuration config) {
        NodeList nl = doc.getElementsByTagName("variables");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!child.getNodeName().equals("variable")) continue;
                NamedNodeMap myAtt = child.getAttributes();
                Node myNode = myAtt.getNamedItem("name");
                String name = myNode.getNodeValue();
                myNode = myAtt.getNamedItem("value");
                String value = myNode.getNodeValue();
                if (name == null || value == null) continue;
                config.setVariable(name, value);
            }
        }
    }

    public Configuration parse(Document doc, String configName) {
        DefaultConfiguration configuration = new DefaultConfiguration(configName);
        AdvancedConfigParser.getVariables(doc, configuration);
        NodeList nl = doc.getElementsByTagName("category");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            NamedNodeMap curAtt = n.getAttributes();
            Node curNode = curAtt.getNamedItem("name");
            String currentCategory = curNode.getNodeValue();
            configuration.setCategory(currentCategory);
            for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || child.getFirstChild() == null) continue;
                String name = child.getNodeName();
                String value = child.getFirstChild().getNodeValue();
                if (name == null || value == null) continue;
                configuration.setProperty(name, value, currentCategory);
            }
        }
        return configuration;
    }
}

