/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.handler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.DefaultCategory;
import org.jconfig.ExtensibleConfiguration;
import org.jconfig.error.ErrorReporter;
import org.jconfig.handler.ConfigurationHandler;
import org.jconfig.parser.ConfigurationParser;
import org.jconfig.utils.ResourceLocator;

public class ScriptHandler
implements ConfigurationHandler {
    public Configuration load(String configurationName) throws ConfigurationManagerException {
        String fileName = configurationName + "_config.script";
        try {
            String line;
            ResourceLocator locator = new ResourceLocator(fileName);
            InputStream is = locator.findResource(fileName);
            BufferedReader nis = new BufferedReader(new InputStreamReader(is));
            Vector<String> content = new Vector<String>();
            while ((line = nis.readLine()) != null) {
                content.add(line);
            }
            nis.close();
            int braces = 0;
            for (int i = 0; i < content.size(); ++i) {
                String tmp = (String)content.get(i);
                if (tmp.indexOf("{") != -1) {
                    ++braces;
                    continue;
                }
                if (tmp.indexOf("}") == -1) continue;
                --braces;
            }
            if (braces != 0) {
                ErrorReporter.getErrorHandler().reportError("Unmatched brackets in script file");
                throw new ConfigurationManagerException("Unmatched brackets in script file");
            }
            ExtensibleConfiguration cfg = new ExtensibleConfiguration(configurationName);
            boolean process = false;
            String currentCategoryName = null;
            for (int i = 0; i < content.size(); ++i) {
                String tmp = (String)content.get(i);
                tmp = tmp.trim();
                if (process) {
                    if (tmp.startsWith("}")) {
                        process = false;
                    } else {
                        String left = tmp.substring(0, tmp.indexOf("=") - 1);
                        left = left.trim();
                        String right = tmp.substring(tmp.indexOf("=") + 1);
                        right = right.trim();
                        cfg.setProperty(left, right, currentCategoryName);
                    }
                }
                if (!tmp.startsWith("category") || tmp.indexOf("{") == -1) continue;
                process = true;
                String name = tmp.substring(9);
                name = name.substring(0, name.indexOf("{"));
                name = name.trim();
                String extend = null;
                if (tmp.indexOf(" extends ") != -1) {
                    extend = name.substring(name.indexOf(" extends ") + 9);
                    extend = extend.trim();
                    name = name.substring(0, name.indexOf(" extends "));
                }
                DefaultCategory ec = new DefaultCategory(name);
                if (extend != null) {
                    ec.setExtendsCategory(extend);
                }
                cfg.setCategory(ec);
                currentCategoryName = name;
            }
            return cfg;
        }
        catch (IOException e) {
            ErrorReporter.getErrorHandler().reportError("Error while trying to read file", e);
            throw new ConfigurationManagerException("Error while trying to read file");
        }
    }

    public void store(Configuration configuration) throws ConfigurationManagerException {
        throw new RuntimeException("not yet implemented");
    }

    public Configuration load(String configurationName, ConfigurationParser parser) throws ConfigurationManagerException {
        throw new ConfigurationManagerException("Using a specific parser with this handler is not supported");
    }
}

