/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.handler;

import java.io.File;
import java.io.FileWriter;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.error.ErrorReporter;
import org.jconfig.handler.AbstractHandler;

public abstract class BaseXMLHandler
extends AbstractHandler {
    private String encoding;

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected void store(File file, Configuration config) throws ConfigurationManagerException {
        String fileName = file.getAbsolutePath();
        if (fileName.indexOf("%20") != -1) {
            fileName = fileName.replaceAll("%20", " ");
        }
        file = new File(fileName);
        try {
            FileWriter fw = new FileWriter(file);
            fw.write(config.getXMLAsString());
            fw.close();
        }
        catch (Exception e) {
            ErrorReporter.getErrorHandler().reportError("The file cannot be saved", e);
            throw new ConfigurationManagerException("The file cannot be saved:" + e.getMessage());
        }
    }

    public String getEncodingType(String str) {
        if (str != null) {
            String ENCODING = "encoding";
            int start = str.indexOf("encoding");
            String rest = str.substring(start + "encoding".length());
            if (rest.indexOf("'") != -1) {
                int beginQuote = rest.indexOf("'");
                if (beginQuote > -1) {
                    rest = rest.substring(beginQuote + 1);
                }
                int endQuote = rest.indexOf("'");
                if (beginQuote > -1) {
                    return rest.substring(0, endQuote);
                }
            } else {
                int beginQuote = rest.indexOf("\"");
                if (beginQuote > -1) {
                    rest = rest.substring(beginQuote + 1);
                }
                int endQuote = rest.indexOf("\"");
                if (beginQuote > -1) {
                    return rest.substring(0, endQuote);
                }
            }
            return str.substring(start + "encoding".length());
        }
        return null;
    }
}

