/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.handler;

import java.io.File;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.FileWatcher;
import org.jconfig.error.ErrorReporter;
import org.jconfig.event.FileListener;
import org.jconfig.event.FileListenerEvent;
import org.jconfig.handler.ConfigurationHandler;
import org.jconfig.utils.ConfigurationUtils;

public abstract class AbstractHandler
implements ConfigurationHandler,
FileListener {
    private FileWatcher watcher = null;

    public void fileChanged(FileListenerEvent event) {
        try {
            this.load(null);
        }
        catch (ConfigurationManagerException e) {
            ErrorReporter.getErrorHandler().reportError(e.getLocalizedMessage(), e);
        }
    }

    public void addFileListener(FileListener fileListener) {
        String val = ConfigurationUtils.getConfigProperty("jconfig.filewatcher", "true");
        if (val.equalsIgnoreCase("true")) {
            this.watcher = new FileWatcher(this.getFile());
            this.watcher.addFileListener(fileListener);
            this.watcher.start();
        }
    }

    public void fireFireChangedEvent(FileListenerEvent event) {
        if (this.watcher == null) {
            throw new IllegalStateException("FileWatcher has not been set");
        }
        FileListener[] listener = this.watcher.getFileListeners();
        int num = listener.length;
        for (int i = 0; i < num; ++i) {
            listener[i].fileChanged(event);
        }
    }

    public abstract File getFile();
}

