/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig;

import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.jconfig.Category;
import org.jconfig.VariableManager;
import org.jconfig.event.CategoryChangedEvent;
import org.jconfig.event.CategoryListener;
import org.jconfig.event.ConfigurationChangedEventImpl;
import org.jconfig.event.PropertyChangedEvent;
import org.jconfig.event.PropertyListener;

public class DefaultCategory
implements Category {
    private static final VariableManager vm = VariableManager.getInstance();
    private String extendsCategory;
    private String name = null;
    private Properties properties = new Properties();
    private EventListenerList listenerList = new EventListenerList();
    private String configurationName;
    static /* synthetic */ Class class$org$jconfig$event$CategoryListener;
    static /* synthetic */ Class class$org$jconfig$event$PropertyListener;

    public DefaultCategory(String categoryName) {
        this.name = categoryName;
    }

    public Category setProperty(String propertyName, String propertyValue) {
        String temp = this.getProperty(propertyName);
        if (propertyValue == null) {
            this.properties.remove(propertyName);
            this.firePropertyChangedEvent(new ConfigurationChangedEventImpl(2, this, propertyName, temp, propertyValue));
            return this;
        }
        this.properties.setProperty(propertyName, propertyValue);
        if (temp == null) {
            this.firePropertyChangedEvent(new ConfigurationChangedEventImpl(1, this, propertyName, temp, propertyValue));
        } else if (!temp.equals(propertyValue)) {
            this.firePropertyChangedEvent(new ConfigurationChangedEventImpl(3, this, propertyName, temp, propertyValue));
        }
        return this;
    }

    public String getProperty(String propertyName) {
        String value = this.properties.getProperty(propertyName);
        if (value != null) {
            return vm.replaceVariables(value, this.getConfigurationName());
        }
        return value;
    }

    public String getProperty(String propertyName, String defaultValue) {
        String temp = this.properties.getProperty(propertyName, vm.replaceVariables(defaultValue, this.getConfigurationName()));
        if (temp != null) {
            return vm.replaceVariables(temp, this.getConfigurationName());
        }
        return this.properties.getProperty(propertyName, vm.replaceVariables(defaultValue, this.getConfigurationName()));
    }

    public String getCategoryName() {
        return this.name;
    }

    public void addCategoryListener(CategoryListener listener) {
        this.listenerList.add(class$org$jconfig$event$CategoryListener == null ? (class$org$jconfig$event$CategoryListener = DefaultCategory.class$("org.jconfig.event.CategoryListener")) : class$org$jconfig$event$CategoryListener, listener);
    }

    public void removeCategoryListener(CategoryListener listener) {
        this.listenerList.remove(class$org$jconfig$event$CategoryListener == null ? (class$org$jconfig$event$CategoryListener = DefaultCategory.class$("org.jconfig.event.CategoryListener")) : class$org$jconfig$event$CategoryListener, listener);
    }

    public void fireCategoryChangedEvent(CategoryChangedEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$jconfig$event$CategoryListener == null ? DefaultCategory.class$("org.jconfig.event.CategoryListener") : class$org$jconfig$event$CategoryListener)) continue;
            ((CategoryListener)listeners[i + 1]).categoryChanged(event);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String[] getArray(String key) {
        return this.getArray(key, null, ",");
    }

    public String[] getArray(String key, String separator) {
        return this.getArray(key, null, separator);
    }

    public String[] getArray(String key, String[] defaultValue) {
        return this.getArray(key, defaultValue, ",");
    }

    public String[] getArray(String key, String[] defaultValue, String separator) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        Vector<String> all = new Vector<String>();
        StringTokenizer sto = new StringTokenizer(value, separator);
        while (sto.hasMoreElements()) {
            String val = (String)sto.nextElement();
            val = vm.replaceVariables(val, this.configurationName);
            all.add(val);
        }
        return all.toArray(new String[0]);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String value = this.properties.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Boolean.valueOf(vm.replaceVariables(value, this.getConfigurationName()));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void setBooleanProperty(String name, boolean value) {
        Boolean bool = new Boolean(value);
        this.setProperty(name, bool.toString());
    }

    public char getCharProperty(String name, char defaultValue) {
        String value = this.properties.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        String subValue = vm.replaceVariables(value, this.getConfigurationName());
        if (subValue.length() == 1) {
            return subValue.charAt(0);
        }
        return defaultValue;
    }

    public void setCharProperty(String key, char value) {
        Character temp = new Character(value);
        this.setProperty(key, temp.toString());
    }

    public double getDoubleProperty(String name, double defaultValue) {
        String value = this.properties.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(vm.replaceVariables(value, this.getConfigurationName()));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int getIntProperty(String name, int defaultValue) {
        String value = this.properties.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(vm.replaceVariables(value, this.getConfigurationName()));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public void setIntProperty(String key, int value) {
        Integer temp = new Integer(value);
        this.setProperty(key, temp.toString());
    }

    public long getLongProperty(String name, long defaultValue) {
        String value = (String)this.properties.get(name);
        value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(vm.replaceVariables(value, this.getConfigurationName()));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void setLongProperty(String key, long value) {
        Long temp = new Long(value);
        this.setProperty(key, temp.toString());
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public void setDoubleProperty(String key, double value) {
        Double temp = new Double(value);
        this.setProperty(key, temp.toString());
    }

    public void addPropertyListener(PropertyListener listener) {
        this.listenerList.add(class$org$jconfig$event$PropertyListener == null ? (class$org$jconfig$event$PropertyListener = DefaultCategory.class$("org.jconfig.event.PropertyListener")) : class$org$jconfig$event$PropertyListener, listener);
    }

    public void removePropertyListener(PropertyListener listener) {
        this.listenerList.remove(class$org$jconfig$event$PropertyListener == null ? (class$org$jconfig$event$PropertyListener = DefaultCategory.class$("org.jconfig.event.PropertyListener")) : class$org$jconfig$event$PropertyListener, listener);
    }

    public void firePropertyChangedEvent(PropertyChangedEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$jconfig$event$PropertyListener == null ? DefaultCategory.class$("org.jconfig.event.PropertyListener") : class$org$jconfig$event$PropertyListener)) continue;
            ((PropertyListener)listeners[i + 1]).propertyChanged(event);
        }
        this.fireCategoryChangedEvent((CategoryChangedEvent)event);
    }

    public void setExtendsCategory(String extendsCategory) {
        this.extendsCategory = extendsCategory;
    }

    public String getExtendsCategory() {
        return this.extendsCategory;
    }

    public void renameCategory(String newName) {
        this.name = newName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

