/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig;

import org.jconfig.Configuration;
import org.jconfig.ConfigurationManager;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.handler.InputStreamHandler;
import org.jconfig.handler.SimpleScriptHandler;
import org.jconfig.handler.URLHandler;
import org.jconfig.handler.XMLFileHandler;
import org.jconfig.parser.ConfigurationParser;

public class ConfigurationLoader {
    private static final ConfigurationManager cm = ConfigurationManager.getInstance();

    public static Configuration load() throws ConfigurationManagerException {
        InputStreamHandler ish = new InputStreamHandler("config.xml");
        Configuration config = ish.load("default");
        cm.setConfiguration(config, ish);
        return config;
    }

    public static Configuration load(String configName) throws ConfigurationManagerException {
        InputStreamHandler ish = new InputStreamHandler(configName + "_config.xml");
        Configuration config = ish.load(configName);
        cm.setConfiguration(config, ish);
        return config;
    }

    public static Configuration load(String configName, String parserName) throws ConfigurationManagerException {
        InputStreamHandler ish = new InputStreamHandler(configName + "_config.xml");
        ConfigurationParser parser = ConfigurationLoader.getParser(parserName);
        Configuration config = ish.load(configName, parser);
        cm.setConfiguration(config, ish);
        return config;
    }

    public static Configuration loadFile(String configName, String fileName) throws ConfigurationManagerException {
        XMLFileHandler xmlHandler = new XMLFileHandler(fileName);
        Configuration config = xmlHandler.load(configName);
        cm.setConfiguration(config, xmlHandler);
        return config;
    }

    public static Configuration loadFile(String configName, String fileName, String parserName) throws ConfigurationManagerException {
        XMLFileHandler xmlHandler = new XMLFileHandler(fileName);
        ConfigurationParser parser = ConfigurationLoader.getParser(parserName);
        Configuration config = xmlHandler.load(configName, parser);
        cm.setConfiguration(config, xmlHandler);
        return config;
    }

    public static Configuration loadFromUrl(String configName, String url) throws ConfigurationManagerException {
        URLHandler urlHandler = new URLHandler();
        urlHandler.setURL(url);
        Configuration config = urlHandler.load(configName);
        cm.setConfiguration(config, urlHandler);
        return config;
    }

    public static Configuration loadFromUrl(String configName, String url, String parserName) throws ConfigurationManagerException {
        URLHandler urlHandler = new URLHandler();
        urlHandler.setURL(url);
        ConfigurationParser parser = ConfigurationLoader.getParser(parserName);
        Configuration config = urlHandler.load(configName, parser);
        cm.setConfiguration(config, urlHandler);
        return config;
    }

    public static Configuration loadScript(String configName) throws ConfigurationManagerException {
        SimpleScriptHandler ssh = new SimpleScriptHandler();
        Configuration config = ssh.load(configName);
        cm.setConfiguration(config, ssh);
        return config;
    }

    public static Configuration loadScript(String configName, String fileName) throws ConfigurationManagerException {
        SimpleScriptHandler ssh = new SimpleScriptHandler();
        Configuration config = ssh.load(configName, fileName);
        cm.setConfiguration(config, ssh);
        return config;
    }

    private static ConfigurationParser getParser(String line) throws ConfigurationManagerException {
        if (line == null) {
            throw new ConfigurationManagerException("No parser defined");
        }
        String cls = line;
        if (line.indexOf(".") == -1) {
            cls = "org.jconfig.parser." + line;
        }
        try {
            ConfigurationParser parser = (ConfigurationParser)Class.forName(cls).newInstance();
            return parser;
        }
        catch (Exception e) {
            throw new ConfigurationManagerException("The parser: " + cls + " cannot be found");
        }
    }
}

