
   (*                                                                  *)
   (*                 Sound Blaster Scope Demo Program                 *)
   (*                                                                  *)
   (*    Programmed by Viriato (l41324@alfa.ist.utl.pt) in 1996 for    *)
   (*                                                                  *)
   (*                  Spellcaster's The Mag issue 12                  *)
   (*                                                                  *)
   (*                                                                  *)
   (* You have two versions of the main procedure DoIt and DoIt2. DoIt *)
   (* is a simple one, good for understanding the mechanism. It        *)
   (* flickers a lot, and it uses the worst algorithm to display the   *)
   (* scope. DoIt2 is a decent version, a one that doesn't flick and   *)
   (* uses a good algorithm to display the scope. He doesn't waste CPU *)
   (* cycles. Scopes can be made very efficient using this algorithm.  *)
   (*                                                                  *)

Program Scope;

Uses Crt,
     Mode13h,
     SBDSU;

Procedure Ini;
Begin
     { Test for an SB presence }
     If Not SBPresent Then
     Begin
          Writeln('Ok... where did you hide the sound card?');
          Halt(0);
     End;
     InitGraph;
     ClsArea(0,0,199,VGA);
     DirectVideo:=FALSE;
     GotoXY(1,22);
     WriteLn('SB scope - demo program for The Mag'#10#13'By Viriato, 1996');
End;

Procedure Fini;
Begin
     CloseGraph;
     WriteLn('SB scope, by Viriato to The Mag, 1996');
     Writeln;
     WriteLn('If you are curious, or wanto know where in the hell');
     WriteLn('is Portugal, write me... l41324@alfa.ist.utl.pt');
     WriteLn;
     WriteLn('See you in some future mag, maybe...');
End;

Procedure DoIt;
{ This is a simple version for you to 'study'. It flicks... try DoIt2 }
{ for a flicker free scope.                                           }
Const PixelNumber=296;                     { a 296 pixels large scope }
Var X_Cord,Y_Cord:Integer;
    Sample,Color:Byte;
Begin
     Color:=14;
     Repeat
           If KeyPressed Then
             Case UpCase(Readkey) Of
                     #0:Readkey;                  { (It was a 2 code key) }
                    #27:Break;     { break make execution leave the repeat}
                    '+':Inc(Color);        { Just do add some features... }
                    '-':Dec(Color);
             End;
           { Clean the old scope }
           ClsArea(1,0,154,VGA);
           { Draw the scope }
           For X_Cord:=1 To PixelNumber Do
           Begin
                { Take a sample }
                DSPWrite($20);            { Direct 8 bit ADC command }
                Sample:=DSPRead Div 2;    { Read a sample. Here, I    }
                                          { divide it by 2 because the screen is only }
                                          { 200 pixels high and the sample goes from  }
                                          { 0 to 255, that means we would need at     }
                                          { least a 256 pixels high video mode.       }
                { Calculate the y coordinate of pixel and plot it. 140 is }
                { a 'screen high locate constant'.                        }
                Y_Cord:=140-Sample;
                PutPixel(X_Cord+10,Y_Cord,Color,VGA)
           End;

           { This delay will make it flick a bit less }
           Delay(10);

     Until FALSE;
End;

Procedure DoIt2;
{ Version that is flicker free. It is also faster, because there is no  }
{ need to clear the entire screen, just the pixels that make the scope. }
Const PixelNumber=296;                     { a 296 pixels large scope }
Var X_Cord,Y_Cord:Integer;
    Sample,Color:Byte;
    { To store the old pixel's y cord, for future erase }
    Y_Array:Array[1..PixelNumber] Of Byte;
Begin
     Color:=14;
     { Clear the array }
     Fillchar(Y_Array,SizeOf(Y_array),0);
     ClsArea(1,0,154,VGA);               { A blue background for the scope }
     Repeat
           If Keypressed Then
             Case Upcase(Readkey) Of
                     #0:Readkey;                   { (It was a 2 code key) }
                    #27:Break;      { break make execution leave the repeat}
                    '+':Inc(Color);         { Just do add some features... }
                    '-':Dec(Color);
             End;
           { Draw the scope }
           For X_Cord:=1 To PixelNumber Do
           Begin
                { Take a sample }
                DSPWrite($20);             { Direct 8 bit ADC command }
                Sample:=DSPRead Div 2;     { Read a sample. Here, I   }
                          { divide it by 2 because the screen is only }
                          { 200 pixels high and the sample goes from  }
                          { 0 to 255, that means we would need at     }
                          { least a 256 pixels high video mode.       }
                Y_Cord:=140-Sample;
                { Erase old pixel }
                PutPixel(X_Cord+10,Y_Array[X_Cord],1,VGA);
                { Put new pixel and store it in y_array }
                PutPixel(X_Cord+10,Y_Cord,Color,VGA);
                Y_Array[X_Cord]:=Y_Cord;
           End;
     Until FALSE;
End;

Begin
     Ini;    { Initialization: video mode, etc }
     DoIt;   { To do the real thing. Try DoIt2, for a flicker free scope }
     Fini    { Back to TM (text mode...got you...) and say bye bye }
End.