Unit Fixed32;

Interface

Const Frac=16;                  { For 16.16 fixed point... You can change
                                  this and obtain 10.22 fixed point, or
                                  anything that sums up 32 }
      Integ=32-Frac;            { This includes the sign bit }
      Power=65536;              { 2^Frac... }

Type Fixed=LongInt;

{ Conversion procedures }
Function RealToFixed(R:Real):Fixed;
Function FixedToReal(F:Fixed):Real;
Function IntToFixed(I:ShortInt):Fixed;
Function FixedToInt(F:Fixed):ShortInt;
{ Calculations }
Function AddFixed(A,B:Fixed):Fixed;
Function AddInt(A:Fixed;B:ShortInt):Fixed;
Function AddReal(A:Fixed;B:Real):Fixed;
Function SubFixed(A,B:Fixed):Fixed;
Function SubInt(A:Fixed;B:ShortInt):Fixed;
Function SubReal(A:Fixed;B:Real):Fixed;
Function MultFixed(A,B:Fixed):Fixed;
Function MultInt(A:Fixed;B:ShortInt):Fixed;
Function MultReal(A:Fixed;B:Real):Fixed;
Function DivFixed(A,B:Fixed):Fixed;
Function DivInt(A:Fixed;B:ShortInt):Fixed;
Function DivReal(A:Fixed;B:Real):Fixed;

Implementation

Function RealToFixed(R:Real):Fixed;
{ Converts a real number to fixed point }
Begin
     RealToFixed:=Round(R*Power);
End;

Function FixedToReal(F:Fixed):Real;
{ Converts a fixed point number to real }
Begin
     FixedToReal:=F/Power;
End;

Function IntToFixed(I:ShortInt):Fixed;
{ Converts an integer to fixed point }
Begin
     IntToFixed:=I*Power;
End;

Function FixedToInt(F:Fixed):ShortInt;
{ Converts a fixed point number to integer }
Begin
     FixedToInt:=F Div Power;
End;

Function AddFixed(A,B:Fixed):Fixed;
{ Adds two fixed point numbers... Isn't really needed, but I though I should
  include it anyway }
Begin
     AddFixed:=A+B;
End;

Function AddInt(A:Fixed;B:ShortInt):Fixed;
{ Adds an integer number to a fixed point number (returns fixed point) }
Begin
     AddInt:=A+IntToFixed(B);
End;

Function AddReal(A:Fixed;B:Real):Fixed;
{ Adds a real number to a fixed point (returns fixed point) }
Begin
     AddReal:=A+RealToFixed(B);
End;

Function SubFixed(A,B:Fixed):Fixed;
{ Subtracts two fixed point numbers... Another that wasn't needed... }
Begin
     SubFixed:=A-B;
End;

Function SubInt(A:Fixed;B:ShortInt):Fixed;
{ Subtracts an integer number from a fixed point number }
Begin
     SubInt:=A-IntToFixed(B);
End;

Function SubReal(A:Fixed;B:Real):Fixed;
{ Subtracts a real number from a fixed point number }
Begin
     SubReal:=A-RealToFixed(B);
End;

Function MultFixed(A,B:Fixed):Fixed; Assembler;
{ Multiplies two fixed point numbers... Now this is the tricky part... Using
  the tricks described in one of the articles of issue 12, we'll use 32 bit
  intructions in old 16 bit Pascal... I've not included the rounding
  intruction because I was feeling pretty lazy... :) }
Asm
   { First, get the args from stack: A=EAX, B=EDX }
   Mov Bx,Sp
   Db 66h; Mov Ax,Word Ptr [Ss:Bx+10]         { Mov EAX,Dword Ptr [Ss:Bx+10] }
   Db 66h; Mov Dx,Word Ptr [Ss:Bx+6]          { Mov EDX,Dword Ptr [Ss:Bx+6] }
   { Multiply }
   Db 66h; IMul Dx                            { IMul EDX }
   Db 66h; Db 0Fh; Db 0ACh; Db 0D0h; Db Frac; { Shrd EAX,EDX,Frac }
   { Convert number in EAX to number in Dx:Ax }
   Db 66h; Mov Dx,Ax                          { Mov EDX,EAX }
   Db 66h; Shr Dx,16                          { Shrd EDX,8  }
End;

Function MultInt(A:Fixed;B:ShortInt):Fixed;
{ Multiplies a fixed point number by an integer }
Begin
     MultInt:=A*B;
End;

Function MultReal(A:Fixed;B:Real):Fixed;
{ Multiplies a fixed point number by a real }
Begin
     MultReal:=Round(A*B);
End;

Function DivFixed(A,B:Fixed):Fixed; Assembler;
{ Multiplies two fixed point numbers... Again, this is the tricky part... }
Asm
   { First, get the args from stack: A=EDX, B=EBX }
   Mov Bx,Sp
   Db 66h; Mov Dx,Word Ptr [Ss:Bx+10]         { Mov EDX,Dword Ptr [Ss:Bx+10] }
   Db 66h; Mov Bx,Word Ptr [Ss:Bx+6]          { Mov EBX,Dword Ptr [Ss:Bx+6] }
   { Divide }
   Db 66h; Xor Ax,Ax                          { Xor EAX,EAX }
   Db 66h; Db 0Fh; Db 0ACh; Db 0D0h; Db Frac  { Shrd EAX,EDX,Frac }
   Db 66h; Db 0C1h; Db 0FAh; Db Frac          { Sar Edx,Frac }
   Db 66h; IDiv Bx                            { IDiv EBX }
   { Convert number in EAX to number in Dx:Ax }
   Db 66h; Mov Dx,Ax                          { Mov EDX,EAX }
   Db 66h; Shr Dx,16                          { Shrd EDX,8  }
End;

Function DivInt(A:Fixed;B:ShortInt):Fixed;
{ Divides a fixed point number by an integer }
Begin
     DivInt:=A Div B;
End;

Function DivReal(A:Fixed;B:Real):Fixed;
{ Divides a fixed point number by real }
Begin
     DivReal:=Round(A/B);
End;

Begin
End.