Unit Fixed16;

Interface

Const Frac=8;                   { For 8.8 fixed point... You can change
                                  this and obtain 10.6 fixed point, or
                                  anything that sums up 16 }
      Integ=16-Frac;            { This includes the sign bit }
      Power=256;                { 2^Frac... }

Type Fixed=Integer;

{ Conversion procedures }
Function RealToFixed(R:Real):Fixed;
Function FixedToReal(F:Fixed):Real;
Function IntToFixed(I:ShortInt):Fixed;
Function FixedToInt(F:Fixed):ShortInt;
{ Calculations }
Function AddFixed(A,B:Fixed):Fixed;
Function AddInt(A:Fixed;B:ShortInt):Fixed;
Function AddReal(A:Fixed;B:Real):Fixed;
Function SubFixed(A,B:Fixed):Fixed;
Function SubInt(A:Fixed;B:ShortInt):Fixed;
Function SubReal(A:Fixed;B:Real):Fixed;
Function MultFixed(A,B:Fixed):Fixed;
Function MultInt(A:Fixed;B:ShortInt):Fixed;
Function MultReal(A:Fixed;B:Real):Fixed;
Function DivFixed(A,B:Fixed):Fixed;
Function DivInt(A:Fixed;B:ShortInt):Fixed;
Function DivReal(A:Fixed;B:Real):Fixed;

Implementation

Function RealToFixed(R:Real):Fixed;
{ Converts a real number to fixed point }
Begin
     RealToFixed:=Round(R*Power);
End;

Function FixedToReal(F:Fixed):Real;
{ Converts a fixed point number to real }
Begin
     FixedToReal:=F/Power;
End;

Function IntToFixed(I:ShortInt):Fixed;
{ Converts an integer to fixed point }
Begin
     IntToFixed:=I*Power;
End;

Function FixedToInt(F:Fixed):ShortInt;
{ Converts a fixed point number to integer }
Begin
     FixedToInt:=F Div Power;
End;

Function AddFixed(A,B:Fixed):Fixed;
{ Adds two fixed point numbers... Isn't really needed, but I though I should
  include it anyway }
Begin
     AddFixed:=A+B;
End;

Function AddInt(A:Fixed;B:ShortInt):Fixed;
{ Adds an integer number to a fixed point number (returns fixed point) }
Begin
     AddInt:=A+IntToFixed(B);
End;

Function AddReal(A:Fixed;B:Real):Fixed;
{ Adds a real number to a fixed point (returns fixed point) }
Begin
     AddReal:=A+RealToFixed(B);
End;

Function SubFixed(A,B:Fixed):Fixed;
{ Subtracts two fixed point numbers... Another that wasn't needed... }
Begin
     SubFixed:=A-B;
End;

Function SubInt(A:Fixed;B:ShortInt):Fixed;
{ Subtracts an integer number from a fixed point number }
Begin
     SubInt:=A-IntToFixed(B);
End;

Function SubReal(A:Fixed;B:Real):Fixed;
{ Subtracts a real number from a fixed point number }
Begin
     SubReal:=A-RealToFixed(B);
End;

Function MultFixed(A,B:Fixed):Fixed;
{ Multiplies two fixed point numbers }
Begin
     MultFixed:=LongInt(A)*LongInt(B) Div Power;
     { We need to use the typecast, or else the result of the mult will
       be an integer value (in most cases it overflows and gives us the
       wrong answear... Usually 0) }
End;

Function MultInt(A:Fixed;B:ShortInt):Fixed;
{ Multiplies a fixed point number by an integer }
Begin
     MultInt:=A*B;
End;

Function MultReal(A:Fixed;B:Real):Fixed;
{ Multiplies a fixed point number by a real }
Begin
     MultReal:=Round(A*B);
End;

Function DivFixed(A,B:Fixed):Fixed;
{ Divides two fixed point numbers }
Begin
     DivFixed:=(A Div B)*Power;
End;

Function DivInt(A:Fixed;B:ShortInt):Fixed;
{ Divides a fixed point number by an integer }
Begin
     DivInt:=A Div B;
End;

Function DivReal(A:Fixed;B:Real):Fixed;
{ Divides a fixed point number by real }
Begin
     DivReal:=Round(A/B);
End;

Begin
End.