function SpagParser() {
	this.source = new Array();
	this.next_line = 0;
}

SpagParser.prototype.end_of_source = function() {
	return this.next_line >= this.source.length;
}

SpagParser.prototype.parse_issue = function(text) {
	this.source = text.split(/\n/);
	this.next_line = 0;

	var output = "";
	while (!this.end_of_source()) {
		this.skip_white();
		output += this.parse_toplevel_block();
	}
	return output;
}

SpagParser.prototype.match = function(pattern) {
	return this.source[this.next_line].match(pattern);
}

SpagParser.prototype.lookahead = function(pattern) {
	if (this.next_line >= (this.source.length - 1))
		return false;
		
	return this.source[this.next_line + 1].match(pattern);
}

SpagParser.prototype.token = function() {
	return this.source[this.next_line];
}

SpagParser.prototype.skip_white = function() {
	while (!this.end_of_source() && this.match(/^\s*$/)) {
		this.next_line++;
	}
}

SpagParser.prototype.parse_toplevel_block = function() {
	if (this.end_of_source())
		return;
		
	var output = "";
	
	if (this.match(/^\s*([^-]+)\s*----+/)) {
		output = "<h2>"
			+ this.token().replace(/(----+)/, "")
			+ "</h2>\n";
		this.next_line++;
		return output;
	}
	
	if (this.match(/^\s*(=-)+=?\s*$/) || this.match(/^\s*-+\s*$/)) {
		this.next_line++;
		return "<hr/>\n";
	}
	
	if (this.lookahead(/^=+$/)) {
		output = "<h2>" + this.token() + "</h2>\n";
		this.next_line += 2;
		return output;
	}

	while (!this.end_of_source() && this.match(/\S/)) {
		if (this.match(/^\s*\d+\./) || this.match(/^\s*[A-Z]+:/))
			output += urls2links(this.token()) + "<br/>\n";
		else
			output += urls2links(this.token()) + "\n";
		this.next_line++;
	}
	return "<p>" + output + "</p>\n";
}

function urls2links(text) {
	var protocol = '((ftp://)|(http://))';
	var urlchars = '[a-zA-Z0-9\/\?~@#\$%&_=;:.-]+';
	var url_re = new RegExp(protocol + urlchars, "g");
	return text.replace(url_re, '<a href="$&">$&</a>');
}


function convert(text) {
	var parser = new SpagParser();
	var dest = window.open('', '_blank');
	dest.document.body.innerHTML = parser.parse_issue(text);
}
