#define PBASEVERSION "012"

/*
 *  l9data_p.h
 *
 *  - Level 9 patches database for l9cut.c
 *
 *  Author: Paul David Doherty <42@pdd.de>
 *
 *  001-008:             see l9data_d.h
 *  009:   5 Mar 2000    first outsourced version
 *                     3 new patches (Mok again...)
 *  010:   7 Mar 2000 17 new patches (PDD, thanx to Achim Haertel)
 *  011:  12 Apr 2000  2 new patches (PDD)
 *  012:  22 May 2001    e-mail address updated
 */

struct patchbase
  {
    type16 length;		/* datafile length, bytes */
    type8 origchk;		/* 8-bit checksum, last datafile byte */
    type16 origcrc;		/* 16-bit CRC, l9cut-internal */
    type8 patchchk;		/* 8-bit checksum, last datafile byte */
    type16 patchcrc;		/* 16-bit CRC, l9cut-internal */
    type16 patchloc1;		/* patch locations and values */
    type8 patch1;
    type16 patchloc2;
    type8 patch2;
    type16 patchloc3;
    type8 patch3;
    type16 patchloc4;
    type8 patch4;
  }
patch_table[] =
{
/*
 *  the *first* patch in the list is always the "optimal" patch
 *
 *  Protection types:
 *  ----------------
 *  V2 games: none
 *  V3 games:
 *  - Adrian Mole I/II: none
 *  - Archers: none
 *  - Worm in Paradise: none
 *  - Price of Magik: Lenslok (except BBC)
 *  - Jewels of Darkness (1): Lenslok (Atari, C-64, CPC, Speccy)
 *  - Jewels of Darkness (2): Manual (ST, Amiga, DOS)
 *  - Silicon Dreams: Manual
 *  V4 games:
 *  - Knight Orc: Manual (small versions: part 1 only)
 *  - Gnome Ranger: Manual
 *  - Time & Magik: Manual (C-64, Amiga, DOS, Speccy48)
 *  - Time & Magik (US): none (C-64/Datasoft, Amiga/Datasoft, DOS/Datasoft)
 *  - Lancelot: Manual (except Speccy48)
 *  - Lancelot (US): none (Amiga/Datasoft, DOS/Datasoft)
 *  - Ingrid's Back: Manual (except Speccy48)
 *  - Scapeghost: none
 *
 *  Patch types:
 *  -----------
 *  L-CT:   (Colin Turnbull) lenslok on Price of Magik/Speccy48,
 *          JoD/Speccy48 -> doesn't work with GS interpreter (timeout)
 *
 *  L-PDD1: lenslok on Adv.Quest/JD/Speccy48 etc.
 *          [new]
 *
 *  L-PDD2: lenslok, adapted from L-PDD1 for Jewels of Darkness
 *
 *  M-PL4:  (Anonymous) manual on Knight Orc pt. 1/C-64, Lancelot/C-64,
 *          Ingrid/C-64 (found as "Plus/4" versions on ftp.funet.fi,
 *          probably originally from ftp.inf.bme.hu)
 *
 *  M-CT:   (Colin Turnbull) manual on SD, Lords of Time/TM and
 *          Red Moon/TM (all Speccy48): changes "if password correct"
 *          to "if password incorrect" -> elegant?
 *
 *  M-Mok:  different patch types (from Sarinee Achavanuntakul's "Home
 *          of the Underdogs" site); originally patched on Amiga
 *          (basically 2/3 byte GOTO patches with additional bytes for
 *          checksum neutrality)
 *          -> mokmok@usa.net / mok@cdprojekt.com / mok@union.org.pl
 *
 *  M-PDD1: manual on Dungeon Adv/JoD/Amiga
 *          [based on M-CT] *superceded*
 *
 *  M-PDD2: manual on Knight Orc/Amiga, Price of Magik/TM/C-64 TO etc.
 *          [same as M-PL4]
 *
 *  M-PDD3: manual, adapted from M-PDD2 for Jewels of Darkness
 */


/* Price of Magik (Speccy128) */
  0x7410, 0x5e, 0x60be, 0x70, 0x6cef, 0x732c, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,	/* <L-PDD1> */

/* Price of Magik (C-64) */
    0x6fc6, 0x14, 0xf9b6, 0x26, 0x3326, 0x6ee2, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <L-PDD1> */

/* Price of Magik (Speccy48) */
    0x5aa4, 0xc1, 0xeda4, 0xd3, 0xed35, 0x59c0, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <L-PDD1> */
    0x5aa4, 0xc1, 0xeda4, 0xc1, 0x8a65, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <L-CT> */

/* Colossal Adventure /JoD (Amiga/PC) */
    0x76f4, 0x5e, 0x1fe5, 0xea, 0x1305, 0x7567, 0x20, 0x7568, 0x35, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD3> */
    0x76f4, 0x5e, 0x1fe5, 0xb5, 0x901f, 0x7567, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0x76f4, 0x5e, 0x1fe5, 0x5e, 0x6ea1, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-Mok> */

/* Colossal Adventure /JoD (ST) */
    0x76f4, 0x5a, 0xcf4b, 0xe6, 0x012a, 0x7567, 0x20, 0x7568, 0x35, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD3> */
    0x76f4, 0x5a, 0xcf4b, 0xb1, 0x40b1, 0x7567, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Adventure Quest /JoD (Amiga/PC) */
    0x6e60, 0x83, 0x18e0, 0x4c, 0xcfb0, 0x6d15, 0x20, 0x6d16, 0x33, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD3> */
    0x6e60, 0x83, 0x18e0, 0xfa, 0x9b3b, 0x6d15, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0x6e60, 0x83, 0x18e0, 0x83, 0x303d, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-Mok> */

/* Adventure Quest /JoD (ST) */
    0x6e5c, 0xf6, 0xd356, 0xbf, 0xede7, 0x6d11, 0x20, 0x6d12, 0x33, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD3> */
    0x6e5c, 0xf6, 0xd356, 0x6d, 0x662d, 0x6d11, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Dungeon Adventure /JoD (Amiga/PC/ST) */
    0x6f0c, 0x95, 0x1f64, 0x6d, 0x2443, 0x6db3, 0x20, 0x6db4, 0x33, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD3> */
    0x6f0c, 0x95, 0x1f64, 0x0c, 0x6066, 0x6db3, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0x6f0c, 0x95, 0x1f64, 0x96, 0xdaca, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD1> */
    0x6f0c, 0x95, 0x1f64, 0x95, 0x848d, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-Mok> */

/* Colossal Adventure /JoD (Speccy128) */
    0x6f6e, 0x78, 0x28cd, 0xf8, 0xda5f, 0x5d71, 0x48, 0x5d72, 0x01, 0x5d73, 0x5e, 0x6d49, 0x02,		/* <L-PDD2> */
    0x6f6e, 0x78, 0x28cd, 0x77, 0x5b4e, 0x6d49, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <L-PDD1> */

/* Adventure Quest /JoD (Speccy128) */
    0x6970, 0xd6, 0xa820, 0x3b, 0x1870, 0x5d9d, 0x48, 0x5d9e, 0x01, 0x5d9f, 0x79, 0x6763, 0x02,		/* <L-PDD2> */
    0x6970, 0xd6, 0xa820, 0xd5, 0x13c4, 0x6763, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <L-PDD1> */

/* Dungeon Adventure /JoD (Speccy128) */
    0x6de8, 0x4c, 0xd795, 0xa2, 0x3eea, 0x5d9f, 0x48, 0x5da0, 0x01, 0x5da1, 0x88, 0x6bdb, 0x02,		/* <L-PDD2> */
    0x6de8, 0x4c, 0xd795, 0x4b, 0xad30, 0x6bdb, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <L-PDD1> */

/* Colossal Adventure /JoD (CPC) */
    0x6f4d, 0xcb, 0xe8f2, 0x4b, 0xb384, 0x5d61, 0x48, 0x5d62, 0x01, 0x5d63, 0x5e, 0x6d2a, 0x02,		/* <L-PDD2> */
    0x6f4d, 0xcb, 0xe8f2, 0xca, 0x96e7, 0x6d2a, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <L-PDD1> */

/* Adventure Quest /JoD (CPC) */
    0x6968, 0x32, 0x0c01, 0x97, 0xdded, 0x5d97, 0x48, 0x5d98, 0x01, 0x5d99, 0x79, 0x675d, 0x02,		/* <L-PDD2> */
    0x6968, 0x32, 0x0c01, 0x31, 0xe8c2, 0x675d, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <L-PDD1> */

/* Dungeon Adventure /JoD (CPC) */
    0x6dc0, 0x63, 0x5d95, 0xb9, 0xc963, 0x5d79, 0x48, 0x5d7a, 0x01, 0x5d7b, 0x88, 0x6bb5, 0x02,		/* <L-PDD2> */
    0x6dc0, 0x63, 0x5d95, 0x62, 0x79f7, 0x6bb5, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <L-PDD1> */

/* Colossal Adventure /JoD (C-64) */
    0x6c8e, 0xb6, 0x9be3, 0x36, 0x6971, 0x5a91, 0x48, 0x5a92, 0x01, 0x5a93, 0x5e, 0x6a69, 0x02,		/* <L-PDD2> */
    0x6c8e, 0xb6, 0x9be3, 0xb5, 0xeba0, 0x6a69, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <L-PDD1> */

/* Adventure Quest /JoD (C-64) */
    0x63b6, 0x2e, 0xef38, 0x93, 0x4e68, 0x57e3, 0x48, 0x57e4, 0x01, 0x57e5, 0x79, 0x61a9, 0x02,		/* <L-PDD2> */
    0x63b6, 0x2e, 0xef38, 0x2d, 0x54dc, 0x61a9, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <L-PDD1> */

/* Dungeon Adventure /JoD (C-64) */
    0x6bd2, 0x65, 0xa41f, 0xbb, 0x4260, 0x5b89, 0x48, 0x5b8a, 0x01, 0x5b8b, 0x88, 0x69c5, 0x02,		/* <L-PDD2> */
    0x6bd2, 0x65, 0xa41f, 0x64, 0xdf5a, 0x69c5, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <L-PDD1> */

/* Colossal Adventure /JoD (Speccy48) */
    0x5a8e, 0xf2, 0x7cca, 0x72, 0x8e58, 0x4891, 0x48, 0x4892, 0x01, 0x4893, 0x5e, 0x5869, 0x02,		/* <L-PDD2> */
    0x5a8e, 0xf2, 0x7cca, 0xf1, 0x0c89, 0x5869, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <L-PDD1> */
    0x5a8e, 0xf2, 0x7cca, 0xf2, 0x2c96, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <L-CT> */

/* Adventure Quest /JoD (Speccy48) */
    0x5ace, 0x11, 0xdc12, 0x76, 0x8663, 0x4efb, 0x48, 0x4efc, 0x01, 0x4efd, 0x79, 0x58c1, 0x02,		/* <L-PDD2> */
    0x5ace, 0x11, 0xdc12, 0x10, 0xa757, 0x58c1, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <L-PDD1> */
    0x5ace, 0x11, 0xdc12, 0x11, 0xf118, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <L-CT> */

/* Dungeon Adventure /JoD (Speccy48) */
    0x58a3, 0x38, 0x8ce4, 0x8e, 0xb61a, 0x485a, 0x48, 0x485b, 0x01, 0x485c, 0x88, 0x5696, 0x02,		/* <L-PDD2> */
    0x58a3, 0x38, 0x8ce4, 0x37, 0x34c0, 0x5696, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <L-PDD1> */
    0x58a3, 0x38, 0x8ce4, 0x38, 0xa1ee, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <L-CT> */

/* Snowball /SD (Amiga/ST) */
    0x7b31, 0x6e, 0x2e2b, 0xe5, 0x6017, 0x79b9, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Return to Eden /SD (Amiga/ST) */
    0x7d16, 0xe6, 0x5438, 0x5d, 0xc770, 0x7b74, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Worm in Paradise /SD (Amiga/ST) */
    0x7cd9, 0x0c, 0x4df1, 0x83, 0xe997, 0x7b5d, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Snowball /SD (PC/Speccy128) */
    0x7b2f, 0x70, 0x6955, 0xe7, 0x0af4, 0x79b9, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0x7b2f, 0x70, 0x6955, 0x70, 0x1179, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-Mok> */

/* Return to Eden /SD (PC) */
    0x7d14, 0xe8, 0xfbab, 0x5f, 0xeab9, 0x7b74, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0x7d14, 0xe8, 0xfbab, 0xe8, 0xe216, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-Mok> */

/* Return to Eden /SD (CPC) */
    0x7cff, 0xf8, 0x6044, 0x6f, 0xbb57, 0x7b5f, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Return to Eden /SD (Speccy128) */
    0x7c55, 0x18, 0xdaee, 0x8f, 0x01fd, 0x7ab5, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Worm in Paradise /SD (CPC/PC/Speccy128) */
    0x7cd7, 0x0e, 0x4feb, 0x85, 0x4eae, 0x7b5d, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0x7cd7, 0x0e, 0x4feb, 0x0e, 0xb02c, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-Mok> */

/* Snowball /SD (C-64) */
    0x7363, 0x65, 0xa0ab, 0xdc, 0xca6a, 0x71ed, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Return to Eden /SD (C-64) */
    0x772f, 0xca, 0x8602, 0x41, 0x9bd0, 0x758f, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Worm in Paradise /SD (C-64) */
    0x788d, 0x72, 0x888a, 0xe9, 0x4cce, 0x7713, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Snowball /SD (Atari) */
    0x6bf8, 0x3f, 0xc9f7, 0x96, 0x1908, 0x6a5d, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Return to Eden /SD (Atari) */
    0x60f7, 0x68, 0xc2bc, 0xdf, 0xd3ae, 0x5f57, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Worm in Paradise /SD (Atari) */
    0x6161, 0xf3, 0xe6d7, 0x6a, 0xe232, 0x5fe7, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Snowball /SD (Speccy48) */
    0x6541, 0x02, 0x2e6c, 0x79, 0xb80c, 0x63cb, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0x6541, 0x02, 0x2e6c, 0x02, 0x028a, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-CT> */

/* Return to Eden /SD (Speccy48) */
    0x5f43, 0xca, 0x828c, 0x41, 0x9f5e, 0x5da3, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0x5f43, 0xca, 0x828c, 0xca, 0x6e1b, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-CT> */

/* Worm in Paradise /SD (Speccy48) */
    0x5ebb, 0xf1, 0x4dec, 0x68, 0x4909, 0x5d41, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0x5ebb, 0xf1, 0x4dec, 0xf1, 0xcc1a, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-CT> */

/* Knight Orc, pt. 1 (Amiga) */
    0xbb93, 0x36, 0x6a05, 0xad, 0xe52d, 0xba30, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Knight Orc, pt. 1 (ST) */
    0xbb6e, 0xad, 0x4d40, 0x24, 0x3bcd, 0xba13, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Knight Orc, pt. 2 (Amiga/ST) */
    0xc58e, 0x4a, 0x4e9d, 0xc1, 0xe2bf, 0x93e2, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Knight Orc, pt. 3 (Amiga/ST) */
    0xcb9a, 0x0f, 0x0804, 0x86, 0x6487, 0x99ee, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Knight Orc, pt. 1 (PC) */
    0xbb6e, 0xa6, 0x9753, 0x1d, 0x2e7f, 0xba13, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0xbb6e, 0xa6, 0x9753, 0xa6, 0x001d, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-Mok> */

/* Knight Orc, pt. 2 (PC) */
    0xc58e, 0x43, 0xe9ce, 0xba, 0x5e4c, 0x93e2, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0xc58e, 0x43, 0xe9ce, 0x43, 0xa8f0, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-Mok> */

/* Knight Orc, pt. 3 (PC) */
    0xcb9a, 0x08, 0x6c36, 0x7f, 0xf0d4, 0x99ee, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0xcb9a, 0x08, 0x6c36, 0x08, 0x2d08, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-Mok> */

/* Knight Orc, pt. 1 (C-64 Gfx) */
    0x8970, 0x6b, 0x3c7b, 0xe2, 0xb6f3, 0x880d, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PL4> */

/* Knight Orc, pt. 1 (Speccy48) */
    0x86d0, 0xb7, 0xadbd, 0x2e, 0x43e1, 0x8567, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Gnome Ranger, pt. 1 (Amiga/ST) */
    0xb1a9, 0x80, 0x5fb7, 0xf7, 0x5c6c, 0xb093, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Gnome Ranger, pt. 2 (Amiga/ST) */
    0xab9d, 0x31, 0xbe6d, 0xa8, 0xcb96, 0x95bf, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Gnome Ranger, pt. 3 (Amiga/ST) */
    0xae28, 0x87, 0xb6b6, 0xfe, 0x760c, 0xad12, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Gnome Ranger, pt. 1 (PC) */
    0xb1aa, 0xad, 0xaf47, 0x24, 0x5cfd, 0xb094, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0xb1aa, 0xad, 0xaf47, 0xad, 0xe0ed, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-Mok> */

/* Gnome Ranger, pt. 1 (ST-var) */
    0xb19e, 0x92, 0x8f96, 0x09, 0x798c, 0xb088, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Gnome Ranger, pt. 2 (PC/ST-var) */
    0xab8b, 0xbf, 0x31e6, 0x36, 0x811c, 0x95ad, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0xab8b, 0xbf, 0x31e6, 0xbf, 0x8ff3, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-Mok> */

/* Gnome Ranger, pt. 3 (PC/ST-var) */
    0xae16, 0x81, 0x8741, 0xf8, 0x47fb, 0xad00, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0xae16, 0x81, 0x8741, 0x81, 0xc8eb, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-Mok> */

/* Gnome Ranger, pt. 1 (C-64 TO) */
    0xad41, 0xa8, 0x42c5, 0x1f, 0x7d1e, 0xac2b, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Gnome Ranger, pt. 2 (C-64 TO) */
    0xa735, 0xf7, 0x2e08, 0x6e, 0x780e, 0x919b, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Gnome Ranger, pt. 3 (C-64 TO) */
    0xa9c0, 0x9e, 0x0d70, 0x15, 0x3e6b, 0xa8aa, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Gnome Ranger, pt. 1 (C-64 Gfx) */
    0x908e, 0x0d, 0x58a7, 0x84, 0xab1d, 0x8f78, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Gnome Ranger, pt. 2 (C-64 Gfx) */
    0x8f6f, 0x0a, 0x411a, 0x81, 0x12bc, 0x79d5, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Gnome Ranger, pt. 3 (C-64 Gfx) */
    0x9060, 0xbb, 0xe75d, 0x32, 0x14e7, 0x8f4a, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Lords of Time /T&M (PC) */
    0xb57c, 0x44, 0x7779, 0xbb, 0x31a6, 0xb453, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0xb57c, 0x44, 0x7779, 0x44, 0xea72, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-Mok> */

/* Red Moon /T&M (PC) */
    0xa69e, 0x6c, 0xb268, 0xe3, 0x4cef, 0xa578, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0xa69e, 0x6c, 0xb268, 0x6c, 0x3799, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-Mok> */

/* Price of Magik /T&M (PC) */
    0xbac7, 0x7f, 0xddb2, 0xf6, 0x6ab3, 0xb96d, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0xbac7, 0x7f, 0xddb2, 0x7f, 0x905c, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-Mok> */

/* Lords of Time /T&M (ST) */
    0xb579, 0x89, 0x3e89, 0x00, 0xa2b7, 0xb450, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Red Moon /T&M (ST) */
    0xa698, 0x41, 0xcaca, 0xb8, 0xeeac, 0xa572, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Price of Magik /T&M (ST) */
    0xbac4, 0x80, 0xa750, 0xf7, 0xe030, 0xb96a, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Lords of Time /T&M (Amiga) */
    0xb576, 0x2a, 0x7239, 0xa1, 0x2ea6, 0xb44d, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Red Moon /T&M (Amiga) */
    0xa692, 0xd1, 0x6a99, 0x48, 0x50ff, 0xa56c, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Price of Magik /T&M (Amiga) */
    0xbaca, 0x3a, 0x221b, 0xb1, 0x55bb, 0xb970, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Lords of Time /T&M (C-64 TO) */
    0xb38c, 0x37, 0x9f8e, 0xae, 0xc6b1, 0xb263, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Red Moon /T&M (C-64 TO) */
    0xa4e2, 0xa6, 0x016d, 0x1d, 0x31ab, 0xa3bc, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Price of Magik /T&M (C-64 TO) */
    0xb451, 0xa8, 0x2682, 0x1f, 0x5de2, 0xb2f7, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Lords of Time /T&M (C-64 Gfx) */
    0x9070, 0x43, 0x45d4, 0xba, 0x02eb, 0x8f47, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Red Moon /T&M (C-64 Gfx) */
    0x903f, 0x6b, 0x603e, 0xe2, 0x9f59, 0x8f19, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Price of Magik /T&M (C-64 Gfx) */
    0x8f51, 0xb2, 0x6c9a, 0x29, 0xde3b, 0x8df7, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Lords of Time /T&M (Speccy48) */
    0x8950, 0xa1, 0xbb16, 0x18, 0x2828, 0x8827, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0x8950, 0xa1, 0xbb16, 0xa1, 0x1ea2, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-CT> */

/* Red Moon /T&M (Speccy48) */
    0x8813, 0x11, 0x22de, 0x88, 0x18b8, 0x86ed, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0x8813, 0x11, 0x22de, 0x11, 0xd0cd, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-CT> */

/* Price of Magik /T&M (Speccy48) */
    0x8a60, 0x2a, 0x29ed, 0xa1, 0x5e4d, 0x8906, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Lancelot, pt. 1 (Amiga/PC/ST) */
    0xc0cf, 0x4e, 0xb7fa, 0xc5, 0x4400, 0xbf7f, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Lancelot, pt. 2 (Amiga/PC/ST) */
    0xd5e9, 0x6a, 0x4192, 0xe1, 0x3b1e, 0xd411, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Lancelot, pt. 3 (Amiga/PC/ST) */
    0xbb8f, 0x1a, 0x7487, 0x91, 0x877d, 0xba3f, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Lancelot, pt. 1 (C-64 TO) */
    0xb4c9, 0x94, 0xd784, 0x0b, 0x203e, 0xb379, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Lancelot, pt. 2 (C-64 TO) */
    0xb729, 0x51, 0x8ee5, 0xc8, 0xf1c9, 0xb551, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Lancelot, pt. 3 (C-64 TO) */
    0xb702, 0xe4, 0x1809, 0x5b, 0x25b2, 0xb5b2, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Lancelot, pt. 1 (C-64 Gfx) */
    0x8feb, 0xba, 0xa800, 0x31, 0x5bfa, 0x8e9b, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PL4> */

/* Lancelot, pt. 2 (C-64 Gfx) */
    0x8f6b, 0xfa, 0x0f7e, 0x71, 0x75f2, 0x8d93, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PL4> */

/* Lancelot, pt. 3 (C-64 Gfx) */
    0x8f71, 0x2f, 0x0ddc, 0xa6, 0x3e87, 0x8e21, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PL4> */

/* Ingrid's Back, pt. 1 (PC) */
    0xd19b, 0xad, 0x306d, 0x24, 0x4504, 0xcff0, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0xd19b, 0xad, 0x306d, 0xad, 0x878e, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-Mok> */

/* Ingrid's Back, pt. 2 (PC) */
    0xc5a5, 0xfe, 0x3c98, 0x75, 0x8950, 0xc3fa, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0xc5a5, 0xfe, 0x3c98, 0xfe, 0x8b7b, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-Mok> */

/* Ingrid's Back, pt. 3 (PC) */
    0xd7ae, 0x9e, 0x1878, 0x15, 0xadb0, 0xd603, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */
    0xd7ae, 0x9e, 0x1878, 0x9e, 0xaf9b, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-Mok> */

/* Ingrid's Back, pt. 1 (Amiga) */
    0xd188, 0x13, 0xdc60, 0x8a, 0x755c, 0xcfe2, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Ingrid's Back, pt. 2 (Amiga) */
    0xc594, 0x03, 0xea95, 0x7a, 0xb5a8, 0xc3ee, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Ingrid's Back, pt. 3 (Amiga) */
    0xd79f, 0xb5, 0x1661, 0x2c, 0xbf5d, 0xd5f9, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Ingrid's Back, pt. 1 (ST) */
    0xd183, 0x83, 0xef72, 0xfa, 0xb04f, 0xcfdd, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Ingrid's Back, pt. 2 (ST) */
    0xc58f, 0x65, 0xf337, 0xdc, 0x900a, 0xc3e9, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Ingrid's Back, pt. 3 (ST) */
    0xd79a, 0x57, 0x49c5, 0xce, 0xe0f9, 0xd5f4, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Ingrid's Back, pt. 1 (C-64 TO) */
    0xb770, 0x03, 0x9a03, 0x7a, 0xdc6a, 0xb5c5, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Ingrid's Back, pt. 2 (C-64 TO) */
    0xb741, 0xb6, 0x2aa5, 0x2d, 0x5a6c, 0xb596, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Ingrid's Back, pt. 3 (C-64 TO) */
    0xb791, 0xa1, 0xd065, 0x18, 0xaa0c, 0xb5e6, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PDD2> */

/* Ingrid's Back, pt. 1 (C-64 Gfx) */
    0x9089, 0xce, 0xc5e2, 0x44, 0xeff4, 0x8ed9, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PL4> */

/* Ingrid's Back, pt. 2 (C-64 Gfx) */
    0x908d, 0x80, 0x30c7, 0xf6, 0x2a11, 0x8edd, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PL4> */

/* Ingrid's Back, pt. 3 (C-64 Gfx) */
    0x909e, 0x9f, 0xdecc, 0x15, 0xf4da, 0x8eee, 0x02, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00,		/* <M-PL4> */

/* The End of the Patches */
    0x0000, 0x00, 0x0000, 0x00, 0x0000, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00, 0xffff, 0x00
};

type16
patch_usage (void)
{
  type16 patchcount = 0;

  patchcount = (sizeof (patch_table) / sizeof (struct patchbase)) - 1;
  return (patchcount);
}
