#include <stdio.h>
#include <string.h>

char MFM_ID[] = "MFM_DISK";
#define MAX_HEADER 976		// cancel header search if more than this

bool checkMFMformat(FILE *fpi) {
	char cBuff[0x100];
	fread(cBuff, 1, sizeof(cBuff), fpi);
	if(strncmp(cBuff, MFM_ID, 8))
		return false;
	printf("ID okay, %02X %02X\n", cBuff[8], cBuff[12]);
	return true;
}

int skipMFMheader(FILE *fpi) { // return N value
	int c, x, T, S, C, N;
	bool toggle = false;
	for(x = 0; x < MAX_HEADER; x++) {
		if((c = fgetc(fpi)) == EOF) {
			printf("EOF\n");
			return 0;
		}

		if(toggle) {		// looking for data mark
			if(c == 0xFB) {	// found data
				printf("Header %03u bytes ", x);
				return N;
			}
			if(c == 0xFE) {	// deleted data
				printf("\nFound deleted data mark at %u\n", ftell(fpi));
				continue;
			}
		} else if((c == 0xFE)) {// found header
			toggle = true;
			T = fgetc(fpi);
			S = fgetc(fpi);
			C = fgetc(fpi);
			N = fgetc(fpi);
			if(S==0x4E && C==0x4E && N==0x4E) {	// fake? try again
				printf("\nFound fake data mark at %X, ignoring\n", ftell(fpi) - 5);
				toggle = false;
			} else {
				printf("Track %u, Side %u, Sector %u, N=%u", T, S, C, N);
				S = fgetc(fpi);
				C = fgetc(fpi);
				printf(" Checksum %04X\n", (S << 8) | C);
			}
		}
	}
	printf("\nHeader not found within %u bytes\n", MAX_HEADER);
	return 0;
}

bool xfer(FILE *fpi, FILE *fpo, int len) { // copy N bytes fpi->fpo
	int c, x;
	for(x = 0; x < len; x++) {
		if((c = fgetc(fpi)) == EOF)
			return false;
		fputc(c, fpo);
	}
	return true;
}

int main(int argc, char *argv[]) {
	int N;

	if(argc < 3) {
		printf("UnMFM [MFM_DISK] [Output]\n"
			   "no options, use at your own risk blah blah\n");
		return 1;
	}

	FILE *fpi, *fpo;
	if(fpi = fopen(argv[1], "rb")) {
		printf("Opened %s for input\n", argv[1]);
		if(!checkMFMformat(fpi))
			printf("However, it doesn't have the \"MFM_DISK\" header\n");
		else {
			if(fpo = fopen(argv[2], "r")) {
				fclose(fpo);
				printf("%s already exists, try again Lord Dimwitt!\n", argv[2]);
			} else {
				if(fpo = fopen(argv[2], "wb")) {
					while(N = skipMFMheader(fpi))
						if(!xfer(fpi, fpo, 256*N))	// EOF
							break;
					// done
					fclose(fpo);
				} else
					printf("%s failed to open for output\n", argv[2]);
			}
		}

		fclose(fpi);
	}
	return 0;
}
