/*
 * Decompiled with CFR 0.152.
 */
package zpplet.machine;

import zpplet.ZUserConfig;
import zpplet.data.ZDictionary;
import zpplet.data.ZObjectTree;
import zpplet.header.ZHeader;
import zpplet.machine.ZMachine;
import zpplet.misc.ZError;
import zpplet.ops.ZInstruction;
import zpplet.system.ZScreen;
import zpplet.system.ZWindow;
import zpplet.system.ZWindow0;

public class ZMachine2
extends ZMachine {
    public ZMachine2(byte[] mem, ZScreen screen) {
        super(mem, screen);
    }

    protected void makeTwoWindows() {
        this.w = new ZWindow[2];
        this.w[0] = ZUserConfig.scrollback == 0 ? new ZWindow(this, 0) : new ZWindow0(this);
        this.w[0].moveTo(1, 2);
        this.w[0].resize(this.s.getChars(), this.s.getLines() - 1);
        this.w[1] = new ZWindow(this, 1);
        this.w[1].moveTo(1, 1);
        this.w[1].resize(this.s.getChars(), 1);
        this.w[1].setScroll(false);
        this.w[1].setWrapMode(false);
        this.w[1].setBufferMode(false);
        this.w[1].setTranscripting(false);
        this.w[1].setFont(4);
        this.curw = this.w[0];
    }

    protected void initWindows() {
        this.makeTwoWindows();
        this.w[0].moveCursor(1, this.w[0].getLines());
        this.w[1].setStyle(1);
    }

    protected void initStructures() {
        this.hd = new ZHeader(this.m);
        this.objs = new ZObjectTree(this);
        this.zd = new ZDictionary(this);
        this.zi = new ZInstruction(this);
    }

    public void setHeaderFlags() {
        this.hd.setRevision(0, 0);
        this.hd.setStatusUnavailable(false);
        this.hd.setSplittingAvailable(false);
        this.hd.setVariableDefault(ZUserConfig.normalfont == ZUserConfig.variablefont);
    }

    public int unpackSAddr(int addr) {
        return addr * 2;
    }

    public int unpackRAddr(int addr) {
        return addr * 2;
    }

    public String getStringAt(int addr) throws ZError {
        int zseq;
        StringBuilder result = new StringBuilder();
        int build_ascii = 0;
        int built_ascii = 0;
        int base_alpha = 0;
        int alphabet = 0;
        boolean shift = false;
        int abbrev_mode = 0;
        int[] zchars = new int[3];
        do {
            zseq = this.getWord(addr);
            addr += 2;
            zchars[0] = zseq >> 10 & 0x1F;
            zchars[1] = zseq >> 5 & 0x1F;
            zchars[2] = zseq & 0x1F;
            int i = 0;
            while (i < 3) {
                if (build_ascii > 0) {
                    built_ascii = (built_ascii << 5) + zchars[i];
                    if (++build_ascii == 3) {
                        result.append((char)built_ascii);
                        built_ascii = 0;
                        build_ascii = 0;
                    }
                } else if (abbrev_mode > 0) {
                    int anum = 32 * (abbrev_mode - 1) + zchars[i];
                    int aindex = this.hd.getAbbrevTableAddr() + anum * 2;
                    int aaddr = this.getWord(aindex) * 2;
                    result.append(this.getStringAt(aaddr));
                    abbrev_mode = 0;
                } else {
                    switch (zchars[i]) {
                        case 0: {
                            result.append(' ');
                            break;
                        }
                        case 1: {
                            if (abbrev_mode != 0) {
                                throw new ZError("Abbreviation in abbreviation");
                            }
                            abbrev_mode = zchars[i];
                            break;
                        }
                        case 2: 
                        case 3: {
                            alphabet = (alphabet + zchars[i] - 1) % 3;
                            shift = true;
                            break;
                        }
                        case 4: 
                        case 5: {
                            base_alpha = alphabet = (alphabet + zchars[i] - 3) % 3;
                            break;
                        }
                        default: {
                            if (zchars[i] == 6 && alphabet == 2) {
                                build_ascii = 1;
                            } else {
                                result.append(this.zc.fromTable(zchars[i], alphabet));
                            }
                            if (!shift) break;
                            alphabet = base_alpha;
                            shift = false;
                        }
                    }
                }
                ++i;
            }
        } while ((zseq & 0x8000) == 0);
        return result.toString();
    }
}

