/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.vm;

import org.zmpp.encoding.ZsciiString;
import org.zmpp.io.OutputStream;
import org.zmpp.vm.Cpu;
import org.zmpp.vm.GameData;
import org.zmpp.vm.MemoryOutputStream;
import org.zmpp.vm.Output;
import org.zmpp.vm.StoryFileHeader;

public class OutputImpl
implements Output {
    private Cpu cpu;
    private GameData gamedata;
    private OutputStream[] outputStream;
    private short[] zchars = new short[1];

    public OutputImpl(GameData gameData, Cpu cpu) {
        this.cpu = cpu;
        this.gamedata = gameData;
        this.outputStream = new OutputStream[3];
    }

    public void setOutputStream(int n, OutputStream outputStream) {
        this.outputStream[n - 1] = outputStream;
    }

    public void printZString(int n) {
        this.print(this.gamedata.getZCharDecoder().decode2Zscii(this.gamedata.getMemoryAccess(), n, 0));
    }

    public void print(ZsciiString zsciiString) {
        this.printZsciiChars(zsciiString, false);
    }

    public void newline() {
        this.printZsciiChar((short)13, false);
    }

    public void printZsciiChar(short s, boolean bl) {
        this.zchars[0] = s;
        this.printZsciiChars(new ZsciiString(this.zchars), bl);
    }

    public void deletePreviousZsciiChar(short s) {
        if (!this.outputStream[2].isSelected()) {
            for (int i = 0; i < this.outputStream.length; ++i) {
                if (this.outputStream[i] == null || !this.outputStream[i].isSelected()) continue;
                this.outputStream[i].deletePrevious(s);
            }
        }
    }

    private void printZsciiChars(ZsciiString zsciiString, boolean bl) {
        this.checkTranscriptFlag();
        if (this.outputStream[2].isSelected()) {
            int n = zsciiString.length();
            for (int i = 0; i < n; ++i) {
                this.outputStream[2].print(zsciiString.charAt(i), bl);
            }
        } else {
            for (int i = 0; i < this.outputStream.length; ++i) {
                if (this.outputStream[i] == null || !this.outputStream[i].isSelected()) continue;
                int n = zsciiString.length();
                for (int j = 0; j < n; ++j) {
                    this.outputStream[i].print(zsciiString.charAt(j), bl);
                }
            }
        }
    }

    public void printNumber(short s) {
        this.print(new ZsciiString(String.valueOf(s)));
    }

    public void flushOutput() {
        if (!this.outputStream[2].isSelected()) {
            for (int i = 0; i < this.outputStream.length; ++i) {
                if (this.outputStream[i] == null || !this.outputStream[i].isSelected()) continue;
                this.outputStream[i].flush();
            }
        }
    }

    private void checkTranscriptFlag() {
        if (this.outputStream[1] != null) {
            this.outputStream[1].select(this.gamedata.getStoryFileHeader().isEnabled(StoryFileHeader.Attribute.TRANSCRIPTING));
        }
    }

    public void selectOutputStream(int n, boolean bl) {
        this.outputStream[n - 1].select(bl);
        if (n == 2) {
            this.gamedata.getStoryFileHeader().setEnabled(StoryFileHeader.Attribute.TRANSCRIPTING, bl);
        } else if (n == 3 && bl) {
            this.cpu.halt("invalid selection of memory stream");
        }
    }

    public void selectOutputStream3(int n, int n2) {
        ((MemoryOutputStream)this.outputStream[2]).select(n, n2);
    }

    public void close() {
        if (this.outputStream != null) {
            for (int i = 0; i < this.outputStream.length; ++i) {
                if (this.outputStream[i] == null) continue;
                this.outputStream[i].flush();
                this.outputStream[i].close();
            }
        }
    }

    public void reset() {
        for (int i = 0; i < this.outputStream.length; ++i) {
            if (this.outputStream[i] == null) continue;
            this.outputStream[i].flush();
        }
    }
}

