/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.instructions;

import java.util.ArrayList;
import java.util.List;
import org.zmpp.instructions.InstructionStaticInfo;
import org.zmpp.instructions.Operand;
import org.zmpp.vm.Cpu;
import org.zmpp.vm.Instruction;
import org.zmpp.vm.Machine;
import org.zmpp.vm.ObjectTree;
import org.zmpp.vm.PortableGameState;
import org.zmpp.vm.Window6;

public abstract class AbstractInstruction
implements Instruction {
    public static final short FALSE = 0;
    public static final short TRUE = 1;
    public static final short RESTORE_TRUE = 2;
    private int storyfileVersion;
    private int opcode;
    private List<Operand> operands;
    private short storeVariable;
    private boolean branchIfConditionTrue;
    private short branchOffset;
    private int length;
    private Machine machine;

    public AbstractInstruction(Machine machine, int n) {
        this.opcode = n;
        this.machine = machine;
        this.operands = new ArrayList<Operand>();
        this.branchIfConditionTrue = true;
        this.storyfileVersion = machine.getGameData().getStoryFileHeader().getVersion();
    }

    protected Machine getMachine() {
        return this.machine;
    }

    protected Cpu getCpu() {
        return this.machine.getCpu();
    }

    public int getOpcode() {
        return this.opcode;
    }

    public abstract InstructionForm getInstructionForm();

    public abstract OperandCount getOperandCount();

    protected abstract InstructionStaticInfo getStaticInfo();

    public Operand getOperand(int n) {
        return this.operands.get(n);
    }

    protected int getStoryFileVersion() {
        return this.storyfileVersion;
    }

    protected ObjectTree getObjectTree() {
        return this.getMachine().getGameData().getObjectTree();
    }

    public int getNumOperands() {
        return this.operands.size();
    }

    public short getStoreVariable() {
        return this.storeVariable;
    }

    public short getBranchOffset() {
        return this.branchOffset;
    }

    public int getLength() {
        return this.length;
    }

    public void setOpcode(int n) {
        this.opcode = n;
    }

    public void addOperand(Operand operand) {
        this.operands.add(operand);
    }

    public void setStoreVariable(short s) {
        this.storeVariable = s;
    }

    public void setBranchOffset(short s) {
        this.branchOffset = s;
    }

    public void setBranchIfTrue(boolean bl) {
        this.branchIfConditionTrue = bl;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public boolean storesResult() {
        return this.getStaticInfo().storesResult(this.getOpcode(), this.getStoryFileVersion());
    }

    public boolean isOutput() {
        return this.getStaticInfo().isOutput(this.getOpcode(), this.getStoryFileVersion());
    }

    public boolean isBranch() {
        return this.getStaticInfo().isBranch(this.getOpcode(), this.getStoryFileVersion());
    }

    public boolean branchIfTrue() {
        return this.branchIfConditionTrue;
    }

    public short getValue(int n) {
        Operand operand = this.getOperand(n);
        switch (operand.getType()) {
            case VARIABLE: {
                return this.getCpu().getVariable(operand.getValue());
            }
        }
        return operand.getValue();
    }

    public int getUnsignedValue(int n) {
        short s = this.getValue(n);
        return s & 0xFFFF;
    }

    protected void storeResult(short s) {
        this.getCpu().setVariable(this.getStoreVariable(), s);
    }

    protected void throwInvalidOpcode() {
        this.getCpu().halt("illegal instruction, type: " + (Object)((Object)this.getInstructionForm()) + " operand count: " + (Object)((Object)this.getOperandCount()) + " opcode: " + this.getOpcode());
    }

    public void execute() {
        if (this.isOpcodeAvailable()) {
            this.doInstruction();
        } else {
            this.throwInvalidOpcode();
        }
    }

    protected abstract void doInstruction();

    private boolean isOpcodeAvailable() {
        int[] nArray;
        int n = this.getStoryFileVersion();
        for (int n2 : nArray = this.getStaticInfo().getValidVersions(this.getOpcode())) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getStaticInfo().getOpName(this.getOpcode(), this.getStoryFileVersion()));
        stringBuilder.append(" ");
        stringBuilder.append(this.getOperandString());
        if (this.storesResult()) {
            stringBuilder.append(" -> ");
            stringBuilder.append(this.getVarName(this.getStoreVariable()));
        }
        return stringBuilder.toString();
    }

    private String getVarName(int n) {
        if (n == 0) {
            return "(SP)";
        }
        if (n <= 15) {
            return String.format("L%02x", n - 1);
        }
        return String.format("G%02x", n - 16);
    }

    private String getVarValue(int n) {
        short s = 0;
        s = n == 0 ? this.getCpu().getStackTopElement() : this.getCpu().getVariable(n);
        return String.format("$%02x", s);
    }

    protected String getOperandString() {
        StringBuilder stringBuilder = new StringBuilder();
        block5: for (int i = 0; i < this.getNumOperands(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            Operand operand = this.getOperand(i);
            switch (operand.getType()) {
                case SMALL_CONSTANT: {
                    stringBuilder.append(String.format("$%02x", operand.getValue()));
                    continue block5;
                }
                case LARGE_CONSTANT: {
                    stringBuilder.append(String.format("$%04x", operand.getValue()));
                    continue block5;
                }
                case VARIABLE: {
                    stringBuilder.append(this.getVarName(operand.getValue()));
                    stringBuilder.append("[");
                    stringBuilder.append(this.getVarValue(operand.getValue()));
                    stringBuilder.append("]");
                }
            }
        }
        return stringBuilder.toString();
    }

    protected void nextInstruction() {
        this.getCpu().incrementProgramCounter(this.getLength());
    }

    protected void branchOnTest(boolean bl) {
        boolean bl2;
        boolean bl3 = this.branchIfConditionTrue ? bl : (bl2 = !bl);
        if (bl2) {
            this.applyBranch();
        } else {
            this.nextInstruction();
        }
    }

    private void applyBranch() {
        Cpu cpu = this.getCpu();
        short s = this.getBranchOffset();
        if (s >= 2 || s < 0) {
            cpu.setProgramCounter(cpu.computeBranchTarget(this.getBranchOffset(), this.getLength()));
        } else {
            this.returnFromRoutine(s);
        }
    }

    protected void returnFromRoutine(short s) {
        this.getCpu().popRoutineContext(s);
    }

    protected void call(int n) {
        int n2 = this.getUnsignedValue(0);
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = this.getValue(i + 1);
        }
        this.call(n2, sArray);
    }

    protected void call(int n, short[] sArray) {
        if (n == 0) {
            if (this.storesResult()) {
                this.storeResult((short)0);
            }
            this.nextInstruction();
        } else {
            Cpu cpu = this.getCpu();
            int n2 = cpu.getProgramCounter() + this.getLength();
            short s = this.storesResult() ? (short)this.getStoreVariable() : (short)-1;
            cpu.call(n, n2, sArray, s);
        }
    }

    protected void saveToStorage(int n) {
        boolean bl = this.getMachine().save(n);
        if (this.getStoryFileVersion() <= 3) {
            this.branchOnTest(bl);
        } else {
            this.storeResult(bl ? (short)1 : 0);
            this.nextInstruction();
        }
    }

    protected void restoreFromStorage() {
        PortableGameState portableGameState = this.getMachine().restore();
        if (this.getStoryFileVersion() <= 3) {
            if (portableGameState == null) {
                this.nextInstruction();
            }
        } else if (portableGameState == null) {
            this.storeResult((short)0);
            this.nextInstruction();
        } else {
            int n = portableGameState.getStoreVariable(this.getMachine());
            this.getCpu().setVariable(n, (short)2);
        }
    }

    protected Window6 getWindow(int n) {
        return n == -3 ? this.getMachine().getScreen6().getSelectedWindow() : this.getMachine().getScreen6().getWindow(n);
    }

    public class InstructionResult {
        private short value;
        private boolean branchCondition;

        public InstructionResult(short s, boolean bl) {
            this.value = s;
            this.branchCondition = bl;
        }

        public short getValue() {
            return this.value;
        }

        public boolean getBranchCondition() {
            return this.branchCondition;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperandCount {
        C0OP,
        C1OP,
        C2OP,
        VAR,
        EXT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InstructionForm {
        LONG,
        SHORT,
        VARIABLE;

    }
}

