/* This file is part of "ZaxMidlet".
 * Copyright (c) 2008 William H. Johnson
 * 
 * --LICENSE NOTICE--
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * --LICENSE NOTICE--
 *
 */

package zmachine.ui;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.*;



import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
public class ZaxSettings {
	public static final String ZAX_SETTINGS = "_ZAX_RECORDS_";
	
	public int fontmode;
	private String storyfile;
	
	/**
	 * Construct a new settings object.
	 */
	public ZaxSettings() {
		fontmode = 4;
	}


	public void readSettings()  {
		RecordStore rs = null;

		// Open
		try {
		    rs = RecordStore.openRecordStore( ZAX_SETTINGS, false );
		}
		catch( RecordStoreNotFoundException e ){
			System.out.println("doesn't exist!");
			return;
			// doesn't exist
		}
		catch( RecordStoreException e ){
			System.out.println("dsome other error");// 
			return;
			}

		int    id = 1; // get the ID from somewhere
		byte[] data = new byte[100];

		try {
		    int numBytes = rs.getRecord( id, data, 0 );
			System.out.println("data[1] = "+ data[1]);// 

		    fontmode=(int)data[1];
		    if (fontmode > 6 || fontmode <0)
		    	fontmode = 4;
		}
		catch( ArrayIndexOutOfBoundsException e ){
		    // record too big for the array
			System.out.println("too big");// 
			return;
		}
		catch( InvalidRecordIDException e ){
		    // record doesn't exist
			System.out.println("doesn't exist2");// 
			return;
		}
		catch( RecordStoreNotOpenException e ){
		    // store has been closed
			System.out.println("not open");// 
			return;
		} 
		catch( RecordStoreException e ){
		    // general error
			return;
		}

		
		
		// Close
		try {
		    rs.closeRecordStore();
		}
		catch( RecordStoreNotOpenException e ){
		    // already closed
			return;}
		catch( RecordStoreException e ){
		    // some other error
			return;}
		
		
		
	}
	
	public void writeSettings(){
		RecordStore rs = null;

		
		byte[] data = new byte[2];

		data[0] = 0; // Version of settings
		data[1] = (byte)fontmode;

		System.out.println("data[1]_out = " + data[1]);// 

		// First Delete The old one
        try {
            RecordStore.deleteRecordStore( ZAX_SETTINGS );
        }
        catch( Exception e ){
            // ignore any errors...
			}
		
		
		// Open
		try {
		    rs = RecordStore.openRecordStore( ZAX_SETTINGS, true );
		}
		catch( RecordStoreNotFoundException e ){
		    System.out.println("doesn't exist");
			return;}
		catch( RecordStoreException e ){
		    // some other error
			return;}
		
		
		
		try {
		    int id = rs.addRecord( data, 0, data.length );
		    System.out.println("write");
		}
		catch( RecordStoreFullException e ){
		    // no room left for more data
			return;}
		catch( RecordStoreNotOpenException e ){
		    System.out.println("writing, but doesn't exist");
			return;}
		catch( RecordStoreException e ){
		    // general error
			return;}
		
		
		// Close
		try {
		    System.out.println("close");
		    rs.closeRecordStore();
		}
		catch( RecordStoreNotOpenException e ){
		    // already closed
			return;}
		catch( RecordStoreException e ){
		    // some other error
			return;}
			
		
		
		
	}
}
