/* This file is part of "ZaxMidlet".
 * Copyright (c) 2008 William H. Johnson
 * 
 * --LICENSE NOTICE--
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * --LICENSE NOTICE--
 *
 */

package zmachine.ui;

import java.util.Enumeration;

import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.*;
import javax.microedition.midlet.*;

import terminal.Terminal;
import terminal.VT320;
import terminal.Settings;

import zmachine.ZCPU;
import terminal.VT320;
import terminal.Terminal;

public class ZaxMidlet extends MIDlet  implements  CommandListener  {
	
	protected VT320 emulation;
	public Terminal terminal;
	private Display display;
	private ZCPU cpu;
	// The settings in effect for the game
	private Settings settings;
	
    protected SettingsForm settingsform;
	
	public ZaxMidlet() {
		super();
		display = Display.getDisplay(this);
		settings = new Settings();
		settings.defaults();
		
	}
	  public void commandAction(Command c, Displayable d) {
	  }

    public Display getDisplay() {
		return display;
	}
	
	
	protected void startApp() throws MIDletStateChangeException {

        if (display.getCurrent() == null) {
    		SettingsForm settingsForm = new SettingsForm(this, settings);
    		settingsForm.setCommandListener(settingsForm);
    		getDisplay().setCurrent(settingsForm);
        } else {
            
        }

	}
	public void startStory(String filename)  {
        emulation = new VT320(){} ;
		terminal = new Terminal( emulation,this, settings );
		cpu = new ZCPU(terminal);
		cpu.initialize(filename);
		terminal.setCommandListener(terminal);
		getDisplay().setCurrent(terminal);
//		try{
//		// Kludge to give the terminal time to get ready before the game starts           
//		 Thread.sleep(1000);
//       } catch (Exception ex){}            

        new Thread(new Runnable() {
            public void run() {
                cpu.start();
            }
        }).start();

	}

	protected void pauseApp() {	}

	protected void destroyApp(boolean unconditional) 
		throws MIDletStateChangeException 
		{	}



}
