/* This is a modified version of FileBrowser.java by Sun, Microsystems, Inc. 
 *  Portions Copyright(c) 2008, William H. Johnson
 *  See below for original license
 */


/*
 *
 * Copyright (c) 2007, Sun Microsystems, Inc.
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * Neither the name of Sun Microsystems nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package zmachine.ui;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;

import javax.microedition.io.Connector;
//import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.*;
import javax.microedition.lcdui.*;

import terminal.Settings;
import zmachine.ZUserInterface;
import zmachine.ui.*;




public class FileDialog  implements  CommandListener {
	private ZaxMidlet midlet;
	private Displayable lastDisplayable;
	private Settings settings;
	private TextField charWidthTextField;
	private TextField storyFileTextField;
	   
	
    public String selected_file;
    
//---------
	    private static final String[] attrList = { "Read", "Write", "Hidden" };
	    private static final String[] typeList = { "Regular File", "Directory" };
	    private static final String[] monthList =
	        { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

	    /* special string denotes upper directory */
	    private static final String UP_DIRECTORY = "..";

	    /* special string that denotes upper directory accessible by this browser.
	     * this virtual directory contains all roots.
	     */
	    private static final String MEGA_ROOT = "/";

	    /* separator string as defined by FC specification */
	    private static final String SEP_STR = "/";

	    /* separator character as defined by FC specification */
	    private static final char SEP = '/';
	    private String currDirName;
	    private Command view = new Command("Select", Command.ITEM, 1);
	    private Command creat = new Command("New", Command.ITEM, 2);

	    //add delete file functionality
	    private Command delete = new Command("Delete", Command.ITEM, 3);
	    private Command creatOK = new Command("OK", Command.OK, 1);
	    private Command prop = new Command("Properties", Command.ITEM, 2);
	    private Command back = new Command("Back", Command.BACK, 2);
	    private Command exit = new Command("Exit", Command.EXIT, 3);
	    private TextField nameInput; // Input field for new file name
	    private ChoiceGroup typeInput; // Input field for file type (regular/dir)
	    private Image dirIcon;
	    private Image fileIcon;
	    private Image[] iconList;
	 	
	    private Command start_browser = new Command("Load Story", Command.ITEM, 1);
	    private Command load_story = new Command("Start Story", Command.ITEM, 1);
		
//---------	 	
	 	
	    private Command alert_yes;
	    private Command alert_no;
	    private int mode;
	 	public int running =0;
	 	/**
	 * Construct a new form.
	 */
	public FileDialog(
		ZaxMidlet midlet, 
		//Displayable lastDisplayable, 
		Settings settings) 
	{
		//super("Settings");
		this.midlet = midlet;
		this.lastDisplayable = lastDisplayable;
		this.settings = settings;
		currDirName = MEGA_ROOT;

        try {
            dirIcon = Image.createImage("/icons/dir.png");
        } catch (IOException e) {
            dirIcon = null;
        }

        try {
            fileIcon = Image.createImage("/icons/file.png");
        } catch (IOException e) {
            fileIcon = null;
        }

        iconList = new Image[] { fileIcon, dirIcon };
	}



	/* File Browser Code */

    public void OpenBrowser(int mode) {
    	// mode 0 Load Story 1 save 2 restore
    	this.mode = mode;
    	selected_file = null;
    	
    	try {
            showCurrDir();
        } catch (SecurityException e) {
            Alert alert =
                new Alert("Error", "You are not authorized to access the restricted API", null,
                    AlertType.ERROR);
            alert.setTimeout(Alert.FOREVER);

            Form form = new Form("Cannot access FileConnection");
            form.append(new StringItem(null,
                    "You cannot run this MIDlet with the current permissions. " +
                    "Sign the MIDlet suite, or run it in a different security domain"));
            form.addCommand(exit);
            form.setCommandListener(this);
    		midlet.getDisplay().setCurrent(alert,form);
//           midlDisplay.getDisplay(this).setCurrent(alert, form);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

	
    void createFile() {
    	System.out.println("Create File");
    	Form creator = new Form("New File (select OK from the menu)");
        nameInput = new TextField("Enter Name:", null, 40, TextField.ANY);
        //typeInput = new ChoiceGroup("Enter File Type", Choice.EXCLUSIVE, typeList, iconList);
        creator.append(nameInput);
        //creator.append(typeInput);
        creator.addCommand(creatOK);
        creator.addCommand(back);
        creator.addCommand(exit);
        creator.setCommandListener(this);
        midlet.getDisplay().setCurrent(creator);
    }
    
    void createFile(String newName, boolean isDirectory) {
        try {

            if (isDirectory) {
                FileConnection fc = (FileConnection)Connector.open("file:///" + currDirName + newName);
                fc.mkdir();
                showCurrDir();
            } else {
//                fc.create();
            	selected_file = "file://localhost/"+currDirName+newName;
                FileConnection fc = (FileConnection)Connector.open(selected_file);
       			
                if (fc.exists()) {
                    fc.close();
                	YesNoAlert();
                }
                else
                {
                	fc.close();
                	midlet.getDisplay().setCurrent(midlet.terminal);
                	running =0;
                }
              }

        } catch (Exception e) {
            String s = "Can not create file '" + newName + "'";

            if ((e.getMessage() != null) && (e.getMessage().length() > 0)) {
                s += ("\n" + e);
            }

            Alert alert = new Alert("Error!", s, null, AlertType.ERROR);
            alert.setTimeout(Alert.FOREVER);
            midlet.getDisplay().setCurrent(alert);
            // Restore the commands that were removed in commandAction()
            midlet.getDisplay().getCurrent().addCommand(creatOK);
            midlet.getDisplay().getCurrent().addCommand(back);
        }
    }
    
 
    //Starts creatFile with another Thread
    private void executeCreateFile(final String name, final boolean val) {
        new Thread(new Runnable() {
                public void run() {
                    createFile(name, val);
                }
            }).start();
    } 
    /**
     * Show file list in the current directory .
     */
    void showCurrDir() {
        Enumeration e;
        FileConnection currDir = null;
        List browser;
    	System.out.println("showCurrDir!");
        try {
           	System.out.println("1");

        	if (MEGA_ROOT.equals(currDirName)) {
                e = FileSystemRegistry.listRoots();
                
                browser = new List(currDirName, List.IMPLICIT);
            } else {
                currDir = (FileConnection)Connector.open("file://localhost/" + currDirName);

                System.out.println("Dir: " +currDirName);
                e = currDir.list();
                browser = new List(currDirName, List.IMPLICIT);
                // not root - draw UP_DIRECTORY
                browser.append(UP_DIRECTORY, dirIcon);
            }

            while (e.hasMoreElements()) {
                String fileName = (String)e.nextElement();
                System.out.println("File: " +fileName);
                if (fileName.charAt(fileName.length() - 1) == SEP) {
                    // This is directory
                    browser.append(fileName, dirIcon);
                } else {
                    // this is regular file
                    browser.append(fileName, fileIcon);
                }
            }

            browser.setSelectCommand(view);

            //Do not allow creating files/directories beside root
            //Do not allow creating files/directories beside root
            if (!MEGA_ROOT.equals(currDirName)) {
                if (mode ==1) // Save File
                	browser.addCommand(creat);
            }
 
            browser.addCommand(exit);

            browser.setCommandListener(this);

            if (currDir != null) {
                currDir.close();
            }
    		midlet.getDisplay().setCurrent(browser);

        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void traverseDirectory(String fileName) {
        /* In case of directory just change the current directory
         * and show it
         */
        if (currDirName.equals(MEGA_ROOT)) {
            if (fileName.equals(UP_DIRECTORY)) {
                // can not go up from MEGA_ROOT
                return;
            }

            currDirName = fileName;
        } else if (fileName.equals(UP_DIRECTORY)) {
            // Go up one directory
        	int i = currDirName.lastIndexOf(SEP, currDirName.length() - 2);

            if (i != -1) {
            		
                currDirName = currDirName.substring(0, i + 1);
            	System.out.println(currDirName);
            } else {
                currDirName = MEGA_ROOT;
            	System.out.println("MEGAROOT "+currDirName);

            }
        } else {
            currDirName = currDirName + fileName;
        }

        showCurrDir();
    }

    void showFile(String fileName) {
        try {
            FileConnection fc =
                (FileConnection)Connector.open("file://localhost/" + currDirName + fileName);

            if (!fc.exists()) {
                throw new IOException("File does not exists");
            }

            
            InputStream fis = fc.openInputStream();
            byte[] b = new byte[1024];

            int length = fis.read(b, 0, 1024);

            fis.close();
            fc.close();

            TextBox viewer =
                new TextBox("View File: " + fileName, null, 1024,
                    TextField.ANY | TextField.UNEDITABLE);

            //viewer.addCommand(back);
            viewer.addCommand(exit);
            viewer.setCommandListener(this);

            if (length > 0) {
                viewer.setString(new String(b, 0, length));
            }
    		midlet.getDisplay().setCurrent(viewer);

//            Display.getDisplay(this).setCurrent(viewer);
        } catch (Exception e) {
            Alert alert =
                new Alert("Error!",
                    "Can not access file " + fileName + " in directory " + currDirName +
                    "\nException: " + e.getMessage(), null, AlertType.ERROR);
            alert.setTimeout(Alert.FOREVER);
    		midlet.getDisplay().setCurrent(alert);
//            Display.getDisplay(this).setCurrent(alert);
        }
    }

	
	
    public void commandAction(Command c, Displayable d) {
    if (c == view) {
    	            List curr = (List)d;
            final String currFile = curr.getString(curr.getSelectedIndex());
            new Thread(new Runnable() {
                    public void run() {
                        if (currFile.endsWith(SEP_STR) || currFile.equals(UP_DIRECTORY)) {
                            traverseDirectory(currFile);
                        } else {  // Is a file that is selected.
                            // Show file contents
                    		if (mode==0)
                        	{
                    			settings.storyfile = "file://localhost/"+currDirName+currFile;
                    			settings.storydir = "file://localhost/"+currDirName;

                    		
                    			System.out.println(currDirName+currFile);
                    			midlet.startStory(settings.storyfile);
                               	running =0;
                        	}
                    		else if (mode==1)  //save
                    		{                    			
                       			selected_file = "file://localhost/"+currDirName+currFile;
                                YesNoAlert();

                    		}
                    		else if (mode==2)  //Restore
                    		{
                    			selected_file = "file://localhost/"+currDirName+currFile;
                        		midlet.getDisplay().setCurrent(midlet.terminal);
                               	running =0;
                   			}
                        	//showFile(currFile);
                    }
                    }
                    }).start();
        }else if (c == creat) {
            createFile();
        } else if (c == creatOK) {
            String newName = nameInput.getString();
            String tmp = newName;
            int i;
            for(i=1; i < tmp.length();i++)
            {
            	if (tmp.charAt(i) == 13 ||tmp.charAt(i) == 10 ) 
            	{
            		newName = tmp.substring(0,i);
            		i=1000; // ends for loop.
            	}
            }
            
            if ((newName == null) || newName.equals("")) {
                Alert alert =
                    new Alert("Error!", "File Name is empty. Please provide file name", null,
                        AlertType.ERROR);
                alert.setTimeout(Alert.FOREVER);
                midlet.getDisplay().setCurrent(alert);
            } else {
                // Create file in a separate thread and disable all commands
                // except for "exit"
                //executeCreateFile(newName, typeInput.getSelectedIndex() != 0);
                // Force to be a file, not a directory
            	executeCreateFile(newName, false);
                midlet.getDisplay().getCurrent().removeCommand(creatOK);
                midlet.getDisplay().getCurrent().removeCommand(back);
            }
        }
    else if (c == back) {
            showCurrDir();
        } 
    else if (c == exit) {
    	running =0;
    	if (mode == 0)
        	midlet.notifyDestroyed();
   	else
    	midlet.getDisplay().setCurrent(midlet.terminal);
    	} 
    else if (c == alert_no) {
    	selected_file = null;
    	if (mode == 0)
    		midlet.getDisplay().setCurrent(midlet.settingsform);
    	else
    		midlet.getDisplay().setCurrent(midlet.terminal);
    	running =0;

    	} 
    else if (c == alert_yes) {
    	if (mode == 0)
    		midlet.getDisplay().setCurrent(midlet.settingsform);
    	else
    		midlet.getDisplay().setCurrent(midlet.terminal);

    	running =0;
    	} 
    
    }
	
	
    private void YesNoAlert()
    {

    	Form alert = new Form("Overwrite File?");
        //Form alert = new Form("Overwrite File?", "Overwrite File: "+ selected_file +"? YES or NO?", null, AlertType.CONFIRMATION);
    	alert.append(new String("Overwrite File: "+ selected_file +"?"));
    	alert.append(new String("\n\nUse the menu key to select YES or NO."));
    	  
    	
    	alert_yes = new Command("Yes", Command.ITEM, 1);
        alert_no = new Command("No", Command.ITEM, 1);
//        alert.setTimeout(Alert.FOREVER);
        midlet.getDisplay().setCurrent(alert);
        
  //      alert.setTimeout(Alert.FOREVER);
        alert.addCommand(alert_yes);
        alert.addCommand(alert_no);

        alert.setCommandListener(this);

    }

}
