/*
 * Decompiled with CFR 0.152.
 */
package zmachine;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import zmachine.ZUserInterface;

class ZMemory {
    private ZUserInterface zui;
    byte[] data;
    int dataLength;

    ZMemory() {
    }

    void initialize(ZUserInterface ui, String storyFile) {
        this.zui = ui;
        try {
            FileConnection fc = (FileConnection)Connector.open((String)storyFile);
            if (!fc.exists() || !fc.canRead()) {
                this.zui.fatal("Storyfile " + storyFile + " not found.");
            }
            this.dataLength = (int)fc.fileSize();
            this.data = new byte[this.dataLength];
            DataInputStream dis = fc.openDataInputStream();
            dis.readFully(this.data, 0, this.dataLength);
            dis.close();
            fc.close();
        }
        catch (IOException ioex) {
            this.zui.fatal("I/O error loading storyfile.");
        }
    }

    int fetchByte(int addr) {
        if (addr > this.dataLength - 1) {
            this.zui.fatal("Memory fault: address " + addr);
        }
        if (addr < 0) {
            return 0;
        }
        int i = this.data[addr] & 0xFF;
        return i;
    }

    void putByte(int addr, int b) {
        if (addr > this.dataLength - 1) {
            this.zui.fatal("Memory fault: address " + addr);
        }
        this.data[addr] = (byte)(b & 0xFF);
    }

    int fetchWord(int addr) {
        if (addr > this.dataLength - 1) {
            this.zui.fatal("Memory fault: address " + addr);
        }
        if (addr < 0) {
            return 0;
        }
        int i = (this.data[addr] << 8 | this.data[addr + 1] & 0xFF) & 0xFFFF;
        return i;
    }

    void putWord(int addr, int w) {
        if (addr > this.dataLength - 1) {
            this.zui.fatal("Memory fault: address " + addr);
        }
        this.data[addr] = (byte)(w >> 8 & 0xFF);
        this.data[addr + 1] = (byte)(w & 0xFF);
    }

    void dumpMemory(DataOutputStream dos, int addr, int len) throws IOException {
        dos.write(this.data, addr, len);
    }

    void readMemory(DataInputStream dis, int addr, int len) throws IOException {
        dis.read(this.data, addr, len);
    }
}

