/*
 * Decompiled with CFR 0.152.
 */
package terminal;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;
import terminal.LCDFont;
import terminal.Settings;
import terminal.VT320;
import zmachine.ZUserInterface;
import zmachine.ui.FileDialog;
import zmachine.ui.StringTokenizer;
import zmachine.ui.ZaxMidlet;

public class Terminal
extends Canvas
implements ZUserInterface,
CommandListener {
    private static final int MODE_DISCONNECTED = 0;
    private static final int MODE_CONNECTED = 1;
    private static final int MODE_CURSOR = 2;
    private static final int MODE_SCROLL = 3;
    private int[] cursorpos = new int[2];
    private int[] fontsize = new int[2];
    private String curr_cmd = "";
    private int previous_window = 0;
    private int[] cursor_row = new int[5];
    private int[] cursor_col = new int[5];
    private int upper_size = 0;
    private int status_size = 0;
    private int new_char = 0;
    private int read_char = 0;
    private ZaxMidlet midlet;
    private Vector inputQueue;
    private int Last_style = 0;
    private FileDialog filedialog;
    private int reading_line = 0;
    private boolean buffermode = true;
    private static final int MODE_TYPING = 4;
    private static int commandPriority = 1;
    private Command exit = new Command("Exit", 7, 3);
    private static final Command textTypeCommand = new Command("Type", 4, commandPriority++);
    private static final Command backMainCommand = new Command("Back", 8, commandPriority++);
    private static final Command textInputCommand = new Command("Input", 8, commandPriority++);
    private Command quitstory = new Command("Quit Story", 8, commandPriority++);
    private static final Command textEnterCommand = new Command("Enter", 8, commandPriority++);
    private static final Command typeCommand = new Command("Type", 8, commandPriority++);
    private static final Command macrosCommand = new Command("Macros", 8, commandPriority++);
    private static final Command tabCommand = new Command("TAB", 8, commandPriority++);
    private static final Command spaceCommand = new Command("SPACE", 8, commandPriority++);
    private static final Command enterCommand = new Command("ENTER", 8, commandPriority++);
    private static final Command escCommand = new Command("ESC", 8, commandPriority++);
    private static final Command ctrlCommand = new Command("CTRL", 8, commandPriority++);
    private static final Command altCommand = new Command("ALT", 8, commandPriority++);
    private static final Command shiftCommand = new Command("SHIFT", 8, commandPriority++);
    private static final Command specialCommand = new Command("Special", 8, commandPriority++);
    private static final Command cursorCommand = new Command("Cursor", 8, commandPriority++);
    private static final Command scrollCommand = new Command("Scroll", 8, commandPriority++);
    private static final Command backCommand = new Command("Back", 2, commandPriority++);
    private static final Command showBindingsCommand = new Command("Show Key Bindings", 8, commandPriority++);
    private static final Command disconnectCommand = new Command("Disconnect", 8, commandPriority++);
    private static final Command closeCommand = new Command("Exit", 6, commandPriority++);
    private static final Command[] commandsDisconnected = new Command[]{closeCommand};
    private static final Command[] commandsConnected = new Command[]{textInputCommand, typeCommand, macrosCommand, tabCommand, spaceCommand, enterCommand, escCommand, ctrlCommand, altCommand, shiftCommand, specialCommand, cursorCommand, scrollCommand, showBindingsCommand, disconnectCommand};
    private static final Command[] commandsCursor = new Command[]{backCommand};
    private static final Command[] commandsTyping = new Command[]{backMainCommand, backCommand, textInputCommand, macrosCommand, tabCommand, spaceCommand, enterCommand, escCommand, ctrlCommand, altCommand, shiftCommand, specialCommand, cursorCommand, scrollCommand, disconnectCommand};
    private static int[] bindingKeys = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 42, 48, 35};
    private TextBox inputDialog;
    private TextBox controlKeyDialog;
    private TextBox altKeyDialog;
    private TextBox shiftKeyDialog;
    private Command[] currentCommands;
    private int mode;
    private Settings settings;
    private StringBuffer commandBuffer = new StringBuffer();
    private static final int KEY_BACKSPACE = -8;
    private static final int KEY_SHIFT = 137;
    private boolean typingShift;
    protected VT320 buffer;
    protected int top;
    protected int left;
    protected int width;
    protected int height;
    private int fontWidth;
    private int fontHeight;
    protected int rotated;
    public int rows;
    public int cols;
    private Image backingStore = null;
    private static final int[] color;
    public int fgcolor = 0;
    public int bgcolor = 0xFFFFFF;
    private static final int[] boldcolor;
    private static final int[] lowcolor;
    private Object paintMutex = new Object();
    private boolean invalid = true;
    private LCDFont lcdfont;
    private int fontMode = Settings.fontMode;
    private Font font;
    private int[][] fontData;
    private static final String FONT_RESOURCE = "/font";

    static {
        int[] nArray = new int[8];
        nArray[1] = 0xCC0000;
        nArray[2] = 52224;
        nArray[3] = 0xCCCC00;
        nArray[4] = 204;
        nArray[5] = 0xCC00CC;
        nArray[6] = 52428;
        nArray[7] = 0xCCCCCC;
        color = nArray;
        boldcolor = new int[]{0x333333, 0xFF0000, 65280, 0xFFFF00, 255, 0xFF00FF, 65535, 0xFFFFFF};
        int[] nArray2 = new int[8];
        nArray2[1] = 0x990000;
        nArray2[2] = 39168;
        nArray2[3] = 0x999900;
        nArray2[4] = 153;
        nArray2[5] = 0x990099;
        nArray2[6] = 39321;
        nArray2[7] = 0x999999;
        lowcolor = nArray2;
    }

    public Terminal(VT320 buffer, ZaxMidlet midlet, Settings settings) {
        this.buffer = buffer;
        this.settings = settings;
        this.midlet = midlet;
        buffer.setDisplay(this);
        this.fgcolor = color[7];
        this.bgcolor = color[0];
        this.inputQueue = new Vector();
        buffer.setCursorPosition(0, 1);
        buffer.setTopMargin(1);
        this.rotated = 0;
        this.initFont();
        this.setFullScreenMode(true);
        this.top = 0;
        this.left = 0;
        this.changeMode(0);
        this.setCommandListener(this);
        this.bgcolor = Settings.bgcolor;
        if (Settings.fgcolor != 0xFFFFFF) {
            this.fgcolor = Settings.fgcolor;
        }
        this.sizeChanged();
        this.setTextStyle(0);
        buffer.setCursorPosition(0, 1);
        this.addCommand(this.quitstory);
        this.addCommand(textInputCommand);
        this.addCommand(this.exit);
    }

    protected void sizeChanged(int w, int h) {
        super.sizeChanged(w, h);
        this.sizeChanged();
    }

    protected void sizeChanged() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (this.rotated != 0) {
            this.width = this.getHeight();
            this.height = this.getWidth();
        }
        this.cols = this.width / this.fontWidth;
        this.rows = this.height / this.fontHeight;
        this.backingStore = Image.createImage((int)this.width, (int)this.height);
        int virtualCols = this.cols;
        int virtualRows = this.rows;
        if (Settings.terminalCols != 0) {
            virtualCols = Settings.terminalCols;
        }
        if (Settings.terminalRows != 0) {
            virtualRows = Settings.terminalRows;
        }
        this.buffer.setScreenSize(virtualCols, virtualRows);
    }

    public void connected() {
        this.changeMode(1);
    }

    public void disconnected() {
        this.changeMode(0);
    }

    protected void changeMode(int mode) {
        this.mode = mode;
        switch (mode) {
            case 0: {
                this.changeCurrentCommands(commandsDisconnected);
                break;
            }
            case 1: {
                this.changeCurrentCommands(commandsConnected);
                break;
            }
            case 2: 
            case 3: {
                this.changeCurrentCommands(commandsCursor);
                break;
            }
            case 4: {
                this.changeCurrentCommands(commandsTyping);
            }
        }
    }

    protected void changeCurrentCommands(Command[] commands) {
    }

    public void activate() {
        this.midlet.getDisplay().setCurrent((Displayable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.inputDialog) {
            if (command != backCommand) {
                this.commandBuffer.setLength(0);
                this.commandBuffer.append(this.inputDialog.getString());
                this.inputDialog.setString("");
                this.activate();
                if (command == textEnterCommand) {
                    this.commandBuffer.append('\n');
                    this.buffer.putStringUpper(this.commandBuffer.toString());
                    String tmp_cmd = "";
                    int i = 0;
                    while (i < this.commandBuffer.length()) {
                        if ((this.commandBuffer.charAt(i) == '\n' || this.commandBuffer.charAt(i) == '\r') && tmp_cmd != "") {
                            Vector vector = this.inputQueue;
                            synchronized (vector) {
                                this.inputQueue.addElement(tmp_cmd.substring(0, tmp_cmd.length()));
                                this.inputQueue.notifyAll();
                            }
                            tmp_cmd = "";
                        } else {
                            tmp_cmd = String.valueOf(tmp_cmd) + this.commandBuffer.charAt(i);
                        }
                        ++i;
                    }
                } else {
                    new Thread(new Runnable(){

                        public void run() {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            int i = 0;
                            while (i < Terminal.this.commandBuffer.length()) {
                                try {
                                    Thread.sleep(5L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                Terminal.this.keyReleasedTyping(Terminal.this.commandBuffer.charAt(i));
                                ++i;
                            }
                        }
                    }).start();
                }
            } else {
                this.activate();
            }
        } else if (displayable == this.controlKeyDialog) {
            this.handleModifierDialog(command, this.controlKeyDialog, 1);
        } else if (displayable == this.altKeyDialog) {
            this.handleModifierDialog(command, this.altKeyDialog, 4);
        } else if (displayable == this.shiftKeyDialog) {
            this.handleModifierDialog(command, this.shiftKeyDialog, 2);
        } else if (displayable != this) {
            this.activate();
        } else if (command == disconnectCommand || command == closeCommand) {
            this.doDisconnect();
        } else if (command != macrosCommand) {
            if (command == tabCommand) {
                this.buffer.keyTyped(0, '\t', 0);
            } else if (command == spaceCommand) {
                this.buffer.keyTyped(0, ' ', 0);
            } else if (command == enterCommand) {
                this.buffer.keyTyped(0, '\n', 0);
            } else if (command == escCommand) {
                this.buffer.keyTyped(0, '\u001b', 0);
            } else if (command == cursorCommand) {
                this.doCursor();
            } else if (command == scrollCommand) {
                this.doScroll();
            } else if (command == typeCommand) {
                this.doTyping();
            } else if (command == textInputCommand) {
                this.doTextInput(null);
            } else if (command != specialCommand) {
                if (command == backCommand || command == backMainCommand) {
                    this.changeMode(1);
                } else if (command == showBindingsCommand) {
                    this.doShowBindings();
                } else if (command == this.exit) {
                    this.midlet.notifyPaused();
                } else if (command == this.quitstory) {
                    this.midlet.notifyDestroyed();
                }
            }
        }
    }

    private void handleModifierDialog(Command command, TextBox box, int modifier) {
        if (command != backCommand) {
            String str = box.getString();
            int i = 0;
            while (i < str.length()) {
                ++i;
            }
            box.setString("");
        }
        this.activate();
    }

    protected void keyPressed(int keycode) {
        this.keyPressedTyping(keycode);
    }

    protected void keyReleased(int keycode) {
        this.keyReleasedTyping(keycode);
    }

    protected void keyRepeated(int keycode) {
        switch (this.mode) {
            case 2: {
                this.keyPressedCursor(keycode);
                break;
            }
            case 3: {
                this.keyPressedScroll(keycode);
            }
        }
    }

    protected boolean handleGameAction(int keycode) {
        int gameAction = this.getGameAction(keycode);
        if (gameAction != 0) {
            switch (gameAction) {
                case 1: {
                    this.buffer.keyPressed(38, 8);
                    return true;
                }
                case 6: {
                    this.buffer.keyPressed(40, 8);
                    return true;
                }
                case 2: {
                    this.buffer.keyPressed(37, 8);
                    return true;
                }
                case 5: {
                    this.buffer.keyPressed(39, 8);
                    return true;
                }
            }
        }
        return false;
    }

    protected void keyPressedTyping(int keycode) {
        if (keycode == 137) {
            this.typingShift = true;
        }
        if (keycode != 8 && keycode != -8 && keycode != 10 && keycode != 13 && keycode != 137 && (keycode < 32 || keycode >= 128) && this.handleGameAction(keycode)) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyReleasedTyping(int keycode) {
        if (keycode < 8 || keycode > 8 && keycode < 10 || keycode > 10 && keycode < 13 || keycode > 13 && keycode < 27 || keycode > 27 && keycode < 32 || keycode > 126 && keycode < 127 || keycode > 127 && keycode < 129 || keycode > 132) {
            return;
        }
        this.new_char = keycode;
        if (this.reading_line == 1) {
            if (keycode == 8 || keycode == -8 || keycode == 127) {
                if (this.curr_cmd.length() > 0) {
                    this.buffer.keyPressed(8, 0);
                }
            } else if (keycode == 10 || keycode == 13) {
                this.buffer.keyTyped(0, '\n', 0);
            } else if (keycode == 137) {
                this.typingShift = false;
            } else if (keycode > 0 && keycode < 32) {
                this.buffer.keyTyped(keycode, (char)keycode, 0);
            } else if (keycode >= 32 && keycode < 128) {
                char c = (char)keycode;
                if (this.typingShift) {
                    c = this.shiftChar(c);
                }
                this.buffer.keyTyped(0, c, 0);
            }
            if (keycode == 8 || keycode == -8 || keycode == 127) {
                if (this.curr_cmd.length() > 0) {
                    this.curr_cmd = this.curr_cmd.substring(0, this.curr_cmd.length() - 1);
                }
            } else if (keycode == 10 || keycode == 13) {
                Vector vector = this.inputQueue;
                synchronized (vector) {
                    this.inputQueue.addElement(this.curr_cmd.substring(0, this.curr_cmd.length()));
                    this.inputQueue.notifyAll();
                }
                this.curr_cmd = "";
            } else {
                this.curr_cmd = String.valueOf(this.curr_cmd) + (char)keycode;
            }
        }
        this.buffer.keypressed = 1;
    }

    private char shiftChar(char c) {
        if (c >= 'a' && c <= 'z') {
            return (char)(c - 97 + 65);
        }
        switch (c) {
            case '0': {
                return ')';
            }
            case '1': {
                return '!';
            }
            case '2': {
                return '@';
            }
            case '3': {
                return '#';
            }
            case '4': {
                return '$';
            }
            case '5': {
                return '%';
            }
            case '6': {
                return '^';
            }
            case '7': {
                return '&';
            }
            case '8': {
                return '*';
            }
            case '9': {
                return '(';
            }
        }
        return c;
    }

    private int gameKeysToNumeric(int keycode) {
        int gameAction = this.getGameAction(keycode);
        switch (gameAction) {
            case 1: {
                keycode = 50;
                break;
            }
            case 6: {
                keycode = 56;
                break;
            }
            case 2: {
                keycode = 52;
                break;
            }
            case 5: {
                keycode = 54;
            }
        }
        return keycode;
    }

    protected void keyPressedCursor(int keycode) {
        keycode = this.gameKeysToNumeric(keycode);
        switch (keycode) {
            case 50: {
                this.buffer.keyPressed(38, 8);
                break;
            }
            case 48: 
            case 56: {
                this.buffer.keyPressed(40, 8);
                break;
            }
            case 52: {
                this.buffer.keyPressed(37, 8);
                break;
            }
            case 54: {
                this.buffer.keyPressed(39, 8);
                break;
            }
            case 49: {
                this.keyPressedCursor(1);
                this.keyPressedCursor(2);
                break;
            }
            case 51: {
                this.keyPressedCursor(1);
                this.keyPressedCursor(5);
                break;
            }
            case 42: 
            case 55: {
                this.keyPressedCursor(6);
                this.keyPressedCursor(2);
                break;
            }
            case 35: 
            case 57: {
                this.keyPressedCursor(6);
                this.keyPressedCursor(5);
            }
        }
    }

    protected void keyPressedScroll(int keycode) {
        keycode = this.gameKeysToNumeric(keycode);
        switch (keycode) {
            case 50: {
                if (this.top > 0) {
                    --this.top;
                }
                this.redraw();
                break;
            }
            case 48: 
            case 56: {
                if (this.top + this.rows < this.buffer.height) {
                    ++this.top;
                }
                this.redraw();
                break;
            }
            case 52: {
                if (this.left > 0) {
                    --this.left;
                }
                this.redraw();
                break;
            }
            case 54: {
                if (this.left + this.cols < this.buffer.width) {
                    ++this.left;
                }
                this.redraw();
                break;
            }
            case 49: {
                this.keyPressedScroll(1);
                this.keyPressedScroll(2);
                break;
            }
            case 51: {
                this.keyPressedScroll(1);
                this.keyPressedScroll(5);
                break;
            }
            case 42: 
            case 55: {
                this.keyPressedScroll(6);
                this.keyPressedScroll(2);
                break;
            }
            case 35: 
            case 57: {
                this.keyPressedScroll(6);
                this.keyPressedScroll(5);
            }
        }
    }

    private void doDisconnect() {
    }

    public void doCursor() {
        this.changeMode(2);
    }

    public void doScroll() {
        this.changeMode(3);
    }

    public void doTyping() {
        this.changeMode(4);
    }

    private void doShowBindings() {
        StringBuffer str = new StringBuffer();
        if (this.currentCommands != null) {
            int i = 0;
            while (i < bindingKeys.length && i < this.currentCommands.length) {
                int keycode = bindingKeys[i];
                Command comm = this.currentCommands[i];
                String keyName = this.getKeyName(keycode);
                str.append(keyName);
                str.append(": ");
                str.append(comm.getLabel());
                str.append("\n");
                ++i;
            }
        }
    }

    public void doTextInput(String text) {
        if (this.inputDialog == null) {
            this.inputDialog = new TextBox("Input", "", 255, 0);
            this.inputDialog.addCommand(textEnterCommand);
            this.inputDialog.addCommand(typeCommand);
            this.inputDialog.addCommand(backCommand);
            if (!Settings.predictiveText) {
                this.inputDialog.setConstraints(524288);
            }
            this.inputDialog.setCommandListener((CommandListener)this);
        }
        if (text != null) {
            this.inputDialog.setString(text);
        }
        this.midlet.getDisplay().setCurrent((Displayable)this.inputDialog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Graphics g) {
        g.setColor(this.bgcolor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Object object = this.paintMutex;
        synchronized (object) {
            this.redrawBackingStore();
            Image image = this.backingStore;
            g.drawImage(image, 0, 1, 20);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redraw() {
        Object object = this.paintMutex;
        synchronized (object) {
            this.invalid = true;
            this.repaint();
        }
    }

    protected void redrawBackingStore() {
        if (this.invalid) {
            Graphics g = this.backingStore.getGraphics();
            g.setColor(this.bgcolor);
            g.fillRect(0, 0, this.width, this.height);
            int l = this.top;
            while (l < this.buffer.height && l < this.top + this.rows) {
                if (this.buffer.update[0] || this.buffer.update[l + 1]) {
                    this.buffer.update[l + 1] = false;
                    int c = this.left;
                    while (c < this.buffer.width && c < this.left + this.cols) {
                        int bgcolorindex;
                        int addr = 0;
                        int currAttr = this.buffer.charAttributes[this.buffer.windowBase + l][c];
                        int fg = this.fgcolor;
                        int bg = this.bgcolor;
                        int fgcolorindex = ((currAttr & 0xF0) >> 4) - 1;
                        if (fgcolorindex >= 0 && fgcolorindex < 8) {
                            fg = (currAttr & 1) != 0 ? boldcolor[fgcolorindex] : ((currAttr & 8) != 0 ? lowcolor[fgcolorindex] : color[fgcolorindex]);
                        }
                        if ((bgcolorindex = ((currAttr & 0xF00) >> 8) - 1) >= 0 && bgcolorindex < 8) {
                            bg = color[bgcolorindex];
                        }
                        if ((currAttr & 4) != 0) {
                            bg = this.fgcolor;
                            fg = this.bgcolor;
                        }
                        while (c + addr < this.buffer.width && (this.buffer.charArray[this.buffer.windowBase + l][c + addr] < ' ' || this.buffer.charAttributes[this.buffer.windowBase + l][c + addr] == currAttr)) {
                            if (this.buffer.charArray[this.buffer.windowBase + l][c + addr] < ' ') {
                                this.buffer.charArray[this.buffer.windowBase + l][c + addr] = 32;
                                this.buffer.charAttributes[this.buffer.windowBase + l][c + addr] = 0;
                                continue;
                            }
                            ++addr;
                        }
                        g.setColor(bg);
                        g.fillRect((c - this.left) * this.fontWidth, (l - this.top) * this.fontHeight, addr * this.fontWidth, this.fontHeight);
                        g.setColor(fg);
                        this.drawChars(g, fg, bg, this.buffer.charArray[this.buffer.windowBase + l], c, addr, (c - this.left) * this.fontWidth, (l - this.top) * this.fontHeight);
                        c += addr - 1;
                        ++c;
                    }
                }
                ++l;
            }
            if (this.buffer.showcursor && this.buffer.screenBase + this.buffer.cursorY >= this.buffer.windowBase && this.buffer.screenBase + this.buffer.cursorY < this.buffer.windowBase + this.buffer.height) {
                g.setColor(this.fgcolor);
                g.fillRect((this.buffer.cursorX - this.left) * this.fontWidth, (this.buffer.cursorY - this.top + this.buffer.screenBase - this.buffer.windowBase) * this.fontHeight, this.fontWidth, this.fontHeight);
            }
            this.invalid = false;
        }
    }

    private void initFont() {
        this.fontMode = Settings.fontMode;
        System.out.println("fontMode: " + this.fontMode);
        this.initInternalFont();
        String lcdFontFile = null;
        switch (this.fontMode) {
            case 0: {
                this.initInternalFont();
                break;
            }
            case 1: {
                lcdFontFile = "/font3x6lcd.png";
                break;
            }
            case 2: {
                lcdFontFile = "/font4x6lcd.png";
                break;
            }
            case 3: {
                lcdFontFile = "/font4x7lcd.png";
                break;
            }
            case 4: {
                lcdFontFile = "/font5x9lcd.png";
                break;
            }
            case 5: {
                lcdFontFile = "/font8x13lcd.png";
            }
        }
        if (lcdFontFile != null) {
            boolean BGR;
            boolean bl = BGR = Settings.lcdFontMode != 0;
            if (this.rotated != 0) {
                lcdFontFile = "/font4x6lcdV.png";
                if (this.rotated == 1) {
                    BGR = !BGR;
                }
            }
            this.lcdfont = new LCDFont(lcdFontFile, BGR);
            this.fontWidth = this.lcdfont.fontWidth;
            this.fontHeight = this.lcdfont.fontHeight;
        }
    }

    private void initInternalFont() {
        this.fontWidth = 4;
        this.fontHeight = 6;
        this.fontData = new int[128][];
        try {
            InputStream in = this.getClass().getResourceAsStream(FONT_RESOURCE);
            int i = 33;
            while (i < 128) {
                int b = in.read();
                int l = (b & 3) + 2;
                this.fontData[i] = new int[l];
                this.fontData[i][0] = (b >> 2) - 32;
                int j = 1;
                while (j < l) {
                    this.fontData[i][j] = in.read();
                    ++j;
                }
                ++i;
            }
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initSystemFont(int size) {
        this.font = Font.getFont((int)32, (int)0, (int)size);
        this.fontHeight = this.font.getHeight();
        this.fontWidth = this.font.charWidth('W');
    }

    protected void drawChars(Graphics g, int fg, int bg, char[] chars, int offset, int length, int x, int y) {
        this.fontMode = Settings.fontMode;
        if (this.fontMode == 0) {
            int i = offset;
            while (i < offset + length) {
                this.drawChar(g, chars[i], x, y);
                x += this.fontWidth;
                ++i;
            }
        } else {
            this.lcdfont.setColor(fg, bg);
            int i = offset;
            while (i < offset + length) {
                this.lcdfont.drawChar(g, chars[i], x, y);
                x += this.fontWidth;
                ++i;
            }
        }
    }

    private void drawChar(Graphics g, char c, int x, int y) {
        if (c >= this.fontData.length || this.fontData[c] == null) {
            return;
        }
        int j = 1;
        while (j < this.fontData[c].length) {
            int x1 = this.fontData[c][j] & 3;
            int y1 = (this.fontData[c][j] & 0xC) >> 2;
            int x2 = (this.fontData[c][j] & 0x30) >> 4;
            int y2 = (this.fontData[c][j] & 0xC0) >> 6;
            if (x1 == 3) {
                x1 = y1;
                y1 = 4;
            }
            if (x2 == 3) {
                x2 = y2;
                y2 = 4;
            }
            g.drawLine(x + x1, y + y1, x + x2, y + y2);
            ++j;
        }
        if (this.fontData[c][0] != 0) {
            this.drawChar(g, (char)(c + this.fontData[c][0]), x, y);
        }
    }

    public boolean defaultFontProportional() {
        return false;
    }

    public void eraseLine(int s) {
        System.out.println("EraseLine");
        this.buffer.deleteArea(this.buffer.getCursorColumn(), s, this.cols, 1);
        this.redraw();
    }

    public void eraseWindow(int window) {
        System.out.println("EraseWindow");
        if (window == 0) {
            this.buffer.rows_counted = 0;
            this.buffer.deleteArea(0, 0, this.cols, this.rows);
            this.upper_size = 0;
            this.status_size = 0;
            this.buffer.setCursorPosition(0, 1);
            this.buffer.setTopMargin(1);
        } else if (this.upper_size > 0) {
            this.buffer.deleteArea(0, 0, this.cols, this.upper_size + this.status_size);
        }
    }

    public void fatal(String errmsg) {
        Alert alert = new Alert("Fatal error", errmsg, null, AlertType.ERROR);
        alert.setTimeout(-2);
        this.quit();
    }

    public int[] getCursorPosition() {
        this.cursorpos[0] = this.buffer.getCursorColumn() + 1;
        this.cursorpos[1] = this.buffer.getCursorRow() + 1;
        return this.cursorpos;
    }

    public int getDefaultBackground() {
        return 9;
    }

    public int getDefaultForeground() {
        return 2;
    }

    public String getFilename(String title, String suggested, boolean saveFlag) {
        this.filedialog = new FileDialog(this.midlet, this.settings);
        this.filedialog.running = 1;
        if (saveFlag) {
            this.filedialog.OpenBrowser(1);
        } else {
            this.filedialog.OpenBrowser(2);
        }
        while (this.filedialog.running == 1) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("filename: " + this.filedialog.selected_file);
        return this.filedialog.selected_file;
    }

    public int[] getFontSize() {
        return new int[]{this.fontWidth, this.fontHeight};
    }

    public int[] getScreenCharacters() {
        System.out.println("getScreenCharacters");
        return new int[]{this.cols, this.rows};
    }

    public int[] getScreenUnits() {
        return new int[]{this.fontWidth * this.cols, this.fontHeight * this.rows};
    }

    public int[] getWindowSize(int window) {
        if (window == 0) {
            return new int[]{this.cols, this.rows - (this.upper_size + this.status_size)};
        }
        return new int[]{this.cols, this.upper_size};
    }

    public boolean hasBoldface() {
        return false;
    }

    public boolean hasColors() {
        return false;
    }

    public boolean hasFixedWidth() {
        return true;
    }

    public boolean hasItalic() {
        return false;
    }

    public boolean hasStatusLine() {
        return true;
    }

    public boolean hasUpperWindow() {
        return true;
    }

    public void initialize(int ver) {
    }

    public void quit() {
        this.midlet.notifyDestroyed();
    }

    public int readChar(int time) {
        this.buffer.rows_counted = 0;
        int t = 0;
        System.out.println("readchar: time = " + time);
        this.new_char = 0;
        this.read_char = 1;
        while (this.new_char == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (++t <= time || time == 0) continue;
            return 0;
        }
        this.read_char = 0;
        if (this.new_char == 10) {
            this.new_char = 13;
        }
        if (this.new_char == -8 || this.new_char == 127) {
            this.new_char = 8;
        }
        return this.new_char;
    }

    public boolean hasTimedInput() {
        return true;
    }

    public void restart() {
        this.eraseWindow(0);
    }

    public void scrollWindow(int lines) {
        System.out.println("scrollWindow not implemented");
    }

    public void setColor(int fg, int bg) {
        System.out.println("setColor not implemented");
    }

    public void setCurrentWindow(int window) {
        this.cursor_row[this.previous_window] = this.buffer.getCursorRow();
        this.cursor_col[this.previous_window] = this.buffer.getCursorColumn();
        this.buffer.setCursorPosition(this.cursor_col[window], this.cursor_row[window]);
        this.previous_window = window;
        if (window == 1) {
            this.buffer.setCursorPosition(0, this.status_size);
        }
        System.out.println("setCurrentWindow: " + window);
    }

    public void setCursorPosition(int x, int y) {
        System.out.println("setCursorPosition:" + x + "," + y);
        this.buffer.setCursorPosition(x - 1, y - 1);
        this.redraw();
    }

    public void setFont(int font) {
        System.out.println("setFont not implemented: " + font);
    }

    public void setTerminatingCharacters(Vector chars) {
        System.out.print("setTerminatingCharacters: ");
        Enumeration enumm = chars.elements();
        while (enumm.hasMoreElements()) {
            System.out.print(enumm.nextElement() + " ");
        }
        System.out.println();
    }

    public void setTextStyle(int style) {
        this.Last_style = style;
        System.out.println("setTextStyle: " + style);
        if (style == 0) {
            this.buffer.setAttributes(0);
        }
        if (style == 1) {
            this.buffer.setAttributes(4);
        }
        if (style == 2) {
            this.buffer.setAttributes(2);
        }
        if (style == 3) {
            this.buffer.setAttributes(1);
        }
        if (style == 4) {
            this.buffer.setAttributes(0);
        }
        this.redraw();
    }

    public void showStatusBar(String s, int a, int b, boolean flag) {
        String stmp;
        this.buffer.rows_counted = 0;
        this.status_size = 1;
        this.buffer.setTopMargin(this.upper_size + this.status_size);
        this.redraw();
        int tmp_style = this.Last_style;
        int tmp_col = this.buffer.getCursorColumn();
        int tmp_row = this.buffer.getCursorRow();
        this.buffer.setCursorPosition(0, 0);
        this.setTextStyle(1);
        if (flag) {
            stmp = a == 0 || a == 24 ? " 12:" : (a < 13 ? " " + a + ":" : " " + (a - 12) + ":");
            stmp = b < 10 ? String.valueOf(stmp) + "0" + b : String.valueOf(stmp) + b;
            stmp = a < 12 ? String.valueOf(stmp) + " AM" : String.valueOf(stmp) + " PM";
        } else {
            stmp = " " + a + "/" + b;
        }
        String stmp2 = "";
        int len = s.length() + stmp.length();
        if (len > this.cols) {
            if (s.length() > this.cols) {
                this.buffer.putStringUpper(String.valueOf(s.substring(0, this.cols - 4)) + "...");
            } else {
                this.buffer.putStringUpper(s);
                stmp2 = "";
                int i = 0;
                while (i < this.cols) {
                    stmp2 = String.valueOf(stmp2) + " ";
                    ++i;
                }
            }
            this.buffer.putStringUpper(stmp2);
        } else {
            this.buffer.putStringUpper(s);
            stmp2 = "";
            int i = len;
            while (i < this.cols) {
                stmp2 = String.valueOf(stmp2) + " ";
                ++i;
            }
            this.buffer.putStringUpper(String.valueOf(stmp2) + stmp);
        }
        this.setTextStyle(tmp_style);
        this.buffer.setCursorPosition(tmp_col, tmp_row);
        this.redraw();
    }

    public void setBufferMode(boolean buffermode) {
        this.buffermode = buffermode;
    }

    public void showString(String s) {
        if (this.previous_window == 0) {
            if (!this.buffermode || this.buffer.getCursorColumn() + s.length() < this.cols) {
                this.buffer.putString(s);
            } else {
                StringTokenizer st = new StringTokenizer(s, "\t ", true);
                String str = new String();
                while (st.hasMoreTokens()) {
                    String word = st.nextToken();
                    if (this.buffer.getCursorColumn() + str.length() + word.length() > this.cols) {
                        this.buffer.putString(String.valueOf(str) + "\n");
                        str = "";
                    }
                    str = String.valueOf(str) + word;
                    if (word.indexOf("\n") == -1) continue;
                    this.buffer.putString(str);
                    str = "";
                }
                this.buffer.putString(str);
            }
        } else {
            this.buffer.putStringUpper(s);
        }
        this.redraw();
    }

    public void splitScreen(int lines) {
        this.upper_size = lines;
        this.buffer.deleteArea(0, this.status_size, this.cols, this.upper_size);
        if (this.buffer.getCursorRow() <= this.upper_size + this.status_size) {
            this.buffer.setCursorPosition(0, this.upper_size + this.status_size);
        }
        this.buffer.setTopMargin(this.upper_size + this.status_size);
        this.redraw();
        System.out.println("splitScreen: " + lines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readLine(StringBuffer sbuf, int time) {
        this.reading_line = 1;
        System.out.println("readline: time = " + time);
        this.buffer.rows_counted = 0;
        try {
            Vector vector = this.inputQueue;
            synchronized (vector) {
                if (this.inputQueue.size() > 0) {
                    sbuf.append((String)this.inputQueue.firstElement());
                    this.inputQueue.removeElementAt(0);
                } else {
                    try {
                        this.inputQueue.wait(time * 100);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.inputQueue.size() > 0) {
                        sbuf.append((String)this.inputQueue.firstElement());
                        this.inputQueue.removeElementAt(0);
                        this.reading_line = 0;
                        return 1;
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.reading_line = 0;
        return -1;
    }
}

