/*
 * Decompiled with CFR 0.152.
 */
package com.zaxsoft.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.util.StringTokenizer;
import java.util.Vector;

public class TextScreen
extends Component {
    public static final int KEYECHO = 1;
    public static final int CURSOR = 2;
    public static final int AUTOWRAP = 4;
    protected static final int WRITE = 1;
    protected static final int READLINE = 2;
    protected static final int READCHAR = 3;
    private int rows;
    private int cols;
    private int attributes;
    private boolean rvsMode;
    private int state;
    private Thread readThread;
    private StringBuffer readString;
    private int readTerminator;
    private int curReadChar;
    private FontMetrics curFontMetrics;
    private int fontHeight;
    private int fontMaxWidth;
    private int fontAscent;
    private Rectangle curRegion;
    private Vector terminators;
    private Image offscreen;
    private int curRow;
    private int curCol;
    private int cursorX;
    private int cursorY;

    public TextScreen(Font initialFont, Color bgColor, Color fgColor, int initialRows, int initialCols, int attrs) {
        this.rows = initialRows;
        this.cols = initialCols;
        this.attributes = attrs;
        this.rvsMode = false;
        this.state = 1;
        this.setBackground(bgColor);
        this.setForeground(fgColor);
        this.setFont(initialFont);
        this.curFontMetrics = this.getFontMetrics(this.getFont());
        this.fontHeight = this.curFontMetrics.getHeight();
        this.fontMaxWidth = this.getFont().getName().equals("Monospaced") ? this.curFontMetrics.charWidth('W') : this.curFontMetrics.getMaxAdvance();
        this.fontAscent = this.curFontMetrics.getMaxAscent();
        this.curRegion = new Rectangle(0, 0, this.cols, this.rows);
        this.terminators = new Vector();
        this.terminators.addElement(new Integer(13));
        this.addKeyListener(new TextScreenKeyboardEventHandler(this));
    }

    public void setTerminators(Vector chars) {
        this.terminators = (Vector)chars.clone();
    }

    public Vector getTerminators() {
        return this.terminators;
    }

    public void resizeToFit() {
        int height = this.fontHeight * this.rows;
        int width = this.fontMaxWidth * this.cols;
        this.setSize(width, height);
        this.curRegion = new Rectangle(0, 0, this.cols, this.rows);
        Dimension s = this.getSize();
        this.offscreen = this.createImage(s.width, s.height);
        this.clearScreen();
    }

    public void clearScreen() {
        Graphics g = this.offscreen.getGraphics();
        g.setColor(this.getBackground());
        g.fillRect(this.curRegion.x * this.fontMaxWidth, this.curRegion.y * this.fontHeight, this.curRegion.width * this.fontMaxWidth, this.curRegion.height * this.fontHeight);
        this.curRow = this.curRegion.x;
        this.curCol = this.curRegion.y;
        this.cursorX = this.curCol * this.fontMaxWidth;
        this.cursorY = this.curRow * this.fontHeight;
        g = this.getGraphics();
        this.paint(g);
    }

    public void setRegion(Rectangle region) {
        this.curRegion = region;
    }

    public Rectangle getRegion() {
        return this.curRegion;
    }

    public void printString(String str) {
        Dimension s = this.getSize();
        Graphics g = this.offscreen.getGraphics();
        int maxCol = this.curRegion.x + this.curRegion.width;
        int maxRow = this.curRegion.y + this.curRegion.height;
        g.setColor(this.getForeground());
        g.setFont(this.getFont());
        StringTokenizer st = new StringTokenizer(str, "\b\n\r", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("\n")) {
                this.cursorX = this.curRegion.x * this.fontMaxWidth;
                this.curCol = this.curRegion.x;
                if (this.curRow + 1 == maxRow) {
                    this.scrollUp(1);
                }
                ++this.curRow;
                this.cursorY += this.fontHeight;
                continue;
            }
            if (token.equals("\b")) {
                if (this.curCol > this.curRegion.x) {
                    this.gotoXY(this.curCol - 1, this.curRow);
                } else if (this.curRow > this.curRegion.y) {
                    this.gotoXY(this.cols - 1, this.curRow - 1);
                }
                g.setColor(this.getBackground());
                g.fillRect(this.cursorX, this.cursorY, this.fontMaxWidth, this.fontHeight);
                g.setColor(this.getForeground());
                continue;
            }
            if (token.equals("\r")) {
                this.gotoXY(this.curRegion.x, this.curRow);
                continue;
            }
            if ((this.attributes & 4) == 4) {
                while (this.curCol + token.length() >= maxCol) {
                    String sub = token.substring(0, maxCol - this.curCol);
                    if (this.rvsMode) {
                        g.fillRect(this.cursorX, this.cursorY, this.curFontMetrics.stringWidth(sub), this.fontHeight);
                        g.setColor(this.getBackground());
                    } else {
                        g.setColor(this.getBackground());
                        g.fillRect(this.cursorX, this.cursorY, this.curFontMetrics.stringWidth(sub), this.fontHeight);
                        g.setColor(this.getForeground());
                    }
                    g.drawString(sub, this.cursorX, this.cursorY + this.fontAscent);
                    if (this.rvsMode) {
                        g.setColor(this.getForeground());
                    }
                    token = token.substring(maxCol - this.curCol);
                    this.cursorX = this.curRegion.x * this.fontMaxWidth;
                    this.curCol = this.curRegion.x;
                    if (this.curRow + 1 == maxRow) {
                        this.scrollUp(1);
                    }
                    ++this.curRow;
                    this.cursorY += this.fontHeight;
                }
            }
            if (this.rvsMode) {
                g.fillRect(this.cursorX, this.cursorY, this.curFontMetrics.stringWidth(token), this.fontHeight);
                g.setColor(this.getBackground());
            } else {
                g.setColor(this.getBackground());
                g.fillRect(this.cursorX, this.cursorY, this.curFontMetrics.stringWidth(token), this.fontHeight);
                g.setColor(this.getForeground());
            }
            g.drawString(token, this.cursorX, this.cursorY + this.fontAscent);
            if (this.rvsMode) {
                g.setColor(this.getForeground());
            }
            this.curCol += token.length();
            this.cursorX += token.length() * this.fontMaxWidth;
        }
        g = this.getGraphics();
        this.paint(g);
    }

    public void newline() {
        this.cursorX = this.curRegion.x * this.fontMaxWidth;
        this.curCol = this.curRegion.x;
        this.cursorY += this.fontHeight;
        ++this.curRow;
        if (this.curRow == this.curRegion.x + this.curRegion.height) {
            this.scrollUp(1);
        }
        Graphics g = this.getGraphics();
        this.paint(g);
    }

    public void gotoXY(int x, int y) {
        this.curCol = x < this.cols ? x : this.cols - 1;
        this.curRow = y < this.rows ? y : this.rows - 1;
        this.cursorX = this.curCol * this.fontMaxWidth;
        this.cursorY = this.curRow * this.fontHeight;
    }

    public void scrollUp(int numLines) {
        if (numLines < 1) {
            return;
        }
        if (numLines >= this.curRegion.height) {
            this.clearScreen();
            return;
        }
        Graphics g = this.offscreen.getGraphics();
        Dimension s = this.getSize();
        int scrollSize = numLines * this.fontHeight;
        g.copyArea(this.curRegion.x * this.fontMaxWidth, this.curRegion.y * this.fontHeight + scrollSize, this.curRegion.width * this.fontMaxWidth, this.curRegion.height * this.fontHeight - scrollSize, 0, -scrollSize);
        g.setColor(this.getBackground());
        g.fillRect(this.curRegion.x * this.fontMaxWidth, (this.curRegion.y + this.curRegion.height) * this.fontHeight - scrollSize, this.curRegion.width * this.fontMaxWidth, scrollSize);
        g.setColor(this.getForeground());
        this.curRow -= numLines;
        this.cursorY = this.curRow * this.fontHeight;
    }

    public void reverseVideo(boolean mode) {
        this.rvsMode = mode;
    }

    public void setFontStyle(int style) {
        Font f = this.getFont();
        int newstyle = style == 0 ? 0 : f.getStyle() | style;
        this.setFont(new Font(f.getName(), newstyle, f.getSize()));
    }

    public Point getCursorPosition() {
        Point d = new Point(this.curCol, this.curRow);
        return d;
    }

    public Dimension getScreenSize() {
        Dimension d = new Dimension(this.cols, this.rows);
        return d;
    }

    public synchronized void setScreenSize(int width, int height) {
        this.rows = height;
        this.cols = width;
        this.resizeToFit();
    }

    public synchronized void setScreenSize(int width, int height, boolean saveBottom) {
        Rectangle r = new Rectangle();
        if (height < this.rows) {
            if (saveBottom) {
                r.x = 0;
                r.y = this.rows * this.fontHeight - height * this.fontHeight;
                r.width = width * this.fontMaxWidth;
                r.height = height * this.fontHeight;
            } else {
                r.x = 0;
                r.y = 0;
                r.width = width * this.fontMaxWidth;
                r.height = height * this.fontHeight;
            }
        } else {
            r.x = 0;
            r.y = 0;
            r.width = this.getSize().width;
            r.height = this.getSize().height;
        }
        CropImageFilter filter = new CropImageFilter(r.x, r.y, r.width, r.height);
        Image oldScreen = this.getToolkit().createImage(new FilteredImageSource(this.offscreen.getSource(), filter));
        int oldRows = this.rows;
        int oldCols = this.cols;
        this.rows = height;
        this.cols = width;
        height = this.fontHeight * this.rows;
        width = this.fontMaxWidth * this.cols;
        this.setSize(width, height);
        Dimension s = this.getSize();
        this.offscreen = this.createImage(s.width, s.height);
        Graphics g = this.offscreen.getGraphics();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, s.width, s.height);
        g.setColor(this.getForeground());
        g.drawImage(oldScreen, 0, 0, this);
        this.curRow -= oldRows - this.rows;
        if (this.curRow < 0 || this.curRow >= this.rows || this.curCol < 0 || this.curCol >= this.cols) {
            this.curCol = 0;
            this.curRow = 0;
        }
        this.cursorX = this.curCol * this.fontMaxWidth;
        this.cursorY = this.curRow * this.fontHeight;
        g = this.getGraphics();
        this.paint(g);
    }

    public Dimension getFontSize() {
        Dimension d = new Dimension(this.fontMaxWidth, this.fontHeight);
        return d;
    }

    public void setAttributes(int attrs) {
        this.attributes = attrs;
    }

    public int getAttributes() {
        return this.attributes;
    }

    public synchronized int readLine(StringBuffer sb) {
        Graphics g = this.getGraphics();
        if ((this.attributes & 2) == 2) {
            g.setColor(this.getForeground());
            g.fillRect(this.cursorX + 1, this.cursorY + 1, this.fontMaxWidth - 2, this.fontHeight - 2);
        }
        this.readString = sb;
        this.readThread = Thread.currentThread();
        this.state = 2;
        try {
            while (true) {
                Thread.currentThread();
                Thread.sleep(Long.MAX_VALUE);
            }
        }
        catch (InterruptedException interruptedException) {
            this.readThread = null;
            if ((this.attributes & 2) == 2) {
                g.setColor(this.getBackground());
                g.clearRect(this.cursorX + 1, this.cursorY + 1, this.fontMaxWidth - 2, this.fontHeight - 2);
            }
            return this.readTerminator;
        }
    }

    public synchronized int readLine(StringBuffer sb, long time) {
        Graphics g = this.getGraphics();
        boolean timedOut = false;
        if ((this.attributes & 2) == 2) {
            g.setColor(this.getForeground());
            g.fillRect(this.cursorX + 1, this.cursorY + 1, this.fontMaxWidth - 2, this.fontHeight - 2);
        }
        this.readString = sb;
        this.readThread = Thread.currentThread();
        this.state = 2;
        try {
            Thread.currentThread();
            Thread.sleep(time);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.readThread = null;
        if (this.state == 2) {
            this.state = 1;
            timedOut = true;
        }
        if ((this.attributes & 2) == 2) {
            g.setColor(this.getBackground());
            g.clearRect(this.cursorX + 1, this.cursorY + 1, this.fontMaxWidth - 2, this.fontHeight - 2);
        }
        if (timedOut) {
            return -1;
        }
        return this.readTerminator;
    }

    public synchronized int readChar() {
        Graphics g = this.getGraphics();
        if ((this.attributes & 2) == 2) {
            g.setColor(this.getForeground());
            g.fillRect(this.cursorX + 1, this.cursorY + 1, this.fontMaxWidth - 2, this.fontHeight - 2);
        }
        this.readThread = Thread.currentThread();
        this.state = 3;
        try {
            while (true) {
                Thread.currentThread();
                Thread.sleep(Long.MAX_VALUE);
            }
        }
        catch (InterruptedException interruptedException) {
            this.readThread = null;
            if ((this.attributes & 2) == 2) {
                g.setColor(this.getBackground());
                g.clearRect(this.cursorX + 1, this.cursorY + 1, this.fontMaxWidth - 2, this.fontHeight - 2);
            }
            return this.curReadChar;
        }
    }

    public synchronized int readChar(long time) {
        Graphics g = this.getGraphics();
        boolean timedOut = false;
        if ((this.attributes & 2) == 2) {
            g.setColor(this.getForeground());
            g.fillRect(this.cursorX + 1, this.cursorY + 1, this.fontMaxWidth - 2, this.fontHeight - 2);
        }
        this.readThread = Thread.currentThread();
        this.state = 3;
        try {
            Thread.currentThread();
            Thread.sleep(time);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.readThread = null;
        if (this.state == 3) {
            this.state = 1;
            timedOut = true;
        }
        if ((this.attributes & 2) == 2) {
            g.setColor(this.getBackground());
            g.clearRect(this.cursorX + 1, this.cursorY + 1, this.fontMaxWidth - 2, this.fontHeight - 2);
        }
        if (timedOut) {
            return -1;
        }
        return this.curReadChar;
    }

    public void paint(Graphics g) {
        if (this.offscreen != null) {
            g.drawImage(this.offscreen, 0, 0, this);
        }
        if ((this.attributes & 2) == 2 && this.state != 1) {
            g.setColor(this.getForeground());
            g.fillRect(this.cursorX + 1, this.cursorY + 1, this.fontMaxWidth - 2, this.fontHeight - 2);
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.cols * this.fontMaxWidth, this.rows * this.fontHeight);
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.cols * this.fontMaxWidth, this.rows * this.fontHeight);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.cols * this.fontMaxWidth, this.rows * this.fontHeight);
    }

    public void addNotify() {
        super.addNotify();
        this.resizeToFit();
    }

    class TextScreenKeyboardEventHandler
    extends KeyAdapter {
        TextScreen parentObject;

        public TextScreenKeyboardEventHandler(TextScreen myParent) {
            this.parentObject = myParent;
        }

        public void keyTyped(KeyEvent e) {
            char key = e.getKeyChar();
            switch (this.parentObject.state) {
                case 2: {
                    if (this.parentObject.terminators.contains(new Integer(key))) {
                        this.parentObject.state = 1;
                        this.parentObject.readTerminator = key;
                        if (((char)key == '\r' || (char)key == '\n') && (this.parentObject.attributes & 1) == 1) {
                            this.parentObject.printString("\n");
                        }
                        this.parentObject.readThread.interrupt();
                        return;
                    }
                    if ((this.parentObject.attributes & 1) == 1 && ((char)key != '\b' || this.parentObject.readString.length() != 0)) {
                        this.parentObject.printString(String.valueOf(key));
                    }
                    switch ((char)key) {
                        case '\b': {
                            if (this.parentObject.readString.length() <= 0) break;
                            this.parentObject.readString.setLength(this.parentObject.readString.length() - 1);
                            break;
                        }
                        default: {
                            this.parentObject.readString.append(String.valueOf(key));
                        }
                    }
                    return;
                }
                case 3: {
                    this.parentObject.curReadChar = key;
                    if ((this.parentObject.attributes & 1) == 1) {
                        this.parentObject.printString(String.valueOf(key));
                    }
                    this.parentObject.state = 1;
                    this.parentObject.readThread.interrupt();
                    return;
                }
                case 1: {
                    return;
                }
            }
        }
    }
}

