/*
 * Decompiled with CFR 0.152.
 */
package com.zaxsoft.apps.zax;

import com.zaxsoft.apps.zax.ZaxWindow;
import com.zaxsoft.awt.TextScreen;
import com.zaxsoft.zmachine.ZCPU;
import com.zaxsoft.zmachine.ZUserInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class Zax
extends Frame
implements ZUserInterface {
    static String versionString = "0.91";
    ZCPU cpu;
    TextScreen screen;
    ZaxWindow[] windows;
    ZaxWindow curWindow;
    ZaxWindow statusBar;
    Dimension screenSize;
    int version = 0;
    int moreLines = 0;
    Hashtable inputCharacters;
    Vector terminatingCharacters;
    Thread cpuThread = null;

    public static void main(String[] args) {
        Zax j = new Zax();
    }

    public Zax() {
        this.setTitle("Zax v" + versionString);
        MenuBar mb = new MenuBar();
        Menu m = new Menu("File");
        m.add("Play Story...");
        m.addSeparator();
        m.add("Exit");
        mb.add(m);
        this.setMenuBar(mb);
        this.setResizable(false);
        this.screen = new TextScreen(new Font("Monospaced", 0, 12), Color.blue, Color.white, 25, 80, 0);
        this.add(this.screen);
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + this.screen.getPreferredSize().width, ins.top + ins.bottom + this.screen.getPreferredSize().height);
        this.show();
    }

    public boolean action(Event evt, Object what) {
        if ("Play Story...".equals(what)) {
            this.playStory();
            return true;
        }
        if ("Exit".equals(what)) {
            System.exit(0);
        }
        return false;
    }

    private void playStory() {
        if (this.cpuThread != null) {
            return;
        }
        this.cpu = new ZCPU(this);
        FileDialog fd = new FileDialog((Frame)this, "Open a Storyfile", 0);
        fd.show();
        String dir = fd.getDirectory();
        String file = fd.getFile();
        if (dir == null || file == null) {
            return;
        }
        String pathname = dir + file;
        this.cpu.initialize(pathname);
        this.cpuThread = this.cpu.start();
    }

    private void switchWindow(ZaxWindow w) {
        this.curWindow.cursorPosition = this.screen.getCursorPosition();
        this.curWindow = w;
        this.screen.setRegion(w.shape);
        this.setTextStyle(this.curWindow.tstyle);
        this.screen.gotoXY(w.cursorPosition.x, w.cursorPosition.y);
        if (w == this.windows[0]) {
            this.screen.setAttributes(3);
        } else {
            this.screen.setAttributes(0);
        }
    }

    public void fatal(String errmsg) {
        this.screen.printString("FATAL ERROR: " + errmsg + "\n");
        this.screen.printString("Hit a key to exit.\n");
        this.screen.readChar();
        System.exit(1);
    }

    public void initialize(int ver) {
        this.inputCharacters = new Hashtable(16);
        this.inputCharacters.put(new Integer(1004), new Integer(129));
        this.inputCharacters.put(new Integer(1005), new Integer(130));
        this.inputCharacters.put(new Integer(1006), new Integer(131));
        this.inputCharacters.put(new Integer(1007), new Integer(132));
        this.inputCharacters.put(new Integer(1008), new Integer(133));
        this.inputCharacters.put(new Integer(1009), new Integer(134));
        this.inputCharacters.put(new Integer(1010), new Integer(135));
        this.inputCharacters.put(new Integer(1011), new Integer(136));
        this.inputCharacters.put(new Integer(1012), new Integer(137));
        this.inputCharacters.put(new Integer(1013), new Integer(138));
        this.inputCharacters.put(new Integer(1014), new Integer(139));
        this.inputCharacters.put(new Integer(1015), new Integer(140));
        this.inputCharacters.put(new Integer(1016), new Integer(141));
        this.inputCharacters.put(new Integer(1017), new Integer(142));
        this.inputCharacters.put(new Integer(1018), new Integer(143));
        this.inputCharacters.put(new Integer(1019), new Integer(144));
        this.terminatingCharacters = new Vector();
        this.terminatingCharacters.addElement(new Integer(13));
        this.terminatingCharacters.addElement(new Integer(10));
        this.version = ver;
        if (this.screen != null) {
            this.remove(this.screen);
        }
        this.screenSize = new Dimension(80, 25);
        this.screen = new TextScreen(new Font("Monospaced", 0, 12), Color.blue, Color.white, this.screenSize.height, this.screenSize.width, 0);
        this.add(this.screen);
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + this.screen.getPreferredSize().width, ins.top + ins.bottom + this.screen.getPreferredSize().height);
        this.show();
        this.screen.setTerminators(this.terminatingCharacters);
        if (this.version == 1 || this.version == 2) {
            this.statusBar = new ZaxWindow(0, 0, this.screenSize.width, 1);
            this.windows = new ZaxWindow[1];
            this.windows[0] = new ZaxWindow(0, 1, this.screenSize.width, this.screenSize.height - 1);
            this.curWindow = this.windows[0];
            this.screen.gotoXY(this.windows[0].shape.x, this.windows[0].shape.y);
            this.screen.setAttributes(3);
            this.screen.setRegion(this.windows[0].shape);
            this.windows[0].cursorPosition = this.screen.getCursorPosition();
            this.statusBar.cursorPosition = new Point(0, 0);
            return;
        }
        if (this.version == 3) {
            this.statusBar = new ZaxWindow(0, 0, this.screenSize.width, 1);
            this.windows = new ZaxWindow[2];
            this.windows[1] = new ZaxWindow(0, 1, this.screenSize.width, 0);
            this.windows[0] = new ZaxWindow(0, 1, this.screenSize.width, this.screenSize.height - 1);
            this.curWindow = this.windows[0];
            this.screen.setAttributes(3);
            this.screen.setRegion(this.windows[0].shape);
            this.screen.gotoXY(this.windows[0].shape.x, this.windows[0].shape.y);
            this.windows[0].cursorPosition = this.screen.getCursorPosition();
            this.windows[1].cursorPosition = new Point(0, 1);
            this.statusBar.cursorPosition = new Point(0, 0);
            return;
        }
        if (this.version >= 4 && this.version <= 8 && this.version != 6) {
            this.windows = new ZaxWindow[2];
            this.windows[0] = new ZaxWindow(0, 1, this.screenSize.width, this.screenSize.height - 1);
            this.windows[1] = new ZaxWindow(0, 0, this.screenSize.width, 1);
            this.curWindow = this.windows[0];
            this.screen.setAttributes(3);
            this.screen.setRegion(this.windows[0].shape);
            this.screen.gotoXY(this.windows[0].shape.x, this.windows[0].shape.y);
            this.windows[0].cursorPosition = this.screen.getCursorPosition();
            this.windows[1].cursorPosition = new Point(0, 0);
            return;
        }
        System.out.println("Unsupported storyfile version.");
        System.exit(1);
    }

    public void setTerminatingCharacters(Vector chars) {
        for (int i = 0; i < chars.size(); ++i) {
            Integer c = (Integer)chars.elementAt(i);
            Enumeration e = this.inputCharacters.keys();
            boolean found = false;
            while (e.hasMoreElements()) {
                Integer key = (Integer)e.nextElement();
                Integer element = (Integer)this.inputCharacters.get(key);
                if (element != c) continue;
                this.terminatingCharacters.addElement(key);
                found = true;
                break;
            }
            if (found) continue;
            this.terminatingCharacters.addElement(c);
        }
        this.screen.setTerminators(this.terminatingCharacters);
    }

    public boolean hasStatusLine() {
        return this.version >= 1 && this.version <= 3;
    }

    public boolean hasUpperWindow() {
        return this.version >= 3;
    }

    public boolean defaultFontProportional() {
        return false;
    }

    public boolean hasFixedWidth() {
        return true;
    }

    public boolean hasColors() {
        return true;
    }

    public boolean hasItalic() {
        return true;
    }

    public boolean hasBoldface() {
        return true;
    }

    public boolean hasTimedInput() {
        return true;
    }

    public int getDefaultBackground() {
        return 6;
    }

    public int getDefaultForeground() {
        return 9;
    }

    public void showStatusBar(String s, int a, int b, boolean flag) {
        String s3;
        String s2;
        ZaxWindow lastWindow = this.curWindow;
        this.switchWindow(this.statusBar);
        this.screen.reverseVideo(true);
        String s1 = new String(" " + s + " ");
        if (flag) {
            s2 = new String(" Time: " + a + ":");
            if (b < 10) {
                s2 = s2 + "0";
            }
            s2 = s2 + b;
            s3 = new String(" ");
        } else {
            s2 = new String(" Score: " + a + " ");
            s3 = new String(" Turns: " + b + " ");
        }
        String status = new String(s1);
        for (int i = 0; i < this.screenSize.width - (s1.length() + s2.length() + s3.length()); ++i) {
            status = status + " ";
        }
        status = status + s2 + s3;
        this.screen.printString(status);
        this.screen.reverseVideo(false);
        this.switchWindow(lastWindow);
    }

    public void splitScreen(int lines) {
        if (lines > this.screenSize.height) {
            lines = this.screenSize.height;
        }
        this.curWindow.cursorPosition = this.screen.getCursorPosition();
        this.windows[1].shape = new Rectangle(0, 0, this.screenSize.width, lines);
        if (this.windows[1].cursorPosition.y >= this.windows[1].shape.height) {
            this.windows[1].cursorPosition = new Point(0, 0);
        }
        this.windows[0].shape = new Rectangle(0, lines, this.screenSize.width, this.screenSize.height - lines);
        if (this.windows[0].cursorPosition.y < this.windows[0].shape.y) {
            this.windows[0].cursorPosition = new Point(0, this.windows[0].shape.y);
        }
        this.screen.gotoXY(this.curWindow.cursorPosition.x, this.curWindow.cursorPosition.y);
        this.screen.setRegion(this.curWindow.shape);
    }

    public void setCurrentWindow(int window) {
        this.switchWindow(this.windows[window]);
        if (window == 1) {
            if (this.version < 4) {
                this.screen.clearScreen();
            }
            this.screen.gotoXY(this.curWindow.shape.x, this.curWindow.shape.y);
        }
    }

    public int readLine(StringBuffer sb, int time) {
        this.moreLines = 0;
        this.screen.requestFocus();
        int rc = time == 0 ? this.screen.readLine(sb) : this.screen.readLine(sb, time * 100);
        if (rc == -2) {
            this.fatal("Unspecified input error");
        }
        if (rc == -1) {
            return -1;
        }
        Integer zc = (Integer)this.inputCharacters.get(new Integer(rc));
        if (zc == null) {
            return rc;
        }
        return zc;
    }

    public int readChar(int time) {
        this.moreLines = 0;
        this.screen.requestFocus();
        int key = time == 0 ? this.screen.readChar() : this.screen.readChar(time * 100);
        if (key == -2) {
            this.fatal("Unspecified input error");
        }
        if (key == -1) {
            return -1;
        }
        Integer zchar = (Integer)this.inputCharacters.get(new Integer(key));
        if (zchar == null) {
            return key;
        }
        return zchar;
    }

    public void showString(String s) {
        int scrollLines = 0;
        if (this.curWindow != this.windows[0]) {
            this.screen.printString(s);
            return;
        }
        Point cursor = this.screen.getCursorPosition();
        cursor.x -= this.curWindow.shape.x;
        cursor.y -= this.curWindow.shape.y;
        int curCol = cursor.x;
        scrollLines = cursor.y < this.curWindow.shape.height - 1 ? -(this.curWindow.shape.height - cursor.y - 1) : 0;
        String outstr = new String();
        StringTokenizer intokens = new StringTokenizer(s, "\n ", true);
        while (intokens.hasMoreTokens()) {
            int junk;
            int oldattrs;
            String curtoken = intokens.nextToken();
            if (curtoken.equals("\n")) {
                outstr = outstr + "\n";
                ++scrollLines;
                ++this.moreLines;
                curCol = 0;
                if (this.moreLines < this.curWindow.shape.height - 1) continue;
                this.screen.scrollUp(scrollLines);
                scrollLines = 0;
                this.screen.printString(outstr);
                outstr = new String();
                this.screen.reverseVideo(true);
                this.screen.printString("[--More--]");
                this.screen.reverseVideo(false);
                oldattrs = this.screen.getAttributes();
                this.screen.setAttributes(oldattrs & 0xFFFFFFFE);
                this.screen.requestFocus();
                junk = this.screen.readChar();
                this.screen.setAttributes(oldattrs);
                this.screen.printString("\b\b\b\b\b\b\b\b\b\b");
                this.moreLines = 0;
                continue;
            }
            if (curtoken.length() + curCol > this.curWindow.shape.width - 2) {
                if (curtoken.equals(" ")) continue;
                outstr = outstr + "\n";
                ++scrollLines;
                ++this.moreLines;
                curCol = 0;
                if (this.moreLines >= this.curWindow.shape.height - 1) {
                    this.screen.scrollUp(scrollLines);
                    scrollLines = 0;
                    this.screen.printString(outstr);
                    outstr = new String();
                    this.screen.reverseVideo(true);
                    this.screen.printString("[--More--]");
                    this.screen.reverseVideo(false);
                    oldattrs = this.screen.getAttributes();
                    this.screen.setAttributes(oldattrs & 0xFFFFFFFE);
                    this.screen.requestFocus();
                    junk = this.screen.readChar();
                    this.screen.setAttributes(oldattrs);
                    this.screen.printString("\b\b\b\b\b\b\b\b\b\b");
                    this.moreLines = 0;
                }
            }
            outstr = outstr + curtoken;
            curCol += curtoken.length();
        }
        if (scrollLines > 0) {
            this.screen.scrollUp(scrollLines);
        }
        if (outstr.length() > 0) {
            this.screen.printString(outstr);
        }
    }

    public void scrollWindow(int lines) {
        if (lines < 0) {
            this.fatal("Scroll down not yet implemented");
        }
        this.screen.scrollUp(lines);
    }

    public void eraseLine(int size) {
        this.fatal("eraseLine not yet implemented");
    }

    public void eraseWindow(int window) {
        ZaxWindow lastWindow = this.curWindow;
        this.switchWindow(this.windows[window]);
        this.screen.clearScreen();
        this.switchWindow(lastWindow);
    }

    public String getFilename(String title, String suggested, boolean saveFlag) {
        FileDialog fd = new FileDialog((Frame)this, title, saveFlag ? 1 : 0);
        if (suggested != null) {
            fd.setFile(suggested);
        } else if (saveFlag) {
            fd.setFile("*.zav");
        }
        fd.show();
        String s = fd.getFile();
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return null;
        }
        int i = s.indexOf(".*", 0);
        if (i > -1) {
            s = s.substring(0, i);
        }
        return fd.getDirectory() + s;
    }

    public Point getCursorPosition() {
        Point p = this.screen.getCursorPosition();
        p.x -= this.curWindow.shape.x;
        p.y -= this.curWindow.shape.y;
        ++p.x;
        ++p.y;
        return p;
    }

    public void setCursorPosition(int x, int y) {
        --x;
        --y;
        this.screen.gotoXY(x += this.curWindow.shape.x, y += this.curWindow.shape.y);
    }

    public void setFont(int font) {
        System.out.println("Ignored a SET_FONT!");
    }

    public Dimension getFontSize() {
        Dimension d = this.screen.getFontSize();
        return d;
    }

    public Dimension getWindowSize(int window) {
        return new Dimension(this.windows[window].shape.width, this.windows[window].shape.height);
    }

    public void setColor(int fg, int bg) {
        System.out.println("Ignored a SET_COLOR!");
    }

    public void setTextStyle(int style) {
        this.curWindow.tstyle = style;
        if (style == 0) {
            this.screen.reverseVideo(false);
            this.screen.setFontStyle(0);
            return;
        }
        if ((style & 1) == 1) {
            this.screen.reverseVideo(true);
        }
        if ((style & 2) == 2) {
            this.screen.setFontStyle(1);
        }
        if ((style & 4) == 4) {
            this.screen.setFontStyle(2);
        }
    }

    public Dimension getScreenCharacters() {
        return this.screenSize;
    }

    public Dimension getScreenUnits() {
        Dimension d = new Dimension();
        Dimension fs = this.getFontSize();
        Dimension scr = this.getScreenCharacters();
        d.width = scr.width * fs.width;
        d.height = scr.height * fs.height;
        return d;
    }

    public void quit() {
        Thread curThread = this.cpuThread;
        this.cpuThread = null;
        curThread.stop();
    }

    public void restart() {
        this.initialize(this.version);
    }
}

