// FrotzCE.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "afxwin.h"
#include "FrotzCE.h"

#include "MainFrm.h"
#include "FrotzCEDoc.h"
#include "FrotzCEView.h"
#include "ZThread.h"


#ifdef _WIN32_WCE_PSPC
#include <aygshell.h>
#pragma comment( lib, "aygshell" )
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFrotzCEApp

BEGIN_MESSAGE_MAP(CFrotzCEApp, CWinApp)
	//{{AFX_MSG_MAP(CFrotzCEApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)

	
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFrotzCEApp construction

CFrotzCEApp::CFrotzCEApp()
	: CWinApp()
{
	m_bZmachineRunning = FALSE;

	m_nFontHeight = 0;
	m_nFontWidth = 0;

	m_nDefaultStyle = NORMAL_STYLE;

	m_bUseStyles = FALSE;

	m_bUseColours = TRUE;

	m_bUseEuroChars = TRUE;

	m_bTandy = FALSE;

	m_bInitialised = FALSE;
}
/////////////////////////////////////////////////////////////////////////////
// The one and only CFrotzCEApp object

CFrotzCEApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CFrotzCEApp initialization

BOOL CFrotzCEApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	// Change the registry key under which our settings are stored.
	// You should modify this string to be something appropriate
	// such as the name of your company or organization.
//*	SetRegistryKey(_T("Local AppWizard-Generated Applications"));


	// Standard initialization
	SetRegistryKey(_T("Frotz"));

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Get defaults from registry
	m_strDefaultDir = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "CurrentDir" ), TEXT( "\\" ) );
	m_nFontHeight =
		GetProfileInt( TEXT( "Defaults" ), TEXT( "FontHeight" ), 0 );
	m_nFontWidth = 		
		GetProfileInt( TEXT( "Defaults" ), TEXT( "FontWidth" ), 0 );
	m_nDefaultStyle = 
		GetProfileInt( TEXT( "Defaults" ), TEXT( "Style" ), NORMAL_STYLE );
	m_bUseStyles = 
		GetProfileInt( TEXT( "Defaults" ), TEXT( "UseStyles" ), FALSE );
	m_bUseColours = 
		GetProfileInt( TEXT( "Defaults" ), TEXT( "UseCols" ), TRUE );

	// New
	m_bShowCompass = 
		GetProfileInt( TEXT( "Defaults" ), TEXT( "ShowComp" ), TRUE );

	// New For Macros
	m_iNumberMacros = 
		GetProfileInt( TEXT( "Defaults" ), TEXT( "NumMacros" ), (int)1 );

	// Probably a better way, but...
	if(m_iNumberMacros<0 || m_iNumberMacros>9)
		m_iNumberMacros = 0;

	m_sMacroNames[0] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroName1" ), TEXT( "Macro1" ) );
	m_sMacroActions[0] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroAction1" ), TEXT( "Macro1Action" )  );
	
	m_sMacroNames[1] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroName2" ), TEXT( "" ) );
	m_sMacroActions[1] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroAction2" ), TEXT( "" )  );

	m_sMacroNames[2] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroName3" ), TEXT( "" ) );
	m_sMacroActions[2] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroAction3" ), TEXT( "" )  );

	m_sMacroNames[3] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroName4" ), TEXT( "" ) );
	m_sMacroActions[3] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroAction4" ), TEXT( "" )  );

	m_sMacroNames[4] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroName5" ), TEXT( "" ) );
	m_sMacroActions[4] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroAction5" ), TEXT( "" )  );

	m_sMacroNames[5] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroName6" ), TEXT( "" ) );
	m_sMacroActions[5] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroAction6" ), TEXT( "" )  );

	m_sMacroNames[6] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroName7" ), TEXT( "" ) );
	m_sMacroActions[6] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroAction7" ), TEXT( "" )  );

	m_sMacroNames[7] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroName8" ), TEXT( "" ) );
	m_sMacroActions[7] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroAction8" ), TEXT( "" )  );

	m_sMacroNames[8] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroName9" ), TEXT( "" ) );
	m_sMacroActions[8] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroAction9" ), TEXT( "" )  );

	m_sMacroNames[9] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroName10" ), TEXT( "" ) );
	m_sMacroActions[9] = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "MacroAction10" ), TEXT( "" )  );
	

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CFrotzCEDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CFrotzCEView));
	AddDocTemplate(pDocTemplate);
	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The one and only window has been initialized, so show and update it.
//	m_pMainWnd->SetIcon( LoadIcon( IDR_MAINFRAME ), FALSE );
	m_pMainWnd->ShowWindow(SW_SHOW);
	m_pMainWnd->UpdateWindow();
	
#ifdef _WIN32_WCE_PSPC


	SIPINFO sSIP;
	memset( &sSIP, 0, sizeof( SIPINFO ) );
	sSIP.cbSize = sizeof( SIPINFO );
	// Soft keyboard visible?
	if (::SHSipInfo( SPI_GETSIPINFO, 0, &sSIP, 0 )
		&& !(sSIP.fdwFlags & SIPF_ON))
	{
		// Show soft keyboard
		sSIP.fdwFlags = SIPF_ON;
		::SHSipInfo( SPI_SETSIPINFO, 0, &sSIP, 0 );
	}
	// Get soft keyboard info
	if (::SHSipInfo( SPI_GETSIPINFO, 0, &sSIP, 0 ))
	{
	CRect cVisibleRect( sSIP.rcVisibleDesktop );

		// Resize main window to visible portion of screen
		m_pMainWnd->SetWindowPos( NULL, 0, 0, cVisibleRect.Width(), 
			cVisibleRect.Height(), SWP_NOMOVE | SWP_NOZORDER );
	}
#endif

	
	
	
	return TRUE;
}






/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();		// Added for WCE apps
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CFrotzCEApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.m_bFullScreen = FALSE;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CFrotzCEApp commands
// Added for WCE apps

BOOL CAboutDlg::OnInitDialog() 
{
CString strStoryInfo;

	CDialog::OnInitDialog();
	
	// Z Machine running?
	if (FROTZCEAPP->m_bZmachineRunning)
	{
	CString strRelease;

		// Get story name
		MAINFRAME->GetWindowText( strStoryInfo );
		// Unrecognised story?
		if (strStoryInfo == TEXT("PocketFrotz"))
		{
			// Use file name
			strStoryInfo = TEXT( "Story: " );
			strStoryInfo += FROTZCEAPP->m_achStoryFile;

			for (int nPos = strStoryInfo.GetLength()-1; nPos >= 0; nPos--)
			{
				// Found beginning of file name?	
				if (strStoryInfo[nPos] == _T('\\') || strStoryInfo[nPos] == _T('/'))
				{
				int nDotPos;

					// Save file name
					strStoryInfo = strStoryInfo.Mid( nPos + 1 );
					// Remove extension
					if ((nDotPos = strStoryInfo.Find( _T('.') )) != -1)
						strStoryInfo = strStoryInfo.Left( nDotPos + 1 );

					break;
				}
			}
		}
		strStoryInfo = TEXT( "Story: " ) + strStoryInfo;

		// Add release no.
		strRelease.Format( TEXT("\nRelease: %d"), h_release );
		strStoryInfo += strRelease;
		// Add serial no. to string
		strStoryInfo += "  SerialNo: ";
		strStoryInfo += h_serial;

		// Display string
		SetDlgItemText( IDC_STORYINFO, strStoryInfo );
	}
	else 
	{
		strStoryInfo = TEXT( "Compiled: " );
		strStoryInfo += __DATE__;
		SetDlgItemText( IDC_STORYINFO, strStoryInfo );
	}

	CenterWindow();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

int CFrotzCEApp::ExitInstance() 
{
	// TODO: Add your specialized code here and/or call the base class
	WriteProfileString( TEXT( "Defaults" ), TEXT( "CurrentDir" ), m_strDefaultDir );
	WriteProfileInt( TEXT( "Defaults" ), TEXT( "FontHeight" ), m_nFontHeight );
	WriteProfileInt( TEXT( "Defaults" ), TEXT( "FontWidth" ), m_nFontWidth );
	WriteProfileInt( TEXT( "Defaults" ), TEXT( "Style" ), m_nDefaultStyle );
	WriteProfileInt( TEXT( "Defaults" ), TEXT( "UseStyles" ), m_bUseStyles );
	WriteProfileInt( TEXT( "Defaults" ), TEXT( "UseCols" ), m_bUseColours );
	WriteProfileInt( TEXT( "Defaults" ), TEXT( "ShowComp" ), m_bShowCompass );

// New For Macros

	WriteProfileInt( TEXT( "Defaults" ), TEXT( "NumMacros" ), m_iNumberMacros );

	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroName1" ), m_sMacroNames[0] );
	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroAction1" ), m_sMacroActions[0] );

	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroName2" ), m_sMacroNames[1] );
	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroAction2" ), m_sMacroActions[1] );

	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroName3" ), m_sMacroNames[2] );
	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroAction3" ), m_sMacroActions[2] );

	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroName4" ), m_sMacroNames[3] );
	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroAction4" ), m_sMacroActions[3] );

	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroName5" ), m_sMacroNames[4] );
	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroAction5" ), m_sMacroActions[4] );

	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroName6" ), m_sMacroNames[5] );
	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroAction6" ), m_sMacroActions[5] );

	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroName7" ), m_sMacroNames[6] );
	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroAction7" ), m_sMacroActions[6] );

	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroName8" ), m_sMacroNames[7] );
	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroAction8" ), m_sMacroActions[7] );

	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroName9" ), m_sMacroNames[8] );
	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroAction9" ), m_sMacroActions[8] );

	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroName10" ), m_sMacroNames[9] );
	WriteProfileString( TEXT( "Defaults" ), TEXT( "MacroAction10" ), m_sMacroActions[9] );





#ifdef _WIN32_WCE_PSPC

	SIPINFO sSIP;
	memset( &sSIP, 0, sizeof( SIPINFO ) );
	sSIP.cbSize = sizeof( SIPINFO );
	// Soft keyboard visible?
	if (::SHSipInfo( SPI_GETSIPINFO, 0, &sSIP, 0 )
		&& (sSIP.fdwFlags & SIPF_ON) != 0)
	{
		// Hide soft keyboard
		sSIP.fdwFlags ^= SIPF_ON;
		::SHSipInfo( SPI_SETSIPINFO, 0, &sSIP, 0 );
	}
#endif	
	return CWinApp::ExitInstance();
}


void CFrotzCEApp::StartZMachine( LPVOID pParam )
{

AFX_THREADPROC temp;

temp = (AFX_THREADPROC)	ZMachineThreadFunction;

	//m_pcZThread = AfxBeginThread( ZMachineThreadFunction, pParam);

	m_pcZThread = AfxBeginThread( temp, pParam);

//	m_pcZThread = AfxBeginThread( temp, pParam, THREAD_PRIORITY_ABOVE_NORMAL, 0x80000, 0, NULL);


}








