// FrotzCE.h : main header file for the FROTZCE application
//

#if !defined(AFX_FROTZCE_H__8C1CE6D8_4EDB_11D5_93BF_002078176AEF__INCLUDED_)
#define AFX_FROTZCE_H__8C1CE6D8_4EDB_11D5_93BF_002078176AEF__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
#define FROTZCEAPP ((CFrotzCEApp *) AfxGetApp())

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols

/////////////////////////////////////////////////////////////////////////////
// CFrotzCEApp:
// See FrotzCE.cpp for the implementation of this class
//

class CFrotzCEApp : public CWinApp
{

private:
	CWinThread*
		// Thread pointer for Z machine thread
		m_pcZThread;

public:
	BOOL
		// Flag to indicate if OS interface is initialised
		m_bInitialised;

	BOOL
		// Flag to indicate if Z machine is running
		m_bZmachineRunning;

	int
		// Font height and width to use as default
		m_nFontHeight,
		m_nFontWidth;

	int
		// Default style to use
		m_nDefaultStyle;

	BOOL
		// Flag to indicate if text style support should be enabled
		m_bUseStyles;

	BOOL
		// Flag to indicate if colour support should be enabled
		m_bUseColours;

	BOOL
		// Flag to indicate if euro chars should be remapped
		m_bUseEuroChars;

	BOOL
		// Flag to indicate if game should run with "Tandy" bit set
		m_bTandy;

	CString
		// Default directory to open files in
		m_strDefaultDir;

	char
		// Current story file name
		m_achStoryFile[256];

	BOOL
		// Flag to indicate if Compass should be displayed.
		m_bShowCompass;


		// Data Containing Macro Definitions
	CString m_sMacroNames[10];
	CString m_sMacroActions[10];
	int m_iNumberMacros;

public:
	CFrotzCEApp();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFrotzCEApp)
	public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	//}}AFX_VIRTUAL

// Implementation


	
	void 
		// Start Z machine thread
		StartZMachine( LPVOID pParam=NULL );

	//{{AFX_MSG(CFrotzCEApp)
	afx_msg void OnAppAbout();
	//}}AFX_MSG

	
	
	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft eMbedded Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_FROTZCE_H__8C1CE6D8_4EDB_11D5_93BF_002078176AEF__INCLUDED_)
