/* YesNo.c - HelioFrotz Yes/No Dialog Handler
 *
 * This file is part of HelioFrotz.
 *
 * HelioFrotz is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * HelioFrotz is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <system.h>
#include "res/resource.h"
#include "frotz.h"
#include "heliofro.h"

static int yesno;
static char *yesnoPrompt;

int DoYesNo(char *prompt, int form)
{
  EvtType event;
  
  yesno = 0;
  yesnoPrompt = prompt;
  FormPopupForm(FORM_YESNO);
  do {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event)) continue;
    if(MenuHandleEvent(&event)) continue;
    if(ApplicationHandleEvent(&event)) continue;
    FormDispatchEvent(&event);
  } while (event.eventType!=EVT_FORM_CLOSE);
  if (form>=0) FormPopupForm(form);
  return yesno;
}


static void YesNoOK(int OK)
{
  FormRestoreBitBehind(FORM_YESNO);
  EvtAppendEvt(EVT_FORM_CLOSE, FORM_YESNO, 0, 0, NULL);
  yesno = OK;
}


BOOLEAN FormYesNoHandleEvent(EvtType* event)
{
  switch(event->eventType) {
    case EVT_FORM_OPEN:
      FormSaveBehindBits(event->eventID);
      StringSetText(STRING_YESNO, yesnoPrompt);
      FormDrawForm(event->eventID);
      break;

    case EVT_INLAY_SELECT:
    switch(event->para1) {
    case INLAY_OK:
      YesNoOK(1);
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      YesNoOK(0);
      break;
    default:
      return FALSE;
    }
  case EVT_CONTROL_SELECT:
    switch (event->eventID) {
    case BUTTON_YESNOOK:
      YesNoOK(1);
      break;
    case BUTTON_YESNOCANCEL:
      YesNoOK(0);
      break;
    }

    default:
      return FALSE;
    }
  return FALSE;
}
