/* os_fatal.c - HelioFrotz Fatal Dialog display/longjmp
 *
 * This file is part of HelioFrotz.
 *
 * HelioFrotz is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * HelioFrotz is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <system.h>
#include <setjmp.h>
#include "res/resource.h"
#include "frotz.h"
#include "heliofro.h"

static char errstr[200];
extern jmp_buf env;

void FatalDialog(const char *str)
{
  EvtType event;

  strcpy(errstr, str);
  FormPopupForm(FORM_ERROR);
  do {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event)) continue;
    if(MenuHandleEvent(&event)) continue;
    if(ApplicationHandleEvent(&event)) continue;
    FormDispatchEvent(&event);
  } while (event.eventType!=EVT_FORM_CLOSE);

  longjmp(env, 1);
}



BOOLEAN FormFatalHandleEvent(EvtType* Event)
{
  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    StringSetText(STRING_ERROR, errstr);
    FormDrawForm(FORM_ERROR);
    break;

  case EVT_INLAY_SELECT:
  case EVT_CONTROL_SELECT:
    EvtAppendEvt(EVT_FORM_CLOSE, FORM_ERROR, 0, 0, NULL);
    break;

  default:
    return FALSE;
  }
  return FALSE;
}

