/* mygetlin.c - HelioFrotz Text Input Handler
 *
 * This file is part of HelioFrotz.
 *
 * HelioFrotz is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * HelioFrotz is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <system.h>
#include <string.h>
#include <setjmp.h>
#include "frotz.h"
#include "heliofro.h"
#include "res\resource.h"
#include "..\stdlib\fnt.h"


BOOLEAN (*FormDispatchEvent)(EvtType *Event);

#define CPU_CLK_75M        (0<<10)
#define CPU_CLK_37M        (1<<10)


static int noclear;
static int hard_exit=0;
static char strsave[200];
static char *string;
static char *preload;
static int doneline=0;
static int timedout = 0;


int StopTheMadness()
{
  return hard_exit;
}

void PowerOff()
{
  hard_exit=1;
}




#define EVT_TIMEOUT 0xdead

void AddTimerEvent()
{
  EvtAppendEvt(EVT_TIMEOUT, 0, 0, 0, NULL);
}

void TimerCallback()
{
  MsgAppendMsgInt(AddTimerEvent, 0, 0, 0, NULL);
}

static  BitmapTemplate slb;

int mygetline(char *str, char *pl, int timeout)
{
  EvtType event;
  UWORD timer;

  string = str;
  preload = pl;
  if (hard_exit) return FALSE;
  str[0]=0;

  noclear=0;
  doneline=0;
  FormPopupForm(FORM_MAIN);	        //start main form
  timedout=timer=0;
  if (timeout)
    timer = TmrIntEnable(timeout*1000/10,TimerCallback);
  slb.xcoord = 0;
  slb.ycoord = 149-62;
  slb.width = 160;
  slb.height = 16;
  LcdGetBitmap(&slb);

  while (!doneline) {
    if (hard_exit) break;;
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event)) continue;
    if(MenuHandleEvent(&event)) continue;
    if(ApplicationHandleEvent(&event)) continue;
    FormDispatchEvent(&event);
    if (event.eventType==EVT_APP_STOP || hard_exit) break;
  }
  if (timeout)
    TmrIntDisable(timer);

  qfree(slb.bitmap_data);

  if (event.eventType==EVT_APP_STOP || hard_exit) {
    extern jmp_buf env;
    
    PowerOff();
    record_close();
    script_close();
    z_save();
    longjmp(env, 1);
  }
  CpuChangeSpeed(CPU_CLK_75M);
  return timedout;
}


BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
  BYTE object_type;
  Form *form_ptr;
  void* evtHandler;
	
  switch(Event->eventType) {
  case EVT_FORM_LOAD:
    if((Event->para1==1)||(UISearchForAddress((ObjectID)Event->eventID,&object_type,(void**)&form_ptr)!=TRUE))
      FormInitAllFormObjects((ObjectID)Event->eventID);
    if(UISearchForAddress((ObjectID)Event->eventID,&object_type,(void**)&form_ptr)!=TRUE)
      return FALSE;
    switch((ObjectID)Event->eventID) {
    case FORM_MAIN: evtHandler = (void*)FormMainHandleEvent; break;
    case FORM_IFACE: evtHandler = (void*)FormIfaceHandleEvent; break;
    case FORM_COMPASS: evtHandler = (void*)FormCompassHandleEvent; break;
    case FORM_HIST: evtHandler = (void*)FormHistoryHandleEvent; break;
    case FORM_ABOUT: evtHandler = (void*)FormAboutHandleEvent; break;
    case FORM_ERROR: evtHandler = (void*)FormFatalHandleEvent; break;
    case FORM_FONT: evtHandler = (void*)FormFontHandleEvent; break;
    case FORM_SAVELOAD: evtHandler = (void*)FormSaveLoadHandleEvent; break;
    case FORM_YESNO: evtHandler = (void*)FormYesNoHandleEvent; break;
    case FORM_HELP: evtHandler = (void*)FormHelpHandleEvent; break;
    default:
      return FALSE;
    }
    FormSetEventHandler((ObjectID)Event->eventID,(void**)&FormDispatchEvent,evtHandler);
    FormSetActiveForm((ObjectID)Event->eventID);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

void OK()
{
  BYTE *text_ptr;
  TextboxSetInsertPointOff(TEXTBOX_MAIN);
  TextboxGetTextPointer(TEXTBOX_MAIN, &text_ptr);
  strcpy(string, text_ptr);
  UpdateHistory(string);
  strcat(string, "\n");
  TextboxDeleteTextbox(TEXTBOX_MAIN);
  TextboxInitTextbox(TEXTBOX_MAIN);
  EvtAppendEvt(EVT_FORM_CLOSE, FORM_MAIN, 0, 0, NULL);
  doneline=1;
}



BOOLEAN FormMainHandleEvent(EvtType* Event)
{
  ObjectBounds bnds;
  BYTE *str, *text_ptr;
  int i;
  extern int findclick(int x, int y, char *buff);
  static int lastx, lasty;
  static int pen_ok;

  switch(Event->eventType) {
  case EVT_TIMEOUT:
    timedout=1;
    OK();
    string[strlen(string)-1]=0;
    break;


  case PEN_EVENT:
    switch (Event->eventID) {
    case PEN_DOWN:
      lastx = Event->para1;
      lasty = Event->para2;
      if (lasty<150) pen_ok=1;
      else pen_ok=0;
      break;
    case PEN_UP:
      if (!pen_ok) break;
      if (more_prompt) {
	FntBeep();
	OK(); 
	break;
      }
      i=(Event->para1 - lastx)*(Event->para1 - lastx) + (Event->para2 - lasty)*(Event->para2 - lasty);
      if (i<10) {
	char buff[200];
	findclick(Event->para1, Event->para2, buff);
	if (buff[0]){
	  TextboxGetTextPointer(TEXTBOX_MAIN, &text_ptr) ;
	  if (strlen(text_ptr)>0)
	    if (text_ptr[strlen(text_ptr)-1]!=' ') TextboxAddKeyInChar(TEXTBOX_MAIN, (BYTE)' ');
	  for (i=0; i<strlen(buff); i++) TextboxAddKeyInChar(TEXTBOX_MAIN, (BYTE)buff[i]);
	  FntBeep();
	}
      }
      break;
    }
    break;


  case EVT_BITMAP_SELECT:
    noclear=1;
    TextboxGetTextPointer(TEXTBOX_MAIN, &text_ptr) ;
    strcpy(strsave, text_ptr );
    if (Event->eventID==COMPASS_BITMAP) {
      if (DoCompass(strsave)==EVT_APP_STOP)
	return TRUE;
    } else if (Event->eventID==ARROW_BITMAP) {
      if (DoHistory(strsave)==EVT_APP_STOP)
	return TRUE;
    }
    break;

  case EVT_MENU_SELECT_ITEM:
    MenuGetMenuItem(7, Event->para1, &str);
    TextboxGetTextPointer(TEXTBOX_MAIN, &text_ptr) ;
    if (text_ptr[strlen(text_ptr)-1]!=' ' && strlen(text_ptr)>0) TextboxAddKeyInChar(TEXTBOX_MAIN, (BYTE)' ');
    for (i=0; i<strlen(str); i++) {
      if (str[i]!='.') 
	TextboxAddKeyInChar(TEXTBOX_MAIN, (BYTE)str[i]);
      else
	OK();
    }
    break;

  case EVT_KEY:
    FormObjectSetFocus(TEXTBOX_MAIN);
    if (Event->eventID == SOFT_KEY) {		
      if (more_prompt) {
	FntBeep();
	OK();
      }
      if ((BYTE)(Event->para1) == 13) OK();
      else TextboxAddKeyInChar(TEXTBOX_MAIN, (BYTE)(Event->para1));
      return TRUE;
    }
    break;

  case EVT_IO_KEY_CTRL:
    if (Event->eventID == EVT_IO_KEY_PRESS && Event->para2 == IO_DOWN_ARROW)
      OK();
    return FALSE;
      
  case EVT_KEYBOARD_STATUS:
    TextboxGetTextboxBounds(TEXTBOX_MAIN, &bnds);
    if (Event->para1==KEYBOARD_ON) {
      bnds.ycoord = 149-61;
    } else if (Event->para1==KEYBOARD_OFF) {
      bnds.ycoord = 149;
      LcdDrawBitmap(&slb, FALSE);
    }
    TextboxSetBounds(TEXTBOX_MAIN, bnds);
    TextboxSetInsertPointOff(TEXTBOX_MAIN);
    TextboxGetTextPointer(TEXTBOX_MAIN, &text_ptr) ;
    TextboxSetInsertPointPositionByCharPos(TEXTBOX_MAIN, strlen(text_ptr));
    TextboxDrawTextbox(TEXTBOX_MAIN);
    TextboxSetInsertPointOn(TEXTBOX_MAIN);
    FormObjectSetFocus(TEXTBOX_MAIN);
    break;


  case EVT_FORM_OPEN:
    if (hard_exit) return TRUE;
    pen_ok = 0;
    FormObjectSetFocus(TEXTBOX_MAIN);
    if (noclear) {
      noclear=0;
      if (strsave[strlen(strsave)-1]=='|') {
	strsave[strlen(strsave)-1]=0;
	EvtAppendEvt(EVT_KEY,SOFT_KEY,13,0,NULL);
      }
      TextboxSetText(TEXTBOX_MAIN, strsave);
      TextboxSetInsertPointPositionByCharPos(TEXTBOX_MAIN, strlen(strsave)); }
    else {
      TextboxSetText(TEXTBOX_MAIN, "");
      TextboxSetInsertPointPositionByCharPos(TEXTBOX_MAIN, 0);
    }
    if (preload) {
      TextboxSetText(TEXTBOX_MAIN, preload);
      TextboxSetInsertPointPositionByCharPos(TEXTBOX_MAIN, strlen(preload));
      preload = NULL;
    }
    TextboxDrawTextbox(TEXTBOX_MAIN);
    TextboxSetInsertPointOn(TEXTBOX_MAIN);
    BitmapDrawBitmap(COMPASS_BITMAP);
    BitmapDrawBitmap(ARROW_BITMAP);
    break;
  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
      OK();
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      if(DoYesNo("Really Exit?", FORM_MAIN)) {
	hard_exit = 1;
	OK();
      }
      break;
    default:
      return FALSE;
    }
    break;

  default:
    return FALSE;
  }
  return FALSE;
}
