/* helioini.h - HelioFrotz Initialization
 *
 * This file is part of HelioFrotz.
 *
 * HelioFrotz is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * HelioFrotz is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <system.h>
#include "frotz.h"
#include "heliofro.h"
#include "..\stdlib\fnt.h"


static int user_interpreter_number = -1;
static int user_random_seed = -1;
static int user_tandy_bit = 0;
char storyname[90];

int helioFixedFont = smallFixedFont;
int helioPropFont = smallFont;

void os_init_screen(void)
{
  int font_width, font_height;

  h_screen_width = 160;
  h_screen_height = 150;

  os_font_data(FIXED_WIDTH_FONT, &font_height, &font_width);
  h_screen_cols = h_screen_width/font_width;
  h_screen_rows = h_screen_height/font_height;

  h_font_height = font_height;
  h_font_width = font_width;

  if (user_interpreter_number > 0)
    h_interpreter_number = user_interpreter_number;
  else 
    h_interpreter_number = h_version == 6 ? INTERP_MSDOS : INTERP_DEC_20;

  h_interpreter_version = 'F';

  if (h_version >= V4)
    h_config |= CONFIG_TIMEDINPUT;

  if (h_version >= V5)
    h_flags &= ~(MOUSE_FLAG | MENU_FLAG);

  /* First, configuration parameters get set up */
  if (h_version == V3 && user_tandy_bit != 0)
    h_config |= CONFIG_TANDY;
  if (h_version == V3)
    h_config |= CONFIG_SPLITSCREEN | CONFIG_PROPORTIONAL;
  if (h_version >= V4)
    h_config |= /*CONFIG_BOLDFACE |*/ CONFIG_EMPHASIS | CONFIG_FIXED;
  if (h_version >= V5) {
    h_flags |= /*GRAPHICS_FLAG |*/ UNDO_FLAG /*| MOUSE_FLAG | COLOUR_FLAG*/;
    h_flags &= ~SOUND_FLAG;
  }
  if (h_version >= V5 && (h_flags & UNDO_FLAG) && option_undo_slots == 0)
    h_flags &= ~UNDO_FLAG;
}

int os_random_seed (void)
{
  if (user_random_seed == -1)
    return (my_time(0) & 0x7fff);
  else return user_random_seed;
}

void os_restart_game (int stage) {}

void os_fatal (const char *s)
{
  extern void FatalDialog(const char *str);

  FatalDialog(s);
}
FILE *os_path_open(const char *name, const char *mode)
{
  return fopen(name, mode);
}
