/* pix2gif.h
 *
 * pix2gif.c header file.
 *
 * Mark Howell 26 August 1992 howell_ma@movies.enet.dec.com
 *
 */
#ifndef __PIX2GIF_H__
#define __PIX2GIF_H__



#include <stdio.h>
#include <stdlib.h>

#if !defined(FILENAME_MAX)
#define FILENAME_MAX 255
#endif

#if !defined(EXIT_SUCCESS)
#define EXIT_SUCCESS 0
#endif

#if !defined(EXIT_FAILURE)
#define EXIT_FAILURE 1
#endif

#if !defined(SEEK_SET)
#define SEEK_SET 0
#endif

#ifdef __DJGPP__
#undef __MSDOS__
#endif

#if defined(__MSDOS__)
#define __USE_FARPTRS__
#endif

/*
  7/3 -- I'm guessing "unix" was used for non-ANSI C dialects.
         So I'm replacing those tests with #ifndef __STDC__
*/

// Messed up things BADLY!
//#ifndef __STDC__
//#define const
//#endif

#define MAX_BIT 512 /* Must be less than or equal to CODE_TABLE_SIZE */
#define CODE_SIZE 8
#define CODE_TABLE_SIZE 4096
#define PREFIX 0
#define PIXEL 1
#define RED 0
#define GREEN 1
#define BLUE 2

typedef struct {
    unsigned char part;
    unsigned char flags;
    unsigned short unknown1;
    unsigned short images;
    unsigned short unknown2;
    unsigned char dir_size;
    unsigned char unknown3;
    unsigned short checksum;
    unsigned short unknown4;
    unsigned short version;
} header_t;

typedef struct {
    short image_number;
    short image_width;
    short image_height;
    short image_flags;
    long image_data_addr;
    long image_cm_addr;
} pdirectory_t;

typedef struct {
    short width;
    short height;
    short colours;
    long pixels;
#ifdef __USE_FARPTRS__
    unsigned char huge *image;
#else
    unsigned char *image;
#endif
    unsigned char (*colourmap)[3];
    unsigned short transflag;
    unsigned short transpixel;
} image_t;

typedef struct {
    short next_code;
    short slen;
    short sptr;
    short tlen;
    short tptr;
} compress_t;


#endif // __PIX2GIF_H__
