/*
 * file "S5screen.c"
 *
 *
 */

#include "frotz.h"
#include "S5frotz.h"
#include "S5api.h"


/*
 * os_erase_area
 *
 * Fill a rectangular area of the screen with the current background
 * colour. Top left coordinates are (1,1). The cursor does not move.
 *
 */

void os_erase_area (struct sg *g, short top, short left, short bottom, short right)
{
	SrvEraseRect(g,top, left, bottom, right, g->scrn_attr);
}/* os_erase_area */


/*
 * os_scroll_area
 *
 * Scroll a rectangular area of the screen up (units > 0) or down
 * (units < 0) and fill the empty space with the current background
 * colour. Top left coordinates are (1,1). The cursor stays put.
 *
 */

void os_scroll_area (struct sg *g, short top, short left, short bottom, short right, short units)
{
	SrvScroll(g,top, left, bottom, right, units, g->scrn_attr);
}/* os_scroll_area */
