/*
 * buffer.c
 *
 * Text buffering and word wrapping
 *
 */

#include "frotz.h"
#include "s5api.h"

extern void stream_char (struct sg *g, zchar);
extern void stream_word (struct sg *g, const zchar *);
extern void stream_new_line (struct sg *g);


/*
 * flush_buffer
 *
 * Copy the contents of the text buffer to the output streams.
 *
 */

void flush_buffer (struct sg *g)
{

    /* Make sure we stop when flush_buffer is called from flush_buffer.
       Note that this is difficult to avoid as we might print a newline
       during flush_buffer, which might cause a newline interrupt, that
       might execute any arbitrary opcode, which might flush the buffer. */

    if (g->locked || g->bufpos == 0)
	return;

    /* Send the buffer to the output streams */

    g->buffer[g->bufpos] = 0;

    g->locked = TRUE; 
	stream_word (g, g->buffer); 
	g->locked = FALSE;

    /* Reset the buffer */

    g->bufpos = 0;
    g->prev_c = 0;

}/* flush_buffer */

/*
 * print_char
 *
 * High level output function.
 *
 */

void print_char (struct sg *g, zchar c)
{
    if (g->message || g->ostream_memory || g->enable_buffering) {

	if (!g->flag) 
	{

	    /* Characters 0 and ZC_RETURN are special cases */
	    if (c == ZC_RETURN)
		{ 
			new_line (g); 
			return; 
		}
	    if (c == 0)
			return;

	    /* Flush the buffer before a whitespace or after a hyphen */

	    if ((c== ' ' && g->prev_c != ' ') || c == ZC_INDENT || c == ZC_GAP || g->prev_c == '-' && c != '-')
			flush_buffer (g);

	    /* Set the flag if this is part one of a style or font change */

	    if (c == ZC_NEW_FONT || c == ZC_NEW_STYLE)
			g->flag = TRUE;

	    /* Remember the current character code */

	    g->prev_c = c;

	} 
	else g->flag = FALSE;

	/* Insert the character into the buffer */

	g->buffer[(g->bufpos)++] = c;

	if (g->bufpos == TEXT_BUFFER_SIZE)
	    runtime_error (g, "Text buffer overflow");

    } else stream_char (g, c);

}/* print_char */

/*
 * new_line
 *
 * High level newline function.
 *
 */

void new_line (struct sg *g)
{

    flush_buffer (g); 
	stream_new_line (g);

}/* new_line */
